/*******************************************************************************
* File Name: cycfg_capsense_tuner_regmap.h
*
* Description:
* CAPSENSE(TM) Tuner register map configuration.
* This file should not be modified. It was automatically generated by
* CAPSENSE(TM) Configurator 8.10.0.10250
*
********************************************************************************
* Copyright 2025, Cypress Semiconductor Corporation (an Infineon company) 
* or an affiliate of Cypress Semiconductor Corporation.
* SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*     http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*******************************************************************************/

#if !defined(CYCFG_CAPSENSE_TUNER_REGMAP_H)
#define CYCFG_CAPSENSE_TUNER_REGMAP_H

#include "cy_capsense_common.h"

#if !defined(CY_CAPSENSE_MW_VERSION)
    #define CY_CAPSENSE_TUNER_MW_VERSION (200)
#else
    #define CY_CAPSENSE_TUNER_MW_VERSION (CY_CAPSENSE_MW_VERSION)
#endif

/* RAM Data structure register definitions */
#if (CY_CAPSENSE_TUNER_MW_VERSION < 300)
#define CY_CAPSENSE_TUNER_CONFIG_ID_OFFSET                                             (0u)
#define CY_CAPSENSE_TUNER_CONFIG_ID_SIZE                                               (2u)

#define CY_CAPSENSE_TUNER_TUNER_CMD_OFFSET                                             (2u)
#define CY_CAPSENSE_TUNER_TUNER_CMD_SIZE                                               (2u)

#define CY_CAPSENSE_TUNER_SCAN_COUNTER_OFFSET                                          (4u)
#define CY_CAPSENSE_TUNER_SCAN_COUNTER_SIZE                                            (2u)

#define CY_CAPSENSE_TUNER_TUNER_ST_OFFSET                                              (6u)
#define CY_CAPSENSE_TUNER_TUNER_ST_SIZE                                                (1u)

#define CY_CAPSENSE_TUNER_INITDONE_OFFSET                                              (7u)
#define CY_CAPSENSE_TUNER_INITDONE_SIZE                                                (1u)

#define CY_CAPSENSE_TUNER_PTRSSCALLBACK_OFFSET                                         (8u)
#define CY_CAPSENSE_TUNER_PTRSSCALLBACK_SIZE                                           (4u)

#define CY_CAPSENSE_TUNER_PTREOSCALLBACK_OFFSET                                        (12u)
#define CY_CAPSENSE_TUNER_PTREOSCALLBACK_SIZE                                          (4u)

#define CY_CAPSENSE_TUNER_PTRTUNERSENDCALLBACK_OFFSET                                  (16u)
#define CY_CAPSENSE_TUNER_PTRTUNERSENDCALLBACK_SIZE                                    (4u)

#define CY_CAPSENSE_TUNER_PTRTUNERRECEIVECALLBACK_OFFSET                               (20u)
#define CY_CAPSENSE_TUNER_PTRTUNERRECEIVECALLBACK_SIZE                                 (4u)

#define CY_CAPSENSE_TUNER_STATUS_OFFSET                                                (24u)
#define CY_CAPSENSE_TUNER_STATUS_SIZE                                                  (4u)

#define CY_CAPSENSE_TUNER_TIMESTAMPINTERVAL_OFFSET                                     (28u)
#define CY_CAPSENSE_TUNER_TIMESTAMPINTERVAL_SIZE                                       (4u)

#define CY_CAPSENSE_TUNER_TIMESTAMP_OFFSET                                             (32u)
#define CY_CAPSENSE_TUNER_TIMESTAMP_SIZE                                               (4u)

#define CY_CAPSENSE_TUNER_CSD_MOD_CLK_DIVIDER_OFFSET                                   (36u)
#define CY_CAPSENSE_TUNER_CSD_MOD_CLK_DIVIDER_SIZE                                     (1u)

#define CY_CAPSENSE_TUNER_CSX_MOD_CLK_DIVIDER_OFFSET                                   (37u)
#define CY_CAPSENSE_TUNER_CSX_MOD_CLK_DIVIDER_SIZE                                     (1u)

#define CY_CAPSENSE_TUNER_TUNER_CNT_OFFSET                                             (38u)
#define CY_CAPSENSE_TUNER_TUNER_CNT_SIZE                                               (1u)

#define CY_CAPSENSE_TUNER_BUTTON0_FINGER_CP_OFFSET                                     (40u)
#define CY_CAPSENSE_TUNER_BUTTON0_FINGER_CP_SIZE                                       (2u)

#define CY_CAPSENSE_TUNER_BUTTON0_SIGPFC_OFFSET                                        (42u)
#define CY_CAPSENSE_TUNER_BUTTON0_SIGPFC_SIZE                                          (2u)

#define CY_CAPSENSE_TUNER_BUTTON0_NUM_CONV_OFFSET                                      (44u)
#define CY_CAPSENSE_TUNER_BUTTON0_NUM_CONV_SIZE                                        (2u)

#define CY_CAPSENSE_TUNER_BUTTON0_MAX_RAW_COUNT_OFFSET                                 (46u)
#define CY_CAPSENSE_TUNER_BUTTON0_MAX_RAW_COUNT_SIZE                                   (2u)

#define CY_CAPSENSE_TUNER_BUTTON0_FINGER_TH_OFFSET                                     (48u)
#define CY_CAPSENSE_TUNER_BUTTON0_FINGER_TH_SIZE                                       (2u)

#define CY_CAPSENSE_TUNER_BUTTON0_PROX_TOUCH_TH_OFFSET                                 (50u)
#define CY_CAPSENSE_TUNER_BUTTON0_PROX_TOUCH_TH_SIZE                                   (2u)

#define CY_CAPSENSE_TUNER_BUTTON0_LOW_BSLN_RST_OFFSET                                  (52u)
#define CY_CAPSENSE_TUNER_BUTTON0_LOW_BSLN_RST_SIZE                                    (2u)

#define CY_CAPSENSE_TUNER_BUTTON0_TX_CLK_OFFSET                                        (54u)
#define CY_CAPSENSE_TUNER_BUTTON0_TX_CLK_SIZE                                          (2u)

#define CY_CAPSENSE_TUNER_BUTTON0_ROW_SNS_CLK_OFFSET                                   (56u)
#define CY_CAPSENSE_TUNER_BUTTON0_ROW_SNS_CLK_SIZE                                     (2u)

#define CY_CAPSENSE_TUNER_BUTTON0_GESTURE_DETECTED_OFFSET                              (58u)
#define CY_CAPSENSE_TUNER_BUTTON0_GESTURE_DETECTED_SIZE                                (2u)

#define CY_CAPSENSE_TUNER_BUTTON0_GESTURE_DIRECTION_OFFSET                             (60u)
#define CY_CAPSENSE_TUNER_BUTTON0_GESTURE_DIRECTION_SIZE                               (2u)

#define CY_CAPSENSE_TUNER_BUTTON0_XDELTA_OFFSET                                        (62u)
#define CY_CAPSENSE_TUNER_BUTTON0_XDELTA_SIZE                                          (2u)

#define CY_CAPSENSE_TUNER_BUTTON0_YDELTA_OFFSET                                        (64u)
#define CY_CAPSENSE_TUNER_BUTTON0_YDELTA_SIZE                                          (2u)

#define CY_CAPSENSE_TUNER_BUTTON0_NOISE_TH_OFFSET                                      (66u)
#define CY_CAPSENSE_TUNER_BUTTON0_NOISE_TH_SIZE                                        (1u)

#define CY_CAPSENSE_TUNER_BUTTON0_NNOISE_TH_OFFSET                                     (67u)
#define CY_CAPSENSE_TUNER_BUTTON0_NNOISE_TH_SIZE                                       (1u)

#define CY_CAPSENSE_TUNER_BUTTON0_HYSTERESIS_OFFSET                                    (68u)
#define CY_CAPSENSE_TUNER_BUTTON0_HYSTERESIS_SIZE                                      (1u)

#define CY_CAPSENSE_TUNER_BUTTON0_ON_DEBOUNCE_OFFSET                                   (69u)
#define CY_CAPSENSE_TUNER_BUTTON0_ON_DEBOUNCE_SIZE                                     (1u)

#define CY_CAPSENSE_TUNER_BUTTON0_TX_CLK_SOURCE_OFFSET                                 (70u)
#define CY_CAPSENSE_TUNER_BUTTON0_TX_CLK_SOURCE_SIZE                                   (1u)

#define CY_CAPSENSE_TUNER_BUTTON0_IDAC_MOD0_OFFSET                                     (71u)
#define CY_CAPSENSE_TUNER_BUTTON0_IDAC_MOD0_SIZE                                       (1u)

#define CY_CAPSENSE_TUNER_BUTTON0_IDAC_MOD1_OFFSET                                     (72u)
#define CY_CAPSENSE_TUNER_BUTTON0_IDAC_MOD1_SIZE                                       (1u)

#define CY_CAPSENSE_TUNER_BUTTON0_IDAC_MOD2_OFFSET                                     (73u)
#define CY_CAPSENSE_TUNER_BUTTON0_IDAC_MOD2_SIZE                                       (1u)

#define CY_CAPSENSE_TUNER_BUTTON0_IDAC_GAIN_INDEX_OFFSET                               (74u)
#define CY_CAPSENSE_TUNER_BUTTON0_IDAC_GAIN_INDEX_SIZE                                 (1u)

#define CY_CAPSENSE_TUNER_BUTTON0_ROW_IDAC_MOD0_OFFSET                                 (75u)
#define CY_CAPSENSE_TUNER_BUTTON0_ROW_IDAC_MOD0_SIZE                                   (1u)

#define CY_CAPSENSE_TUNER_BUTTON0_ROW_IDAC_MOD1_OFFSET                                 (76u)
#define CY_CAPSENSE_TUNER_BUTTON0_ROW_IDAC_MOD1_SIZE                                   (1u)

#define CY_CAPSENSE_TUNER_BUTTON0_ROW_IDAC_MOD2_OFFSET                                 (77u)
#define CY_CAPSENSE_TUNER_BUTTON0_ROW_IDAC_MOD2_SIZE                                   (1u)

#define CY_CAPSENSE_TUNER_BUTTON0_REGULAR_IIR_BL_N_OFFSET                              (78u)
#define CY_CAPSENSE_TUNER_BUTTON0_REGULAR_IIR_BL_N_SIZE                                (1u)

#define CY_CAPSENSE_TUNER_BUTTON0_STATUS_OFFSET                                        (79u)
#define CY_CAPSENSE_TUNER_BUTTON0_STATUS_SIZE                                          (1u)

#define CY_CAPSENSE_TUNER_BUTTON0_PTRPOSITION_OFFSET                                   (80u)
#define CY_CAPSENSE_TUNER_BUTTON0_PTRPOSITION_SIZE                                     (4u)

#define CY_CAPSENSE_TUNER_BUTTON0_NUM_POSITIONS_OFFSET                                 (84u)
#define CY_CAPSENSE_TUNER_BUTTON0_NUM_POSITIONS_SIZE                                   (1u)

#define CY_CAPSENSE_TUNER_BUTTON1_FINGER_CP_OFFSET                                     (88u)
#define CY_CAPSENSE_TUNER_BUTTON1_FINGER_CP_SIZE                                       (2u)

#define CY_CAPSENSE_TUNER_BUTTON1_SIGPFC_OFFSET                                        (90u)
#define CY_CAPSENSE_TUNER_BUTTON1_SIGPFC_SIZE                                          (2u)

#define CY_CAPSENSE_TUNER_BUTTON1_NUM_CONV_OFFSET                                      (92u)
#define CY_CAPSENSE_TUNER_BUTTON1_NUM_CONV_SIZE                                        (2u)

#define CY_CAPSENSE_TUNER_BUTTON1_MAX_RAW_COUNT_OFFSET                                 (94u)
#define CY_CAPSENSE_TUNER_BUTTON1_MAX_RAW_COUNT_SIZE                                   (2u)

#define CY_CAPSENSE_TUNER_BUTTON1_FINGER_TH_OFFSET                                     (96u)
#define CY_CAPSENSE_TUNER_BUTTON1_FINGER_TH_SIZE                                       (2u)

#define CY_CAPSENSE_TUNER_BUTTON1_PROX_TOUCH_TH_OFFSET                                 (98u)
#define CY_CAPSENSE_TUNER_BUTTON1_PROX_TOUCH_TH_SIZE                                   (2u)

#define CY_CAPSENSE_TUNER_BUTTON1_LOW_BSLN_RST_OFFSET                                  (100u)
#define CY_CAPSENSE_TUNER_BUTTON1_LOW_BSLN_RST_SIZE                                    (2u)

#define CY_CAPSENSE_TUNER_BUTTON1_TX_CLK_OFFSET                                        (102u)
#define CY_CAPSENSE_TUNER_BUTTON1_TX_CLK_SIZE                                          (2u)

#define CY_CAPSENSE_TUNER_BUTTON1_ROW_SNS_CLK_OFFSET                                   (104u)
#define CY_CAPSENSE_TUNER_BUTTON1_ROW_SNS_CLK_SIZE                                     (2u)

#define CY_CAPSENSE_TUNER_BUTTON1_GESTURE_DETECTED_OFFSET                              (106u)
#define CY_CAPSENSE_TUNER_BUTTON1_GESTURE_DETECTED_SIZE                                (2u)

#define CY_CAPSENSE_TUNER_BUTTON1_GESTURE_DIRECTION_OFFSET                             (108u)
#define CY_CAPSENSE_TUNER_BUTTON1_GESTURE_DIRECTION_SIZE                               (2u)

#define CY_CAPSENSE_TUNER_BUTTON1_XDELTA_OFFSET                                        (110u)
#define CY_CAPSENSE_TUNER_BUTTON1_XDELTA_SIZE                                          (2u)

#define CY_CAPSENSE_TUNER_BUTTON1_YDELTA_OFFSET                                        (112u)
#define CY_CAPSENSE_TUNER_BUTTON1_YDELTA_SIZE                                          (2u)

#define CY_CAPSENSE_TUNER_BUTTON1_NOISE_TH_OFFSET                                      (114u)
#define CY_CAPSENSE_TUNER_BUTTON1_NOISE_TH_SIZE                                        (1u)

#define CY_CAPSENSE_TUNER_BUTTON1_NNOISE_TH_OFFSET                                     (115u)
#define CY_CAPSENSE_TUNER_BUTTON1_NNOISE_TH_SIZE                                       (1u)

#define CY_CAPSENSE_TUNER_BUTTON1_HYSTERESIS_OFFSET                                    (116u)
#define CY_CAPSENSE_TUNER_BUTTON1_HYSTERESIS_SIZE                                      (1u)

#define CY_CAPSENSE_TUNER_BUTTON1_ON_DEBOUNCE_OFFSET                                   (117u)
#define CY_CAPSENSE_TUNER_BUTTON1_ON_DEBOUNCE_SIZE                                     (1u)

#define CY_CAPSENSE_TUNER_BUTTON1_TX_CLK_SOURCE_OFFSET                                 (118u)
#define CY_CAPSENSE_TUNER_BUTTON1_TX_CLK_SOURCE_SIZE                                   (1u)

#define CY_CAPSENSE_TUNER_BUTTON1_IDAC_MOD0_OFFSET                                     (119u)
#define CY_CAPSENSE_TUNER_BUTTON1_IDAC_MOD0_SIZE                                       (1u)

#define CY_CAPSENSE_TUNER_BUTTON1_IDAC_MOD1_OFFSET                                     (120u)
#define CY_CAPSENSE_TUNER_BUTTON1_IDAC_MOD1_SIZE                                       (1u)

#define CY_CAPSENSE_TUNER_BUTTON1_IDAC_MOD2_OFFSET                                     (121u)
#define CY_CAPSENSE_TUNER_BUTTON1_IDAC_MOD2_SIZE                                       (1u)

#define CY_CAPSENSE_TUNER_BUTTON1_IDAC_GAIN_INDEX_OFFSET                               (122u)
#define CY_CAPSENSE_TUNER_BUTTON1_IDAC_GAIN_INDEX_SIZE                                 (1u)

#define CY_CAPSENSE_TUNER_BUTTON1_ROW_IDAC_MOD0_OFFSET                                 (123u)
#define CY_CAPSENSE_TUNER_BUTTON1_ROW_IDAC_MOD0_SIZE                                   (1u)

#define CY_CAPSENSE_TUNER_BUTTON1_ROW_IDAC_MOD1_OFFSET                                 (124u)
#define CY_CAPSENSE_TUNER_BUTTON1_ROW_IDAC_MOD1_SIZE                                   (1u)

#define CY_CAPSENSE_TUNER_BUTTON1_ROW_IDAC_MOD2_OFFSET                                 (125u)
#define CY_CAPSENSE_TUNER_BUTTON1_ROW_IDAC_MOD2_SIZE                                   (1u)

#define CY_CAPSENSE_TUNER_BUTTON1_REGULAR_IIR_BL_N_OFFSET                              (126u)
#define CY_CAPSENSE_TUNER_BUTTON1_REGULAR_IIR_BL_N_SIZE                                (1u)

#define CY_CAPSENSE_TUNER_BUTTON1_STATUS_OFFSET                                        (127u)
#define CY_CAPSENSE_TUNER_BUTTON1_STATUS_SIZE                                          (1u)

#define CY_CAPSENSE_TUNER_BUTTON1_PTRPOSITION_OFFSET                                   (128u)
#define CY_CAPSENSE_TUNER_BUTTON1_PTRPOSITION_SIZE                                     (4u)

#define CY_CAPSENSE_TUNER_BUTTON1_NUM_POSITIONS_OFFSET                                 (132u)
#define CY_CAPSENSE_TUNER_BUTTON1_NUM_POSITIONS_SIZE                                   (1u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_FINGER_CP_OFFSET                               (136u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_FINGER_CP_SIZE                                 (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SIGPFC_OFFSET                                  (138u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SIGPFC_SIZE                                    (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_RESOLUTION_OFFSET                              (140u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_RESOLUTION_SIZE                                (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_MAX_RAW_COUNT_OFFSET                           (142u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_MAX_RAW_COUNT_SIZE                             (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_FINGER_TH_OFFSET                               (144u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_FINGER_TH_SIZE                                 (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_PROX_TOUCH_TH_OFFSET                           (146u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_PROX_TOUCH_TH_SIZE                             (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_LOW_BSLN_RST_OFFSET                            (148u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_LOW_BSLN_RST_SIZE                              (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS_CLK_OFFSET                                 (150u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS_CLK_SIZE                                   (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_ROW_SNS_CLK_OFFSET                             (152u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_ROW_SNS_CLK_SIZE                               (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_GESTURE_DETECTED_OFFSET                        (154u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_GESTURE_DETECTED_SIZE                          (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_GESTURE_DIRECTION_OFFSET                       (156u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_GESTURE_DIRECTION_SIZE                         (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_XDELTA_OFFSET                                  (158u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_XDELTA_SIZE                                    (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_YDELTA_OFFSET                                  (160u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_YDELTA_SIZE                                    (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_NOISE_TH_OFFSET                                (162u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_NOISE_TH_SIZE                                  (1u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_NNOISE_TH_OFFSET                               (163u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_NNOISE_TH_SIZE                                 (1u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_HYSTERESIS_OFFSET                              (164u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_HYSTERESIS_SIZE                                (1u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_ON_DEBOUNCE_OFFSET                             (165u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_ON_DEBOUNCE_SIZE                               (1u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS_CLK_SOURCE_OFFSET                          (166u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS_CLK_SOURCE_SIZE                            (1u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_IDAC_MOD0_OFFSET                               (167u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_IDAC_MOD0_SIZE                                 (1u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_IDAC_MOD1_OFFSET                               (168u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_IDAC_MOD1_SIZE                                 (1u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_IDAC_MOD2_OFFSET                               (169u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_IDAC_MOD2_SIZE                                 (1u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_IDAC_GAIN_INDEX_OFFSET                         (170u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_IDAC_GAIN_INDEX_SIZE                           (1u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_ROW_IDAC_MOD0_OFFSET                           (171u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_ROW_IDAC_MOD0_SIZE                             (1u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_ROW_IDAC_MOD1_OFFSET                           (172u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_ROW_IDAC_MOD1_SIZE                             (1u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_ROW_IDAC_MOD2_OFFSET                           (173u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_ROW_IDAC_MOD2_SIZE                             (1u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_REGULAR_IIR_BL_N_OFFSET                        (174u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_REGULAR_IIR_BL_N_SIZE                          (1u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_STATUS_OFFSET                                  (175u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_STATUS_SIZE                                    (1u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_PTRPOSITION_OFFSET                             (176u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_PTRPOSITION_SIZE                               (4u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_NUM_POSITIONS_OFFSET                           (180u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_NUM_POSITIONS_SIZE                             (1u)

#define CY_CAPSENSE_TUNER_BUTTON0_RX0_RAW0_OFFSET                                      (184u)
#define CY_CAPSENSE_TUNER_BUTTON0_RX0_RAW0_SIZE                                        (2u)

#define CY_CAPSENSE_TUNER_BUTTON0_RX0_BSLN0_OFFSET                                     (186u)
#define CY_CAPSENSE_TUNER_BUTTON0_RX0_BSLN0_SIZE                                       (2u)

#define CY_CAPSENSE_TUNER_BUTTON0_RX0_DIFF0_OFFSET                                     (188u)
#define CY_CAPSENSE_TUNER_BUTTON0_RX0_DIFF0_SIZE                                       (2u)

#define CY_CAPSENSE_TUNER_BUTTON0_RX0_STATUS0_OFFSET                                   (190u)
#define CY_CAPSENSE_TUNER_BUTTON0_RX0_STATUS0_SIZE                                     (1u)

#define CY_CAPSENSE_TUNER_BUTTON0_RX0_NEG_BSLN_RST_CNT0_OFFSET                         (191u)
#define CY_CAPSENSE_TUNER_BUTTON0_RX0_NEG_BSLN_RST_CNT0_SIZE                           (1u)

#define CY_CAPSENSE_TUNER_BUTTON0_RX0_IDAC0_OFFSET                                     (192u)
#define CY_CAPSENSE_TUNER_BUTTON0_RX0_IDAC0_SIZE                                       (1u)

#define CY_CAPSENSE_TUNER_BUTTON0_RX0_BSLN_EXT0_OFFSET                                 (193u)
#define CY_CAPSENSE_TUNER_BUTTON0_RX0_BSLN_EXT0_SIZE                                   (1u)

#define CY_CAPSENSE_TUNER_BUTTON1_RX0_RAW0_OFFSET                                      (194u)
#define CY_CAPSENSE_TUNER_BUTTON1_RX0_RAW0_SIZE                                        (2u)

#define CY_CAPSENSE_TUNER_BUTTON1_RX0_BSLN0_OFFSET                                     (196u)
#define CY_CAPSENSE_TUNER_BUTTON1_RX0_BSLN0_SIZE                                       (2u)

#define CY_CAPSENSE_TUNER_BUTTON1_RX0_DIFF0_OFFSET                                     (198u)
#define CY_CAPSENSE_TUNER_BUTTON1_RX0_DIFF0_SIZE                                       (2u)

#define CY_CAPSENSE_TUNER_BUTTON1_RX0_STATUS0_OFFSET                                   (200u)
#define CY_CAPSENSE_TUNER_BUTTON1_RX0_STATUS0_SIZE                                     (1u)

#define CY_CAPSENSE_TUNER_BUTTON1_RX0_NEG_BSLN_RST_CNT0_OFFSET                         (201u)
#define CY_CAPSENSE_TUNER_BUTTON1_RX0_NEG_BSLN_RST_CNT0_SIZE                           (1u)

#define CY_CAPSENSE_TUNER_BUTTON1_RX0_IDAC0_OFFSET                                     (202u)
#define CY_CAPSENSE_TUNER_BUTTON1_RX0_IDAC0_SIZE                                       (1u)

#define CY_CAPSENSE_TUNER_BUTTON1_RX0_BSLN_EXT0_OFFSET                                 (203u)
#define CY_CAPSENSE_TUNER_BUTTON1_RX0_BSLN_EXT0_SIZE                                   (1u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS0_RAW0_OFFSET                               (204u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS0_RAW0_SIZE                                 (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS0_BSLN0_OFFSET                              (206u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS0_BSLN0_SIZE                                (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS0_DIFF0_OFFSET                              (208u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS0_DIFF0_SIZE                                (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS0_STATUS0_OFFSET                            (210u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS0_STATUS0_SIZE                              (1u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS0_NEG_BSLN_RST_CNT0_OFFSET                  (211u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS0_NEG_BSLN_RST_CNT0_SIZE                    (1u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS0_IDAC0_OFFSET                              (212u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS0_IDAC0_SIZE                                (1u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS0_BSLN_EXT0_OFFSET                          (213u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS0_BSLN_EXT0_SIZE                            (1u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS1_RAW0_OFFSET                               (214u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS1_RAW0_SIZE                                 (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS1_BSLN0_OFFSET                              (216u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS1_BSLN0_SIZE                                (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS1_DIFF0_OFFSET                              (218u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS1_DIFF0_SIZE                                (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS1_STATUS0_OFFSET                            (220u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS1_STATUS0_SIZE                              (1u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS1_NEG_BSLN_RST_CNT0_OFFSET                  (221u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS1_NEG_BSLN_RST_CNT0_SIZE                    (1u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS1_IDAC0_OFFSET                              (222u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS1_IDAC0_SIZE                                (1u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS1_BSLN_EXT0_OFFSET                          (223u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS1_BSLN_EXT0_SIZE                            (1u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS2_RAW0_OFFSET                               (224u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS2_RAW0_SIZE                                 (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS2_BSLN0_OFFSET                              (226u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS2_BSLN0_SIZE                                (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS2_DIFF0_OFFSET                              (228u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS2_DIFF0_SIZE                                (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS2_STATUS0_OFFSET                            (230u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS2_STATUS0_SIZE                              (1u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS2_NEG_BSLN_RST_CNT0_OFFSET                  (231u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS2_NEG_BSLN_RST_CNT0_SIZE                    (1u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS2_IDAC0_OFFSET                              (232u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS2_IDAC0_SIZE                                (1u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS2_BSLN_EXT0_OFFSET                          (233u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS2_BSLN_EXT0_SIZE                            (1u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS3_RAW0_OFFSET                               (234u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS3_RAW0_SIZE                                 (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS3_BSLN0_OFFSET                              (236u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS3_BSLN0_SIZE                                (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS3_DIFF0_OFFSET                              (238u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS3_DIFF0_SIZE                                (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS3_STATUS0_OFFSET                            (240u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS3_STATUS0_SIZE                              (1u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS3_NEG_BSLN_RST_CNT0_OFFSET                  (241u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS3_NEG_BSLN_RST_CNT0_SIZE                    (1u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS3_IDAC0_OFFSET                              (242u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS3_IDAC0_SIZE                                (1u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS3_BSLN_EXT0_OFFSET                          (243u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS3_BSLN_EXT0_SIZE                            (1u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS4_RAW0_OFFSET                               (244u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS4_RAW0_SIZE                                 (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS4_BSLN0_OFFSET                              (246u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS4_BSLN0_SIZE                                (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS4_DIFF0_OFFSET                              (248u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS4_DIFF0_SIZE                                (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS4_STATUS0_OFFSET                            (250u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS4_STATUS0_SIZE                              (1u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS4_NEG_BSLN_RST_CNT0_OFFSET                  (251u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS4_NEG_BSLN_RST_CNT0_SIZE                    (1u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS4_IDAC0_OFFSET                              (252u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS4_IDAC0_SIZE                                (1u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS4_BSLN_EXT0_OFFSET                          (253u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS4_BSLN_EXT0_SIZE                            (1u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_X0_OFFSET                                      (254u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_X0_SIZE                                        (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_Y0_OFFSET                                      (256u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_Y0_SIZE                                        (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_Z0_OFFSET                                      (258u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_Z0_SIZE                                        (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_ID0_OFFSET                                     (260u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_ID0_SIZE                                       (2u)

#elif (CY_CAPSENSE_TUNER_MW_VERSION < 400)
#define CY_CAPSENSE_TUNER_CONFIG_ID_OFFSET                                             (0u)
#define CY_CAPSENSE_TUNER_CONFIG_ID_SIZE                                               (2u)

#define CY_CAPSENSE_TUNER_TUNER_CMD_OFFSET                                             (2u)
#define CY_CAPSENSE_TUNER_TUNER_CMD_SIZE                                               (2u)

#define CY_CAPSENSE_TUNER_SCAN_COUNTER_OFFSET                                          (4u)
#define CY_CAPSENSE_TUNER_SCAN_COUNTER_SIZE                                            (2u)

#define CY_CAPSENSE_TUNER_TUNER_ST_OFFSET                                              (6u)
#define CY_CAPSENSE_TUNER_TUNER_ST_SIZE                                                (1u)

#define CY_CAPSENSE_TUNER_INITDONE_OFFSET                                              (7u)
#define CY_CAPSENSE_TUNER_INITDONE_SIZE                                                (1u)

#define CY_CAPSENSE_TUNER_STATUS_OFFSET                                                (8u)
#define CY_CAPSENSE_TUNER_STATUS_SIZE                                                  (4u)

#define CY_CAPSENSE_TUNER_TIMESTAMPINTERVAL_OFFSET                                     (12u)
#define CY_CAPSENSE_TUNER_TIMESTAMPINTERVAL_SIZE                                       (4u)

#define CY_CAPSENSE_TUNER_TIMESTAMP_OFFSET                                             (16u)
#define CY_CAPSENSE_TUNER_TIMESTAMP_SIZE                                               (4u)

#define CY_CAPSENSE_TUNER_CSD_MOD_CLK_DIVIDER_OFFSET                                   (20u)
#define CY_CAPSENSE_TUNER_CSD_MOD_CLK_DIVIDER_SIZE                                     (1u)

#define CY_CAPSENSE_TUNER_CSX_MOD_CLK_DIVIDER_OFFSET                                   (21u)
#define CY_CAPSENSE_TUNER_CSX_MOD_CLK_DIVIDER_SIZE                                     (1u)

#define CY_CAPSENSE_TUNER_TUNER_CNT_OFFSET                                             (22u)
#define CY_CAPSENSE_TUNER_TUNER_CNT_SIZE                                               (1u)

#define CY_CAPSENSE_TUNER_BUTTON0_FINGER_CP_OFFSET                                     (24u)
#define CY_CAPSENSE_TUNER_BUTTON0_FINGER_CP_SIZE                                       (2u)

#define CY_CAPSENSE_TUNER_BUTTON0_SIGPFC_OFFSET                                        (26u)
#define CY_CAPSENSE_TUNER_BUTTON0_SIGPFC_SIZE                                          (2u)

#define CY_CAPSENSE_TUNER_BUTTON0_NUM_CONV_OFFSET                                      (28u)
#define CY_CAPSENSE_TUNER_BUTTON0_NUM_CONV_SIZE                                        (2u)

#define CY_CAPSENSE_TUNER_BUTTON0_MAX_RAW_COUNT_OFFSET                                 (30u)
#define CY_CAPSENSE_TUNER_BUTTON0_MAX_RAW_COUNT_SIZE                                   (2u)

#define CY_CAPSENSE_TUNER_BUTTON0_ROW_MAX_RAW_COUNT_OFFSET                             (32u)
#define CY_CAPSENSE_TUNER_BUTTON0_ROW_MAX_RAW_COUNT_SIZE                               (2u)

#define CY_CAPSENSE_TUNER_BUTTON0_FINGER_TH_OFFSET                                     (34u)
#define CY_CAPSENSE_TUNER_BUTTON0_FINGER_TH_SIZE                                       (2u)

#define CY_CAPSENSE_TUNER_BUTTON0_PROX_TOUCH_TH_OFFSET                                 (36u)
#define CY_CAPSENSE_TUNER_BUTTON0_PROX_TOUCH_TH_SIZE                                   (2u)

#define CY_CAPSENSE_TUNER_BUTTON0_LOW_BSLN_RST_OFFSET                                  (38u)
#define CY_CAPSENSE_TUNER_BUTTON0_LOW_BSLN_RST_SIZE                                    (2u)

#define CY_CAPSENSE_TUNER_BUTTON0_TX_CLK_OFFSET                                        (40u)
#define CY_CAPSENSE_TUNER_BUTTON0_TX_CLK_SIZE                                          (2u)

#define CY_CAPSENSE_TUNER_BUTTON0_ROW_SNS_CLK_OFFSET                                   (42u)
#define CY_CAPSENSE_TUNER_BUTTON0_ROW_SNS_CLK_SIZE                                     (2u)

#define CY_CAPSENSE_TUNER_BUTTON0_GESTURE_DETECTED_OFFSET                              (44u)
#define CY_CAPSENSE_TUNER_BUTTON0_GESTURE_DETECTED_SIZE                                (2u)

#define CY_CAPSENSE_TUNER_BUTTON0_GESTURE_DIRECTION_OFFSET                             (46u)
#define CY_CAPSENSE_TUNER_BUTTON0_GESTURE_DIRECTION_SIZE                               (2u)

#define CY_CAPSENSE_TUNER_BUTTON0_XDELTA_OFFSET                                        (48u)
#define CY_CAPSENSE_TUNER_BUTTON0_XDELTA_SIZE                                          (2u)

#define CY_CAPSENSE_TUNER_BUTTON0_YDELTA_OFFSET                                        (50u)
#define CY_CAPSENSE_TUNER_BUTTON0_YDELTA_SIZE                                          (2u)

#define CY_CAPSENSE_TUNER_BUTTON0_NOISE_TH_OFFSET                                      (52u)
#define CY_CAPSENSE_TUNER_BUTTON0_NOISE_TH_SIZE                                        (2u)

#define CY_CAPSENSE_TUNER_BUTTON0_NNOISE_TH_OFFSET                                     (54u)
#define CY_CAPSENSE_TUNER_BUTTON0_NNOISE_TH_SIZE                                       (2u)

#define CY_CAPSENSE_TUNER_BUTTON0_HYSTERESIS_OFFSET                                    (56u)
#define CY_CAPSENSE_TUNER_BUTTON0_HYSTERESIS_SIZE                                      (2u)

#define CY_CAPSENSE_TUNER_BUTTON0_ON_DEBOUNCE_OFFSET                                   (58u)
#define CY_CAPSENSE_TUNER_BUTTON0_ON_DEBOUNCE_SIZE                                     (1u)

#define CY_CAPSENSE_TUNER_BUTTON0_TX_CLK_SOURCE_OFFSET                                 (59u)
#define CY_CAPSENSE_TUNER_BUTTON0_TX_CLK_SOURCE_SIZE                                   (1u)

#define CY_CAPSENSE_TUNER_BUTTON0_IDAC_MOD0_OFFSET                                     (60u)
#define CY_CAPSENSE_TUNER_BUTTON0_IDAC_MOD0_SIZE                                       (1u)

#define CY_CAPSENSE_TUNER_BUTTON0_IDAC_MOD1_OFFSET                                     (61u)
#define CY_CAPSENSE_TUNER_BUTTON0_IDAC_MOD1_SIZE                                       (1u)

#define CY_CAPSENSE_TUNER_BUTTON0_IDAC_MOD2_OFFSET                                     (62u)
#define CY_CAPSENSE_TUNER_BUTTON0_IDAC_MOD2_SIZE                                       (1u)

#define CY_CAPSENSE_TUNER_BUTTON0_IDAC_GAIN_INDEX_OFFSET                               (63u)
#define CY_CAPSENSE_TUNER_BUTTON0_IDAC_GAIN_INDEX_SIZE                                 (1u)

#define CY_CAPSENSE_TUNER_BUTTON0_ROW_IDAC_MOD0_OFFSET                                 (64u)
#define CY_CAPSENSE_TUNER_BUTTON0_ROW_IDAC_MOD0_SIZE                                   (1u)

#define CY_CAPSENSE_TUNER_BUTTON0_ROW_IDAC_MOD1_OFFSET                                 (65u)
#define CY_CAPSENSE_TUNER_BUTTON0_ROW_IDAC_MOD1_SIZE                                   (1u)

#define CY_CAPSENSE_TUNER_BUTTON0_ROW_IDAC_MOD2_OFFSET                                 (66u)
#define CY_CAPSENSE_TUNER_BUTTON0_ROW_IDAC_MOD2_SIZE                                   (1u)

#define CY_CAPSENSE_TUNER_BUTTON0_REGULAR_IIR_BL_N_OFFSET                              (67u)
#define CY_CAPSENSE_TUNER_BUTTON0_REGULAR_IIR_BL_N_SIZE                                (1u)

#define CY_CAPSENSE_TUNER_BUTTON0_STATUS_OFFSET                                        (68u)
#define CY_CAPSENSE_TUNER_BUTTON0_STATUS_SIZE                                          (1u)

#define CY_CAPSENSE_TUNER_BUTTON0_PTRPOSITION_OFFSET                                   (72u)
#define CY_CAPSENSE_TUNER_BUTTON0_PTRPOSITION_SIZE                                     (4u)

#define CY_CAPSENSE_TUNER_BUTTON0_NUM_POSITIONS_OFFSET                                 (76u)
#define CY_CAPSENSE_TUNER_BUTTON0_NUM_POSITIONS_SIZE                                   (1u)

#define CY_CAPSENSE_TUNER_BUTTON1_FINGER_CP_OFFSET                                     (80u)
#define CY_CAPSENSE_TUNER_BUTTON1_FINGER_CP_SIZE                                       (2u)

#define CY_CAPSENSE_TUNER_BUTTON1_SIGPFC_OFFSET                                        (82u)
#define CY_CAPSENSE_TUNER_BUTTON1_SIGPFC_SIZE                                          (2u)

#define CY_CAPSENSE_TUNER_BUTTON1_NUM_CONV_OFFSET                                      (84u)
#define CY_CAPSENSE_TUNER_BUTTON1_NUM_CONV_SIZE                                        (2u)

#define CY_CAPSENSE_TUNER_BUTTON1_MAX_RAW_COUNT_OFFSET                                 (86u)
#define CY_CAPSENSE_TUNER_BUTTON1_MAX_RAW_COUNT_SIZE                                   (2u)

#define CY_CAPSENSE_TUNER_BUTTON1_ROW_MAX_RAW_COUNT_OFFSET                             (88u)
#define CY_CAPSENSE_TUNER_BUTTON1_ROW_MAX_RAW_COUNT_SIZE                               (2u)

#define CY_CAPSENSE_TUNER_BUTTON1_FINGER_TH_OFFSET                                     (90u)
#define CY_CAPSENSE_TUNER_BUTTON1_FINGER_TH_SIZE                                       (2u)

#define CY_CAPSENSE_TUNER_BUTTON1_PROX_TOUCH_TH_OFFSET                                 (92u)
#define CY_CAPSENSE_TUNER_BUTTON1_PROX_TOUCH_TH_SIZE                                   (2u)

#define CY_CAPSENSE_TUNER_BUTTON1_LOW_BSLN_RST_OFFSET                                  (94u)
#define CY_CAPSENSE_TUNER_BUTTON1_LOW_BSLN_RST_SIZE                                    (2u)

#define CY_CAPSENSE_TUNER_BUTTON1_TX_CLK_OFFSET                                        (96u)
#define CY_CAPSENSE_TUNER_BUTTON1_TX_CLK_SIZE                                          (2u)

#define CY_CAPSENSE_TUNER_BUTTON1_ROW_SNS_CLK_OFFSET                                   (98u)
#define CY_CAPSENSE_TUNER_BUTTON1_ROW_SNS_CLK_SIZE                                     (2u)

#define CY_CAPSENSE_TUNER_BUTTON1_GESTURE_DETECTED_OFFSET                              (100u)
#define CY_CAPSENSE_TUNER_BUTTON1_GESTURE_DETECTED_SIZE                                (2u)

#define CY_CAPSENSE_TUNER_BUTTON1_GESTURE_DIRECTION_OFFSET                             (102u)
#define CY_CAPSENSE_TUNER_BUTTON1_GESTURE_DIRECTION_SIZE                               (2u)

#define CY_CAPSENSE_TUNER_BUTTON1_XDELTA_OFFSET                                        (104u)
#define CY_CAPSENSE_TUNER_BUTTON1_XDELTA_SIZE                                          (2u)

#define CY_CAPSENSE_TUNER_BUTTON1_YDELTA_OFFSET                                        (106u)
#define CY_CAPSENSE_TUNER_BUTTON1_YDELTA_SIZE                                          (2u)

#define CY_CAPSENSE_TUNER_BUTTON1_NOISE_TH_OFFSET                                      (108u)
#define CY_CAPSENSE_TUNER_BUTTON1_NOISE_TH_SIZE                                        (2u)

#define CY_CAPSENSE_TUNER_BUTTON1_NNOISE_TH_OFFSET                                     (110u)
#define CY_CAPSENSE_TUNER_BUTTON1_NNOISE_TH_SIZE                                       (2u)

#define CY_CAPSENSE_TUNER_BUTTON1_HYSTERESIS_OFFSET                                    (112u)
#define CY_CAPSENSE_TUNER_BUTTON1_HYSTERESIS_SIZE                                      (2u)

#define CY_CAPSENSE_TUNER_BUTTON1_ON_DEBOUNCE_OFFSET                                   (114u)
#define CY_CAPSENSE_TUNER_BUTTON1_ON_DEBOUNCE_SIZE                                     (1u)

#define CY_CAPSENSE_TUNER_BUTTON1_TX_CLK_SOURCE_OFFSET                                 (115u)
#define CY_CAPSENSE_TUNER_BUTTON1_TX_CLK_SOURCE_SIZE                                   (1u)

#define CY_CAPSENSE_TUNER_BUTTON1_IDAC_MOD0_OFFSET                                     (116u)
#define CY_CAPSENSE_TUNER_BUTTON1_IDAC_MOD0_SIZE                                       (1u)

#define CY_CAPSENSE_TUNER_BUTTON1_IDAC_MOD1_OFFSET                                     (117u)
#define CY_CAPSENSE_TUNER_BUTTON1_IDAC_MOD1_SIZE                                       (1u)

#define CY_CAPSENSE_TUNER_BUTTON1_IDAC_MOD2_OFFSET                                     (118u)
#define CY_CAPSENSE_TUNER_BUTTON1_IDAC_MOD2_SIZE                                       (1u)

#define CY_CAPSENSE_TUNER_BUTTON1_IDAC_GAIN_INDEX_OFFSET                               (119u)
#define CY_CAPSENSE_TUNER_BUTTON1_IDAC_GAIN_INDEX_SIZE                                 (1u)

#define CY_CAPSENSE_TUNER_BUTTON1_ROW_IDAC_MOD0_OFFSET                                 (120u)
#define CY_CAPSENSE_TUNER_BUTTON1_ROW_IDAC_MOD0_SIZE                                   (1u)

#define CY_CAPSENSE_TUNER_BUTTON1_ROW_IDAC_MOD1_OFFSET                                 (121u)
#define CY_CAPSENSE_TUNER_BUTTON1_ROW_IDAC_MOD1_SIZE                                   (1u)

#define CY_CAPSENSE_TUNER_BUTTON1_ROW_IDAC_MOD2_OFFSET                                 (122u)
#define CY_CAPSENSE_TUNER_BUTTON1_ROW_IDAC_MOD2_SIZE                                   (1u)

#define CY_CAPSENSE_TUNER_BUTTON1_REGULAR_IIR_BL_N_OFFSET                              (123u)
#define CY_CAPSENSE_TUNER_BUTTON1_REGULAR_IIR_BL_N_SIZE                                (1u)

#define CY_CAPSENSE_TUNER_BUTTON1_STATUS_OFFSET                                        (124u)
#define CY_CAPSENSE_TUNER_BUTTON1_STATUS_SIZE                                          (1u)

#define CY_CAPSENSE_TUNER_BUTTON1_PTRPOSITION_OFFSET                                   (128u)
#define CY_CAPSENSE_TUNER_BUTTON1_PTRPOSITION_SIZE                                     (4u)

#define CY_CAPSENSE_TUNER_BUTTON1_NUM_POSITIONS_OFFSET                                 (132u)
#define CY_CAPSENSE_TUNER_BUTTON1_NUM_POSITIONS_SIZE                                   (1u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_FINGER_CP_OFFSET                               (136u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_FINGER_CP_SIZE                                 (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SIGPFC_OFFSET                                  (138u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SIGPFC_SIZE                                    (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_RESOLUTION_OFFSET                              (140u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_RESOLUTION_SIZE                                (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_MAX_RAW_COUNT_OFFSET                           (142u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_MAX_RAW_COUNT_SIZE                             (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_ROW_MAX_RAW_COUNT_OFFSET                       (144u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_ROW_MAX_RAW_COUNT_SIZE                         (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_FINGER_TH_OFFSET                               (146u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_FINGER_TH_SIZE                                 (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_PROX_TOUCH_TH_OFFSET                           (148u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_PROX_TOUCH_TH_SIZE                             (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_LOW_BSLN_RST_OFFSET                            (150u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_LOW_BSLN_RST_SIZE                              (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS_CLK_OFFSET                                 (152u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS_CLK_SIZE                                   (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_ROW_SNS_CLK_OFFSET                             (154u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_ROW_SNS_CLK_SIZE                               (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_GESTURE_DETECTED_OFFSET                        (156u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_GESTURE_DETECTED_SIZE                          (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_GESTURE_DIRECTION_OFFSET                       (158u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_GESTURE_DIRECTION_SIZE                         (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_XDELTA_OFFSET                                  (160u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_XDELTA_SIZE                                    (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_YDELTA_OFFSET                                  (162u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_YDELTA_SIZE                                    (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_NOISE_TH_OFFSET                                (164u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_NOISE_TH_SIZE                                  (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_NNOISE_TH_OFFSET                               (166u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_NNOISE_TH_SIZE                                 (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_HYSTERESIS_OFFSET                              (168u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_HYSTERESIS_SIZE                                (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_ON_DEBOUNCE_OFFSET                             (170u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_ON_DEBOUNCE_SIZE                               (1u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS_CLK_SOURCE_OFFSET                          (171u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS_CLK_SOURCE_SIZE                            (1u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_IDAC_MOD0_OFFSET                               (172u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_IDAC_MOD0_SIZE                                 (1u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_IDAC_MOD1_OFFSET                               (173u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_IDAC_MOD1_SIZE                                 (1u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_IDAC_MOD2_OFFSET                               (174u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_IDAC_MOD2_SIZE                                 (1u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_IDAC_GAIN_INDEX_OFFSET                         (175u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_IDAC_GAIN_INDEX_SIZE                           (1u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_ROW_IDAC_MOD0_OFFSET                           (176u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_ROW_IDAC_MOD0_SIZE                             (1u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_ROW_IDAC_MOD1_OFFSET                           (177u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_ROW_IDAC_MOD1_SIZE                             (1u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_ROW_IDAC_MOD2_OFFSET                           (178u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_ROW_IDAC_MOD2_SIZE                             (1u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_REGULAR_IIR_BL_N_OFFSET                        (179u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_REGULAR_IIR_BL_N_SIZE                          (1u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_STATUS_OFFSET                                  (180u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_STATUS_SIZE                                    (1u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_PTRPOSITION_OFFSET                             (184u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_PTRPOSITION_SIZE                               (4u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_NUM_POSITIONS_OFFSET                           (188u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_NUM_POSITIONS_SIZE                             (1u)

#define CY_CAPSENSE_TUNER_BUTTON0_RX0_RAW0_OFFSET                                      (192u)
#define CY_CAPSENSE_TUNER_BUTTON0_RX0_RAW0_SIZE                                        (2u)

#define CY_CAPSENSE_TUNER_BUTTON0_RX0_BSLN0_OFFSET                                     (194u)
#define CY_CAPSENSE_TUNER_BUTTON0_RX0_BSLN0_SIZE                                       (2u)

#define CY_CAPSENSE_TUNER_BUTTON0_RX0_DIFF0_OFFSET                                     (196u)
#define CY_CAPSENSE_TUNER_BUTTON0_RX0_DIFF0_SIZE                                       (2u)

#define CY_CAPSENSE_TUNER_BUTTON0_RX0_STATUS0_OFFSET                                   (198u)
#define CY_CAPSENSE_TUNER_BUTTON0_RX0_STATUS0_SIZE                                     (1u)

#define CY_CAPSENSE_TUNER_BUTTON0_RX0_NEG_BSLN_RST_CNT0_OFFSET                         (199u)
#define CY_CAPSENSE_TUNER_BUTTON0_RX0_NEG_BSLN_RST_CNT0_SIZE                           (1u)

#define CY_CAPSENSE_TUNER_BUTTON0_RX0_IDAC0_OFFSET                                     (200u)
#define CY_CAPSENSE_TUNER_BUTTON0_RX0_IDAC0_SIZE                                       (1u)

#define CY_CAPSENSE_TUNER_BUTTON0_RX0_BSLN_EXT0_OFFSET                                 (201u)
#define CY_CAPSENSE_TUNER_BUTTON0_RX0_BSLN_EXT0_SIZE                                   (1u)

#define CY_CAPSENSE_TUNER_BUTTON1_RX0_RAW0_OFFSET                                      (202u)
#define CY_CAPSENSE_TUNER_BUTTON1_RX0_RAW0_SIZE                                        (2u)

#define CY_CAPSENSE_TUNER_BUTTON1_RX0_BSLN0_OFFSET                                     (204u)
#define CY_CAPSENSE_TUNER_BUTTON1_RX0_BSLN0_SIZE                                       (2u)

#define CY_CAPSENSE_TUNER_BUTTON1_RX0_DIFF0_OFFSET                                     (206u)
#define CY_CAPSENSE_TUNER_BUTTON1_RX0_DIFF0_SIZE                                       (2u)

#define CY_CAPSENSE_TUNER_BUTTON1_RX0_STATUS0_OFFSET                                   (208u)
#define CY_CAPSENSE_TUNER_BUTTON1_RX0_STATUS0_SIZE                                     (1u)

#define CY_CAPSENSE_TUNER_BUTTON1_RX0_NEG_BSLN_RST_CNT0_OFFSET                         (209u)
#define CY_CAPSENSE_TUNER_BUTTON1_RX0_NEG_BSLN_RST_CNT0_SIZE                           (1u)

#define CY_CAPSENSE_TUNER_BUTTON1_RX0_IDAC0_OFFSET                                     (210u)
#define CY_CAPSENSE_TUNER_BUTTON1_RX0_IDAC0_SIZE                                       (1u)

#define CY_CAPSENSE_TUNER_BUTTON1_RX0_BSLN_EXT0_OFFSET                                 (211u)
#define CY_CAPSENSE_TUNER_BUTTON1_RX0_BSLN_EXT0_SIZE                                   (1u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS0_RAW0_OFFSET                               (212u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS0_RAW0_SIZE                                 (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS0_BSLN0_OFFSET                              (214u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS0_BSLN0_SIZE                                (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS0_DIFF0_OFFSET                              (216u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS0_DIFF0_SIZE                                (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS0_STATUS0_OFFSET                            (218u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS0_STATUS0_SIZE                              (1u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS0_NEG_BSLN_RST_CNT0_OFFSET                  (219u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS0_NEG_BSLN_RST_CNT0_SIZE                    (1u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS0_IDAC0_OFFSET                              (220u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS0_IDAC0_SIZE                                (1u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS0_BSLN_EXT0_OFFSET                          (221u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS0_BSLN_EXT0_SIZE                            (1u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS1_RAW0_OFFSET                               (222u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS1_RAW0_SIZE                                 (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS1_BSLN0_OFFSET                              (224u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS1_BSLN0_SIZE                                (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS1_DIFF0_OFFSET                              (226u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS1_DIFF0_SIZE                                (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS1_STATUS0_OFFSET                            (228u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS1_STATUS0_SIZE                              (1u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS1_NEG_BSLN_RST_CNT0_OFFSET                  (229u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS1_NEG_BSLN_RST_CNT0_SIZE                    (1u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS1_IDAC0_OFFSET                              (230u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS1_IDAC0_SIZE                                (1u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS1_BSLN_EXT0_OFFSET                          (231u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS1_BSLN_EXT0_SIZE                            (1u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS2_RAW0_OFFSET                               (232u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS2_RAW0_SIZE                                 (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS2_BSLN0_OFFSET                              (234u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS2_BSLN0_SIZE                                (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS2_DIFF0_OFFSET                              (236u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS2_DIFF0_SIZE                                (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS2_STATUS0_OFFSET                            (238u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS2_STATUS0_SIZE                              (1u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS2_NEG_BSLN_RST_CNT0_OFFSET                  (239u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS2_NEG_BSLN_RST_CNT0_SIZE                    (1u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS2_IDAC0_OFFSET                              (240u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS2_IDAC0_SIZE                                (1u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS2_BSLN_EXT0_OFFSET                          (241u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS2_BSLN_EXT0_SIZE                            (1u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS3_RAW0_OFFSET                               (242u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS3_RAW0_SIZE                                 (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS3_BSLN0_OFFSET                              (244u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS3_BSLN0_SIZE                                (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS3_DIFF0_OFFSET                              (246u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS3_DIFF0_SIZE                                (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS3_STATUS0_OFFSET                            (248u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS3_STATUS0_SIZE                              (1u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS3_NEG_BSLN_RST_CNT0_OFFSET                  (249u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS3_NEG_BSLN_RST_CNT0_SIZE                    (1u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS3_IDAC0_OFFSET                              (250u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS3_IDAC0_SIZE                                (1u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS3_BSLN_EXT0_OFFSET                          (251u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS3_BSLN_EXT0_SIZE                            (1u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS4_RAW0_OFFSET                               (252u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS4_RAW0_SIZE                                 (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS4_BSLN0_OFFSET                              (254u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS4_BSLN0_SIZE                                (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS4_DIFF0_OFFSET                              (256u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS4_DIFF0_SIZE                                (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS4_STATUS0_OFFSET                            (258u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS4_STATUS0_SIZE                              (1u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS4_NEG_BSLN_RST_CNT0_OFFSET                  (259u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS4_NEG_BSLN_RST_CNT0_SIZE                    (1u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS4_IDAC0_OFFSET                              (260u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS4_IDAC0_SIZE                                (1u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS4_BSLN_EXT0_OFFSET                          (261u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS4_BSLN_EXT0_SIZE                            (1u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_X0_OFFSET                                      (262u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_X0_SIZE                                        (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_Y0_OFFSET                                      (264u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_Y0_SIZE                                        (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_Z0_OFFSET                                      (266u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_Z0_SIZE                                        (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_ID0_OFFSET                                     (268u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_ID0_SIZE                                       (2u)

#elif (CY_CAPSENSE_TUNER_MW_VERSION < 500)
#define CY_CAPSENSE_TUNER_CONFIG_ID_OFFSET                                             (0u)
#define CY_CAPSENSE_TUNER_CONFIG_ID_SIZE                                               (2u)

#define CY_CAPSENSE_TUNER_TUNER_CMD_OFFSET                                             (2u)
#define CY_CAPSENSE_TUNER_TUNER_CMD_SIZE                                               (2u)

#define CY_CAPSENSE_TUNER_SCAN_COUNTER_OFFSET                                          (4u)
#define CY_CAPSENSE_TUNER_SCAN_COUNTER_SIZE                                            (2u)

#define CY_CAPSENSE_TUNER_TUNER_ST_OFFSET                                              (6u)
#define CY_CAPSENSE_TUNER_TUNER_ST_SIZE                                                (1u)

#define CY_CAPSENSE_TUNER_INITDONE_OFFSET                                              (7u)
#define CY_CAPSENSE_TUNER_INITDONE_SIZE                                                (1u)

#define CY_CAPSENSE_TUNER_STATUS_OFFSET                                                (8u)
#define CY_CAPSENSE_TUNER_STATUS_SIZE                                                  (4u)

#define CY_CAPSENSE_TUNER_TIMESTAMPINTERVAL_OFFSET                                     (12u)
#define CY_CAPSENSE_TUNER_TIMESTAMPINTERVAL_SIZE                                       (4u)

#define CY_CAPSENSE_TUNER_TIMESTAMP_OFFSET                                             (16u)
#define CY_CAPSENSE_TUNER_TIMESTAMP_SIZE                                               (4u)

#define CY_CAPSENSE_TUNER_CSD_MOD_CLK_DIVIDER_OFFSET                                   (20u)
#define CY_CAPSENSE_TUNER_CSD_MOD_CLK_DIVIDER_SIZE                                     (1u)

#define CY_CAPSENSE_TUNER_CSX_MOD_CLK_DIVIDER_OFFSET                                   (21u)
#define CY_CAPSENSE_TUNER_CSX_MOD_CLK_DIVIDER_SIZE                                     (1u)

#define CY_CAPSENSE_TUNER_TUNER_CNT_OFFSET                                             (22u)
#define CY_CAPSENSE_TUNER_TUNER_CNT_SIZE                                               (1u)

#define CY_CAPSENSE_TUNER_BUTTON0_FINGER_CP_OFFSET                                     (24u)
#define CY_CAPSENSE_TUNER_BUTTON0_FINGER_CP_SIZE                                       (2u)

#define CY_CAPSENSE_TUNER_BUTTON0_SIGPFC_OFFSET                                        (26u)
#define CY_CAPSENSE_TUNER_BUTTON0_SIGPFC_SIZE                                          (2u)

#define CY_CAPSENSE_TUNER_BUTTON0_NUM_CONV_OFFSET                                      (28u)
#define CY_CAPSENSE_TUNER_BUTTON0_NUM_CONV_SIZE                                        (2u)

#define CY_CAPSENSE_TUNER_BUTTON0_MAX_RAW_COUNT_OFFSET                                 (30u)
#define CY_CAPSENSE_TUNER_BUTTON0_MAX_RAW_COUNT_SIZE                                   (2u)

#define CY_CAPSENSE_TUNER_BUTTON0_ROW_MAX_RAW_COUNT_OFFSET                             (32u)
#define CY_CAPSENSE_TUNER_BUTTON0_ROW_MAX_RAW_COUNT_SIZE                               (2u)

#define CY_CAPSENSE_TUNER_BUTTON0_FINGER_TH_OFFSET                                     (34u)
#define CY_CAPSENSE_TUNER_BUTTON0_FINGER_TH_SIZE                                       (2u)

#define CY_CAPSENSE_TUNER_BUTTON0_PROX_TOUCH_TH_OFFSET                                 (36u)
#define CY_CAPSENSE_TUNER_BUTTON0_PROX_TOUCH_TH_SIZE                                   (2u)

#define CY_CAPSENSE_TUNER_BUTTON0_LOW_BSLN_RST_OFFSET                                  (38u)
#define CY_CAPSENSE_TUNER_BUTTON0_LOW_BSLN_RST_SIZE                                    (2u)

#define CY_CAPSENSE_TUNER_BUTTON0_TX_CLK_OFFSET                                        (40u)
#define CY_CAPSENSE_TUNER_BUTTON0_TX_CLK_SIZE                                          (2u)

#define CY_CAPSENSE_TUNER_BUTTON0_ROW_SNS_CLK_OFFSET                                   (42u)
#define CY_CAPSENSE_TUNER_BUTTON0_ROW_SNS_CLK_SIZE                                     (2u)

#define CY_CAPSENSE_TUNER_BUTTON0_GESTURE_DETECTED_OFFSET                              (44u)
#define CY_CAPSENSE_TUNER_BUTTON0_GESTURE_DETECTED_SIZE                                (2u)

#define CY_CAPSENSE_TUNER_BUTTON0_GESTURE_DIRECTION_OFFSET                             (46u)
#define CY_CAPSENSE_TUNER_BUTTON0_GESTURE_DIRECTION_SIZE                               (2u)

#define CY_CAPSENSE_TUNER_BUTTON0_XDELTA_OFFSET                                        (48u)
#define CY_CAPSENSE_TUNER_BUTTON0_XDELTA_SIZE                                          (2u)

#define CY_CAPSENSE_TUNER_BUTTON0_YDELTA_OFFSET                                        (50u)
#define CY_CAPSENSE_TUNER_BUTTON0_YDELTA_SIZE                                          (2u)

#define CY_CAPSENSE_TUNER_BUTTON0_NOISE_TH_OFFSET                                      (52u)
#define CY_CAPSENSE_TUNER_BUTTON0_NOISE_TH_SIZE                                        (2u)

#define CY_CAPSENSE_TUNER_BUTTON0_NNOISE_TH_OFFSET                                     (54u)
#define CY_CAPSENSE_TUNER_BUTTON0_NNOISE_TH_SIZE                                       (2u)

#define CY_CAPSENSE_TUNER_BUTTON0_HYSTERESIS_OFFSET                                    (56u)
#define CY_CAPSENSE_TUNER_BUTTON0_HYSTERESIS_SIZE                                      (2u)

#define CY_CAPSENSE_TUNER_BUTTON0_ON_DEBOUNCE_OFFSET                                   (58u)
#define CY_CAPSENSE_TUNER_BUTTON0_ON_DEBOUNCE_SIZE                                     (1u)

#define CY_CAPSENSE_TUNER_BUTTON0_TX_CLK_SOURCE_OFFSET                                 (59u)
#define CY_CAPSENSE_TUNER_BUTTON0_TX_CLK_SOURCE_SIZE                                   (1u)

#define CY_CAPSENSE_TUNER_BUTTON0_IDAC_MOD0_OFFSET                                     (60u)
#define CY_CAPSENSE_TUNER_BUTTON0_IDAC_MOD0_SIZE                                       (1u)

#define CY_CAPSENSE_TUNER_BUTTON0_IDAC_MOD1_OFFSET                                     (61u)
#define CY_CAPSENSE_TUNER_BUTTON0_IDAC_MOD1_SIZE                                       (1u)

#define CY_CAPSENSE_TUNER_BUTTON0_IDAC_MOD2_OFFSET                                     (62u)
#define CY_CAPSENSE_TUNER_BUTTON0_IDAC_MOD2_SIZE                                       (1u)

#define CY_CAPSENSE_TUNER_BUTTON0_IDAC_GAIN_INDEX_OFFSET                               (63u)
#define CY_CAPSENSE_TUNER_BUTTON0_IDAC_GAIN_INDEX_SIZE                                 (1u)

#define CY_CAPSENSE_TUNER_BUTTON0_ROW_IDAC_MOD0_OFFSET                                 (64u)
#define CY_CAPSENSE_TUNER_BUTTON0_ROW_IDAC_MOD0_SIZE                                   (1u)

#define CY_CAPSENSE_TUNER_BUTTON0_ROW_IDAC_MOD1_OFFSET                                 (65u)
#define CY_CAPSENSE_TUNER_BUTTON0_ROW_IDAC_MOD1_SIZE                                   (1u)

#define CY_CAPSENSE_TUNER_BUTTON0_ROW_IDAC_MOD2_OFFSET                                 (66u)
#define CY_CAPSENSE_TUNER_BUTTON0_ROW_IDAC_MOD2_SIZE                                   (1u)

#define CY_CAPSENSE_TUNER_BUTTON0_REGULAR_IIR_BL_N_OFFSET                              (67u)
#define CY_CAPSENSE_TUNER_BUTTON0_REGULAR_IIR_BL_N_SIZE                                (1u)

#define CY_CAPSENSE_TUNER_BUTTON0_STATUS_OFFSET                                        (68u)
#define CY_CAPSENSE_TUNER_BUTTON0_STATUS_SIZE                                          (1u)

#define CY_CAPSENSE_TUNER_BUTTON0_PTRPOSITION_OFFSET                                   (72u)
#define CY_CAPSENSE_TUNER_BUTTON0_PTRPOSITION_SIZE                                     (4u)

#define CY_CAPSENSE_TUNER_BUTTON0_NUM_POSITIONS_OFFSET                                 (76u)
#define CY_CAPSENSE_TUNER_BUTTON0_NUM_POSITIONS_SIZE                                   (1u)

#define CY_CAPSENSE_TUNER_BUTTON1_FINGER_CP_OFFSET                                     (80u)
#define CY_CAPSENSE_TUNER_BUTTON1_FINGER_CP_SIZE                                       (2u)

#define CY_CAPSENSE_TUNER_BUTTON1_SIGPFC_OFFSET                                        (82u)
#define CY_CAPSENSE_TUNER_BUTTON1_SIGPFC_SIZE                                          (2u)

#define CY_CAPSENSE_TUNER_BUTTON1_NUM_CONV_OFFSET                                      (84u)
#define CY_CAPSENSE_TUNER_BUTTON1_NUM_CONV_SIZE                                        (2u)

#define CY_CAPSENSE_TUNER_BUTTON1_MAX_RAW_COUNT_OFFSET                                 (86u)
#define CY_CAPSENSE_TUNER_BUTTON1_MAX_RAW_COUNT_SIZE                                   (2u)

#define CY_CAPSENSE_TUNER_BUTTON1_ROW_MAX_RAW_COUNT_OFFSET                             (88u)
#define CY_CAPSENSE_TUNER_BUTTON1_ROW_MAX_RAW_COUNT_SIZE                               (2u)

#define CY_CAPSENSE_TUNER_BUTTON1_FINGER_TH_OFFSET                                     (90u)
#define CY_CAPSENSE_TUNER_BUTTON1_FINGER_TH_SIZE                                       (2u)

#define CY_CAPSENSE_TUNER_BUTTON1_PROX_TOUCH_TH_OFFSET                                 (92u)
#define CY_CAPSENSE_TUNER_BUTTON1_PROX_TOUCH_TH_SIZE                                   (2u)

#define CY_CAPSENSE_TUNER_BUTTON1_LOW_BSLN_RST_OFFSET                                  (94u)
#define CY_CAPSENSE_TUNER_BUTTON1_LOW_BSLN_RST_SIZE                                    (2u)

#define CY_CAPSENSE_TUNER_BUTTON1_TX_CLK_OFFSET                                        (96u)
#define CY_CAPSENSE_TUNER_BUTTON1_TX_CLK_SIZE                                          (2u)

#define CY_CAPSENSE_TUNER_BUTTON1_ROW_SNS_CLK_OFFSET                                   (98u)
#define CY_CAPSENSE_TUNER_BUTTON1_ROW_SNS_CLK_SIZE                                     (2u)

#define CY_CAPSENSE_TUNER_BUTTON1_GESTURE_DETECTED_OFFSET                              (100u)
#define CY_CAPSENSE_TUNER_BUTTON1_GESTURE_DETECTED_SIZE                                (2u)

#define CY_CAPSENSE_TUNER_BUTTON1_GESTURE_DIRECTION_OFFSET                             (102u)
#define CY_CAPSENSE_TUNER_BUTTON1_GESTURE_DIRECTION_SIZE                               (2u)

#define CY_CAPSENSE_TUNER_BUTTON1_XDELTA_OFFSET                                        (104u)
#define CY_CAPSENSE_TUNER_BUTTON1_XDELTA_SIZE                                          (2u)

#define CY_CAPSENSE_TUNER_BUTTON1_YDELTA_OFFSET                                        (106u)
#define CY_CAPSENSE_TUNER_BUTTON1_YDELTA_SIZE                                          (2u)

#define CY_CAPSENSE_TUNER_BUTTON1_NOISE_TH_OFFSET                                      (108u)
#define CY_CAPSENSE_TUNER_BUTTON1_NOISE_TH_SIZE                                        (2u)

#define CY_CAPSENSE_TUNER_BUTTON1_NNOISE_TH_OFFSET                                     (110u)
#define CY_CAPSENSE_TUNER_BUTTON1_NNOISE_TH_SIZE                                       (2u)

#define CY_CAPSENSE_TUNER_BUTTON1_HYSTERESIS_OFFSET                                    (112u)
#define CY_CAPSENSE_TUNER_BUTTON1_HYSTERESIS_SIZE                                      (2u)

#define CY_CAPSENSE_TUNER_BUTTON1_ON_DEBOUNCE_OFFSET                                   (114u)
#define CY_CAPSENSE_TUNER_BUTTON1_ON_DEBOUNCE_SIZE                                     (1u)

#define CY_CAPSENSE_TUNER_BUTTON1_TX_CLK_SOURCE_OFFSET                                 (115u)
#define CY_CAPSENSE_TUNER_BUTTON1_TX_CLK_SOURCE_SIZE                                   (1u)

#define CY_CAPSENSE_TUNER_BUTTON1_IDAC_MOD0_OFFSET                                     (116u)
#define CY_CAPSENSE_TUNER_BUTTON1_IDAC_MOD0_SIZE                                       (1u)

#define CY_CAPSENSE_TUNER_BUTTON1_IDAC_MOD1_OFFSET                                     (117u)
#define CY_CAPSENSE_TUNER_BUTTON1_IDAC_MOD1_SIZE                                       (1u)

#define CY_CAPSENSE_TUNER_BUTTON1_IDAC_MOD2_OFFSET                                     (118u)
#define CY_CAPSENSE_TUNER_BUTTON1_IDAC_MOD2_SIZE                                       (1u)

#define CY_CAPSENSE_TUNER_BUTTON1_IDAC_GAIN_INDEX_OFFSET                               (119u)
#define CY_CAPSENSE_TUNER_BUTTON1_IDAC_GAIN_INDEX_SIZE                                 (1u)

#define CY_CAPSENSE_TUNER_BUTTON1_ROW_IDAC_MOD0_OFFSET                                 (120u)
#define CY_CAPSENSE_TUNER_BUTTON1_ROW_IDAC_MOD0_SIZE                                   (1u)

#define CY_CAPSENSE_TUNER_BUTTON1_ROW_IDAC_MOD1_OFFSET                                 (121u)
#define CY_CAPSENSE_TUNER_BUTTON1_ROW_IDAC_MOD1_SIZE                                   (1u)

#define CY_CAPSENSE_TUNER_BUTTON1_ROW_IDAC_MOD2_OFFSET                                 (122u)
#define CY_CAPSENSE_TUNER_BUTTON1_ROW_IDAC_MOD2_SIZE                                   (1u)

#define CY_CAPSENSE_TUNER_BUTTON1_REGULAR_IIR_BL_N_OFFSET                              (123u)
#define CY_CAPSENSE_TUNER_BUTTON1_REGULAR_IIR_BL_N_SIZE                                (1u)

#define CY_CAPSENSE_TUNER_BUTTON1_STATUS_OFFSET                                        (124u)
#define CY_CAPSENSE_TUNER_BUTTON1_STATUS_SIZE                                          (1u)

#define CY_CAPSENSE_TUNER_BUTTON1_PTRPOSITION_OFFSET                                   (128u)
#define CY_CAPSENSE_TUNER_BUTTON1_PTRPOSITION_SIZE                                     (4u)

#define CY_CAPSENSE_TUNER_BUTTON1_NUM_POSITIONS_OFFSET                                 (132u)
#define CY_CAPSENSE_TUNER_BUTTON1_NUM_POSITIONS_SIZE                                   (1u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_FINGER_CP_OFFSET                               (136u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_FINGER_CP_SIZE                                 (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SIGPFC_OFFSET                                  (138u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SIGPFC_SIZE                                    (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_RESOLUTION_OFFSET                              (140u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_RESOLUTION_SIZE                                (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_MAX_RAW_COUNT_OFFSET                           (142u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_MAX_RAW_COUNT_SIZE                             (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_ROW_MAX_RAW_COUNT_OFFSET                       (144u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_ROW_MAX_RAW_COUNT_SIZE                         (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_FINGER_TH_OFFSET                               (146u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_FINGER_TH_SIZE                                 (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_PROX_TOUCH_TH_OFFSET                           (148u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_PROX_TOUCH_TH_SIZE                             (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_LOW_BSLN_RST_OFFSET                            (150u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_LOW_BSLN_RST_SIZE                              (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS_CLK_OFFSET                                 (152u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS_CLK_SIZE                                   (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_ROW_SNS_CLK_OFFSET                             (154u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_ROW_SNS_CLK_SIZE                               (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_GESTURE_DETECTED_OFFSET                        (156u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_GESTURE_DETECTED_SIZE                          (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_GESTURE_DIRECTION_OFFSET                       (158u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_GESTURE_DIRECTION_SIZE                         (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_XDELTA_OFFSET                                  (160u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_XDELTA_SIZE                                    (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_YDELTA_OFFSET                                  (162u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_YDELTA_SIZE                                    (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_NOISE_TH_OFFSET                                (164u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_NOISE_TH_SIZE                                  (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_NNOISE_TH_OFFSET                               (166u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_NNOISE_TH_SIZE                                 (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_HYSTERESIS_OFFSET                              (168u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_HYSTERESIS_SIZE                                (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_ON_DEBOUNCE_OFFSET                             (170u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_ON_DEBOUNCE_SIZE                               (1u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS_CLK_SOURCE_OFFSET                          (171u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS_CLK_SOURCE_SIZE                            (1u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_IDAC_MOD0_OFFSET                               (172u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_IDAC_MOD0_SIZE                                 (1u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_IDAC_MOD1_OFFSET                               (173u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_IDAC_MOD1_SIZE                                 (1u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_IDAC_MOD2_OFFSET                               (174u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_IDAC_MOD2_SIZE                                 (1u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_IDAC_GAIN_INDEX_OFFSET                         (175u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_IDAC_GAIN_INDEX_SIZE                           (1u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_ROW_IDAC_MOD0_OFFSET                           (176u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_ROW_IDAC_MOD0_SIZE                             (1u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_ROW_IDAC_MOD1_OFFSET                           (177u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_ROW_IDAC_MOD1_SIZE                             (1u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_ROW_IDAC_MOD2_OFFSET                           (178u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_ROW_IDAC_MOD2_SIZE                             (1u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_REGULAR_IIR_BL_N_OFFSET                        (179u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_REGULAR_IIR_BL_N_SIZE                          (1u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_STATUS_OFFSET                                  (180u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_STATUS_SIZE                                    (1u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_PTRPOSITION_OFFSET                             (184u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_PTRPOSITION_SIZE                               (4u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_NUM_POSITIONS_OFFSET                           (188u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_NUM_POSITIONS_SIZE                             (1u)

#define CY_CAPSENSE_TUNER_BUTTON0_RX0_RAW0_OFFSET                                      (192u)
#define CY_CAPSENSE_TUNER_BUTTON0_RX0_RAW0_SIZE                                        (2u)

#define CY_CAPSENSE_TUNER_BUTTON0_RX0_BSLN0_OFFSET                                     (194u)
#define CY_CAPSENSE_TUNER_BUTTON0_RX0_BSLN0_SIZE                                       (2u)

#define CY_CAPSENSE_TUNER_BUTTON0_RX0_DIFF0_OFFSET                                     (196u)
#define CY_CAPSENSE_TUNER_BUTTON0_RX0_DIFF0_SIZE                                       (2u)

#define CY_CAPSENSE_TUNER_BUTTON0_RX0_STATUS0_OFFSET                                   (198u)
#define CY_CAPSENSE_TUNER_BUTTON0_RX0_STATUS0_SIZE                                     (1u)

#define CY_CAPSENSE_TUNER_BUTTON0_RX0_NEG_BSLN_RST_CNT0_OFFSET                         (199u)
#define CY_CAPSENSE_TUNER_BUTTON0_RX0_NEG_BSLN_RST_CNT0_SIZE                           (1u)

#define CY_CAPSENSE_TUNER_BUTTON0_RX0_IDAC0_OFFSET                                     (200u)
#define CY_CAPSENSE_TUNER_BUTTON0_RX0_IDAC0_SIZE                                       (1u)

#define CY_CAPSENSE_TUNER_BUTTON0_RX0_BSLN_EXT0_OFFSET                                 (201u)
#define CY_CAPSENSE_TUNER_BUTTON0_RX0_BSLN_EXT0_SIZE                                   (1u)

#define CY_CAPSENSE_TUNER_BUTTON1_RX0_RAW0_OFFSET                                      (202u)
#define CY_CAPSENSE_TUNER_BUTTON1_RX0_RAW0_SIZE                                        (2u)

#define CY_CAPSENSE_TUNER_BUTTON1_RX0_BSLN0_OFFSET                                     (204u)
#define CY_CAPSENSE_TUNER_BUTTON1_RX0_BSLN0_SIZE                                       (2u)

#define CY_CAPSENSE_TUNER_BUTTON1_RX0_DIFF0_OFFSET                                     (206u)
#define CY_CAPSENSE_TUNER_BUTTON1_RX0_DIFF0_SIZE                                       (2u)

#define CY_CAPSENSE_TUNER_BUTTON1_RX0_STATUS0_OFFSET                                   (208u)
#define CY_CAPSENSE_TUNER_BUTTON1_RX0_STATUS0_SIZE                                     (1u)

#define CY_CAPSENSE_TUNER_BUTTON1_RX0_NEG_BSLN_RST_CNT0_OFFSET                         (209u)
#define CY_CAPSENSE_TUNER_BUTTON1_RX0_NEG_BSLN_RST_CNT0_SIZE                           (1u)

#define CY_CAPSENSE_TUNER_BUTTON1_RX0_IDAC0_OFFSET                                     (210u)
#define CY_CAPSENSE_TUNER_BUTTON1_RX0_IDAC0_SIZE                                       (1u)

#define CY_CAPSENSE_TUNER_BUTTON1_RX0_BSLN_EXT0_OFFSET                                 (211u)
#define CY_CAPSENSE_TUNER_BUTTON1_RX0_BSLN_EXT0_SIZE                                   (1u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS0_RAW0_OFFSET                               (212u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS0_RAW0_SIZE                                 (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS0_BSLN0_OFFSET                              (214u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS0_BSLN0_SIZE                                (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS0_DIFF0_OFFSET                              (216u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS0_DIFF0_SIZE                                (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS0_STATUS0_OFFSET                            (218u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS0_STATUS0_SIZE                              (1u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS0_NEG_BSLN_RST_CNT0_OFFSET                  (219u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS0_NEG_BSLN_RST_CNT0_SIZE                    (1u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS0_IDAC0_OFFSET                              (220u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS0_IDAC0_SIZE                                (1u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS0_BSLN_EXT0_OFFSET                          (221u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS0_BSLN_EXT0_SIZE                            (1u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS1_RAW0_OFFSET                               (222u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS1_RAW0_SIZE                                 (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS1_BSLN0_OFFSET                              (224u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS1_BSLN0_SIZE                                (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS1_DIFF0_OFFSET                              (226u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS1_DIFF0_SIZE                                (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS1_STATUS0_OFFSET                            (228u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS1_STATUS0_SIZE                              (1u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS1_NEG_BSLN_RST_CNT0_OFFSET                  (229u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS1_NEG_BSLN_RST_CNT0_SIZE                    (1u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS1_IDAC0_OFFSET                              (230u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS1_IDAC0_SIZE                                (1u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS1_BSLN_EXT0_OFFSET                          (231u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS1_BSLN_EXT0_SIZE                            (1u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS2_RAW0_OFFSET                               (232u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS2_RAW0_SIZE                                 (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS2_BSLN0_OFFSET                              (234u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS2_BSLN0_SIZE                                (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS2_DIFF0_OFFSET                              (236u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS2_DIFF0_SIZE                                (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS2_STATUS0_OFFSET                            (238u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS2_STATUS0_SIZE                              (1u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS2_NEG_BSLN_RST_CNT0_OFFSET                  (239u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS2_NEG_BSLN_RST_CNT0_SIZE                    (1u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS2_IDAC0_OFFSET                              (240u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS2_IDAC0_SIZE                                (1u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS2_BSLN_EXT0_OFFSET                          (241u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS2_BSLN_EXT0_SIZE                            (1u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS3_RAW0_OFFSET                               (242u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS3_RAW0_SIZE                                 (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS3_BSLN0_OFFSET                              (244u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS3_BSLN0_SIZE                                (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS3_DIFF0_OFFSET                              (246u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS3_DIFF0_SIZE                                (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS3_STATUS0_OFFSET                            (248u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS3_STATUS0_SIZE                              (1u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS3_NEG_BSLN_RST_CNT0_OFFSET                  (249u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS3_NEG_BSLN_RST_CNT0_SIZE                    (1u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS3_IDAC0_OFFSET                              (250u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS3_IDAC0_SIZE                                (1u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS3_BSLN_EXT0_OFFSET                          (251u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS3_BSLN_EXT0_SIZE                            (1u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS4_RAW0_OFFSET                               (252u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS4_RAW0_SIZE                                 (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS4_BSLN0_OFFSET                              (254u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS4_BSLN0_SIZE                                (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS4_DIFF0_OFFSET                              (256u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS4_DIFF0_SIZE                                (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS4_STATUS0_OFFSET                            (258u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS4_STATUS0_SIZE                              (1u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS4_NEG_BSLN_RST_CNT0_OFFSET                  (259u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS4_NEG_BSLN_RST_CNT0_SIZE                    (1u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS4_IDAC0_OFFSET                              (260u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS4_IDAC0_SIZE                                (1u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS4_BSLN_EXT0_OFFSET                          (261u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS4_BSLN_EXT0_SIZE                            (1u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_X0_OFFSET                                      (262u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_X0_SIZE                                        (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_Y0_OFFSET                                      (264u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_Y0_SIZE                                        (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_Z0_OFFSET                                      (266u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_Z0_SIZE                                        (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_ID0_OFFSET                                     (268u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_ID0_SIZE                                       (2u)

#elif (CY_CAPSENSE_TUNER_MW_VERSION < 700)
#define CY_CAPSENSE_TUNER_CONFIG_ID_OFFSET                                             (0u)
#define CY_CAPSENSE_TUNER_CONFIG_ID_SIZE                                               (2u)

#define CY_CAPSENSE_TUNER_TUNER_CMD_OFFSET                                             (2u)
#define CY_CAPSENSE_TUNER_TUNER_CMD_SIZE                                               (2u)

#define CY_CAPSENSE_TUNER_SCAN_COUNTER_OFFSET                                          (4u)
#define CY_CAPSENSE_TUNER_SCAN_COUNTER_SIZE                                            (2u)

#define CY_CAPSENSE_TUNER_TUNER_ST_OFFSET                                              (6u)
#define CY_CAPSENSE_TUNER_TUNER_ST_SIZE                                                (1u)

#define CY_CAPSENSE_TUNER_INITDONE_OFFSET                                              (7u)
#define CY_CAPSENSE_TUNER_INITDONE_SIZE                                                (1u)

#define CY_CAPSENSE_TUNER_STATUS_OFFSET                                                (8u)
#define CY_CAPSENSE_TUNER_STATUS_SIZE                                                  (4u)

#define CY_CAPSENSE_TUNER_TIMESTAMPINTERVAL_OFFSET                                     (12u)
#define CY_CAPSENSE_TUNER_TIMESTAMPINTERVAL_SIZE                                       (4u)

#define CY_CAPSENSE_TUNER_TIMESTAMP_OFFSET                                             (16u)
#define CY_CAPSENSE_TUNER_TIMESTAMP_SIZE                                               (4u)

#define CY_CAPSENSE_TUNER_CSD_MOD_CLK_DIVIDER_OFFSET                                   (20u)
#define CY_CAPSENSE_TUNER_CSD_MOD_CLK_DIVIDER_SIZE                                     (1u)

#define CY_CAPSENSE_TUNER_CSX_MOD_CLK_DIVIDER_OFFSET                                   (21u)
#define CY_CAPSENSE_TUNER_CSX_MOD_CLK_DIVIDER_SIZE                                     (1u)

#define CY_CAPSENSE_TUNER_TUNER_CNT_OFFSET                                             (22u)
#define CY_CAPSENSE_TUNER_TUNER_CNT_SIZE                                               (1u)

#define CY_CAPSENSE_TUNER_BUTTON0_FINGER_CP_OFFSET                                     (24u)
#define CY_CAPSENSE_TUNER_BUTTON0_FINGER_CP_SIZE                                       (2u)

#define CY_CAPSENSE_TUNER_BUTTON0_SIGPFC_OFFSET                                        (26u)
#define CY_CAPSENSE_TUNER_BUTTON0_SIGPFC_SIZE                                          (2u)

#define CY_CAPSENSE_TUNER_BUTTON0_NUM_CONV_OFFSET                                      (28u)
#define CY_CAPSENSE_TUNER_BUTTON0_NUM_CONV_SIZE                                        (2u)

#define CY_CAPSENSE_TUNER_BUTTON0_MAX_RAW_COUNT_OFFSET                                 (30u)
#define CY_CAPSENSE_TUNER_BUTTON0_MAX_RAW_COUNT_SIZE                                   (2u)

#define CY_CAPSENSE_TUNER_BUTTON0_ROW_MAX_RAW_COUNT_OFFSET                             (32u)
#define CY_CAPSENSE_TUNER_BUTTON0_ROW_MAX_RAW_COUNT_SIZE                               (2u)

#define CY_CAPSENSE_TUNER_BUTTON0_FINGER_TH_OFFSET                                     (34u)
#define CY_CAPSENSE_TUNER_BUTTON0_FINGER_TH_SIZE                                       (2u)

#define CY_CAPSENSE_TUNER_BUTTON0_PROX_TOUCH_TH_OFFSET                                 (36u)
#define CY_CAPSENSE_TUNER_BUTTON0_PROX_TOUCH_TH_SIZE                                   (2u)

#define CY_CAPSENSE_TUNER_BUTTON0_LOW_BSLN_RST_OFFSET                                  (38u)
#define CY_CAPSENSE_TUNER_BUTTON0_LOW_BSLN_RST_SIZE                                    (2u)

#define CY_CAPSENSE_TUNER_BUTTON0_TX_CLK_OFFSET                                        (40u)
#define CY_CAPSENSE_TUNER_BUTTON0_TX_CLK_SIZE                                          (2u)

#define CY_CAPSENSE_TUNER_BUTTON0_ROW_SNS_CLK_OFFSET                                   (42u)
#define CY_CAPSENSE_TUNER_BUTTON0_ROW_SNS_CLK_SIZE                                     (2u)

#define CY_CAPSENSE_TUNER_BUTTON0_GESTURE_DETECTED_OFFSET                              (44u)
#define CY_CAPSENSE_TUNER_BUTTON0_GESTURE_DETECTED_SIZE                                (2u)

#define CY_CAPSENSE_TUNER_BUTTON0_GESTURE_DIRECTION_OFFSET                             (46u)
#define CY_CAPSENSE_TUNER_BUTTON0_GESTURE_DIRECTION_SIZE                               (2u)

#define CY_CAPSENSE_TUNER_BUTTON0_XDELTA_OFFSET                                        (48u)
#define CY_CAPSENSE_TUNER_BUTTON0_XDELTA_SIZE                                          (2u)

#define CY_CAPSENSE_TUNER_BUTTON0_YDELTA_OFFSET                                        (50u)
#define CY_CAPSENSE_TUNER_BUTTON0_YDELTA_SIZE                                          (2u)

#define CY_CAPSENSE_TUNER_BUTTON0_NOISE_TH_OFFSET                                      (52u)
#define CY_CAPSENSE_TUNER_BUTTON0_NOISE_TH_SIZE                                        (2u)

#define CY_CAPSENSE_TUNER_BUTTON0_NNOISE_TH_OFFSET                                     (54u)
#define CY_CAPSENSE_TUNER_BUTTON0_NNOISE_TH_SIZE                                       (2u)

#define CY_CAPSENSE_TUNER_BUTTON0_HYSTERESIS_OFFSET                                    (56u)
#define CY_CAPSENSE_TUNER_BUTTON0_HYSTERESIS_SIZE                                      (2u)

#define CY_CAPSENSE_TUNER_BUTTON0_ON_DEBOUNCE_OFFSET                                   (58u)
#define CY_CAPSENSE_TUNER_BUTTON0_ON_DEBOUNCE_SIZE                                     (1u)

#define CY_CAPSENSE_TUNER_BUTTON0_TX_CLK_SOURCE_OFFSET                                 (59u)
#define CY_CAPSENSE_TUNER_BUTTON0_TX_CLK_SOURCE_SIZE                                   (1u)

#define CY_CAPSENSE_TUNER_BUTTON0_IDAC_MOD0_OFFSET                                     (60u)
#define CY_CAPSENSE_TUNER_BUTTON0_IDAC_MOD0_SIZE                                       (1u)

#define CY_CAPSENSE_TUNER_BUTTON0_IDAC_MOD1_OFFSET                                     (61u)
#define CY_CAPSENSE_TUNER_BUTTON0_IDAC_MOD1_SIZE                                       (1u)

#define CY_CAPSENSE_TUNER_BUTTON0_IDAC_MOD2_OFFSET                                     (62u)
#define CY_CAPSENSE_TUNER_BUTTON0_IDAC_MOD2_SIZE                                       (1u)

#define CY_CAPSENSE_TUNER_BUTTON0_IDAC_GAIN_INDEX_OFFSET                               (63u)
#define CY_CAPSENSE_TUNER_BUTTON0_IDAC_GAIN_INDEX_SIZE                                 (1u)

#define CY_CAPSENSE_TUNER_BUTTON0_ROW_IDAC_MOD0_OFFSET                                 (64u)
#define CY_CAPSENSE_TUNER_BUTTON0_ROW_IDAC_MOD0_SIZE                                   (1u)

#define CY_CAPSENSE_TUNER_BUTTON0_ROW_IDAC_MOD1_OFFSET                                 (65u)
#define CY_CAPSENSE_TUNER_BUTTON0_ROW_IDAC_MOD1_SIZE                                   (1u)

#define CY_CAPSENSE_TUNER_BUTTON0_ROW_IDAC_MOD2_OFFSET                                 (66u)
#define CY_CAPSENSE_TUNER_BUTTON0_ROW_IDAC_MOD2_SIZE                                   (1u)

#define CY_CAPSENSE_TUNER_BUTTON0_REGULAR_IIR_BL_N_OFFSET                              (67u)
#define CY_CAPSENSE_TUNER_BUTTON0_REGULAR_IIR_BL_N_SIZE                                (1u)

#define CY_CAPSENSE_TUNER_BUTTON0_STATUS_OFFSET                                        (68u)
#define CY_CAPSENSE_TUNER_BUTTON0_STATUS_SIZE                                          (1u)

#define CY_CAPSENSE_TUNER_BUTTON0_PTRPOSITION_OFFSET                                   (72u)
#define CY_CAPSENSE_TUNER_BUTTON0_PTRPOSITION_SIZE                                     (4u)

#define CY_CAPSENSE_TUNER_BUTTON0_NUM_POSITIONS_OFFSET                                 (76u)
#define CY_CAPSENSE_TUNER_BUTTON0_NUM_POSITIONS_SIZE                                   (1u)

#define CY_CAPSENSE_TUNER_BUTTON1_FINGER_CP_OFFSET                                     (80u)
#define CY_CAPSENSE_TUNER_BUTTON1_FINGER_CP_SIZE                                       (2u)

#define CY_CAPSENSE_TUNER_BUTTON1_SIGPFC_OFFSET                                        (82u)
#define CY_CAPSENSE_TUNER_BUTTON1_SIGPFC_SIZE                                          (2u)

#define CY_CAPSENSE_TUNER_BUTTON1_NUM_CONV_OFFSET                                      (84u)
#define CY_CAPSENSE_TUNER_BUTTON1_NUM_CONV_SIZE                                        (2u)

#define CY_CAPSENSE_TUNER_BUTTON1_MAX_RAW_COUNT_OFFSET                                 (86u)
#define CY_CAPSENSE_TUNER_BUTTON1_MAX_RAW_COUNT_SIZE                                   (2u)

#define CY_CAPSENSE_TUNER_BUTTON1_ROW_MAX_RAW_COUNT_OFFSET                             (88u)
#define CY_CAPSENSE_TUNER_BUTTON1_ROW_MAX_RAW_COUNT_SIZE                               (2u)

#define CY_CAPSENSE_TUNER_BUTTON1_FINGER_TH_OFFSET                                     (90u)
#define CY_CAPSENSE_TUNER_BUTTON1_FINGER_TH_SIZE                                       (2u)

#define CY_CAPSENSE_TUNER_BUTTON1_PROX_TOUCH_TH_OFFSET                                 (92u)
#define CY_CAPSENSE_TUNER_BUTTON1_PROX_TOUCH_TH_SIZE                                   (2u)

#define CY_CAPSENSE_TUNER_BUTTON1_LOW_BSLN_RST_OFFSET                                  (94u)
#define CY_CAPSENSE_TUNER_BUTTON1_LOW_BSLN_RST_SIZE                                    (2u)

#define CY_CAPSENSE_TUNER_BUTTON1_TX_CLK_OFFSET                                        (96u)
#define CY_CAPSENSE_TUNER_BUTTON1_TX_CLK_SIZE                                          (2u)

#define CY_CAPSENSE_TUNER_BUTTON1_ROW_SNS_CLK_OFFSET                                   (98u)
#define CY_CAPSENSE_TUNER_BUTTON1_ROW_SNS_CLK_SIZE                                     (2u)

#define CY_CAPSENSE_TUNER_BUTTON1_GESTURE_DETECTED_OFFSET                              (100u)
#define CY_CAPSENSE_TUNER_BUTTON1_GESTURE_DETECTED_SIZE                                (2u)

#define CY_CAPSENSE_TUNER_BUTTON1_GESTURE_DIRECTION_OFFSET                             (102u)
#define CY_CAPSENSE_TUNER_BUTTON1_GESTURE_DIRECTION_SIZE                               (2u)

#define CY_CAPSENSE_TUNER_BUTTON1_XDELTA_OFFSET                                        (104u)
#define CY_CAPSENSE_TUNER_BUTTON1_XDELTA_SIZE                                          (2u)

#define CY_CAPSENSE_TUNER_BUTTON1_YDELTA_OFFSET                                        (106u)
#define CY_CAPSENSE_TUNER_BUTTON1_YDELTA_SIZE                                          (2u)

#define CY_CAPSENSE_TUNER_BUTTON1_NOISE_TH_OFFSET                                      (108u)
#define CY_CAPSENSE_TUNER_BUTTON1_NOISE_TH_SIZE                                        (2u)

#define CY_CAPSENSE_TUNER_BUTTON1_NNOISE_TH_OFFSET                                     (110u)
#define CY_CAPSENSE_TUNER_BUTTON1_NNOISE_TH_SIZE                                       (2u)

#define CY_CAPSENSE_TUNER_BUTTON1_HYSTERESIS_OFFSET                                    (112u)
#define CY_CAPSENSE_TUNER_BUTTON1_HYSTERESIS_SIZE                                      (2u)

#define CY_CAPSENSE_TUNER_BUTTON1_ON_DEBOUNCE_OFFSET                                   (114u)
#define CY_CAPSENSE_TUNER_BUTTON1_ON_DEBOUNCE_SIZE                                     (1u)

#define CY_CAPSENSE_TUNER_BUTTON1_TX_CLK_SOURCE_OFFSET                                 (115u)
#define CY_CAPSENSE_TUNER_BUTTON1_TX_CLK_SOURCE_SIZE                                   (1u)

#define CY_CAPSENSE_TUNER_BUTTON1_IDAC_MOD0_OFFSET                                     (116u)
#define CY_CAPSENSE_TUNER_BUTTON1_IDAC_MOD0_SIZE                                       (1u)

#define CY_CAPSENSE_TUNER_BUTTON1_IDAC_MOD1_OFFSET                                     (117u)
#define CY_CAPSENSE_TUNER_BUTTON1_IDAC_MOD1_SIZE                                       (1u)

#define CY_CAPSENSE_TUNER_BUTTON1_IDAC_MOD2_OFFSET                                     (118u)
#define CY_CAPSENSE_TUNER_BUTTON1_IDAC_MOD2_SIZE                                       (1u)

#define CY_CAPSENSE_TUNER_BUTTON1_IDAC_GAIN_INDEX_OFFSET                               (119u)
#define CY_CAPSENSE_TUNER_BUTTON1_IDAC_GAIN_INDEX_SIZE                                 (1u)

#define CY_CAPSENSE_TUNER_BUTTON1_ROW_IDAC_MOD0_OFFSET                                 (120u)
#define CY_CAPSENSE_TUNER_BUTTON1_ROW_IDAC_MOD0_SIZE                                   (1u)

#define CY_CAPSENSE_TUNER_BUTTON1_ROW_IDAC_MOD1_OFFSET                                 (121u)
#define CY_CAPSENSE_TUNER_BUTTON1_ROW_IDAC_MOD1_SIZE                                   (1u)

#define CY_CAPSENSE_TUNER_BUTTON1_ROW_IDAC_MOD2_OFFSET                                 (122u)
#define CY_CAPSENSE_TUNER_BUTTON1_ROW_IDAC_MOD2_SIZE                                   (1u)

#define CY_CAPSENSE_TUNER_BUTTON1_REGULAR_IIR_BL_N_OFFSET                              (123u)
#define CY_CAPSENSE_TUNER_BUTTON1_REGULAR_IIR_BL_N_SIZE                                (1u)

#define CY_CAPSENSE_TUNER_BUTTON1_STATUS_OFFSET                                        (124u)
#define CY_CAPSENSE_TUNER_BUTTON1_STATUS_SIZE                                          (1u)

#define CY_CAPSENSE_TUNER_BUTTON1_PTRPOSITION_OFFSET                                   (128u)
#define CY_CAPSENSE_TUNER_BUTTON1_PTRPOSITION_SIZE                                     (4u)

#define CY_CAPSENSE_TUNER_BUTTON1_NUM_POSITIONS_OFFSET                                 (132u)
#define CY_CAPSENSE_TUNER_BUTTON1_NUM_POSITIONS_SIZE                                   (1u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_FINGER_CP_OFFSET                               (136u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_FINGER_CP_SIZE                                 (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SIGPFC_OFFSET                                  (138u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SIGPFC_SIZE                                    (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_RESOLUTION_OFFSET                              (140u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_RESOLUTION_SIZE                                (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_MAX_RAW_COUNT_OFFSET                           (142u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_MAX_RAW_COUNT_SIZE                             (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_ROW_MAX_RAW_COUNT_OFFSET                       (144u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_ROW_MAX_RAW_COUNT_SIZE                         (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_FINGER_TH_OFFSET                               (146u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_FINGER_TH_SIZE                                 (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_PROX_TOUCH_TH_OFFSET                           (148u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_PROX_TOUCH_TH_SIZE                             (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_LOW_BSLN_RST_OFFSET                            (150u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_LOW_BSLN_RST_SIZE                              (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS_CLK_OFFSET                                 (152u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS_CLK_SIZE                                   (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_ROW_SNS_CLK_OFFSET                             (154u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_ROW_SNS_CLK_SIZE                               (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_GESTURE_DETECTED_OFFSET                        (156u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_GESTURE_DETECTED_SIZE                          (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_GESTURE_DIRECTION_OFFSET                       (158u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_GESTURE_DIRECTION_SIZE                         (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_XDELTA_OFFSET                                  (160u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_XDELTA_SIZE                                    (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_YDELTA_OFFSET                                  (162u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_YDELTA_SIZE                                    (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_NOISE_TH_OFFSET                                (164u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_NOISE_TH_SIZE                                  (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_NNOISE_TH_OFFSET                               (166u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_NNOISE_TH_SIZE                                 (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_HYSTERESIS_OFFSET                              (168u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_HYSTERESIS_SIZE                                (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_ON_DEBOUNCE_OFFSET                             (170u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_ON_DEBOUNCE_SIZE                               (1u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS_CLK_SOURCE_OFFSET                          (171u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS_CLK_SOURCE_SIZE                            (1u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_IDAC_MOD0_OFFSET                               (172u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_IDAC_MOD0_SIZE                                 (1u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_IDAC_MOD1_OFFSET                               (173u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_IDAC_MOD1_SIZE                                 (1u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_IDAC_MOD2_OFFSET                               (174u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_IDAC_MOD2_SIZE                                 (1u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_IDAC_GAIN_INDEX_OFFSET                         (175u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_IDAC_GAIN_INDEX_SIZE                           (1u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_ROW_IDAC_MOD0_OFFSET                           (176u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_ROW_IDAC_MOD0_SIZE                             (1u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_ROW_IDAC_MOD1_OFFSET                           (177u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_ROW_IDAC_MOD1_SIZE                             (1u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_ROW_IDAC_MOD2_OFFSET                           (178u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_ROW_IDAC_MOD2_SIZE                             (1u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_REGULAR_IIR_BL_N_OFFSET                        (179u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_REGULAR_IIR_BL_N_SIZE                          (1u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_STATUS_OFFSET                                  (180u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_STATUS_SIZE                                    (1u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_PTRPOSITION_OFFSET                             (184u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_PTRPOSITION_SIZE                               (4u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_NUM_POSITIONS_OFFSET                           (188u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_NUM_POSITIONS_SIZE                             (1u)

#define CY_CAPSENSE_TUNER_BUTTON0_RX0_RAW0_OFFSET                                      (192u)
#define CY_CAPSENSE_TUNER_BUTTON0_RX0_RAW0_SIZE                                        (2u)

#define CY_CAPSENSE_TUNER_BUTTON0_RX0_BSLN0_OFFSET                                     (194u)
#define CY_CAPSENSE_TUNER_BUTTON0_RX0_BSLN0_SIZE                                       (2u)

#define CY_CAPSENSE_TUNER_BUTTON0_RX0_DIFF0_OFFSET                                     (196u)
#define CY_CAPSENSE_TUNER_BUTTON0_RX0_DIFF0_SIZE                                       (2u)

#define CY_CAPSENSE_TUNER_BUTTON0_RX0_STATUS0_OFFSET                                   (198u)
#define CY_CAPSENSE_TUNER_BUTTON0_RX0_STATUS0_SIZE                                     (1u)

#define CY_CAPSENSE_TUNER_BUTTON0_RX0_NEG_BSLN_RST_CNT0_OFFSET                         (199u)
#define CY_CAPSENSE_TUNER_BUTTON0_RX0_NEG_BSLN_RST_CNT0_SIZE                           (1u)

#define CY_CAPSENSE_TUNER_BUTTON0_RX0_IDAC0_OFFSET                                     (200u)
#define CY_CAPSENSE_TUNER_BUTTON0_RX0_IDAC0_SIZE                                       (1u)

#define CY_CAPSENSE_TUNER_BUTTON0_RX0_BSLN_EXT0_OFFSET                                 (201u)
#define CY_CAPSENSE_TUNER_BUTTON0_RX0_BSLN_EXT0_SIZE                                   (1u)

#define CY_CAPSENSE_TUNER_BUTTON1_RX0_RAW0_OFFSET                                      (202u)
#define CY_CAPSENSE_TUNER_BUTTON1_RX0_RAW0_SIZE                                        (2u)

#define CY_CAPSENSE_TUNER_BUTTON1_RX0_BSLN0_OFFSET                                     (204u)
#define CY_CAPSENSE_TUNER_BUTTON1_RX0_BSLN0_SIZE                                       (2u)

#define CY_CAPSENSE_TUNER_BUTTON1_RX0_DIFF0_OFFSET                                     (206u)
#define CY_CAPSENSE_TUNER_BUTTON1_RX0_DIFF0_SIZE                                       (2u)

#define CY_CAPSENSE_TUNER_BUTTON1_RX0_STATUS0_OFFSET                                   (208u)
#define CY_CAPSENSE_TUNER_BUTTON1_RX0_STATUS0_SIZE                                     (1u)

#define CY_CAPSENSE_TUNER_BUTTON1_RX0_NEG_BSLN_RST_CNT0_OFFSET                         (209u)
#define CY_CAPSENSE_TUNER_BUTTON1_RX0_NEG_BSLN_RST_CNT0_SIZE                           (1u)

#define CY_CAPSENSE_TUNER_BUTTON1_RX0_IDAC0_OFFSET                                     (210u)
#define CY_CAPSENSE_TUNER_BUTTON1_RX0_IDAC0_SIZE                                       (1u)

#define CY_CAPSENSE_TUNER_BUTTON1_RX0_BSLN_EXT0_OFFSET                                 (211u)
#define CY_CAPSENSE_TUNER_BUTTON1_RX0_BSLN_EXT0_SIZE                                   (1u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS0_RAW0_OFFSET                               (212u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS0_RAW0_SIZE                                 (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS0_BSLN0_OFFSET                              (214u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS0_BSLN0_SIZE                                (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS0_DIFF0_OFFSET                              (216u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS0_DIFF0_SIZE                                (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS0_STATUS0_OFFSET                            (218u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS0_STATUS0_SIZE                              (1u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS0_NEG_BSLN_RST_CNT0_OFFSET                  (219u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS0_NEG_BSLN_RST_CNT0_SIZE                    (1u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS0_IDAC0_OFFSET                              (220u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS0_IDAC0_SIZE                                (1u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS0_BSLN_EXT0_OFFSET                          (221u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS0_BSLN_EXT0_SIZE                            (1u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS1_RAW0_OFFSET                               (222u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS1_RAW0_SIZE                                 (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS1_BSLN0_OFFSET                              (224u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS1_BSLN0_SIZE                                (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS1_DIFF0_OFFSET                              (226u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS1_DIFF0_SIZE                                (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS1_STATUS0_OFFSET                            (228u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS1_STATUS0_SIZE                              (1u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS1_NEG_BSLN_RST_CNT0_OFFSET                  (229u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS1_NEG_BSLN_RST_CNT0_SIZE                    (1u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS1_IDAC0_OFFSET                              (230u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS1_IDAC0_SIZE                                (1u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS1_BSLN_EXT0_OFFSET                          (231u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS1_BSLN_EXT0_SIZE                            (1u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS2_RAW0_OFFSET                               (232u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS2_RAW0_SIZE                                 (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS2_BSLN0_OFFSET                              (234u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS2_BSLN0_SIZE                                (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS2_DIFF0_OFFSET                              (236u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS2_DIFF0_SIZE                                (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS2_STATUS0_OFFSET                            (238u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS2_STATUS0_SIZE                              (1u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS2_NEG_BSLN_RST_CNT0_OFFSET                  (239u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS2_NEG_BSLN_RST_CNT0_SIZE                    (1u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS2_IDAC0_OFFSET                              (240u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS2_IDAC0_SIZE                                (1u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS2_BSLN_EXT0_OFFSET                          (241u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS2_BSLN_EXT0_SIZE                            (1u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS3_RAW0_OFFSET                               (242u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS3_RAW0_SIZE                                 (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS3_BSLN0_OFFSET                              (244u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS3_BSLN0_SIZE                                (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS3_DIFF0_OFFSET                              (246u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS3_DIFF0_SIZE                                (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS3_STATUS0_OFFSET                            (248u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS3_STATUS0_SIZE                              (1u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS3_NEG_BSLN_RST_CNT0_OFFSET                  (249u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS3_NEG_BSLN_RST_CNT0_SIZE                    (1u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS3_IDAC0_OFFSET                              (250u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS3_IDAC0_SIZE                                (1u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS3_BSLN_EXT0_OFFSET                          (251u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS3_BSLN_EXT0_SIZE                            (1u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS4_RAW0_OFFSET                               (252u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS4_RAW0_SIZE                                 (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS4_BSLN0_OFFSET                              (254u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS4_BSLN0_SIZE                                (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS4_DIFF0_OFFSET                              (256u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS4_DIFF0_SIZE                                (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS4_STATUS0_OFFSET                            (258u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS4_STATUS0_SIZE                              (1u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS4_NEG_BSLN_RST_CNT0_OFFSET                  (259u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS4_NEG_BSLN_RST_CNT0_SIZE                    (1u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS4_IDAC0_OFFSET                              (260u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS4_IDAC0_SIZE                                (1u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS4_BSLN_EXT0_OFFSET                          (261u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS4_BSLN_EXT0_SIZE                            (1u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_X0_OFFSET                                      (262u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_X0_SIZE                                        (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_Y0_OFFSET                                      (264u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_Y0_SIZE                                        (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_Z0_OFFSET                                      (266u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_Z0_SIZE                                        (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_ID0_OFFSET                                     (268u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_ID0_SIZE                                       (2u)

#else /* CY_CAPSENSE_TUNER_MW_VERSION >= 700 */
#define CY_CAPSENSE_TUNER_CONFIG_ID_OFFSET                                             (0u)
#define CY_CAPSENSE_TUNER_CONFIG_ID_SIZE                                               (2u)

#define CY_CAPSENSE_TUNER_TUNER_CMD_OFFSET                                             (2u)
#define CY_CAPSENSE_TUNER_TUNER_CMD_SIZE                                               (2u)

#define CY_CAPSENSE_TUNER_MWVERSIONMAJOR_OFFSET                                        (4u)
#define CY_CAPSENSE_TUNER_MWVERSIONMAJOR_SIZE                                          (1u)

#define CY_CAPSENSE_TUNER_MWVERSIONMINOR_OFFSET                                        (5u)
#define CY_CAPSENSE_TUNER_MWVERSIONMINOR_SIZE                                          (1u)

#define CY_CAPSENSE_TUNER_SCAN_COUNTER_OFFSET                                          (6u)
#define CY_CAPSENSE_TUNER_SCAN_COUNTER_SIZE                                            (2u)

#define CY_CAPSENSE_TUNER_TUNER_ST_OFFSET                                              (8u)
#define CY_CAPSENSE_TUNER_TUNER_ST_SIZE                                                (1u)

#define CY_CAPSENSE_TUNER_INITDONE_OFFSET                                              (9u)
#define CY_CAPSENSE_TUNER_INITDONE_SIZE                                                (1u)

#define CY_CAPSENSE_TUNER_MISC_OFFSET                                                  (10u)
#define CY_CAPSENSE_TUNER_MISC_SIZE                                                    (1u)

#define CY_CAPSENSE_TUNER_STATUS_OFFSET                                                (12u)
#define CY_CAPSENSE_TUNER_STATUS_SIZE                                                  (4u)

#define CY_CAPSENSE_TUNER_TIMESTAMPINTERVAL_OFFSET                                     (16u)
#define CY_CAPSENSE_TUNER_TIMESTAMPINTERVAL_SIZE                                       (4u)

#define CY_CAPSENSE_TUNER_TIMESTAMP_OFFSET                                             (20u)
#define CY_CAPSENSE_TUNER_TIMESTAMP_SIZE                                               (4u)

#define CY_CAPSENSE_TUNER_CSD_MOD_CLK_DIVIDER_OFFSET                                   (24u)
#define CY_CAPSENSE_TUNER_CSD_MOD_CLK_DIVIDER_SIZE                                     (1u)

#define CY_CAPSENSE_TUNER_CSX_MOD_CLK_DIVIDER_OFFSET                                   (25u)
#define CY_CAPSENSE_TUNER_CSX_MOD_CLK_DIVIDER_SIZE                                     (1u)

#define CY_CAPSENSE_TUNER_TUNER_CNT_OFFSET                                             (26u)
#define CY_CAPSENSE_TUNER_TUNER_CNT_SIZE                                               (1u)

#define CY_CAPSENSE_TUNER_BUTTON0_FINGER_CP_OFFSET                                     (28u)
#define CY_CAPSENSE_TUNER_BUTTON0_FINGER_CP_SIZE                                       (2u)

#define CY_CAPSENSE_TUNER_BUTTON0_SIGPFC_OFFSET                                        (30u)
#define CY_CAPSENSE_TUNER_BUTTON0_SIGPFC_SIZE                                          (2u)

#define CY_CAPSENSE_TUNER_BUTTON0_NUM_CONV_OFFSET                                      (32u)
#define CY_CAPSENSE_TUNER_BUTTON0_NUM_CONV_SIZE                                        (2u)

#define CY_CAPSENSE_TUNER_BUTTON0_MAX_RAW_COUNT_OFFSET                                 (34u)
#define CY_CAPSENSE_TUNER_BUTTON0_MAX_RAW_COUNT_SIZE                                   (2u)

#define CY_CAPSENSE_TUNER_BUTTON0_ROW_MAX_RAW_COUNT_OFFSET                             (36u)
#define CY_CAPSENSE_TUNER_BUTTON0_ROW_MAX_RAW_COUNT_SIZE                               (2u)

#define CY_CAPSENSE_TUNER_BUTTON0_FINGER_TH_OFFSET                                     (38u)
#define CY_CAPSENSE_TUNER_BUTTON0_FINGER_TH_SIZE                                       (2u)

#define CY_CAPSENSE_TUNER_BUTTON0_PROX_TOUCH_TH_OFFSET                                 (40u)
#define CY_CAPSENSE_TUNER_BUTTON0_PROX_TOUCH_TH_SIZE                                   (2u)

#define CY_CAPSENSE_TUNER_BUTTON0_LOW_BSLN_RST_OFFSET                                  (42u)
#define CY_CAPSENSE_TUNER_BUTTON0_LOW_BSLN_RST_SIZE                                    (2u)

#define CY_CAPSENSE_TUNER_BUTTON0_TX_CLK_OFFSET                                        (44u)
#define CY_CAPSENSE_TUNER_BUTTON0_TX_CLK_SIZE                                          (2u)

#define CY_CAPSENSE_TUNER_BUTTON0_ROW_SNS_CLK_OFFSET                                   (46u)
#define CY_CAPSENSE_TUNER_BUTTON0_ROW_SNS_CLK_SIZE                                     (2u)

#define CY_CAPSENSE_TUNER_BUTTON0_GESTURE_DETECTED_OFFSET                              (48u)
#define CY_CAPSENSE_TUNER_BUTTON0_GESTURE_DETECTED_SIZE                                (2u)

#define CY_CAPSENSE_TUNER_BUTTON0_GESTURE_DIRECTION_OFFSET                             (50u)
#define CY_CAPSENSE_TUNER_BUTTON0_GESTURE_DIRECTION_SIZE                               (2u)

#define CY_CAPSENSE_TUNER_BUTTON0_XDELTA_OFFSET                                        (52u)
#define CY_CAPSENSE_TUNER_BUTTON0_XDELTA_SIZE                                          (2u)

#define CY_CAPSENSE_TUNER_BUTTON0_YDELTA_OFFSET                                        (54u)
#define CY_CAPSENSE_TUNER_BUTTON0_YDELTA_SIZE                                          (2u)

#define CY_CAPSENSE_TUNER_BUTTON0_NOISE_TH_OFFSET                                      (56u)
#define CY_CAPSENSE_TUNER_BUTTON0_NOISE_TH_SIZE                                        (2u)

#define CY_CAPSENSE_TUNER_BUTTON0_NNOISE_TH_OFFSET                                     (58u)
#define CY_CAPSENSE_TUNER_BUTTON0_NNOISE_TH_SIZE                                       (2u)

#define CY_CAPSENSE_TUNER_BUTTON0_HYSTERESIS_OFFSET                                    (60u)
#define CY_CAPSENSE_TUNER_BUTTON0_HYSTERESIS_SIZE                                      (2u)

#define CY_CAPSENSE_TUNER_BUTTON0_ON_DEBOUNCE_OFFSET                                   (62u)
#define CY_CAPSENSE_TUNER_BUTTON0_ON_DEBOUNCE_SIZE                                     (1u)

#define CY_CAPSENSE_TUNER_BUTTON0_TX_CLK_SOURCE_OFFSET                                 (63u)
#define CY_CAPSENSE_TUNER_BUTTON0_TX_CLK_SOURCE_SIZE                                   (1u)

#define CY_CAPSENSE_TUNER_BUTTON0_IDAC_MOD0_OFFSET                                     (64u)
#define CY_CAPSENSE_TUNER_BUTTON0_IDAC_MOD0_SIZE                                       (1u)

#define CY_CAPSENSE_TUNER_BUTTON0_IDAC_MOD1_OFFSET                                     (65u)
#define CY_CAPSENSE_TUNER_BUTTON0_IDAC_MOD1_SIZE                                       (1u)

#define CY_CAPSENSE_TUNER_BUTTON0_IDAC_MOD2_OFFSET                                     (66u)
#define CY_CAPSENSE_TUNER_BUTTON0_IDAC_MOD2_SIZE                                       (1u)

#define CY_CAPSENSE_TUNER_BUTTON0_IDAC_GAIN_INDEX_OFFSET                               (67u)
#define CY_CAPSENSE_TUNER_BUTTON0_IDAC_GAIN_INDEX_SIZE                                 (1u)

#define CY_CAPSENSE_TUNER_BUTTON0_ROW_IDAC_MOD0_OFFSET                                 (68u)
#define CY_CAPSENSE_TUNER_BUTTON0_ROW_IDAC_MOD0_SIZE                                   (1u)

#define CY_CAPSENSE_TUNER_BUTTON0_ROW_IDAC_MOD1_OFFSET                                 (69u)
#define CY_CAPSENSE_TUNER_BUTTON0_ROW_IDAC_MOD1_SIZE                                   (1u)

#define CY_CAPSENSE_TUNER_BUTTON0_ROW_IDAC_MOD2_OFFSET                                 (70u)
#define CY_CAPSENSE_TUNER_BUTTON0_ROW_IDAC_MOD2_SIZE                                   (1u)

#define CY_CAPSENSE_TUNER_BUTTON0_REGULAR_IIR_BL_N_OFFSET                              (71u)
#define CY_CAPSENSE_TUNER_BUTTON0_REGULAR_IIR_BL_N_SIZE                                (1u)

#define CY_CAPSENSE_TUNER_BUTTON0_STATUS_OFFSET                                        (72u)
#define CY_CAPSENSE_TUNER_BUTTON0_STATUS_SIZE                                          (1u)

#define CY_CAPSENSE_TUNER_BUTTON0_PTRPOSITION_OFFSET                                   (76u)
#define CY_CAPSENSE_TUNER_BUTTON0_PTRPOSITION_SIZE                                     (4u)

#define CY_CAPSENSE_TUNER_BUTTON0_NUM_POSITIONS_OFFSET                                 (80u)
#define CY_CAPSENSE_TUNER_BUTTON0_NUM_POSITIONS_SIZE                                   (1u)

#define CY_CAPSENSE_TUNER_BUTTON1_FINGER_CP_OFFSET                                     (84u)
#define CY_CAPSENSE_TUNER_BUTTON1_FINGER_CP_SIZE                                       (2u)

#define CY_CAPSENSE_TUNER_BUTTON1_SIGPFC_OFFSET                                        (86u)
#define CY_CAPSENSE_TUNER_BUTTON1_SIGPFC_SIZE                                          (2u)

#define CY_CAPSENSE_TUNER_BUTTON1_NUM_CONV_OFFSET                                      (88u)
#define CY_CAPSENSE_TUNER_BUTTON1_NUM_CONV_SIZE                                        (2u)

#define CY_CAPSENSE_TUNER_BUTTON1_MAX_RAW_COUNT_OFFSET                                 (90u)
#define CY_CAPSENSE_TUNER_BUTTON1_MAX_RAW_COUNT_SIZE                                   (2u)

#define CY_CAPSENSE_TUNER_BUTTON1_ROW_MAX_RAW_COUNT_OFFSET                             (92u)
#define CY_CAPSENSE_TUNER_BUTTON1_ROW_MAX_RAW_COUNT_SIZE                               (2u)

#define CY_CAPSENSE_TUNER_BUTTON1_FINGER_TH_OFFSET                                     (94u)
#define CY_CAPSENSE_TUNER_BUTTON1_FINGER_TH_SIZE                                       (2u)

#define CY_CAPSENSE_TUNER_BUTTON1_PROX_TOUCH_TH_OFFSET                                 (96u)
#define CY_CAPSENSE_TUNER_BUTTON1_PROX_TOUCH_TH_SIZE                                   (2u)

#define CY_CAPSENSE_TUNER_BUTTON1_LOW_BSLN_RST_OFFSET                                  (98u)
#define CY_CAPSENSE_TUNER_BUTTON1_LOW_BSLN_RST_SIZE                                    (2u)

#define CY_CAPSENSE_TUNER_BUTTON1_TX_CLK_OFFSET                                        (100u)
#define CY_CAPSENSE_TUNER_BUTTON1_TX_CLK_SIZE                                          (2u)

#define CY_CAPSENSE_TUNER_BUTTON1_ROW_SNS_CLK_OFFSET                                   (102u)
#define CY_CAPSENSE_TUNER_BUTTON1_ROW_SNS_CLK_SIZE                                     (2u)

#define CY_CAPSENSE_TUNER_BUTTON1_GESTURE_DETECTED_OFFSET                              (104u)
#define CY_CAPSENSE_TUNER_BUTTON1_GESTURE_DETECTED_SIZE                                (2u)

#define CY_CAPSENSE_TUNER_BUTTON1_GESTURE_DIRECTION_OFFSET                             (106u)
#define CY_CAPSENSE_TUNER_BUTTON1_GESTURE_DIRECTION_SIZE                               (2u)

#define CY_CAPSENSE_TUNER_BUTTON1_XDELTA_OFFSET                                        (108u)
#define CY_CAPSENSE_TUNER_BUTTON1_XDELTA_SIZE                                          (2u)

#define CY_CAPSENSE_TUNER_BUTTON1_YDELTA_OFFSET                                        (110u)
#define CY_CAPSENSE_TUNER_BUTTON1_YDELTA_SIZE                                          (2u)

#define CY_CAPSENSE_TUNER_BUTTON1_NOISE_TH_OFFSET                                      (112u)
#define CY_CAPSENSE_TUNER_BUTTON1_NOISE_TH_SIZE                                        (2u)

#define CY_CAPSENSE_TUNER_BUTTON1_NNOISE_TH_OFFSET                                     (114u)
#define CY_CAPSENSE_TUNER_BUTTON1_NNOISE_TH_SIZE                                       (2u)

#define CY_CAPSENSE_TUNER_BUTTON1_HYSTERESIS_OFFSET                                    (116u)
#define CY_CAPSENSE_TUNER_BUTTON1_HYSTERESIS_SIZE                                      (2u)

#define CY_CAPSENSE_TUNER_BUTTON1_ON_DEBOUNCE_OFFSET                                   (118u)
#define CY_CAPSENSE_TUNER_BUTTON1_ON_DEBOUNCE_SIZE                                     (1u)

#define CY_CAPSENSE_TUNER_BUTTON1_TX_CLK_SOURCE_OFFSET                                 (119u)
#define CY_CAPSENSE_TUNER_BUTTON1_TX_CLK_SOURCE_SIZE                                   (1u)

#define CY_CAPSENSE_TUNER_BUTTON1_IDAC_MOD0_OFFSET                                     (120u)
#define CY_CAPSENSE_TUNER_BUTTON1_IDAC_MOD0_SIZE                                       (1u)

#define CY_CAPSENSE_TUNER_BUTTON1_IDAC_MOD1_OFFSET                                     (121u)
#define CY_CAPSENSE_TUNER_BUTTON1_IDAC_MOD1_SIZE                                       (1u)

#define CY_CAPSENSE_TUNER_BUTTON1_IDAC_MOD2_OFFSET                                     (122u)
#define CY_CAPSENSE_TUNER_BUTTON1_IDAC_MOD2_SIZE                                       (1u)

#define CY_CAPSENSE_TUNER_BUTTON1_IDAC_GAIN_INDEX_OFFSET                               (123u)
#define CY_CAPSENSE_TUNER_BUTTON1_IDAC_GAIN_INDEX_SIZE                                 (1u)

#define CY_CAPSENSE_TUNER_BUTTON1_ROW_IDAC_MOD0_OFFSET                                 (124u)
#define CY_CAPSENSE_TUNER_BUTTON1_ROW_IDAC_MOD0_SIZE                                   (1u)

#define CY_CAPSENSE_TUNER_BUTTON1_ROW_IDAC_MOD1_OFFSET                                 (125u)
#define CY_CAPSENSE_TUNER_BUTTON1_ROW_IDAC_MOD1_SIZE                                   (1u)

#define CY_CAPSENSE_TUNER_BUTTON1_ROW_IDAC_MOD2_OFFSET                                 (126u)
#define CY_CAPSENSE_TUNER_BUTTON1_ROW_IDAC_MOD2_SIZE                                   (1u)

#define CY_CAPSENSE_TUNER_BUTTON1_REGULAR_IIR_BL_N_OFFSET                              (127u)
#define CY_CAPSENSE_TUNER_BUTTON1_REGULAR_IIR_BL_N_SIZE                                (1u)

#define CY_CAPSENSE_TUNER_BUTTON1_STATUS_OFFSET                                        (128u)
#define CY_CAPSENSE_TUNER_BUTTON1_STATUS_SIZE                                          (1u)

#define CY_CAPSENSE_TUNER_BUTTON1_PTRPOSITION_OFFSET                                   (132u)
#define CY_CAPSENSE_TUNER_BUTTON1_PTRPOSITION_SIZE                                     (4u)

#define CY_CAPSENSE_TUNER_BUTTON1_NUM_POSITIONS_OFFSET                                 (136u)
#define CY_CAPSENSE_TUNER_BUTTON1_NUM_POSITIONS_SIZE                                   (1u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_FINGER_CP_OFFSET                               (140u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_FINGER_CP_SIZE                                 (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SIGPFC_OFFSET                                  (142u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SIGPFC_SIZE                                    (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_RESOLUTION_OFFSET                              (144u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_RESOLUTION_SIZE                                (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_MAX_RAW_COUNT_OFFSET                           (146u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_MAX_RAW_COUNT_SIZE                             (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_ROW_MAX_RAW_COUNT_OFFSET                       (148u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_ROW_MAX_RAW_COUNT_SIZE                         (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_FINGER_TH_OFFSET                               (150u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_FINGER_TH_SIZE                                 (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_PROX_TOUCH_TH_OFFSET                           (152u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_PROX_TOUCH_TH_SIZE                             (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_LOW_BSLN_RST_OFFSET                            (154u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_LOW_BSLN_RST_SIZE                              (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS_CLK_OFFSET                                 (156u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS_CLK_SIZE                                   (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_ROW_SNS_CLK_OFFSET                             (158u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_ROW_SNS_CLK_SIZE                               (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_GESTURE_DETECTED_OFFSET                        (160u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_GESTURE_DETECTED_SIZE                          (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_GESTURE_DIRECTION_OFFSET                       (162u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_GESTURE_DIRECTION_SIZE                         (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_XDELTA_OFFSET                                  (164u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_XDELTA_SIZE                                    (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_YDELTA_OFFSET                                  (166u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_YDELTA_SIZE                                    (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_NOISE_TH_OFFSET                                (168u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_NOISE_TH_SIZE                                  (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_NNOISE_TH_OFFSET                               (170u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_NNOISE_TH_SIZE                                 (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_HYSTERESIS_OFFSET                              (172u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_HYSTERESIS_SIZE                                (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_ON_DEBOUNCE_OFFSET                             (174u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_ON_DEBOUNCE_SIZE                               (1u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS_CLK_SOURCE_OFFSET                          (175u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS_CLK_SOURCE_SIZE                            (1u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_IDAC_MOD0_OFFSET                               (176u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_IDAC_MOD0_SIZE                                 (1u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_IDAC_MOD1_OFFSET                               (177u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_IDAC_MOD1_SIZE                                 (1u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_IDAC_MOD2_OFFSET                               (178u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_IDAC_MOD2_SIZE                                 (1u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_IDAC_GAIN_INDEX_OFFSET                         (179u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_IDAC_GAIN_INDEX_SIZE                           (1u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_ROW_IDAC_MOD0_OFFSET                           (180u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_ROW_IDAC_MOD0_SIZE                             (1u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_ROW_IDAC_MOD1_OFFSET                           (181u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_ROW_IDAC_MOD1_SIZE                             (1u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_ROW_IDAC_MOD2_OFFSET                           (182u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_ROW_IDAC_MOD2_SIZE                             (1u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_REGULAR_IIR_BL_N_OFFSET                        (183u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_REGULAR_IIR_BL_N_SIZE                          (1u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_STATUS_OFFSET                                  (184u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_STATUS_SIZE                                    (1u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_PTRPOSITION_OFFSET                             (188u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_PTRPOSITION_SIZE                               (4u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_NUM_POSITIONS_OFFSET                           (192u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_NUM_POSITIONS_SIZE                             (1u)

#define CY_CAPSENSE_TUNER_BUTTON0_RX0_RAW0_OFFSET                                      (196u)
#define CY_CAPSENSE_TUNER_BUTTON0_RX0_RAW0_SIZE                                        (2u)

#define CY_CAPSENSE_TUNER_BUTTON0_RX0_BSLN0_OFFSET                                     (198u)
#define CY_CAPSENSE_TUNER_BUTTON0_RX0_BSLN0_SIZE                                       (2u)

#define CY_CAPSENSE_TUNER_BUTTON0_RX0_DIFF0_OFFSET                                     (200u)
#define CY_CAPSENSE_TUNER_BUTTON0_RX0_DIFF0_SIZE                                       (2u)

#define CY_CAPSENSE_TUNER_BUTTON0_RX0_STATUS0_OFFSET                                   (202u)
#define CY_CAPSENSE_TUNER_BUTTON0_RX0_STATUS0_SIZE                                     (1u)

#define CY_CAPSENSE_TUNER_BUTTON0_RX0_NEG_BSLN_RST_CNT0_OFFSET                         (203u)
#define CY_CAPSENSE_TUNER_BUTTON0_RX0_NEG_BSLN_RST_CNT0_SIZE                           (1u)

#define CY_CAPSENSE_TUNER_BUTTON0_RX0_IDAC0_OFFSET                                     (204u)
#define CY_CAPSENSE_TUNER_BUTTON0_RX0_IDAC0_SIZE                                       (1u)

#define CY_CAPSENSE_TUNER_BUTTON0_RX0_BSLN_EXT0_OFFSET                                 (205u)
#define CY_CAPSENSE_TUNER_BUTTON0_RX0_BSLN_EXT0_SIZE                                   (1u)

#define CY_CAPSENSE_TUNER_BUTTON1_RX0_RAW0_OFFSET                                      (206u)
#define CY_CAPSENSE_TUNER_BUTTON1_RX0_RAW0_SIZE                                        (2u)

#define CY_CAPSENSE_TUNER_BUTTON1_RX0_BSLN0_OFFSET                                     (208u)
#define CY_CAPSENSE_TUNER_BUTTON1_RX0_BSLN0_SIZE                                       (2u)

#define CY_CAPSENSE_TUNER_BUTTON1_RX0_DIFF0_OFFSET                                     (210u)
#define CY_CAPSENSE_TUNER_BUTTON1_RX0_DIFF0_SIZE                                       (2u)

#define CY_CAPSENSE_TUNER_BUTTON1_RX0_STATUS0_OFFSET                                   (212u)
#define CY_CAPSENSE_TUNER_BUTTON1_RX0_STATUS0_SIZE                                     (1u)

#define CY_CAPSENSE_TUNER_BUTTON1_RX0_NEG_BSLN_RST_CNT0_OFFSET                         (213u)
#define CY_CAPSENSE_TUNER_BUTTON1_RX0_NEG_BSLN_RST_CNT0_SIZE                           (1u)

#define CY_CAPSENSE_TUNER_BUTTON1_RX0_IDAC0_OFFSET                                     (214u)
#define CY_CAPSENSE_TUNER_BUTTON1_RX0_IDAC0_SIZE                                       (1u)

#define CY_CAPSENSE_TUNER_BUTTON1_RX0_BSLN_EXT0_OFFSET                                 (215u)
#define CY_CAPSENSE_TUNER_BUTTON1_RX0_BSLN_EXT0_SIZE                                   (1u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS0_RAW0_OFFSET                               (216u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS0_RAW0_SIZE                                 (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS0_BSLN0_OFFSET                              (218u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS0_BSLN0_SIZE                                (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS0_DIFF0_OFFSET                              (220u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS0_DIFF0_SIZE                                (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS0_STATUS0_OFFSET                            (222u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS0_STATUS0_SIZE                              (1u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS0_NEG_BSLN_RST_CNT0_OFFSET                  (223u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS0_NEG_BSLN_RST_CNT0_SIZE                    (1u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS0_IDAC0_OFFSET                              (224u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS0_IDAC0_SIZE                                (1u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS0_BSLN_EXT0_OFFSET                          (225u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS0_BSLN_EXT0_SIZE                            (1u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS1_RAW0_OFFSET                               (226u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS1_RAW0_SIZE                                 (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS1_BSLN0_OFFSET                              (228u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS1_BSLN0_SIZE                                (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS1_DIFF0_OFFSET                              (230u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS1_DIFF0_SIZE                                (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS1_STATUS0_OFFSET                            (232u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS1_STATUS0_SIZE                              (1u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS1_NEG_BSLN_RST_CNT0_OFFSET                  (233u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS1_NEG_BSLN_RST_CNT0_SIZE                    (1u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS1_IDAC0_OFFSET                              (234u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS1_IDAC0_SIZE                                (1u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS1_BSLN_EXT0_OFFSET                          (235u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS1_BSLN_EXT0_SIZE                            (1u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS2_RAW0_OFFSET                               (236u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS2_RAW0_SIZE                                 (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS2_BSLN0_OFFSET                              (238u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS2_BSLN0_SIZE                                (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS2_DIFF0_OFFSET                              (240u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS2_DIFF0_SIZE                                (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS2_STATUS0_OFFSET                            (242u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS2_STATUS0_SIZE                              (1u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS2_NEG_BSLN_RST_CNT0_OFFSET                  (243u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS2_NEG_BSLN_RST_CNT0_SIZE                    (1u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS2_IDAC0_OFFSET                              (244u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS2_IDAC0_SIZE                                (1u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS2_BSLN_EXT0_OFFSET                          (245u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS2_BSLN_EXT0_SIZE                            (1u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS3_RAW0_OFFSET                               (246u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS3_RAW0_SIZE                                 (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS3_BSLN0_OFFSET                              (248u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS3_BSLN0_SIZE                                (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS3_DIFF0_OFFSET                              (250u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS3_DIFF0_SIZE                                (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS3_STATUS0_OFFSET                            (252u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS3_STATUS0_SIZE                              (1u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS3_NEG_BSLN_RST_CNT0_OFFSET                  (253u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS3_NEG_BSLN_RST_CNT0_SIZE                    (1u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS3_IDAC0_OFFSET                              (254u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS3_IDAC0_SIZE                                (1u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS3_BSLN_EXT0_OFFSET                          (255u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS3_BSLN_EXT0_SIZE                            (1u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS4_RAW0_OFFSET                               (256u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS4_RAW0_SIZE                                 (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS4_BSLN0_OFFSET                              (258u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS4_BSLN0_SIZE                                (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS4_DIFF0_OFFSET                              (260u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS4_DIFF0_SIZE                                (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS4_STATUS0_OFFSET                            (262u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS4_STATUS0_SIZE                              (1u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS4_NEG_BSLN_RST_CNT0_OFFSET                  (263u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS4_NEG_BSLN_RST_CNT0_SIZE                    (1u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS4_IDAC0_OFFSET                              (264u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS4_IDAC0_SIZE                                (1u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS4_BSLN_EXT0_OFFSET                          (265u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_SNS4_BSLN_EXT0_SIZE                            (1u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_X0_OFFSET                                      (266u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_X0_SIZE                                        (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_Y0_OFFSET                                      (268u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_Y0_SIZE                                        (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_Z0_OFFSET                                      (270u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_Z0_SIZE                                        (2u)

#define CY_CAPSENSE_TUNER_LINEARSLIDER0_ID0_OFFSET                                     (272u)
#define CY_CAPSENSE_TUNER_LINEARSLIDER0_ID0_SIZE                                       (2u)

#endif

#endif /* CYCFG_CAPSENSE_TUNER_REGMAP_H */

/* [] END OF FILE */
