#include "UART.h"

#include <cyhal.h>
#include <cycfg.h>
#include <string.h>
#include <stdlib.h>

static cyhal_uart_t uart;

void UART_Init() {
	cyhal_uart_init_cfg(&uart, &scb_5_hal_config);
}

void UART_PrintString(char* message) {
	size_t len = strlen(message);
	cy_rslt_t status = cyhal_uart_write(&uart, message, &len);
	CY_ASSERT(status == 0);
}

void UART_PrintNumber(int number) {
	char buff[12];
	itoa(number, buff, 10);
	UART_PrintString(buff);
}

void UART_SetFontColor(uint8_t color) {
	UART_PrintString("\033[1;3");
	UART_PrintNumber(color);
	UART_PrintString("m");
}

void UART_SetBackgroundColor(uint8_t color) {
	UART_PrintString("\033[4");
	UART_PrintNumber(color);
	UART_PrintString("m");
}