#include "SPILED.h"
#include "cy_scb_spi.h"
#include "cy_dma.h"

#include <string.h>

static uint8_t buffer[4 + SPILED_MAX_LEDS * 4 + 4];

static cy_stc_scb_spi_context_t spiCtx;
static cy_stc_dma_descriptor_t dmaDescriptor;

void SPILED_Init() {
	memset(buffer, 0, sizeof(buffer));
    buffer[4 + SPILED_MAX_LEDS * 4 + 0] = 0;
    buffer[4 + SPILED_MAX_LEDS * 4 + 1] = 0;
    buffer[4 + SPILED_MAX_LEDS * 4 + 2] = 0;
    buffer[4 + SPILED_MAX_LEDS * 4 + 3] = 0;

    for (size_t i = 0; i < SPILED_MAX_LEDS; i++) {
        SPILED_OffLed(i);
    }

	cy_rslt_t status;

    NVIC_ClearPendingIRQ(scb_1_interrupt_IRQn);
    NVIC_EnableIRQ(scb_1_interrupt_IRQn);

	cy_stc_scb_spi_config_t spiConfig;
    spiConfig.spiMode = CY_SCB_SPI_MASTER;
    spiConfig.subMode = CY_SCB_SPI_MOTOROLA;
    spiConfig.sclkMode = CY_SCB_SPI_CPHA0_CPOL0;
    spiConfig.oversample = 5;
    spiConfig.rxDataWidth = 8UL;
    spiConfig.txDataWidth = 8UL;
    spiConfig.enableMsbFirst = true;
    spiConfig.enableInputFilter = false;
    spiConfig.enableFreeRunSclk = false;
    spiConfig.enableMisoLateSample = true;
    spiConfig.enableTransferSeperation = false;
    spiConfig.ssPolarity = 0;
    spiConfig.enableWakeFromSleep = false;
    spiConfig.rxFifoTriggerLevel = 63UL;
    spiConfig.rxFifoIntEnableMask = 0UL;
    spiConfig.txFifoTriggerLevel = 63UL;
    spiConfig.txFifoIntEnableMask = 0UL;
    spiConfig.masterSlaveIntEnableMask = 0UL;

    status = Cy_SCB_SPI_Init(SCB2, &spiConfig, &spiCtx);
    CY_ASSERT(status == CY_RSLT_SUCCESS);
    Cy_SCB_SPI_Enable(SCB2);

	cy_stc_dma_descriptor_config_t descriptorConfig;
    descriptorConfig.channelState = CY_DMA_CHANNEL_DISABLED;
    descriptorConfig.interruptType = CY_DMA_DESCR;
    descriptorConfig.triggerOutType = CY_DMA_DESCR;
    descriptorConfig.triggerInType = CY_DMA_1ELEMENT;
    descriptorConfig.srcXincrement = 1;
    descriptorConfig.dstXincrement = 0;
    descriptorConfig.xCount = 32;
    descriptorConfig.srcYincrement = 32;
    descriptorConfig.dstYincrement = 0;
    descriptorConfig.yCount = sizeof(buffer) / 32;
    descriptorConfig.descriptorType = CY_DMA_2D_TRANSFER;
    descriptorConfig.dataSize = CY_DMA_BYTE;
    descriptorConfig.dstAddress = (void *)&(SCB2->TX_FIFO_WR);
	descriptorConfig.retrigger = CY_DMA_RETRIG_IM;
    descriptorConfig.srcTransferSize = CY_DMA_TRANSFER_SIZE_DATA;
    descriptorConfig.dstTransferSize = CY_DMA_TRANSFER_SIZE_WORD;
    descriptorConfig.srcAddress = buffer;
    descriptorConfig.nextDescriptor = NULL;

    status = Cy_DMA_Descriptor_Init(&dmaDescriptor, &descriptorConfig);
    CY_ASSERT(status == 0);

    NVIC_SetPriority(cpuss_interrupts_dw0_20_IRQn, 3);
    NVIC_ClearPendingIRQ(cpuss_interrupts_dw0_20_IRQn);
    NVIC_EnableIRQ(cpuss_interrupts_dw0_20_IRQn);

	Cy_DMA_Channel_SetDescriptor(DW0, 20, &dmaDescriptor);
    Cy_DMA_Channel_SetPriority(DW0, 20, 2);
    Cy_DMA_Channel_SetInterruptMask(DW0, 20, CY_DMA_INTR_MASK);
}

void SPILED_SetLed32(size_t index, uint8_t iGain, uint8_t r, uint8_t g, uint8_t b) {
    CY_ASSERT(iGain < 32);

	buffer[4 + index * 4 + 0] = 0xE0 | iGain;
	buffer[4 + index * 4 + 1] = g;
	buffer[4 + index * 4 + 2] = b;
	buffer[4 + index * 4 + 3] = r;
}

void SPILED_OffLed(size_t index) {
	buffer[4 + index * 4 + 0] = 0xA0;
	buffer[4 + index * 4 + 1] = 0;
	buffer[4 + index * 4 + 2] = 0;
	buffer[4 + index * 4 + 3] = 0;
}

void scb_2_interrupt_IRQHandler(void) {
    Cy_SCB_SPI_Interrupt(SCB2, &spiCtx);
}

void cpuss_interrupts_dw0_20_IRQHandler(void) {
    cy_en_dma_intr_cause_t status = Cy_DMA_Channel_GetStatus(DW0, 20);
    CY_ASSERT(status == CY_DMA_INTR_CAUSE_COMPLETION);

    Cy_DMA_Channel_Disable(DW0, 20);
    Cy_DMA_Channel_ClearInterrupt(DW0, 20);
}

void SPILED_Transmit() {
	Cy_DMA_Channel_SetDescriptor(DW0, 20, &dmaDescriptor);
    Cy_DMA_Enable(DW0);
    Cy_DMA_Channel_Enable(DW0, 20);
}