/*******************************************************************************
* File Name: cycfg_capsense.h
*
* Description:
* CAPSENSE(TM) Middleware configuration
* This file should not be modified. It was automatically generated by
* CAPSENSE(TM) Configurator 8.10.0.10250
*
********************************************************************************
* Copyright 2025, Cypress Semiconductor Corporation (an Infineon company) 
* or an affiliate of Cypress Semiconductor Corporation.
* SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*     http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*******************************************************************************/

#if !defined(CYCFG_CAPSENSE_H)
#define CYCFG_CAPSENSE_H

/* This enables code only when the CAPSENSE(TM) Middleware is present in the project 
 * or the information about the Middleware presence cannot be obtained.
 */
#if (defined(COMPONENT_MW_MIDDLEWARE_LLS_PROTOTYPE) || defined(COMPONENT_MW_CAPSENSE) || !defined(COMPONENT_MW_CORE_MAKE))

#include <stddef.h>
#include "cy_device_headers.h"
#include "cycfg_peripherals.h"
#include "cycfg_capsense_defines.h"

#define CY_CAPSENSE_CFG_TOOL_VERSION              (810)

#if !defined(CY_DISABLE_CAPSENSE)

#if (CY_CAPSENSE_CORE == __CORTEX_M)

#if !defined(Cmod_PORT) || !defined(Cmod_PIN) || !defined(Cmod_PORT_NUM)
#error Cmod Capacitor is not assigned: missing #define Cmod_PORT, #define Cmod_PIN, #define Cmod_PORT_NUM
#endif

#if !defined(CintA_PORT) || !defined(CintA_PIN) || !defined(CintA_PORT_NUM)
#error CintA Capacitor is not assigned: missing #define CintA_PORT, #define CintA_PIN, #define CintA_PORT_NUM
#endif

#if !defined(CintB_PORT) || !defined(CintB_PIN) || !defined(CintB_PORT_NUM)
#error CintB Capacitor is not assigned: missing #define CintB_PORT, #define CintB_PIN, #define CintB_PORT_NUM
#endif

#if !defined(Button0_Rx0_PORT) || !defined(Button0_Rx0_PIN)
#error Button0_Rx0 Sensor is not assigned: missing #define Button0_Rx0_PORT, #define Button0_Rx0_PIN
#endif

#if !defined(Button0_Tx_PORT) || !defined(Button0_Tx_PIN)
#error Button0_Tx Sensor is not assigned: missing #define Button0_Tx_PORT, #define Button0_Tx_PIN
#endif

#if !defined(Button1_Rx0_PORT) || !defined(Button1_Rx0_PIN)
#error Button1_Rx0 Sensor is not assigned: missing #define Button1_Rx0_PORT, #define Button1_Rx0_PIN
#endif

#if !defined(Button1_Tx_PORT) || !defined(Button1_Tx_PIN)
#error Button1_Tx Sensor is not assigned: missing #define Button1_Tx_PORT, #define Button1_Tx_PIN
#endif

#if !defined(LinearSlider0_Sns0_PORT) || !defined(LinearSlider0_Sns0_PIN)
#error LinearSlider0_Sns0 Sensor is not assigned: missing #define LinearSlider0_Sns0_PORT, #define LinearSlider0_Sns0_PIN
#endif

#if !defined(LinearSlider0_Sns1_PORT) || !defined(LinearSlider0_Sns1_PIN)
#error LinearSlider0_Sns1 Sensor is not assigned: missing #define LinearSlider0_Sns1_PORT, #define LinearSlider0_Sns1_PIN
#endif

#if !defined(LinearSlider0_Sns2_PORT) || !defined(LinearSlider0_Sns2_PIN)
#error LinearSlider0_Sns2 Sensor is not assigned: missing #define LinearSlider0_Sns2_PORT, #define LinearSlider0_Sns2_PIN
#endif

#if !defined(LinearSlider0_Sns3_PORT) || !defined(LinearSlider0_Sns3_PIN)
#error LinearSlider0_Sns3 Sensor is not assigned: missing #define LinearSlider0_Sns3_PORT, #define LinearSlider0_Sns3_PIN
#endif

#if !defined(LinearSlider0_Sns4_PORT) || !defined(LinearSlider0_Sns4_PIN)
#error LinearSlider0_Sns4 Sensor is not assigned: missing #define LinearSlider0_Sns4_PORT, #define LinearSlider0_Sns4_PIN
#endif

#if !defined(CY_CAPSENSE_CPU_CLK)
#error CPU clock frequency is not set: missing #define CY_CAPSENSE_CPU_CLK
#endif

#if !defined(CY_CAPSENSE_PERI_CLK)
#error Peripheral clock core is not set: missing #define CY_CAPSENSE_PERI_CLK
#endif

#if !defined(CY_CAPSENSE_VDDA_MV)
#error VDDA voltage is not set: missing #define CY_CAPSENSE_VDDA_MV
#endif

#if !defined(CY_CAPSENSE_PERI_DIV_TYPE)
#error Peripheral clock divider type is not set: missing #define CY_CAPSENSE_PERI_DIV_TYPE
#endif

#if !defined(CY_CAPSENSE_PERI_DIV_INDEX)
#error Peripheral clock divider index is not set: missing #define CY_CAPSENSE_PERI_DIV_INDEX
#endif


#include "cy_capsense.h"

/* Supported CAPSENSE(TM) Middleware version */
#define CY_CAPSENSE_MW_VERSION_REQUIRED           (200)

#if !defined (CY_CAPSENSE_MW_VERSION)
    #if (CY_CAPSENSE_MW_VERSION_MAJOR == 2)
        #define CY_CAPSENSE_MW_VERSION            (200)
    #elif (CY_CAPSENSE_MW_VERSION_MAJOR == 1)
        #define CY_CAPSENSE_MW_VERSION            (100)
    #else
        #define CY_CAPSENSE_MW_VERSION            (100)
    #endif
#endif

/* Check the used Middleware version */
#if (CY_CAPSENSE_MW_VERSION_REQUIRED > CY_CAPSENSE_MW_VERSION)
    #error The CAPSENSE(TM) Configurator requires a newer version of the CAPSENSE(TM) Middleware. Update the CAPSENSE(TM) Middleware in your project.
#endif

#define CY_CAPSENSE_BIST_SUPPORTED                (CY_CAPSENSE_MW_VERSION >= 210)

#if defined(__cplusplus)
extern "C" {
#endif

/* Widget names */
#define CY_CAPSENSE_BUTTON0_WDGT_ID                                              (0u)
#define CY_CAPSENSE_BUTTON1_WDGT_ID                                              (1u)
#define CY_CAPSENSE_LINEARSLIDER0_WDGT_ID                                        (2u)

/* Button0 sensor names */
#define CY_CAPSENSE_BUTTON0_SNS0_ID                                              (0u)

/* Button0 node names */
#define CY_CAPSENSE_BUTTON0_RX0_TX0_ID                                           (0u)

/* Button0 sensor element IDs */
#define CY_CAPSENSE_BUTTON0_RX0_ID                                               (0u)
#define CY_CAPSENSE_BUTTON0_TX0_ID                                               (1u)

/* Button1 sensor names */
#define CY_CAPSENSE_BUTTON1_SNS0_ID                                              (0u)

/* Button1 node names */
#define CY_CAPSENSE_BUTTON1_RX0_TX0_ID                                           (0u)

/* Button1 sensor element IDs */
#define CY_CAPSENSE_BUTTON1_RX0_ID                                               (0u)
#define CY_CAPSENSE_BUTTON1_TX0_ID                                               (1u)

/* LinearSlider0 sensor names */
#define CY_CAPSENSE_LINEARSLIDER0_SNS0_ID                                        (0u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS1_ID                                        (1u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS2_ID                                        (2u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS3_ID                                        (3u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS4_ID                                        (4u)


#if (CY_CAPSENSE_BIST_SUPPORTED)
#if (CY_CAPSENSE_BIST_EN != 0)
typedef struct {
    uint32_t cy_capsense_eltdCap[CY_CAPSENSE_ELTD_COUNT];    
} cy_stc_capsense_bist_data_t;
#endif
#endif

typedef struct {
    cy_stc_capsense_common_context_t commonContext;
    cy_stc_capsense_widget_context_t widgetContext[3];
    cy_stc_capsense_sensor_context_t sensorContext[7];
    cy_stc_capsense_position_t position[1];
} cy_stc_capsense_tuner_t;

extern cy_stc_capsense_tuner_t cy_capsense_tuner;

extern cy_stc_capsense_context_t cy_capsense_context;

/* RAM Data structure register definitions */
#if (CY_CAPSENSE_MW_VERSION < 300)
#define CY_CAPSENSE_CONFIG_ID_VALUE                                              (cy_capsense_tuner.commonContext.configId)
#define CY_CAPSENSE_CONFIG_ID_OFFSET                                             (0u)
#define CY_CAPSENSE_CONFIG_ID_SIZE                                               (2u)
#define CY_CAPSENSE_CONFIG_ID_PARAM_ID                                           (0x02000000u)

#define CY_CAPSENSE_TUNER_CMD_VALUE                                              (cy_capsense_tuner.commonContext.tunerCmd)
#define CY_CAPSENSE_TUNER_CMD_OFFSET                                             (2u)
#define CY_CAPSENSE_TUNER_CMD_SIZE                                               (2u)
#define CY_CAPSENSE_TUNER_CMD_PARAM_ID                                           (0x02000002u)

#define CY_CAPSENSE_SCAN_COUNTER_VALUE                                           (cy_capsense_tuner.commonContext.scanCounter)
#define CY_CAPSENSE_SCAN_COUNTER_OFFSET                                          (4u)
#define CY_CAPSENSE_SCAN_COUNTER_SIZE                                            (2u)
#define CY_CAPSENSE_SCAN_COUNTER_PARAM_ID                                        (0x02000004u)

#define CY_CAPSENSE_TUNER_ST_VALUE                                               (cy_capsense_tuner.commonContext.tunerSt)
#define CY_CAPSENSE_TUNER_ST_OFFSET                                              (6u)
#define CY_CAPSENSE_TUNER_ST_SIZE                                                (1u)
#define CY_CAPSENSE_TUNER_ST_PARAM_ID                                            (0x01000006u)

#define CY_CAPSENSE_INITDONE_VALUE                                               (cy_capsense_tuner.commonContext.initDone)
#define CY_CAPSENSE_INITDONE_OFFSET                                              (7u)
#define CY_CAPSENSE_INITDONE_SIZE                                                (1u)
#define CY_CAPSENSE_INITDONE_PARAM_ID                                            (0x01000007u)

#define CY_CAPSENSE_PTRSSCALLBACK_VALUE                                          (cy_capsense_tuner.commonContext.ptrSSCallback)
#define CY_CAPSENSE_PTRSSCALLBACK_OFFSET                                         (8u)
#define CY_CAPSENSE_PTRSSCALLBACK_SIZE                                           (4u)
#define CY_CAPSENSE_PTRSSCALLBACK_PARAM_ID                                       (0x03000008u)

#define CY_CAPSENSE_PTREOSCALLBACK_VALUE                                         (cy_capsense_tuner.commonContext.ptrEOSCallback)
#define CY_CAPSENSE_PTREOSCALLBACK_OFFSET                                        (12u)
#define CY_CAPSENSE_PTREOSCALLBACK_SIZE                                          (4u)
#define CY_CAPSENSE_PTREOSCALLBACK_PARAM_ID                                      (0x0300000cu)

#define CY_CAPSENSE_PTRTUNERSENDCALLBACK_VALUE                                   (cy_capsense_tuner.commonContext.ptrTunerSendCallback)
#define CY_CAPSENSE_PTRTUNERSENDCALLBACK_OFFSET                                  (16u)
#define CY_CAPSENSE_PTRTUNERSENDCALLBACK_SIZE                                    (4u)
#define CY_CAPSENSE_PTRTUNERSENDCALLBACK_PARAM_ID                                (0x03000010u)

#define CY_CAPSENSE_PTRTUNERRECEIVECALLBACK_VALUE                                (cy_capsense_tuner.commonContext.ptrTunerReceiveCallback)
#define CY_CAPSENSE_PTRTUNERRECEIVECALLBACK_OFFSET                               (20u)
#define CY_CAPSENSE_PTRTUNERRECEIVECALLBACK_SIZE                                 (4u)
#define CY_CAPSENSE_PTRTUNERRECEIVECALLBACK_PARAM_ID                             (0x03000014u)

#define CY_CAPSENSE_STATUS_VALUE                                                 (cy_capsense_tuner.commonContext.status)
#define CY_CAPSENSE_STATUS_OFFSET                                                (24u)
#define CY_CAPSENSE_STATUS_SIZE                                                  (4u)
#define CY_CAPSENSE_STATUS_PARAM_ID                                              (0x03000018u)

#define CY_CAPSENSE_TIMESTAMPINTERVAL_VALUE                                      (cy_capsense_tuner.commonContext.timestampInterval)
#define CY_CAPSENSE_TIMESTAMPINTERVAL_OFFSET                                     (28u)
#define CY_CAPSENSE_TIMESTAMPINTERVAL_SIZE                                       (4u)
#define CY_CAPSENSE_TIMESTAMPINTERVAL_PARAM_ID                                   (0x0300001cu)

#define CY_CAPSENSE_TIMESTAMP_VALUE                                              (cy_capsense_tuner.commonContext.timestamp)
#define CY_CAPSENSE_TIMESTAMP_OFFSET                                             (32u)
#define CY_CAPSENSE_TIMESTAMP_SIZE                                               (4u)
#define CY_CAPSENSE_TIMESTAMP_PARAM_ID                                           (0x03000020u)

#define CY_CAPSENSE_CSD_MOD_CLK_DIVIDER_VALUE                                    (cy_capsense_tuner.commonContext.modCsdClk)
#define CY_CAPSENSE_CSD_MOD_CLK_DIVIDER_OFFSET                                   (36u)
#define CY_CAPSENSE_CSD_MOD_CLK_DIVIDER_SIZE                                     (1u)
#define CY_CAPSENSE_CSD_MOD_CLK_DIVIDER_PARAM_ID                                 (0x01000024u)

#define CY_CAPSENSE_CSX_MOD_CLK_DIVIDER_VALUE                                    (cy_capsense_tuner.commonContext.modCsxClk)
#define CY_CAPSENSE_CSX_MOD_CLK_DIVIDER_OFFSET                                   (37u)
#define CY_CAPSENSE_CSX_MOD_CLK_DIVIDER_SIZE                                     (1u)
#define CY_CAPSENSE_CSX_MOD_CLK_DIVIDER_PARAM_ID                                 (0x01000025u)

#define CY_CAPSENSE_TUNER_CNT_VALUE                                              (cy_capsense_tuner.commonContext.tunerCnt)
#define CY_CAPSENSE_TUNER_CNT_OFFSET                                             (38u)
#define CY_CAPSENSE_TUNER_CNT_SIZE                                               (1u)
#define CY_CAPSENSE_TUNER_CNT_PARAM_ID                                           (0x01000026u)

#define CY_CAPSENSE_BUTTON0_FINGER_CP_VALUE                                      (cy_capsense_tuner.widgetContext[0].fingerCap)
#define CY_CAPSENSE_BUTTON0_FINGER_CP_OFFSET                                     (40u)
#define CY_CAPSENSE_BUTTON0_FINGER_CP_SIZE                                       (2u)
#define CY_CAPSENSE_BUTTON0_FINGER_CP_PARAM_ID                                   (0x06000028u)

#define CY_CAPSENSE_BUTTON0_SIGPFC_VALUE                                         (cy_capsense_tuner.widgetContext[0].sigPFC)
#define CY_CAPSENSE_BUTTON0_SIGPFC_OFFSET                                        (42u)
#define CY_CAPSENSE_BUTTON0_SIGPFC_SIZE                                          (2u)
#define CY_CAPSENSE_BUTTON0_SIGPFC_PARAM_ID                                      (0x0600002au)

#define CY_CAPSENSE_BUTTON0_NUM_CONV_VALUE                                       (cy_capsense_tuner.widgetContext[0].resolution)
#define CY_CAPSENSE_BUTTON0_NUM_CONV_OFFSET                                      (44u)
#define CY_CAPSENSE_BUTTON0_NUM_CONV_SIZE                                        (2u)
#define CY_CAPSENSE_BUTTON0_NUM_CONV_PARAM_ID                                    (0x0600002cu)

#define CY_CAPSENSE_BUTTON0_MAX_RAW_COUNT_VALUE                                  (cy_capsense_tuner.widgetContext[0].maxRawCount)
#define CY_CAPSENSE_BUTTON0_MAX_RAW_COUNT_OFFSET                                 (46u)
#define CY_CAPSENSE_BUTTON0_MAX_RAW_COUNT_SIZE                                   (2u)
#define CY_CAPSENSE_BUTTON0_MAX_RAW_COUNT_PARAM_ID                               (0x0600002eu)

#define CY_CAPSENSE_BUTTON0_FINGER_TH_VALUE                                      (cy_capsense_tuner.widgetContext[0].fingerTh)
#define CY_CAPSENSE_BUTTON0_FINGER_TH_OFFSET                                     (48u)
#define CY_CAPSENSE_BUTTON0_FINGER_TH_SIZE                                       (2u)
#define CY_CAPSENSE_BUTTON0_FINGER_TH_PARAM_ID                                   (0x06000030u)

#define CY_CAPSENSE_BUTTON0_PROX_TOUCH_TH_VALUE                                  (cy_capsense_tuner.widgetContext[0].proxTh)
#define CY_CAPSENSE_BUTTON0_PROX_TOUCH_TH_OFFSET                                 (50u)
#define CY_CAPSENSE_BUTTON0_PROX_TOUCH_TH_SIZE                                   (2u)
#define CY_CAPSENSE_BUTTON0_PROX_TOUCH_TH_PARAM_ID                               (0x06000032u)

#define CY_CAPSENSE_BUTTON0_LOW_BSLN_RST_VALUE                                   (cy_capsense_tuner.widgetContext[0].lowBslnRst)
#define CY_CAPSENSE_BUTTON0_LOW_BSLN_RST_OFFSET                                  (52u)
#define CY_CAPSENSE_BUTTON0_LOW_BSLN_RST_SIZE                                    (2u)
#define CY_CAPSENSE_BUTTON0_LOW_BSLN_RST_PARAM_ID                                (0x06000034u)

#define CY_CAPSENSE_BUTTON0_TX_CLK_VALUE                                         (cy_capsense_tuner.widgetContext[0].snsClk)
#define CY_CAPSENSE_BUTTON0_TX_CLK_OFFSET                                        (54u)
#define CY_CAPSENSE_BUTTON0_TX_CLK_SIZE                                          (2u)
#define CY_CAPSENSE_BUTTON0_TX_CLK_PARAM_ID                                      (0x06000036u)

#define CY_CAPSENSE_BUTTON0_ROW_SNS_CLK_VALUE                                    (cy_capsense_tuner.widgetContext[0].rowSnsClk)
#define CY_CAPSENSE_BUTTON0_ROW_SNS_CLK_OFFSET                                   (56u)
#define CY_CAPSENSE_BUTTON0_ROW_SNS_CLK_SIZE                                     (2u)
#define CY_CAPSENSE_BUTTON0_ROW_SNS_CLK_PARAM_ID                                 (0x06000038u)

#define CY_CAPSENSE_BUTTON0_GESTURE_DETECTED_VALUE                               (cy_capsense_tuner.widgetContext[0].gestureDetected)
#define CY_CAPSENSE_BUTTON0_GESTURE_DETECTED_OFFSET                              (58u)
#define CY_CAPSENSE_BUTTON0_GESTURE_DETECTED_SIZE                                (2u)
#define CY_CAPSENSE_BUTTON0_GESTURE_DETECTED_PARAM_ID                            (0x0200003au)

#define CY_CAPSENSE_BUTTON0_GESTURE_DIRECTION_VALUE                              (cy_capsense_tuner.widgetContext[0].gestureDirection)
#define CY_CAPSENSE_BUTTON0_GESTURE_DIRECTION_OFFSET                             (60u)
#define CY_CAPSENSE_BUTTON0_GESTURE_DIRECTION_SIZE                               (2u)
#define CY_CAPSENSE_BUTTON0_GESTURE_DIRECTION_PARAM_ID                           (0x0200003cu)

#define CY_CAPSENSE_BUTTON0_XDELTA_VALUE                                         (cy_capsense_tuner.widgetContext[0].xDelta)
#define CY_CAPSENSE_BUTTON0_XDELTA_OFFSET                                        (62u)
#define CY_CAPSENSE_BUTTON0_XDELTA_SIZE                                          (2u)
#define CY_CAPSENSE_BUTTON0_XDELTA_PARAM_ID                                      (0x0200003eu)

#define CY_CAPSENSE_BUTTON0_YDELTA_VALUE                                         (cy_capsense_tuner.widgetContext[0].yDelta)
#define CY_CAPSENSE_BUTTON0_YDELTA_OFFSET                                        (64u)
#define CY_CAPSENSE_BUTTON0_YDELTA_SIZE                                          (2u)
#define CY_CAPSENSE_BUTTON0_YDELTA_PARAM_ID                                      (0x02000040u)

#define CY_CAPSENSE_BUTTON0_NOISE_TH_VALUE                                       (cy_capsense_tuner.widgetContext[0].noiseTh)
#define CY_CAPSENSE_BUTTON0_NOISE_TH_OFFSET                                      (66u)
#define CY_CAPSENSE_BUTTON0_NOISE_TH_SIZE                                        (1u)
#define CY_CAPSENSE_BUTTON0_NOISE_TH_PARAM_ID                                    (0x05000042u)

#define CY_CAPSENSE_BUTTON0_NNOISE_TH_VALUE                                      (cy_capsense_tuner.widgetContext[0].nNoiseTh)
#define CY_CAPSENSE_BUTTON0_NNOISE_TH_OFFSET                                     (67u)
#define CY_CAPSENSE_BUTTON0_NNOISE_TH_SIZE                                       (1u)
#define CY_CAPSENSE_BUTTON0_NNOISE_TH_PARAM_ID                                   (0x05000043u)

#define CY_CAPSENSE_BUTTON0_HYSTERESIS_VALUE                                     (cy_capsense_tuner.widgetContext[0].hysteresis)
#define CY_CAPSENSE_BUTTON0_HYSTERESIS_OFFSET                                    (68u)
#define CY_CAPSENSE_BUTTON0_HYSTERESIS_SIZE                                      (1u)
#define CY_CAPSENSE_BUTTON0_HYSTERESIS_PARAM_ID                                  (0x05000044u)

#define CY_CAPSENSE_BUTTON0_ON_DEBOUNCE_VALUE                                    (cy_capsense_tuner.widgetContext[0].onDebounce)
#define CY_CAPSENSE_BUTTON0_ON_DEBOUNCE_OFFSET                                   (69u)
#define CY_CAPSENSE_BUTTON0_ON_DEBOUNCE_SIZE                                     (1u)
#define CY_CAPSENSE_BUTTON0_ON_DEBOUNCE_PARAM_ID                                 (0x05000045u)

#define CY_CAPSENSE_BUTTON0_TX_CLK_SOURCE_VALUE                                  (cy_capsense_tuner.widgetContext[0].snsClkSource)
#define CY_CAPSENSE_BUTTON0_TX_CLK_SOURCE_OFFSET                                 (70u)
#define CY_CAPSENSE_BUTTON0_TX_CLK_SOURCE_SIZE                                   (1u)
#define CY_CAPSENSE_BUTTON0_TX_CLK_SOURCE_PARAM_ID                               (0x05000046u)

#define CY_CAPSENSE_BUTTON0_IDAC_MOD0_VALUE                                      (cy_capsense_tuner.widgetContext[0].idacMod[0])
#define CY_CAPSENSE_BUTTON0_IDAC_MOD0_OFFSET                                     (71u)
#define CY_CAPSENSE_BUTTON0_IDAC_MOD0_SIZE                                       (1u)
#define CY_CAPSENSE_BUTTON0_IDAC_MOD0_PARAM_ID                                   (0x05000047u)

#define CY_CAPSENSE_BUTTON0_IDAC_MOD1_VALUE                                      (cy_capsense_tuner.widgetContext[0].idacMod[1])
#define CY_CAPSENSE_BUTTON0_IDAC_MOD1_OFFSET                                     (72u)
#define CY_CAPSENSE_BUTTON0_IDAC_MOD1_SIZE                                       (1u)
#define CY_CAPSENSE_BUTTON0_IDAC_MOD1_PARAM_ID                                   (0x05000048u)

#define CY_CAPSENSE_BUTTON0_IDAC_MOD2_VALUE                                      (cy_capsense_tuner.widgetContext[0].idacMod[2])
#define CY_CAPSENSE_BUTTON0_IDAC_MOD2_OFFSET                                     (73u)
#define CY_CAPSENSE_BUTTON0_IDAC_MOD2_SIZE                                       (1u)
#define CY_CAPSENSE_BUTTON0_IDAC_MOD2_PARAM_ID                                   (0x05000049u)

#define CY_CAPSENSE_BUTTON0_IDAC_GAIN_INDEX_VALUE                                (cy_capsense_tuner.widgetContext[0].idacGainIndex)
#define CY_CAPSENSE_BUTTON0_IDAC_GAIN_INDEX_OFFSET                               (74u)
#define CY_CAPSENSE_BUTTON0_IDAC_GAIN_INDEX_SIZE                                 (1u)
#define CY_CAPSENSE_BUTTON0_IDAC_GAIN_INDEX_PARAM_ID                             (0x0500004au)

#define CY_CAPSENSE_BUTTON0_ROW_IDAC_MOD0_VALUE                                  (cy_capsense_tuner.widgetContext[0].rowIdacMod[0])
#define CY_CAPSENSE_BUTTON0_ROW_IDAC_MOD0_OFFSET                                 (75u)
#define CY_CAPSENSE_BUTTON0_ROW_IDAC_MOD0_SIZE                                   (1u)
#define CY_CAPSENSE_BUTTON0_ROW_IDAC_MOD0_PARAM_ID                               (0x0500004bu)

#define CY_CAPSENSE_BUTTON0_ROW_IDAC_MOD1_VALUE                                  (cy_capsense_tuner.widgetContext[0].rowIdacMod[1])
#define CY_CAPSENSE_BUTTON0_ROW_IDAC_MOD1_OFFSET                                 (76u)
#define CY_CAPSENSE_BUTTON0_ROW_IDAC_MOD1_SIZE                                   (1u)
#define CY_CAPSENSE_BUTTON0_ROW_IDAC_MOD1_PARAM_ID                               (0x0500004cu)

#define CY_CAPSENSE_BUTTON0_ROW_IDAC_MOD2_VALUE                                  (cy_capsense_tuner.widgetContext[0].rowIdacMod[2])
#define CY_CAPSENSE_BUTTON0_ROW_IDAC_MOD2_OFFSET                                 (77u)
#define CY_CAPSENSE_BUTTON0_ROW_IDAC_MOD2_SIZE                                   (1u)
#define CY_CAPSENSE_BUTTON0_ROW_IDAC_MOD2_PARAM_ID                               (0x0500004du)

#define CY_CAPSENSE_BUTTON0_REGULAR_IIR_BL_N_VALUE                               (cy_capsense_tuner.widgetContext[0].bslnCoeff)
#define CY_CAPSENSE_BUTTON0_REGULAR_IIR_BL_N_OFFSET                              (78u)
#define CY_CAPSENSE_BUTTON0_REGULAR_IIR_BL_N_SIZE                                (1u)
#define CY_CAPSENSE_BUTTON0_REGULAR_IIR_BL_N_PARAM_ID                            (0x0500004eu)

#define CY_CAPSENSE_BUTTON0_STATUS_VALUE                                         (cy_capsense_tuner.widgetContext[0].status)
#define CY_CAPSENSE_BUTTON0_STATUS_OFFSET                                        (79u)
#define CY_CAPSENSE_BUTTON0_STATUS_SIZE                                          (1u)
#define CY_CAPSENSE_BUTTON0_STATUS_PARAM_ID                                      (0x0100004fu)

#define CY_CAPSENSE_BUTTON0_PTRPOSITION_VALUE                                    (cy_capsense_tuner.widgetContext[0].wdTouch.ptrPosition)
#define CY_CAPSENSE_BUTTON0_PTRPOSITION_OFFSET                                   (80u)
#define CY_CAPSENSE_BUTTON0_PTRPOSITION_SIZE                                     (4u)
#define CY_CAPSENSE_BUTTON0_PTRPOSITION_PARAM_ID                                 (0x03000050u)

#define CY_CAPSENSE_BUTTON0_NUM_POSITIONS_VALUE                                  (cy_capsense_tuner.widgetContext[0].wdTouch.numPosition)
#define CY_CAPSENSE_BUTTON0_NUM_POSITIONS_OFFSET                                 (84u)
#define CY_CAPSENSE_BUTTON0_NUM_POSITIONS_SIZE                                   (1u)
#define CY_CAPSENSE_BUTTON0_NUM_POSITIONS_PARAM_ID                               (0x01000054u)

#define CY_CAPSENSE_BUTTON1_FINGER_CP_VALUE                                      (cy_capsense_tuner.widgetContext[1].fingerCap)
#define CY_CAPSENSE_BUTTON1_FINGER_CP_OFFSET                                     (88u)
#define CY_CAPSENSE_BUTTON1_FINGER_CP_SIZE                                       (2u)
#define CY_CAPSENSE_BUTTON1_FINGER_CP_PARAM_ID                                   (0x06010058u)

#define CY_CAPSENSE_BUTTON1_SIGPFC_VALUE                                         (cy_capsense_tuner.widgetContext[1].sigPFC)
#define CY_CAPSENSE_BUTTON1_SIGPFC_OFFSET                                        (90u)
#define CY_CAPSENSE_BUTTON1_SIGPFC_SIZE                                          (2u)
#define CY_CAPSENSE_BUTTON1_SIGPFC_PARAM_ID                                      (0x0601005au)

#define CY_CAPSENSE_BUTTON1_NUM_CONV_VALUE                                       (cy_capsense_tuner.widgetContext[1].resolution)
#define CY_CAPSENSE_BUTTON1_NUM_CONV_OFFSET                                      (92u)
#define CY_CAPSENSE_BUTTON1_NUM_CONV_SIZE                                        (2u)
#define CY_CAPSENSE_BUTTON1_NUM_CONV_PARAM_ID                                    (0x0601005cu)

#define CY_CAPSENSE_BUTTON1_MAX_RAW_COUNT_VALUE                                  (cy_capsense_tuner.widgetContext[1].maxRawCount)
#define CY_CAPSENSE_BUTTON1_MAX_RAW_COUNT_OFFSET                                 (94u)
#define CY_CAPSENSE_BUTTON1_MAX_RAW_COUNT_SIZE                                   (2u)
#define CY_CAPSENSE_BUTTON1_MAX_RAW_COUNT_PARAM_ID                               (0x0601005eu)

#define CY_CAPSENSE_BUTTON1_FINGER_TH_VALUE                                      (cy_capsense_tuner.widgetContext[1].fingerTh)
#define CY_CAPSENSE_BUTTON1_FINGER_TH_OFFSET                                     (96u)
#define CY_CAPSENSE_BUTTON1_FINGER_TH_SIZE                                       (2u)
#define CY_CAPSENSE_BUTTON1_FINGER_TH_PARAM_ID                                   (0x06010060u)

#define CY_CAPSENSE_BUTTON1_PROX_TOUCH_TH_VALUE                                  (cy_capsense_tuner.widgetContext[1].proxTh)
#define CY_CAPSENSE_BUTTON1_PROX_TOUCH_TH_OFFSET                                 (98u)
#define CY_CAPSENSE_BUTTON1_PROX_TOUCH_TH_SIZE                                   (2u)
#define CY_CAPSENSE_BUTTON1_PROX_TOUCH_TH_PARAM_ID                               (0x06010062u)

#define CY_CAPSENSE_BUTTON1_LOW_BSLN_RST_VALUE                                   (cy_capsense_tuner.widgetContext[1].lowBslnRst)
#define CY_CAPSENSE_BUTTON1_LOW_BSLN_RST_OFFSET                                  (100u)
#define CY_CAPSENSE_BUTTON1_LOW_BSLN_RST_SIZE                                    (2u)
#define CY_CAPSENSE_BUTTON1_LOW_BSLN_RST_PARAM_ID                                (0x06010064u)

#define CY_CAPSENSE_BUTTON1_TX_CLK_VALUE                                         (cy_capsense_tuner.widgetContext[1].snsClk)
#define CY_CAPSENSE_BUTTON1_TX_CLK_OFFSET                                        (102u)
#define CY_CAPSENSE_BUTTON1_TX_CLK_SIZE                                          (2u)
#define CY_CAPSENSE_BUTTON1_TX_CLK_PARAM_ID                                      (0x06010066u)

#define CY_CAPSENSE_BUTTON1_ROW_SNS_CLK_VALUE                                    (cy_capsense_tuner.widgetContext[1].rowSnsClk)
#define CY_CAPSENSE_BUTTON1_ROW_SNS_CLK_OFFSET                                   (104u)
#define CY_CAPSENSE_BUTTON1_ROW_SNS_CLK_SIZE                                     (2u)
#define CY_CAPSENSE_BUTTON1_ROW_SNS_CLK_PARAM_ID                                 (0x06010068u)

#define CY_CAPSENSE_BUTTON1_GESTURE_DETECTED_VALUE                               (cy_capsense_tuner.widgetContext[1].gestureDetected)
#define CY_CAPSENSE_BUTTON1_GESTURE_DETECTED_OFFSET                              (106u)
#define CY_CAPSENSE_BUTTON1_GESTURE_DETECTED_SIZE                                (2u)
#define CY_CAPSENSE_BUTTON1_GESTURE_DETECTED_PARAM_ID                            (0x0201006au)

#define CY_CAPSENSE_BUTTON1_GESTURE_DIRECTION_VALUE                              (cy_capsense_tuner.widgetContext[1].gestureDirection)
#define CY_CAPSENSE_BUTTON1_GESTURE_DIRECTION_OFFSET                             (108u)
#define CY_CAPSENSE_BUTTON1_GESTURE_DIRECTION_SIZE                               (2u)
#define CY_CAPSENSE_BUTTON1_GESTURE_DIRECTION_PARAM_ID                           (0x0201006cu)

#define CY_CAPSENSE_BUTTON1_XDELTA_VALUE                                         (cy_capsense_tuner.widgetContext[1].xDelta)
#define CY_CAPSENSE_BUTTON1_XDELTA_OFFSET                                        (110u)
#define CY_CAPSENSE_BUTTON1_XDELTA_SIZE                                          (2u)
#define CY_CAPSENSE_BUTTON1_XDELTA_PARAM_ID                                      (0x0201006eu)

#define CY_CAPSENSE_BUTTON1_YDELTA_VALUE                                         (cy_capsense_tuner.widgetContext[1].yDelta)
#define CY_CAPSENSE_BUTTON1_YDELTA_OFFSET                                        (112u)
#define CY_CAPSENSE_BUTTON1_YDELTA_SIZE                                          (2u)
#define CY_CAPSENSE_BUTTON1_YDELTA_PARAM_ID                                      (0x02010070u)

#define CY_CAPSENSE_BUTTON1_NOISE_TH_VALUE                                       (cy_capsense_tuner.widgetContext[1].noiseTh)
#define CY_CAPSENSE_BUTTON1_NOISE_TH_OFFSET                                      (114u)
#define CY_CAPSENSE_BUTTON1_NOISE_TH_SIZE                                        (1u)
#define CY_CAPSENSE_BUTTON1_NOISE_TH_PARAM_ID                                    (0x05010072u)

#define CY_CAPSENSE_BUTTON1_NNOISE_TH_VALUE                                      (cy_capsense_tuner.widgetContext[1].nNoiseTh)
#define CY_CAPSENSE_BUTTON1_NNOISE_TH_OFFSET                                     (115u)
#define CY_CAPSENSE_BUTTON1_NNOISE_TH_SIZE                                       (1u)
#define CY_CAPSENSE_BUTTON1_NNOISE_TH_PARAM_ID                                   (0x05010073u)

#define CY_CAPSENSE_BUTTON1_HYSTERESIS_VALUE                                     (cy_capsense_tuner.widgetContext[1].hysteresis)
#define CY_CAPSENSE_BUTTON1_HYSTERESIS_OFFSET                                    (116u)
#define CY_CAPSENSE_BUTTON1_HYSTERESIS_SIZE                                      (1u)
#define CY_CAPSENSE_BUTTON1_HYSTERESIS_PARAM_ID                                  (0x05010074u)

#define CY_CAPSENSE_BUTTON1_ON_DEBOUNCE_VALUE                                    (cy_capsense_tuner.widgetContext[1].onDebounce)
#define CY_CAPSENSE_BUTTON1_ON_DEBOUNCE_OFFSET                                   (117u)
#define CY_CAPSENSE_BUTTON1_ON_DEBOUNCE_SIZE                                     (1u)
#define CY_CAPSENSE_BUTTON1_ON_DEBOUNCE_PARAM_ID                                 (0x05010075u)

#define CY_CAPSENSE_BUTTON1_TX_CLK_SOURCE_VALUE                                  (cy_capsense_tuner.widgetContext[1].snsClkSource)
#define CY_CAPSENSE_BUTTON1_TX_CLK_SOURCE_OFFSET                                 (118u)
#define CY_CAPSENSE_BUTTON1_TX_CLK_SOURCE_SIZE                                   (1u)
#define CY_CAPSENSE_BUTTON1_TX_CLK_SOURCE_PARAM_ID                               (0x05010076u)

#define CY_CAPSENSE_BUTTON1_IDAC_MOD0_VALUE                                      (cy_capsense_tuner.widgetContext[1].idacMod[0])
#define CY_CAPSENSE_BUTTON1_IDAC_MOD0_OFFSET                                     (119u)
#define CY_CAPSENSE_BUTTON1_IDAC_MOD0_SIZE                                       (1u)
#define CY_CAPSENSE_BUTTON1_IDAC_MOD0_PARAM_ID                                   (0x05010077u)

#define CY_CAPSENSE_BUTTON1_IDAC_MOD1_VALUE                                      (cy_capsense_tuner.widgetContext[1].idacMod[1])
#define CY_CAPSENSE_BUTTON1_IDAC_MOD1_OFFSET                                     (120u)
#define CY_CAPSENSE_BUTTON1_IDAC_MOD1_SIZE                                       (1u)
#define CY_CAPSENSE_BUTTON1_IDAC_MOD1_PARAM_ID                                   (0x05010078u)

#define CY_CAPSENSE_BUTTON1_IDAC_MOD2_VALUE                                      (cy_capsense_tuner.widgetContext[1].idacMod[2])
#define CY_CAPSENSE_BUTTON1_IDAC_MOD2_OFFSET                                     (121u)
#define CY_CAPSENSE_BUTTON1_IDAC_MOD2_SIZE                                       (1u)
#define CY_CAPSENSE_BUTTON1_IDAC_MOD2_PARAM_ID                                   (0x05010079u)

#define CY_CAPSENSE_BUTTON1_IDAC_GAIN_INDEX_VALUE                                (cy_capsense_tuner.widgetContext[1].idacGainIndex)
#define CY_CAPSENSE_BUTTON1_IDAC_GAIN_INDEX_OFFSET                               (122u)
#define CY_CAPSENSE_BUTTON1_IDAC_GAIN_INDEX_SIZE                                 (1u)
#define CY_CAPSENSE_BUTTON1_IDAC_GAIN_INDEX_PARAM_ID                             (0x0501007au)

#define CY_CAPSENSE_BUTTON1_ROW_IDAC_MOD0_VALUE                                  (cy_capsense_tuner.widgetContext[1].rowIdacMod[0])
#define CY_CAPSENSE_BUTTON1_ROW_IDAC_MOD0_OFFSET                                 (123u)
#define CY_CAPSENSE_BUTTON1_ROW_IDAC_MOD0_SIZE                                   (1u)
#define CY_CAPSENSE_BUTTON1_ROW_IDAC_MOD0_PARAM_ID                               (0x0501007bu)

#define CY_CAPSENSE_BUTTON1_ROW_IDAC_MOD1_VALUE                                  (cy_capsense_tuner.widgetContext[1].rowIdacMod[1])
#define CY_CAPSENSE_BUTTON1_ROW_IDAC_MOD1_OFFSET                                 (124u)
#define CY_CAPSENSE_BUTTON1_ROW_IDAC_MOD1_SIZE                                   (1u)
#define CY_CAPSENSE_BUTTON1_ROW_IDAC_MOD1_PARAM_ID                               (0x0501007cu)

#define CY_CAPSENSE_BUTTON1_ROW_IDAC_MOD2_VALUE                                  (cy_capsense_tuner.widgetContext[1].rowIdacMod[2])
#define CY_CAPSENSE_BUTTON1_ROW_IDAC_MOD2_OFFSET                                 (125u)
#define CY_CAPSENSE_BUTTON1_ROW_IDAC_MOD2_SIZE                                   (1u)
#define CY_CAPSENSE_BUTTON1_ROW_IDAC_MOD2_PARAM_ID                               (0x0501007du)

#define CY_CAPSENSE_BUTTON1_REGULAR_IIR_BL_N_VALUE                               (cy_capsense_tuner.widgetContext[1].bslnCoeff)
#define CY_CAPSENSE_BUTTON1_REGULAR_IIR_BL_N_OFFSET                              (126u)
#define CY_CAPSENSE_BUTTON1_REGULAR_IIR_BL_N_SIZE                                (1u)
#define CY_CAPSENSE_BUTTON1_REGULAR_IIR_BL_N_PARAM_ID                            (0x0501007eu)

#define CY_CAPSENSE_BUTTON1_STATUS_VALUE                                         (cy_capsense_tuner.widgetContext[1].status)
#define CY_CAPSENSE_BUTTON1_STATUS_OFFSET                                        (127u)
#define CY_CAPSENSE_BUTTON1_STATUS_SIZE                                          (1u)
#define CY_CAPSENSE_BUTTON1_STATUS_PARAM_ID                                      (0x0101007fu)

#define CY_CAPSENSE_BUTTON1_PTRPOSITION_VALUE                                    (cy_capsense_tuner.widgetContext[1].wdTouch.ptrPosition)
#define CY_CAPSENSE_BUTTON1_PTRPOSITION_OFFSET                                   (128u)
#define CY_CAPSENSE_BUTTON1_PTRPOSITION_SIZE                                     (4u)
#define CY_CAPSENSE_BUTTON1_PTRPOSITION_PARAM_ID                                 (0x03010080u)

#define CY_CAPSENSE_BUTTON1_NUM_POSITIONS_VALUE                                  (cy_capsense_tuner.widgetContext[1].wdTouch.numPosition)
#define CY_CAPSENSE_BUTTON1_NUM_POSITIONS_OFFSET                                 (132u)
#define CY_CAPSENSE_BUTTON1_NUM_POSITIONS_SIZE                                   (1u)
#define CY_CAPSENSE_BUTTON1_NUM_POSITIONS_PARAM_ID                               (0x01010084u)

#define CY_CAPSENSE_LINEARSLIDER0_FINGER_CP_VALUE                                (cy_capsense_tuner.widgetContext[2].fingerCap)
#define CY_CAPSENSE_LINEARSLIDER0_FINGER_CP_OFFSET                               (136u)
#define CY_CAPSENSE_LINEARSLIDER0_FINGER_CP_SIZE                                 (2u)
#define CY_CAPSENSE_LINEARSLIDER0_FINGER_CP_PARAM_ID                             (0x06020088u)

#define CY_CAPSENSE_LINEARSLIDER0_SIGPFC_VALUE                                   (cy_capsense_tuner.widgetContext[2].sigPFC)
#define CY_CAPSENSE_LINEARSLIDER0_SIGPFC_OFFSET                                  (138u)
#define CY_CAPSENSE_LINEARSLIDER0_SIGPFC_SIZE                                    (2u)
#define CY_CAPSENSE_LINEARSLIDER0_SIGPFC_PARAM_ID                                (0x0602008au)

#define CY_CAPSENSE_LINEARSLIDER0_RESOLUTION_VALUE                               (cy_capsense_tuner.widgetContext[2].resolution)
#define CY_CAPSENSE_LINEARSLIDER0_RESOLUTION_OFFSET                              (140u)
#define CY_CAPSENSE_LINEARSLIDER0_RESOLUTION_SIZE                                (2u)
#define CY_CAPSENSE_LINEARSLIDER0_RESOLUTION_PARAM_ID                            (0x0602008cu)

#define CY_CAPSENSE_LINEARSLIDER0_MAX_RAW_COUNT_VALUE                            (cy_capsense_tuner.widgetContext[2].maxRawCount)
#define CY_CAPSENSE_LINEARSLIDER0_MAX_RAW_COUNT_OFFSET                           (142u)
#define CY_CAPSENSE_LINEARSLIDER0_MAX_RAW_COUNT_SIZE                             (2u)
#define CY_CAPSENSE_LINEARSLIDER0_MAX_RAW_COUNT_PARAM_ID                         (0x0602008eu)

#define CY_CAPSENSE_LINEARSLIDER0_FINGER_TH_VALUE                                (cy_capsense_tuner.widgetContext[2].fingerTh)
#define CY_CAPSENSE_LINEARSLIDER0_FINGER_TH_OFFSET                               (144u)
#define CY_CAPSENSE_LINEARSLIDER0_FINGER_TH_SIZE                                 (2u)
#define CY_CAPSENSE_LINEARSLIDER0_FINGER_TH_PARAM_ID                             (0x02020090u)

#define CY_CAPSENSE_LINEARSLIDER0_PROX_TOUCH_TH_VALUE                            (cy_capsense_tuner.widgetContext[2].proxTh)
#define CY_CAPSENSE_LINEARSLIDER0_PROX_TOUCH_TH_OFFSET                           (146u)
#define CY_CAPSENSE_LINEARSLIDER0_PROX_TOUCH_TH_SIZE                             (2u)
#define CY_CAPSENSE_LINEARSLIDER0_PROX_TOUCH_TH_PARAM_ID                         (0x02020092u)

#define CY_CAPSENSE_LINEARSLIDER0_LOW_BSLN_RST_VALUE                             (cy_capsense_tuner.widgetContext[2].lowBslnRst)
#define CY_CAPSENSE_LINEARSLIDER0_LOW_BSLN_RST_OFFSET                            (148u)
#define CY_CAPSENSE_LINEARSLIDER0_LOW_BSLN_RST_SIZE                              (2u)
#define CY_CAPSENSE_LINEARSLIDER0_LOW_BSLN_RST_PARAM_ID                          (0x06020094u)

#define CY_CAPSENSE_LINEARSLIDER0_SNS_CLK_VALUE                                  (cy_capsense_tuner.widgetContext[2].snsClk)
#define CY_CAPSENSE_LINEARSLIDER0_SNS_CLK_OFFSET                                 (150u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS_CLK_SIZE                                   (2u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS_CLK_PARAM_ID                               (0x06020096u)

#define CY_CAPSENSE_LINEARSLIDER0_ROW_SNS_CLK_VALUE                              (cy_capsense_tuner.widgetContext[2].rowSnsClk)
#define CY_CAPSENSE_LINEARSLIDER0_ROW_SNS_CLK_OFFSET                             (152u)
#define CY_CAPSENSE_LINEARSLIDER0_ROW_SNS_CLK_SIZE                               (2u)
#define CY_CAPSENSE_LINEARSLIDER0_ROW_SNS_CLK_PARAM_ID                           (0x06020098u)

#define CY_CAPSENSE_LINEARSLIDER0_GESTURE_DETECTED_VALUE                         (cy_capsense_tuner.widgetContext[2].gestureDetected)
#define CY_CAPSENSE_LINEARSLIDER0_GESTURE_DETECTED_OFFSET                        (154u)
#define CY_CAPSENSE_LINEARSLIDER0_GESTURE_DETECTED_SIZE                          (2u)
#define CY_CAPSENSE_LINEARSLIDER0_GESTURE_DETECTED_PARAM_ID                      (0x0202009au)

#define CY_CAPSENSE_LINEARSLIDER0_GESTURE_DIRECTION_VALUE                        (cy_capsense_tuner.widgetContext[2].gestureDirection)
#define CY_CAPSENSE_LINEARSLIDER0_GESTURE_DIRECTION_OFFSET                       (156u)
#define CY_CAPSENSE_LINEARSLIDER0_GESTURE_DIRECTION_SIZE                         (2u)
#define CY_CAPSENSE_LINEARSLIDER0_GESTURE_DIRECTION_PARAM_ID                     (0x0202009cu)

#define CY_CAPSENSE_LINEARSLIDER0_XDELTA_VALUE                                   (cy_capsense_tuner.widgetContext[2].xDelta)
#define CY_CAPSENSE_LINEARSLIDER0_XDELTA_OFFSET                                  (158u)
#define CY_CAPSENSE_LINEARSLIDER0_XDELTA_SIZE                                    (2u)
#define CY_CAPSENSE_LINEARSLIDER0_XDELTA_PARAM_ID                                (0x0202009eu)

#define CY_CAPSENSE_LINEARSLIDER0_YDELTA_VALUE                                   (cy_capsense_tuner.widgetContext[2].yDelta)
#define CY_CAPSENSE_LINEARSLIDER0_YDELTA_OFFSET                                  (160u)
#define CY_CAPSENSE_LINEARSLIDER0_YDELTA_SIZE                                    (2u)
#define CY_CAPSENSE_LINEARSLIDER0_YDELTA_PARAM_ID                                (0x020200a0u)

#define CY_CAPSENSE_LINEARSLIDER0_NOISE_TH_VALUE                                 (cy_capsense_tuner.widgetContext[2].noiseTh)
#define CY_CAPSENSE_LINEARSLIDER0_NOISE_TH_OFFSET                                (162u)
#define CY_CAPSENSE_LINEARSLIDER0_NOISE_TH_SIZE                                  (1u)
#define CY_CAPSENSE_LINEARSLIDER0_NOISE_TH_PARAM_ID                              (0x010200a2u)

#define CY_CAPSENSE_LINEARSLIDER0_NNOISE_TH_VALUE                                (cy_capsense_tuner.widgetContext[2].nNoiseTh)
#define CY_CAPSENSE_LINEARSLIDER0_NNOISE_TH_OFFSET                               (163u)
#define CY_CAPSENSE_LINEARSLIDER0_NNOISE_TH_SIZE                                 (1u)
#define CY_CAPSENSE_LINEARSLIDER0_NNOISE_TH_PARAM_ID                             (0x010200a3u)

#define CY_CAPSENSE_LINEARSLIDER0_HYSTERESIS_VALUE                               (cy_capsense_tuner.widgetContext[2].hysteresis)
#define CY_CAPSENSE_LINEARSLIDER0_HYSTERESIS_OFFSET                              (164u)
#define CY_CAPSENSE_LINEARSLIDER0_HYSTERESIS_SIZE                                (1u)
#define CY_CAPSENSE_LINEARSLIDER0_HYSTERESIS_PARAM_ID                            (0x010200a4u)

#define CY_CAPSENSE_LINEARSLIDER0_ON_DEBOUNCE_VALUE                              (cy_capsense_tuner.widgetContext[2].onDebounce)
#define CY_CAPSENSE_LINEARSLIDER0_ON_DEBOUNCE_OFFSET                             (165u)
#define CY_CAPSENSE_LINEARSLIDER0_ON_DEBOUNCE_SIZE                               (1u)
#define CY_CAPSENSE_LINEARSLIDER0_ON_DEBOUNCE_PARAM_ID                           (0x050200a5u)

#define CY_CAPSENSE_LINEARSLIDER0_SNS_CLK_SOURCE_VALUE                           (cy_capsense_tuner.widgetContext[2].snsClkSource)
#define CY_CAPSENSE_LINEARSLIDER0_SNS_CLK_SOURCE_OFFSET                          (166u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS_CLK_SOURCE_SIZE                            (1u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS_CLK_SOURCE_PARAM_ID                        (0x050200a6u)

#define CY_CAPSENSE_LINEARSLIDER0_IDAC_MOD0_VALUE                                (cy_capsense_tuner.widgetContext[2].idacMod[0])
#define CY_CAPSENSE_LINEARSLIDER0_IDAC_MOD0_OFFSET                               (167u)
#define CY_CAPSENSE_LINEARSLIDER0_IDAC_MOD0_SIZE                                 (1u)
#define CY_CAPSENSE_LINEARSLIDER0_IDAC_MOD0_PARAM_ID                             (0x050200a7u)

#define CY_CAPSENSE_LINEARSLIDER0_IDAC_MOD1_VALUE                                (cy_capsense_tuner.widgetContext[2].idacMod[1])
#define CY_CAPSENSE_LINEARSLIDER0_IDAC_MOD1_OFFSET                               (168u)
#define CY_CAPSENSE_LINEARSLIDER0_IDAC_MOD1_SIZE                                 (1u)
#define CY_CAPSENSE_LINEARSLIDER0_IDAC_MOD1_PARAM_ID                             (0x050200a8u)

#define CY_CAPSENSE_LINEARSLIDER0_IDAC_MOD2_VALUE                                (cy_capsense_tuner.widgetContext[2].idacMod[2])
#define CY_CAPSENSE_LINEARSLIDER0_IDAC_MOD2_OFFSET                               (169u)
#define CY_CAPSENSE_LINEARSLIDER0_IDAC_MOD2_SIZE                                 (1u)
#define CY_CAPSENSE_LINEARSLIDER0_IDAC_MOD2_PARAM_ID                             (0x050200a9u)

#define CY_CAPSENSE_LINEARSLIDER0_IDAC_GAIN_INDEX_VALUE                          (cy_capsense_tuner.widgetContext[2].idacGainIndex)
#define CY_CAPSENSE_LINEARSLIDER0_IDAC_GAIN_INDEX_OFFSET                         (170u)
#define CY_CAPSENSE_LINEARSLIDER0_IDAC_GAIN_INDEX_SIZE                           (1u)
#define CY_CAPSENSE_LINEARSLIDER0_IDAC_GAIN_INDEX_PARAM_ID                       (0x050200aau)

#define CY_CAPSENSE_LINEARSLIDER0_ROW_IDAC_MOD0_VALUE                            (cy_capsense_tuner.widgetContext[2].rowIdacMod[0])
#define CY_CAPSENSE_LINEARSLIDER0_ROW_IDAC_MOD0_OFFSET                           (171u)
#define CY_CAPSENSE_LINEARSLIDER0_ROW_IDAC_MOD0_SIZE                             (1u)
#define CY_CAPSENSE_LINEARSLIDER0_ROW_IDAC_MOD0_PARAM_ID                         (0x050200abu)

#define CY_CAPSENSE_LINEARSLIDER0_ROW_IDAC_MOD1_VALUE                            (cy_capsense_tuner.widgetContext[2].rowIdacMod[1])
#define CY_CAPSENSE_LINEARSLIDER0_ROW_IDAC_MOD1_OFFSET                           (172u)
#define CY_CAPSENSE_LINEARSLIDER0_ROW_IDAC_MOD1_SIZE                             (1u)
#define CY_CAPSENSE_LINEARSLIDER0_ROW_IDAC_MOD1_PARAM_ID                         (0x050200acu)

#define CY_CAPSENSE_LINEARSLIDER0_ROW_IDAC_MOD2_VALUE                            (cy_capsense_tuner.widgetContext[2].rowIdacMod[2])
#define CY_CAPSENSE_LINEARSLIDER0_ROW_IDAC_MOD2_OFFSET                           (173u)
#define CY_CAPSENSE_LINEARSLIDER0_ROW_IDAC_MOD2_SIZE                             (1u)
#define CY_CAPSENSE_LINEARSLIDER0_ROW_IDAC_MOD2_PARAM_ID                         (0x050200adu)

#define CY_CAPSENSE_LINEARSLIDER0_REGULAR_IIR_BL_N_VALUE                         (cy_capsense_tuner.widgetContext[2].bslnCoeff)
#define CY_CAPSENSE_LINEARSLIDER0_REGULAR_IIR_BL_N_OFFSET                        (174u)
#define CY_CAPSENSE_LINEARSLIDER0_REGULAR_IIR_BL_N_SIZE                          (1u)
#define CY_CAPSENSE_LINEARSLIDER0_REGULAR_IIR_BL_N_PARAM_ID                      (0x050200aeu)

#define CY_CAPSENSE_LINEARSLIDER0_STATUS_VALUE                                   (cy_capsense_tuner.widgetContext[2].status)
#define CY_CAPSENSE_LINEARSLIDER0_STATUS_OFFSET                                  (175u)
#define CY_CAPSENSE_LINEARSLIDER0_STATUS_SIZE                                    (1u)
#define CY_CAPSENSE_LINEARSLIDER0_STATUS_PARAM_ID                                (0x010200afu)

#define CY_CAPSENSE_LINEARSLIDER0_PTRPOSITION_VALUE                              (cy_capsense_tuner.widgetContext[2].wdTouch.ptrPosition)
#define CY_CAPSENSE_LINEARSLIDER0_PTRPOSITION_OFFSET                             (176u)
#define CY_CAPSENSE_LINEARSLIDER0_PTRPOSITION_SIZE                               (4u)
#define CY_CAPSENSE_LINEARSLIDER0_PTRPOSITION_PARAM_ID                           (0x030200b0u)

#define CY_CAPSENSE_LINEARSLIDER0_NUM_POSITIONS_VALUE                            (cy_capsense_tuner.widgetContext[2].wdTouch.numPosition)
#define CY_CAPSENSE_LINEARSLIDER0_NUM_POSITIONS_OFFSET                           (180u)
#define CY_CAPSENSE_LINEARSLIDER0_NUM_POSITIONS_SIZE                             (1u)
#define CY_CAPSENSE_LINEARSLIDER0_NUM_POSITIONS_PARAM_ID                         (0x010200b4u)

#define CY_CAPSENSE_BUTTON0_RX0_RAW0_VALUE                                       (cy_capsense_tuner.sensorContext[0].raw)
#define CY_CAPSENSE_BUTTON0_RX0_RAW0_OFFSET                                      (184u)
#define CY_CAPSENSE_BUTTON0_RX0_RAW0_SIZE                                        (2u)
#define CY_CAPSENSE_BUTTON0_RX0_RAW0_PARAM_ID                                    (0x020000b8u)

#define CY_CAPSENSE_BUTTON0_RX0_BSLN0_VALUE                                      (cy_capsense_tuner.sensorContext[0].bsln)
#define CY_CAPSENSE_BUTTON0_RX0_BSLN0_OFFSET                                     (186u)
#define CY_CAPSENSE_BUTTON0_RX0_BSLN0_SIZE                                       (2u)
#define CY_CAPSENSE_BUTTON0_RX0_BSLN0_PARAM_ID                                   (0x020000bau)

#define CY_CAPSENSE_BUTTON0_RX0_DIFF0_VALUE                                      (cy_capsense_tuner.sensorContext[0].diff)
#define CY_CAPSENSE_BUTTON0_RX0_DIFF0_OFFSET                                     (188u)
#define CY_CAPSENSE_BUTTON0_RX0_DIFF0_SIZE                                       (2u)
#define CY_CAPSENSE_BUTTON0_RX0_DIFF0_PARAM_ID                                   (0x020000bcu)

#define CY_CAPSENSE_BUTTON0_RX0_STATUS0_VALUE                                    (cy_capsense_tuner.sensorContext[0].status)
#define CY_CAPSENSE_BUTTON0_RX0_STATUS0_OFFSET                                   (190u)
#define CY_CAPSENSE_BUTTON0_RX0_STATUS0_SIZE                                     (1u)
#define CY_CAPSENSE_BUTTON0_RX0_STATUS0_PARAM_ID                                 (0x010000beu)

#define CY_CAPSENSE_BUTTON0_RX0_NEG_BSLN_RST_CNT0_VALUE                          (cy_capsense_tuner.sensorContext[0].negBslnRstCnt)
#define CY_CAPSENSE_BUTTON0_RX0_NEG_BSLN_RST_CNT0_OFFSET                         (191u)
#define CY_CAPSENSE_BUTTON0_RX0_NEG_BSLN_RST_CNT0_SIZE                           (1u)
#define CY_CAPSENSE_BUTTON0_RX0_NEG_BSLN_RST_CNT0_PARAM_ID                       (0x010000bfu)

#define CY_CAPSENSE_BUTTON0_RX0_IDAC0_VALUE                                      (cy_capsense_tuner.sensorContext[0].idacComp)
#define CY_CAPSENSE_BUTTON0_RX0_IDAC0_OFFSET                                     (192u)
#define CY_CAPSENSE_BUTTON0_RX0_IDAC0_SIZE                                       (1u)
#define CY_CAPSENSE_BUTTON0_RX0_IDAC0_PARAM_ID                                   (0x010000c0u)

#define CY_CAPSENSE_BUTTON0_RX0_BSLN_EXT0_VALUE                                  (cy_capsense_tuner.sensorContext[0].bslnExt)
#define CY_CAPSENSE_BUTTON0_RX0_BSLN_EXT0_OFFSET                                 (193u)
#define CY_CAPSENSE_BUTTON0_RX0_BSLN_EXT0_SIZE                                   (1u)
#define CY_CAPSENSE_BUTTON0_RX0_BSLN_EXT0_PARAM_ID                               (0x010000c1u)

#define CY_CAPSENSE_BUTTON1_RX0_RAW0_VALUE                                       (cy_capsense_tuner.sensorContext[1].raw)
#define CY_CAPSENSE_BUTTON1_RX0_RAW0_OFFSET                                      (194u)
#define CY_CAPSENSE_BUTTON1_RX0_RAW0_SIZE                                        (2u)
#define CY_CAPSENSE_BUTTON1_RX0_RAW0_PARAM_ID                                    (0x020100c2u)

#define CY_CAPSENSE_BUTTON1_RX0_BSLN0_VALUE                                      (cy_capsense_tuner.sensorContext[1].bsln)
#define CY_CAPSENSE_BUTTON1_RX0_BSLN0_OFFSET                                     (196u)
#define CY_CAPSENSE_BUTTON1_RX0_BSLN0_SIZE                                       (2u)
#define CY_CAPSENSE_BUTTON1_RX0_BSLN0_PARAM_ID                                   (0x020100c4u)

#define CY_CAPSENSE_BUTTON1_RX0_DIFF0_VALUE                                      (cy_capsense_tuner.sensorContext[1].diff)
#define CY_CAPSENSE_BUTTON1_RX0_DIFF0_OFFSET                                     (198u)
#define CY_CAPSENSE_BUTTON1_RX0_DIFF0_SIZE                                       (2u)
#define CY_CAPSENSE_BUTTON1_RX0_DIFF0_PARAM_ID                                   (0x020100c6u)

#define CY_CAPSENSE_BUTTON1_RX0_STATUS0_VALUE                                    (cy_capsense_tuner.sensorContext[1].status)
#define CY_CAPSENSE_BUTTON1_RX0_STATUS0_OFFSET                                   (200u)
#define CY_CAPSENSE_BUTTON1_RX0_STATUS0_SIZE                                     (1u)
#define CY_CAPSENSE_BUTTON1_RX0_STATUS0_PARAM_ID                                 (0x010100c8u)

#define CY_CAPSENSE_BUTTON1_RX0_NEG_BSLN_RST_CNT0_VALUE                          (cy_capsense_tuner.sensorContext[1].negBslnRstCnt)
#define CY_CAPSENSE_BUTTON1_RX0_NEG_BSLN_RST_CNT0_OFFSET                         (201u)
#define CY_CAPSENSE_BUTTON1_RX0_NEG_BSLN_RST_CNT0_SIZE                           (1u)
#define CY_CAPSENSE_BUTTON1_RX0_NEG_BSLN_RST_CNT0_PARAM_ID                       (0x010100c9u)

#define CY_CAPSENSE_BUTTON1_RX0_IDAC0_VALUE                                      (cy_capsense_tuner.sensorContext[1].idacComp)
#define CY_CAPSENSE_BUTTON1_RX0_IDAC0_OFFSET                                     (202u)
#define CY_CAPSENSE_BUTTON1_RX0_IDAC0_SIZE                                       (1u)
#define CY_CAPSENSE_BUTTON1_RX0_IDAC0_PARAM_ID                                   (0x010100cau)

#define CY_CAPSENSE_BUTTON1_RX0_BSLN_EXT0_VALUE                                  (cy_capsense_tuner.sensorContext[1].bslnExt)
#define CY_CAPSENSE_BUTTON1_RX0_BSLN_EXT0_OFFSET                                 (203u)
#define CY_CAPSENSE_BUTTON1_RX0_BSLN_EXT0_SIZE                                   (1u)
#define CY_CAPSENSE_BUTTON1_RX0_BSLN_EXT0_PARAM_ID                               (0x010100cbu)

#define CY_CAPSENSE_LINEARSLIDER0_SNS0_RAW0_VALUE                                (cy_capsense_tuner.sensorContext[2].raw)
#define CY_CAPSENSE_LINEARSLIDER0_SNS0_RAW0_OFFSET                               (204u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS0_RAW0_SIZE                                 (2u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS0_RAW0_PARAM_ID                             (0x020200ccu)

#define CY_CAPSENSE_LINEARSLIDER0_SNS0_BSLN0_VALUE                               (cy_capsense_tuner.sensorContext[2].bsln)
#define CY_CAPSENSE_LINEARSLIDER0_SNS0_BSLN0_OFFSET                              (206u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS0_BSLN0_SIZE                                (2u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS0_BSLN0_PARAM_ID                            (0x020200ceu)

#define CY_CAPSENSE_LINEARSLIDER0_SNS0_DIFF0_VALUE                               (cy_capsense_tuner.sensorContext[2].diff)
#define CY_CAPSENSE_LINEARSLIDER0_SNS0_DIFF0_OFFSET                              (208u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS0_DIFF0_SIZE                                (2u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS0_DIFF0_PARAM_ID                            (0x020200d0u)

#define CY_CAPSENSE_LINEARSLIDER0_SNS0_STATUS0_VALUE                             (cy_capsense_tuner.sensorContext[2].status)
#define CY_CAPSENSE_LINEARSLIDER0_SNS0_STATUS0_OFFSET                            (210u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS0_STATUS0_SIZE                              (1u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS0_STATUS0_PARAM_ID                          (0x010200d2u)

#define CY_CAPSENSE_LINEARSLIDER0_SNS0_NEG_BSLN_RST_CNT0_VALUE                   (cy_capsense_tuner.sensorContext[2].negBslnRstCnt)
#define CY_CAPSENSE_LINEARSLIDER0_SNS0_NEG_BSLN_RST_CNT0_OFFSET                  (211u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS0_NEG_BSLN_RST_CNT0_SIZE                    (1u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS0_NEG_BSLN_RST_CNT0_PARAM_ID                (0x010200d3u)

#define CY_CAPSENSE_LINEARSLIDER0_SNS0_IDAC0_VALUE                               (cy_capsense_tuner.sensorContext[2].idacComp)
#define CY_CAPSENSE_LINEARSLIDER0_SNS0_IDAC0_OFFSET                              (212u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS0_IDAC0_SIZE                                (1u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS0_IDAC0_PARAM_ID                            (0x010200d4u)

#define CY_CAPSENSE_LINEARSLIDER0_SNS0_BSLN_EXT0_VALUE                           (cy_capsense_tuner.sensorContext[2].bslnExt)
#define CY_CAPSENSE_LINEARSLIDER0_SNS0_BSLN_EXT0_OFFSET                          (213u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS0_BSLN_EXT0_SIZE                            (1u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS0_BSLN_EXT0_PARAM_ID                        (0x010200d5u)

#define CY_CAPSENSE_LINEARSLIDER0_SNS1_RAW0_VALUE                                (cy_capsense_tuner.sensorContext[3].raw)
#define CY_CAPSENSE_LINEARSLIDER0_SNS1_RAW0_OFFSET                               (214u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS1_RAW0_SIZE                                 (2u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS1_RAW0_PARAM_ID                             (0x020200d6u)

#define CY_CAPSENSE_LINEARSLIDER0_SNS1_BSLN0_VALUE                               (cy_capsense_tuner.sensorContext[3].bsln)
#define CY_CAPSENSE_LINEARSLIDER0_SNS1_BSLN0_OFFSET                              (216u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS1_BSLN0_SIZE                                (2u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS1_BSLN0_PARAM_ID                            (0x020200d8u)

#define CY_CAPSENSE_LINEARSLIDER0_SNS1_DIFF0_VALUE                               (cy_capsense_tuner.sensorContext[3].diff)
#define CY_CAPSENSE_LINEARSLIDER0_SNS1_DIFF0_OFFSET                              (218u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS1_DIFF0_SIZE                                (2u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS1_DIFF0_PARAM_ID                            (0x020200dau)

#define CY_CAPSENSE_LINEARSLIDER0_SNS1_STATUS0_VALUE                             (cy_capsense_tuner.sensorContext[3].status)
#define CY_CAPSENSE_LINEARSLIDER0_SNS1_STATUS0_OFFSET                            (220u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS1_STATUS0_SIZE                              (1u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS1_STATUS0_PARAM_ID                          (0x010200dcu)

#define CY_CAPSENSE_LINEARSLIDER0_SNS1_NEG_BSLN_RST_CNT0_VALUE                   (cy_capsense_tuner.sensorContext[3].negBslnRstCnt)
#define CY_CAPSENSE_LINEARSLIDER0_SNS1_NEG_BSLN_RST_CNT0_OFFSET                  (221u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS1_NEG_BSLN_RST_CNT0_SIZE                    (1u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS1_NEG_BSLN_RST_CNT0_PARAM_ID                (0x010200ddu)

#define CY_CAPSENSE_LINEARSLIDER0_SNS1_IDAC0_VALUE                               (cy_capsense_tuner.sensorContext[3].idacComp)
#define CY_CAPSENSE_LINEARSLIDER0_SNS1_IDAC0_OFFSET                              (222u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS1_IDAC0_SIZE                                (1u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS1_IDAC0_PARAM_ID                            (0x010200deu)

#define CY_CAPSENSE_LINEARSLIDER0_SNS1_BSLN_EXT0_VALUE                           (cy_capsense_tuner.sensorContext[3].bslnExt)
#define CY_CAPSENSE_LINEARSLIDER0_SNS1_BSLN_EXT0_OFFSET                          (223u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS1_BSLN_EXT0_SIZE                            (1u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS1_BSLN_EXT0_PARAM_ID                        (0x010200dfu)

#define CY_CAPSENSE_LINEARSLIDER0_SNS2_RAW0_VALUE                                (cy_capsense_tuner.sensorContext[4].raw)
#define CY_CAPSENSE_LINEARSLIDER0_SNS2_RAW0_OFFSET                               (224u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS2_RAW0_SIZE                                 (2u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS2_RAW0_PARAM_ID                             (0x020200e0u)

#define CY_CAPSENSE_LINEARSLIDER0_SNS2_BSLN0_VALUE                               (cy_capsense_tuner.sensorContext[4].bsln)
#define CY_CAPSENSE_LINEARSLIDER0_SNS2_BSLN0_OFFSET                              (226u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS2_BSLN0_SIZE                                (2u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS2_BSLN0_PARAM_ID                            (0x020200e2u)

#define CY_CAPSENSE_LINEARSLIDER0_SNS2_DIFF0_VALUE                               (cy_capsense_tuner.sensorContext[4].diff)
#define CY_CAPSENSE_LINEARSLIDER0_SNS2_DIFF0_OFFSET                              (228u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS2_DIFF0_SIZE                                (2u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS2_DIFF0_PARAM_ID                            (0x020200e4u)

#define CY_CAPSENSE_LINEARSLIDER0_SNS2_STATUS0_VALUE                             (cy_capsense_tuner.sensorContext[4].status)
#define CY_CAPSENSE_LINEARSLIDER0_SNS2_STATUS0_OFFSET                            (230u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS2_STATUS0_SIZE                              (1u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS2_STATUS0_PARAM_ID                          (0x010200e6u)

#define CY_CAPSENSE_LINEARSLIDER0_SNS2_NEG_BSLN_RST_CNT0_VALUE                   (cy_capsense_tuner.sensorContext[4].negBslnRstCnt)
#define CY_CAPSENSE_LINEARSLIDER0_SNS2_NEG_BSLN_RST_CNT0_OFFSET                  (231u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS2_NEG_BSLN_RST_CNT0_SIZE                    (1u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS2_NEG_BSLN_RST_CNT0_PARAM_ID                (0x010200e7u)

#define CY_CAPSENSE_LINEARSLIDER0_SNS2_IDAC0_VALUE                               (cy_capsense_tuner.sensorContext[4].idacComp)
#define CY_CAPSENSE_LINEARSLIDER0_SNS2_IDAC0_OFFSET                              (232u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS2_IDAC0_SIZE                                (1u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS2_IDAC0_PARAM_ID                            (0x010200e8u)

#define CY_CAPSENSE_LINEARSLIDER0_SNS2_BSLN_EXT0_VALUE                           (cy_capsense_tuner.sensorContext[4].bslnExt)
#define CY_CAPSENSE_LINEARSLIDER0_SNS2_BSLN_EXT0_OFFSET                          (233u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS2_BSLN_EXT0_SIZE                            (1u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS2_BSLN_EXT0_PARAM_ID                        (0x010200e9u)

#define CY_CAPSENSE_LINEARSLIDER0_SNS3_RAW0_VALUE                                (cy_capsense_tuner.sensorContext[5].raw)
#define CY_CAPSENSE_LINEARSLIDER0_SNS3_RAW0_OFFSET                               (234u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS3_RAW0_SIZE                                 (2u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS3_RAW0_PARAM_ID                             (0x020200eau)

#define CY_CAPSENSE_LINEARSLIDER0_SNS3_BSLN0_VALUE                               (cy_capsense_tuner.sensorContext[5].bsln)
#define CY_CAPSENSE_LINEARSLIDER0_SNS3_BSLN0_OFFSET                              (236u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS3_BSLN0_SIZE                                (2u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS3_BSLN0_PARAM_ID                            (0x020200ecu)

#define CY_CAPSENSE_LINEARSLIDER0_SNS3_DIFF0_VALUE                               (cy_capsense_tuner.sensorContext[5].diff)
#define CY_CAPSENSE_LINEARSLIDER0_SNS3_DIFF0_OFFSET                              (238u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS3_DIFF0_SIZE                                (2u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS3_DIFF0_PARAM_ID                            (0x020200eeu)

#define CY_CAPSENSE_LINEARSLIDER0_SNS3_STATUS0_VALUE                             (cy_capsense_tuner.sensorContext[5].status)
#define CY_CAPSENSE_LINEARSLIDER0_SNS3_STATUS0_OFFSET                            (240u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS3_STATUS0_SIZE                              (1u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS3_STATUS0_PARAM_ID                          (0x010200f0u)

#define CY_CAPSENSE_LINEARSLIDER0_SNS3_NEG_BSLN_RST_CNT0_VALUE                   (cy_capsense_tuner.sensorContext[5].negBslnRstCnt)
#define CY_CAPSENSE_LINEARSLIDER0_SNS3_NEG_BSLN_RST_CNT0_OFFSET                  (241u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS3_NEG_BSLN_RST_CNT0_SIZE                    (1u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS3_NEG_BSLN_RST_CNT0_PARAM_ID                (0x010200f1u)

#define CY_CAPSENSE_LINEARSLIDER0_SNS3_IDAC0_VALUE                               (cy_capsense_tuner.sensorContext[5].idacComp)
#define CY_CAPSENSE_LINEARSLIDER0_SNS3_IDAC0_OFFSET                              (242u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS3_IDAC0_SIZE                                (1u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS3_IDAC0_PARAM_ID                            (0x010200f2u)

#define CY_CAPSENSE_LINEARSLIDER0_SNS3_BSLN_EXT0_VALUE                           (cy_capsense_tuner.sensorContext[5].bslnExt)
#define CY_CAPSENSE_LINEARSLIDER0_SNS3_BSLN_EXT0_OFFSET                          (243u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS3_BSLN_EXT0_SIZE                            (1u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS3_BSLN_EXT0_PARAM_ID                        (0x010200f3u)

#define CY_CAPSENSE_LINEARSLIDER0_SNS4_RAW0_VALUE                                (cy_capsense_tuner.sensorContext[6].raw)
#define CY_CAPSENSE_LINEARSLIDER0_SNS4_RAW0_OFFSET                               (244u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS4_RAW0_SIZE                                 (2u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS4_RAW0_PARAM_ID                             (0x020200f4u)

#define CY_CAPSENSE_LINEARSLIDER0_SNS4_BSLN0_VALUE                               (cy_capsense_tuner.sensorContext[6].bsln)
#define CY_CAPSENSE_LINEARSLIDER0_SNS4_BSLN0_OFFSET                              (246u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS4_BSLN0_SIZE                                (2u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS4_BSLN0_PARAM_ID                            (0x020200f6u)

#define CY_CAPSENSE_LINEARSLIDER0_SNS4_DIFF0_VALUE                               (cy_capsense_tuner.sensorContext[6].diff)
#define CY_CAPSENSE_LINEARSLIDER0_SNS4_DIFF0_OFFSET                              (248u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS4_DIFF0_SIZE                                (2u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS4_DIFF0_PARAM_ID                            (0x020200f8u)

#define CY_CAPSENSE_LINEARSLIDER0_SNS4_STATUS0_VALUE                             (cy_capsense_tuner.sensorContext[6].status)
#define CY_CAPSENSE_LINEARSLIDER0_SNS4_STATUS0_OFFSET                            (250u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS4_STATUS0_SIZE                              (1u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS4_STATUS0_PARAM_ID                          (0x010200fau)

#define CY_CAPSENSE_LINEARSLIDER0_SNS4_NEG_BSLN_RST_CNT0_VALUE                   (cy_capsense_tuner.sensorContext[6].negBslnRstCnt)
#define CY_CAPSENSE_LINEARSLIDER0_SNS4_NEG_BSLN_RST_CNT0_OFFSET                  (251u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS4_NEG_BSLN_RST_CNT0_SIZE                    (1u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS4_NEG_BSLN_RST_CNT0_PARAM_ID                (0x010200fbu)

#define CY_CAPSENSE_LINEARSLIDER0_SNS4_IDAC0_VALUE                               (cy_capsense_tuner.sensorContext[6].idacComp)
#define CY_CAPSENSE_LINEARSLIDER0_SNS4_IDAC0_OFFSET                              (252u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS4_IDAC0_SIZE                                (1u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS4_IDAC0_PARAM_ID                            (0x010200fcu)

#define CY_CAPSENSE_LINEARSLIDER0_SNS4_BSLN_EXT0_VALUE                           (cy_capsense_tuner.sensorContext[6].bslnExt)
#define CY_CAPSENSE_LINEARSLIDER0_SNS4_BSLN_EXT0_OFFSET                          (253u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS4_BSLN_EXT0_SIZE                            (1u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS4_BSLN_EXT0_PARAM_ID                        (0x010200fdu)

#define CY_CAPSENSE_LINEARSLIDER0_X0_VALUE                                       (cy_capsense_tuner.position[0].x)
#define CY_CAPSENSE_LINEARSLIDER0_X0_OFFSET                                      (254u)
#define CY_CAPSENSE_LINEARSLIDER0_X0_SIZE                                        (2u)
#define CY_CAPSENSE_LINEARSLIDER0_X0_PARAM_ID                                    (0x020200feu)

#define CY_CAPSENSE_LINEARSLIDER0_Y0_VALUE                                       (cy_capsense_tuner.position[0].y)
#define CY_CAPSENSE_LINEARSLIDER0_Y0_OFFSET                                      (256u)
#define CY_CAPSENSE_LINEARSLIDER0_Y0_SIZE                                        (2u)
#define CY_CAPSENSE_LINEARSLIDER0_Y0_PARAM_ID                                    (0x02020100u)

#define CY_CAPSENSE_LINEARSLIDER0_Z0_VALUE                                       (cy_capsense_tuner.position[0].z)
#define CY_CAPSENSE_LINEARSLIDER0_Z0_OFFSET                                      (258u)
#define CY_CAPSENSE_LINEARSLIDER0_Z0_SIZE                                        (2u)
#define CY_CAPSENSE_LINEARSLIDER0_Z0_PARAM_ID                                    (0x02020102u)

#define CY_CAPSENSE_LINEARSLIDER0_ID0_VALUE                                      (cy_capsense_tuner.position[0].id)
#define CY_CAPSENSE_LINEARSLIDER0_ID0_OFFSET                                     (260u)
#define CY_CAPSENSE_LINEARSLIDER0_ID0_SIZE                                       (2u)
#define CY_CAPSENSE_LINEARSLIDER0_ID0_PARAM_ID                                   (0x02020104u)

#elif (CY_CAPSENSE_MW_VERSION < 400)
#define CY_CAPSENSE_CONFIG_ID_VALUE                                              (cy_capsense_tuner.commonContext.configId)
#define CY_CAPSENSE_CONFIG_ID_OFFSET                                             (0u)
#define CY_CAPSENSE_CONFIG_ID_SIZE                                               (2u)
#define CY_CAPSENSE_CONFIG_ID_PARAM_ID                                           (0x02000000u)

#define CY_CAPSENSE_TUNER_CMD_VALUE                                              (cy_capsense_tuner.commonContext.tunerCmd)
#define CY_CAPSENSE_TUNER_CMD_OFFSET                                             (2u)
#define CY_CAPSENSE_TUNER_CMD_SIZE                                               (2u)
#define CY_CAPSENSE_TUNER_CMD_PARAM_ID                                           (0x02000002u)

#define CY_CAPSENSE_SCAN_COUNTER_VALUE                                           (cy_capsense_tuner.commonContext.scanCounter)
#define CY_CAPSENSE_SCAN_COUNTER_OFFSET                                          (4u)
#define CY_CAPSENSE_SCAN_COUNTER_SIZE                                            (2u)
#define CY_CAPSENSE_SCAN_COUNTER_PARAM_ID                                        (0x02000004u)

#define CY_CAPSENSE_TUNER_ST_VALUE                                               (cy_capsense_tuner.commonContext.tunerSt)
#define CY_CAPSENSE_TUNER_ST_OFFSET                                              (6u)
#define CY_CAPSENSE_TUNER_ST_SIZE                                                (1u)
#define CY_CAPSENSE_TUNER_ST_PARAM_ID                                            (0x01000006u)

#define CY_CAPSENSE_INITDONE_VALUE                                               (cy_capsense_tuner.commonContext.initDone)
#define CY_CAPSENSE_INITDONE_OFFSET                                              (7u)
#define CY_CAPSENSE_INITDONE_SIZE                                                (1u)
#define CY_CAPSENSE_INITDONE_PARAM_ID                                            (0x01000007u)

#define CY_CAPSENSE_STATUS_VALUE                                                 (cy_capsense_tuner.commonContext.status)
#define CY_CAPSENSE_STATUS_OFFSET                                                (8u)
#define CY_CAPSENSE_STATUS_SIZE                                                  (4u)
#define CY_CAPSENSE_STATUS_PARAM_ID                                              (0x03000008u)

#define CY_CAPSENSE_TIMESTAMPINTERVAL_VALUE                                      (cy_capsense_tuner.commonContext.timestampInterval)
#define CY_CAPSENSE_TIMESTAMPINTERVAL_OFFSET                                     (12u)
#define CY_CAPSENSE_TIMESTAMPINTERVAL_SIZE                                       (4u)
#define CY_CAPSENSE_TIMESTAMPINTERVAL_PARAM_ID                                   (0x0300000cu)

#define CY_CAPSENSE_TIMESTAMP_VALUE                                              (cy_capsense_tuner.commonContext.timestamp)
#define CY_CAPSENSE_TIMESTAMP_OFFSET                                             (16u)
#define CY_CAPSENSE_TIMESTAMP_SIZE                                               (4u)
#define CY_CAPSENSE_TIMESTAMP_PARAM_ID                                           (0x03000010u)

#define CY_CAPSENSE_CSD_MOD_CLK_DIVIDER_VALUE                                    (cy_capsense_tuner.commonContext.modCsdClk)
#define CY_CAPSENSE_CSD_MOD_CLK_DIVIDER_OFFSET                                   (20u)
#define CY_CAPSENSE_CSD_MOD_CLK_DIVIDER_SIZE                                     (1u)
#define CY_CAPSENSE_CSD_MOD_CLK_DIVIDER_PARAM_ID                                 (0x01000014u)

#define CY_CAPSENSE_CSX_MOD_CLK_DIVIDER_VALUE                                    (cy_capsense_tuner.commonContext.modCsxClk)
#define CY_CAPSENSE_CSX_MOD_CLK_DIVIDER_OFFSET                                   (21u)
#define CY_CAPSENSE_CSX_MOD_CLK_DIVIDER_SIZE                                     (1u)
#define CY_CAPSENSE_CSX_MOD_CLK_DIVIDER_PARAM_ID                                 (0x01000015u)

#define CY_CAPSENSE_TUNER_CNT_VALUE                                              (cy_capsense_tuner.commonContext.tunerCnt)
#define CY_CAPSENSE_TUNER_CNT_OFFSET                                             (22u)
#define CY_CAPSENSE_TUNER_CNT_SIZE                                               (1u)
#define CY_CAPSENSE_TUNER_CNT_PARAM_ID                                           (0x01000016u)

#define CY_CAPSENSE_BUTTON0_FINGER_CP_VALUE                                      (cy_capsense_tuner.widgetContext[0].fingerCap)
#define CY_CAPSENSE_BUTTON0_FINGER_CP_OFFSET                                     (24u)
#define CY_CAPSENSE_BUTTON0_FINGER_CP_SIZE                                       (2u)
#define CY_CAPSENSE_BUTTON0_FINGER_CP_PARAM_ID                                   (0x06000018u)

#define CY_CAPSENSE_BUTTON0_SIGPFC_VALUE                                         (cy_capsense_tuner.widgetContext[0].sigPFC)
#define CY_CAPSENSE_BUTTON0_SIGPFC_OFFSET                                        (26u)
#define CY_CAPSENSE_BUTTON0_SIGPFC_SIZE                                          (2u)
#define CY_CAPSENSE_BUTTON0_SIGPFC_PARAM_ID                                      (0x0600001au)

#define CY_CAPSENSE_BUTTON0_NUM_CONV_VALUE                                       (cy_capsense_tuner.widgetContext[0].resolution)
#define CY_CAPSENSE_BUTTON0_NUM_CONV_OFFSET                                      (28u)
#define CY_CAPSENSE_BUTTON0_NUM_CONV_SIZE                                        (2u)
#define CY_CAPSENSE_BUTTON0_NUM_CONV_PARAM_ID                                    (0x0600001cu)

#define CY_CAPSENSE_BUTTON0_MAX_RAW_COUNT_VALUE                                  (cy_capsense_tuner.widgetContext[0].maxRawCount)
#define CY_CAPSENSE_BUTTON0_MAX_RAW_COUNT_OFFSET                                 (30u)
#define CY_CAPSENSE_BUTTON0_MAX_RAW_COUNT_SIZE                                   (2u)
#define CY_CAPSENSE_BUTTON0_MAX_RAW_COUNT_PARAM_ID                               (0x0600001eu)

#define CY_CAPSENSE_BUTTON0_ROW_MAX_RAW_COUNT_VALUE                              (cy_capsense_tuner.widgetContext[0].maxRawCountRow)
#define CY_CAPSENSE_BUTTON0_ROW_MAX_RAW_COUNT_OFFSET                             (32u)
#define CY_CAPSENSE_BUTTON0_ROW_MAX_RAW_COUNT_SIZE                               (2u)
#define CY_CAPSENSE_BUTTON0_ROW_MAX_RAW_COUNT_PARAM_ID                           (0x06000020u)

#define CY_CAPSENSE_BUTTON0_FINGER_TH_VALUE                                      (cy_capsense_tuner.widgetContext[0].fingerTh)
#define CY_CAPSENSE_BUTTON0_FINGER_TH_OFFSET                                     (34u)
#define CY_CAPSENSE_BUTTON0_FINGER_TH_SIZE                                       (2u)
#define CY_CAPSENSE_BUTTON0_FINGER_TH_PARAM_ID                                   (0x06000022u)

#define CY_CAPSENSE_BUTTON0_PROX_TOUCH_TH_VALUE                                  (cy_capsense_tuner.widgetContext[0].proxTh)
#define CY_CAPSENSE_BUTTON0_PROX_TOUCH_TH_OFFSET                                 (36u)
#define CY_CAPSENSE_BUTTON0_PROX_TOUCH_TH_SIZE                                   (2u)
#define CY_CAPSENSE_BUTTON0_PROX_TOUCH_TH_PARAM_ID                               (0x06000024u)

#define CY_CAPSENSE_BUTTON0_LOW_BSLN_RST_VALUE                                   (cy_capsense_tuner.widgetContext[0].lowBslnRst)
#define CY_CAPSENSE_BUTTON0_LOW_BSLN_RST_OFFSET                                  (38u)
#define CY_CAPSENSE_BUTTON0_LOW_BSLN_RST_SIZE                                    (2u)
#define CY_CAPSENSE_BUTTON0_LOW_BSLN_RST_PARAM_ID                                (0x06000026u)

#define CY_CAPSENSE_BUTTON0_TX_CLK_VALUE                                         (cy_capsense_tuner.widgetContext[0].snsClk)
#define CY_CAPSENSE_BUTTON0_TX_CLK_OFFSET                                        (40u)
#define CY_CAPSENSE_BUTTON0_TX_CLK_SIZE                                          (2u)
#define CY_CAPSENSE_BUTTON0_TX_CLK_PARAM_ID                                      (0x06000028u)

#define CY_CAPSENSE_BUTTON0_ROW_SNS_CLK_VALUE                                    (cy_capsense_tuner.widgetContext[0].rowSnsClk)
#define CY_CAPSENSE_BUTTON0_ROW_SNS_CLK_OFFSET                                   (42u)
#define CY_CAPSENSE_BUTTON0_ROW_SNS_CLK_SIZE                                     (2u)
#define CY_CAPSENSE_BUTTON0_ROW_SNS_CLK_PARAM_ID                                 (0x0600002au)

#define CY_CAPSENSE_BUTTON0_GESTURE_DETECTED_VALUE                               (cy_capsense_tuner.widgetContext[0].gestureDetected)
#define CY_CAPSENSE_BUTTON0_GESTURE_DETECTED_OFFSET                              (44u)
#define CY_CAPSENSE_BUTTON0_GESTURE_DETECTED_SIZE                                (2u)
#define CY_CAPSENSE_BUTTON0_GESTURE_DETECTED_PARAM_ID                            (0x0200002cu)

#define CY_CAPSENSE_BUTTON0_GESTURE_DIRECTION_VALUE                              (cy_capsense_tuner.widgetContext[0].gestureDirection)
#define CY_CAPSENSE_BUTTON0_GESTURE_DIRECTION_OFFSET                             (46u)
#define CY_CAPSENSE_BUTTON0_GESTURE_DIRECTION_SIZE                               (2u)
#define CY_CAPSENSE_BUTTON0_GESTURE_DIRECTION_PARAM_ID                           (0x0200002eu)

#define CY_CAPSENSE_BUTTON0_XDELTA_VALUE                                         (cy_capsense_tuner.widgetContext[0].xDelta)
#define CY_CAPSENSE_BUTTON0_XDELTA_OFFSET                                        (48u)
#define CY_CAPSENSE_BUTTON0_XDELTA_SIZE                                          (2u)
#define CY_CAPSENSE_BUTTON0_XDELTA_PARAM_ID                                      (0x02000030u)

#define CY_CAPSENSE_BUTTON0_YDELTA_VALUE                                         (cy_capsense_tuner.widgetContext[0].yDelta)
#define CY_CAPSENSE_BUTTON0_YDELTA_OFFSET                                        (50u)
#define CY_CAPSENSE_BUTTON0_YDELTA_SIZE                                          (2u)
#define CY_CAPSENSE_BUTTON0_YDELTA_PARAM_ID                                      (0x02000032u)

#define CY_CAPSENSE_BUTTON0_NOISE_TH_VALUE                                       (cy_capsense_tuner.widgetContext[0].noiseTh)
#define CY_CAPSENSE_BUTTON0_NOISE_TH_OFFSET                                      (52u)
#define CY_CAPSENSE_BUTTON0_NOISE_TH_SIZE                                        (2u)
#define CY_CAPSENSE_BUTTON0_NOISE_TH_PARAM_ID                                    (0x06000034u)

#define CY_CAPSENSE_BUTTON0_NNOISE_TH_VALUE                                      (cy_capsense_tuner.widgetContext[0].nNoiseTh)
#define CY_CAPSENSE_BUTTON0_NNOISE_TH_OFFSET                                     (54u)
#define CY_CAPSENSE_BUTTON0_NNOISE_TH_SIZE                                       (2u)
#define CY_CAPSENSE_BUTTON0_NNOISE_TH_PARAM_ID                                   (0x06000036u)

#define CY_CAPSENSE_BUTTON0_HYSTERESIS_VALUE                                     (cy_capsense_tuner.widgetContext[0].hysteresis)
#define CY_CAPSENSE_BUTTON0_HYSTERESIS_OFFSET                                    (56u)
#define CY_CAPSENSE_BUTTON0_HYSTERESIS_SIZE                                      (2u)
#define CY_CAPSENSE_BUTTON0_HYSTERESIS_PARAM_ID                                  (0x06000038u)

#define CY_CAPSENSE_BUTTON0_ON_DEBOUNCE_VALUE                                    (cy_capsense_tuner.widgetContext[0].onDebounce)
#define CY_CAPSENSE_BUTTON0_ON_DEBOUNCE_OFFSET                                   (58u)
#define CY_CAPSENSE_BUTTON0_ON_DEBOUNCE_SIZE                                     (1u)
#define CY_CAPSENSE_BUTTON0_ON_DEBOUNCE_PARAM_ID                                 (0x0500003au)

#define CY_CAPSENSE_BUTTON0_TX_CLK_SOURCE_VALUE                                  (cy_capsense_tuner.widgetContext[0].snsClkSource)
#define CY_CAPSENSE_BUTTON0_TX_CLK_SOURCE_OFFSET                                 (59u)
#define CY_CAPSENSE_BUTTON0_TX_CLK_SOURCE_SIZE                                   (1u)
#define CY_CAPSENSE_BUTTON0_TX_CLK_SOURCE_PARAM_ID                               (0x0500003bu)

#define CY_CAPSENSE_BUTTON0_IDAC_MOD0_VALUE                                      (cy_capsense_tuner.widgetContext[0].idacMod[0])
#define CY_CAPSENSE_BUTTON0_IDAC_MOD0_OFFSET                                     (60u)
#define CY_CAPSENSE_BUTTON0_IDAC_MOD0_SIZE                                       (1u)
#define CY_CAPSENSE_BUTTON0_IDAC_MOD0_PARAM_ID                                   (0x0500003cu)

#define CY_CAPSENSE_BUTTON0_IDAC_MOD1_VALUE                                      (cy_capsense_tuner.widgetContext[0].idacMod[1])
#define CY_CAPSENSE_BUTTON0_IDAC_MOD1_OFFSET                                     (61u)
#define CY_CAPSENSE_BUTTON0_IDAC_MOD1_SIZE                                       (1u)
#define CY_CAPSENSE_BUTTON0_IDAC_MOD1_PARAM_ID                                   (0x0500003du)

#define CY_CAPSENSE_BUTTON0_IDAC_MOD2_VALUE                                      (cy_capsense_tuner.widgetContext[0].idacMod[2])
#define CY_CAPSENSE_BUTTON0_IDAC_MOD2_OFFSET                                     (62u)
#define CY_CAPSENSE_BUTTON0_IDAC_MOD2_SIZE                                       (1u)
#define CY_CAPSENSE_BUTTON0_IDAC_MOD2_PARAM_ID                                   (0x0500003eu)

#define CY_CAPSENSE_BUTTON0_IDAC_GAIN_INDEX_VALUE                                (cy_capsense_tuner.widgetContext[0].idacGainIndex)
#define CY_CAPSENSE_BUTTON0_IDAC_GAIN_INDEX_OFFSET                               (63u)
#define CY_CAPSENSE_BUTTON0_IDAC_GAIN_INDEX_SIZE                                 (1u)
#define CY_CAPSENSE_BUTTON0_IDAC_GAIN_INDEX_PARAM_ID                             (0x0500003fu)

#define CY_CAPSENSE_BUTTON0_ROW_IDAC_MOD0_VALUE                                  (cy_capsense_tuner.widgetContext[0].rowIdacMod[0])
#define CY_CAPSENSE_BUTTON0_ROW_IDAC_MOD0_OFFSET                                 (64u)
#define CY_CAPSENSE_BUTTON0_ROW_IDAC_MOD0_SIZE                                   (1u)
#define CY_CAPSENSE_BUTTON0_ROW_IDAC_MOD0_PARAM_ID                               (0x05000040u)

#define CY_CAPSENSE_BUTTON0_ROW_IDAC_MOD1_VALUE                                  (cy_capsense_tuner.widgetContext[0].rowIdacMod[1])
#define CY_CAPSENSE_BUTTON0_ROW_IDAC_MOD1_OFFSET                                 (65u)
#define CY_CAPSENSE_BUTTON0_ROW_IDAC_MOD1_SIZE                                   (1u)
#define CY_CAPSENSE_BUTTON0_ROW_IDAC_MOD1_PARAM_ID                               (0x05000041u)

#define CY_CAPSENSE_BUTTON0_ROW_IDAC_MOD2_VALUE                                  (cy_capsense_tuner.widgetContext[0].rowIdacMod[2])
#define CY_CAPSENSE_BUTTON0_ROW_IDAC_MOD2_OFFSET                                 (66u)
#define CY_CAPSENSE_BUTTON0_ROW_IDAC_MOD2_SIZE                                   (1u)
#define CY_CAPSENSE_BUTTON0_ROW_IDAC_MOD2_PARAM_ID                               (0x05000042u)

#define CY_CAPSENSE_BUTTON0_REGULAR_IIR_BL_N_VALUE                               (cy_capsense_tuner.widgetContext[0].bslnCoeff)
#define CY_CAPSENSE_BUTTON0_REGULAR_IIR_BL_N_OFFSET                              (67u)
#define CY_CAPSENSE_BUTTON0_REGULAR_IIR_BL_N_SIZE                                (1u)
#define CY_CAPSENSE_BUTTON0_REGULAR_IIR_BL_N_PARAM_ID                            (0x05000043u)

#define CY_CAPSENSE_BUTTON0_STATUS_VALUE                                         (cy_capsense_tuner.widgetContext[0].status)
#define CY_CAPSENSE_BUTTON0_STATUS_OFFSET                                        (68u)
#define CY_CAPSENSE_BUTTON0_STATUS_SIZE                                          (1u)
#define CY_CAPSENSE_BUTTON0_STATUS_PARAM_ID                                      (0x01000044u)

#define CY_CAPSENSE_BUTTON0_PTRPOSITION_VALUE                                    (cy_capsense_tuner.widgetContext[0].wdTouch.ptrPosition)
#define CY_CAPSENSE_BUTTON0_PTRPOSITION_OFFSET                                   (72u)
#define CY_CAPSENSE_BUTTON0_PTRPOSITION_SIZE                                     (4u)
#define CY_CAPSENSE_BUTTON0_PTRPOSITION_PARAM_ID                                 (0x03000048u)

#define CY_CAPSENSE_BUTTON0_NUM_POSITIONS_VALUE                                  (cy_capsense_tuner.widgetContext[0].wdTouch.numPosition)
#define CY_CAPSENSE_BUTTON0_NUM_POSITIONS_OFFSET                                 (76u)
#define CY_CAPSENSE_BUTTON0_NUM_POSITIONS_SIZE                                   (1u)
#define CY_CAPSENSE_BUTTON0_NUM_POSITIONS_PARAM_ID                               (0x0100004cu)

#define CY_CAPSENSE_BUTTON1_FINGER_CP_VALUE                                      (cy_capsense_tuner.widgetContext[1].fingerCap)
#define CY_CAPSENSE_BUTTON1_FINGER_CP_OFFSET                                     (80u)
#define CY_CAPSENSE_BUTTON1_FINGER_CP_SIZE                                       (2u)
#define CY_CAPSENSE_BUTTON1_FINGER_CP_PARAM_ID                                   (0x06010050u)

#define CY_CAPSENSE_BUTTON1_SIGPFC_VALUE                                         (cy_capsense_tuner.widgetContext[1].sigPFC)
#define CY_CAPSENSE_BUTTON1_SIGPFC_OFFSET                                        (82u)
#define CY_CAPSENSE_BUTTON1_SIGPFC_SIZE                                          (2u)
#define CY_CAPSENSE_BUTTON1_SIGPFC_PARAM_ID                                      (0x06010052u)

#define CY_CAPSENSE_BUTTON1_NUM_CONV_VALUE                                       (cy_capsense_tuner.widgetContext[1].resolution)
#define CY_CAPSENSE_BUTTON1_NUM_CONV_OFFSET                                      (84u)
#define CY_CAPSENSE_BUTTON1_NUM_CONV_SIZE                                        (2u)
#define CY_CAPSENSE_BUTTON1_NUM_CONV_PARAM_ID                                    (0x06010054u)

#define CY_CAPSENSE_BUTTON1_MAX_RAW_COUNT_VALUE                                  (cy_capsense_tuner.widgetContext[1].maxRawCount)
#define CY_CAPSENSE_BUTTON1_MAX_RAW_COUNT_OFFSET                                 (86u)
#define CY_CAPSENSE_BUTTON1_MAX_RAW_COUNT_SIZE                                   (2u)
#define CY_CAPSENSE_BUTTON1_MAX_RAW_COUNT_PARAM_ID                               (0x06010056u)

#define CY_CAPSENSE_BUTTON1_ROW_MAX_RAW_COUNT_VALUE                              (cy_capsense_tuner.widgetContext[1].maxRawCountRow)
#define CY_CAPSENSE_BUTTON1_ROW_MAX_RAW_COUNT_OFFSET                             (88u)
#define CY_CAPSENSE_BUTTON1_ROW_MAX_RAW_COUNT_SIZE                               (2u)
#define CY_CAPSENSE_BUTTON1_ROW_MAX_RAW_COUNT_PARAM_ID                           (0x06010058u)

#define CY_CAPSENSE_BUTTON1_FINGER_TH_VALUE                                      (cy_capsense_tuner.widgetContext[1].fingerTh)
#define CY_CAPSENSE_BUTTON1_FINGER_TH_OFFSET                                     (90u)
#define CY_CAPSENSE_BUTTON1_FINGER_TH_SIZE                                       (2u)
#define CY_CAPSENSE_BUTTON1_FINGER_TH_PARAM_ID                                   (0x0601005au)

#define CY_CAPSENSE_BUTTON1_PROX_TOUCH_TH_VALUE                                  (cy_capsense_tuner.widgetContext[1].proxTh)
#define CY_CAPSENSE_BUTTON1_PROX_TOUCH_TH_OFFSET                                 (92u)
#define CY_CAPSENSE_BUTTON1_PROX_TOUCH_TH_SIZE                                   (2u)
#define CY_CAPSENSE_BUTTON1_PROX_TOUCH_TH_PARAM_ID                               (0x0601005cu)

#define CY_CAPSENSE_BUTTON1_LOW_BSLN_RST_VALUE                                   (cy_capsense_tuner.widgetContext[1].lowBslnRst)
#define CY_CAPSENSE_BUTTON1_LOW_BSLN_RST_OFFSET                                  (94u)
#define CY_CAPSENSE_BUTTON1_LOW_BSLN_RST_SIZE                                    (2u)
#define CY_CAPSENSE_BUTTON1_LOW_BSLN_RST_PARAM_ID                                (0x0601005eu)

#define CY_CAPSENSE_BUTTON1_TX_CLK_VALUE                                         (cy_capsense_tuner.widgetContext[1].snsClk)
#define CY_CAPSENSE_BUTTON1_TX_CLK_OFFSET                                        (96u)
#define CY_CAPSENSE_BUTTON1_TX_CLK_SIZE                                          (2u)
#define CY_CAPSENSE_BUTTON1_TX_CLK_PARAM_ID                                      (0x06010060u)

#define CY_CAPSENSE_BUTTON1_ROW_SNS_CLK_VALUE                                    (cy_capsense_tuner.widgetContext[1].rowSnsClk)
#define CY_CAPSENSE_BUTTON1_ROW_SNS_CLK_OFFSET                                   (98u)
#define CY_CAPSENSE_BUTTON1_ROW_SNS_CLK_SIZE                                     (2u)
#define CY_CAPSENSE_BUTTON1_ROW_SNS_CLK_PARAM_ID                                 (0x06010062u)

#define CY_CAPSENSE_BUTTON1_GESTURE_DETECTED_VALUE                               (cy_capsense_tuner.widgetContext[1].gestureDetected)
#define CY_CAPSENSE_BUTTON1_GESTURE_DETECTED_OFFSET                              (100u)
#define CY_CAPSENSE_BUTTON1_GESTURE_DETECTED_SIZE                                (2u)
#define CY_CAPSENSE_BUTTON1_GESTURE_DETECTED_PARAM_ID                            (0x02010064u)

#define CY_CAPSENSE_BUTTON1_GESTURE_DIRECTION_VALUE                              (cy_capsense_tuner.widgetContext[1].gestureDirection)
#define CY_CAPSENSE_BUTTON1_GESTURE_DIRECTION_OFFSET                             (102u)
#define CY_CAPSENSE_BUTTON1_GESTURE_DIRECTION_SIZE                               (2u)
#define CY_CAPSENSE_BUTTON1_GESTURE_DIRECTION_PARAM_ID                           (0x02010066u)

#define CY_CAPSENSE_BUTTON1_XDELTA_VALUE                                         (cy_capsense_tuner.widgetContext[1].xDelta)
#define CY_CAPSENSE_BUTTON1_XDELTA_OFFSET                                        (104u)
#define CY_CAPSENSE_BUTTON1_XDELTA_SIZE                                          (2u)
#define CY_CAPSENSE_BUTTON1_XDELTA_PARAM_ID                                      (0x02010068u)

#define CY_CAPSENSE_BUTTON1_YDELTA_VALUE                                         (cy_capsense_tuner.widgetContext[1].yDelta)
#define CY_CAPSENSE_BUTTON1_YDELTA_OFFSET                                        (106u)
#define CY_CAPSENSE_BUTTON1_YDELTA_SIZE                                          (2u)
#define CY_CAPSENSE_BUTTON1_YDELTA_PARAM_ID                                      (0x0201006au)

#define CY_CAPSENSE_BUTTON1_NOISE_TH_VALUE                                       (cy_capsense_tuner.widgetContext[1].noiseTh)
#define CY_CAPSENSE_BUTTON1_NOISE_TH_OFFSET                                      (108u)
#define CY_CAPSENSE_BUTTON1_NOISE_TH_SIZE                                        (2u)
#define CY_CAPSENSE_BUTTON1_NOISE_TH_PARAM_ID                                    (0x0601006cu)

#define CY_CAPSENSE_BUTTON1_NNOISE_TH_VALUE                                      (cy_capsense_tuner.widgetContext[1].nNoiseTh)
#define CY_CAPSENSE_BUTTON1_NNOISE_TH_OFFSET                                     (110u)
#define CY_CAPSENSE_BUTTON1_NNOISE_TH_SIZE                                       (2u)
#define CY_CAPSENSE_BUTTON1_NNOISE_TH_PARAM_ID                                   (0x0601006eu)

#define CY_CAPSENSE_BUTTON1_HYSTERESIS_VALUE                                     (cy_capsense_tuner.widgetContext[1].hysteresis)
#define CY_CAPSENSE_BUTTON1_HYSTERESIS_OFFSET                                    (112u)
#define CY_CAPSENSE_BUTTON1_HYSTERESIS_SIZE                                      (2u)
#define CY_CAPSENSE_BUTTON1_HYSTERESIS_PARAM_ID                                  (0x06010070u)

#define CY_CAPSENSE_BUTTON1_ON_DEBOUNCE_VALUE                                    (cy_capsense_tuner.widgetContext[1].onDebounce)
#define CY_CAPSENSE_BUTTON1_ON_DEBOUNCE_OFFSET                                   (114u)
#define CY_CAPSENSE_BUTTON1_ON_DEBOUNCE_SIZE                                     (1u)
#define CY_CAPSENSE_BUTTON1_ON_DEBOUNCE_PARAM_ID                                 (0x05010072u)

#define CY_CAPSENSE_BUTTON1_TX_CLK_SOURCE_VALUE                                  (cy_capsense_tuner.widgetContext[1].snsClkSource)
#define CY_CAPSENSE_BUTTON1_TX_CLK_SOURCE_OFFSET                                 (115u)
#define CY_CAPSENSE_BUTTON1_TX_CLK_SOURCE_SIZE                                   (1u)
#define CY_CAPSENSE_BUTTON1_TX_CLK_SOURCE_PARAM_ID                               (0x05010073u)

#define CY_CAPSENSE_BUTTON1_IDAC_MOD0_VALUE                                      (cy_capsense_tuner.widgetContext[1].idacMod[0])
#define CY_CAPSENSE_BUTTON1_IDAC_MOD0_OFFSET                                     (116u)
#define CY_CAPSENSE_BUTTON1_IDAC_MOD0_SIZE                                       (1u)
#define CY_CAPSENSE_BUTTON1_IDAC_MOD0_PARAM_ID                                   (0x05010074u)

#define CY_CAPSENSE_BUTTON1_IDAC_MOD1_VALUE                                      (cy_capsense_tuner.widgetContext[1].idacMod[1])
#define CY_CAPSENSE_BUTTON1_IDAC_MOD1_OFFSET                                     (117u)
#define CY_CAPSENSE_BUTTON1_IDAC_MOD1_SIZE                                       (1u)
#define CY_CAPSENSE_BUTTON1_IDAC_MOD1_PARAM_ID                                   (0x05010075u)

#define CY_CAPSENSE_BUTTON1_IDAC_MOD2_VALUE                                      (cy_capsense_tuner.widgetContext[1].idacMod[2])
#define CY_CAPSENSE_BUTTON1_IDAC_MOD2_OFFSET                                     (118u)
#define CY_CAPSENSE_BUTTON1_IDAC_MOD2_SIZE                                       (1u)
#define CY_CAPSENSE_BUTTON1_IDAC_MOD2_PARAM_ID                                   (0x05010076u)

#define CY_CAPSENSE_BUTTON1_IDAC_GAIN_INDEX_VALUE                                (cy_capsense_tuner.widgetContext[1].idacGainIndex)
#define CY_CAPSENSE_BUTTON1_IDAC_GAIN_INDEX_OFFSET                               (119u)
#define CY_CAPSENSE_BUTTON1_IDAC_GAIN_INDEX_SIZE                                 (1u)
#define CY_CAPSENSE_BUTTON1_IDAC_GAIN_INDEX_PARAM_ID                             (0x05010077u)

#define CY_CAPSENSE_BUTTON1_ROW_IDAC_MOD0_VALUE                                  (cy_capsense_tuner.widgetContext[1].rowIdacMod[0])
#define CY_CAPSENSE_BUTTON1_ROW_IDAC_MOD0_OFFSET                                 (120u)
#define CY_CAPSENSE_BUTTON1_ROW_IDAC_MOD0_SIZE                                   (1u)
#define CY_CAPSENSE_BUTTON1_ROW_IDAC_MOD0_PARAM_ID                               (0x05010078u)

#define CY_CAPSENSE_BUTTON1_ROW_IDAC_MOD1_VALUE                                  (cy_capsense_tuner.widgetContext[1].rowIdacMod[1])
#define CY_CAPSENSE_BUTTON1_ROW_IDAC_MOD1_OFFSET                                 (121u)
#define CY_CAPSENSE_BUTTON1_ROW_IDAC_MOD1_SIZE                                   (1u)
#define CY_CAPSENSE_BUTTON1_ROW_IDAC_MOD1_PARAM_ID                               (0x05010079u)

#define CY_CAPSENSE_BUTTON1_ROW_IDAC_MOD2_VALUE                                  (cy_capsense_tuner.widgetContext[1].rowIdacMod[2])
#define CY_CAPSENSE_BUTTON1_ROW_IDAC_MOD2_OFFSET                                 (122u)
#define CY_CAPSENSE_BUTTON1_ROW_IDAC_MOD2_SIZE                                   (1u)
#define CY_CAPSENSE_BUTTON1_ROW_IDAC_MOD2_PARAM_ID                               (0x0501007au)

#define CY_CAPSENSE_BUTTON1_REGULAR_IIR_BL_N_VALUE                               (cy_capsense_tuner.widgetContext[1].bslnCoeff)
#define CY_CAPSENSE_BUTTON1_REGULAR_IIR_BL_N_OFFSET                              (123u)
#define CY_CAPSENSE_BUTTON1_REGULAR_IIR_BL_N_SIZE                                (1u)
#define CY_CAPSENSE_BUTTON1_REGULAR_IIR_BL_N_PARAM_ID                            (0x0501007bu)

#define CY_CAPSENSE_BUTTON1_STATUS_VALUE                                         (cy_capsense_tuner.widgetContext[1].status)
#define CY_CAPSENSE_BUTTON1_STATUS_OFFSET                                        (124u)
#define CY_CAPSENSE_BUTTON1_STATUS_SIZE                                          (1u)
#define CY_CAPSENSE_BUTTON1_STATUS_PARAM_ID                                      (0x0101007cu)

#define CY_CAPSENSE_BUTTON1_PTRPOSITION_VALUE                                    (cy_capsense_tuner.widgetContext[1].wdTouch.ptrPosition)
#define CY_CAPSENSE_BUTTON1_PTRPOSITION_OFFSET                                   (128u)
#define CY_CAPSENSE_BUTTON1_PTRPOSITION_SIZE                                     (4u)
#define CY_CAPSENSE_BUTTON1_PTRPOSITION_PARAM_ID                                 (0x03010080u)

#define CY_CAPSENSE_BUTTON1_NUM_POSITIONS_VALUE                                  (cy_capsense_tuner.widgetContext[1].wdTouch.numPosition)
#define CY_CAPSENSE_BUTTON1_NUM_POSITIONS_OFFSET                                 (132u)
#define CY_CAPSENSE_BUTTON1_NUM_POSITIONS_SIZE                                   (1u)
#define CY_CAPSENSE_BUTTON1_NUM_POSITIONS_PARAM_ID                               (0x01010084u)

#define CY_CAPSENSE_LINEARSLIDER0_FINGER_CP_VALUE                                (cy_capsense_tuner.widgetContext[2].fingerCap)
#define CY_CAPSENSE_LINEARSLIDER0_FINGER_CP_OFFSET                               (136u)
#define CY_CAPSENSE_LINEARSLIDER0_FINGER_CP_SIZE                                 (2u)
#define CY_CAPSENSE_LINEARSLIDER0_FINGER_CP_PARAM_ID                             (0x06020088u)

#define CY_CAPSENSE_LINEARSLIDER0_SIGPFC_VALUE                                   (cy_capsense_tuner.widgetContext[2].sigPFC)
#define CY_CAPSENSE_LINEARSLIDER0_SIGPFC_OFFSET                                  (138u)
#define CY_CAPSENSE_LINEARSLIDER0_SIGPFC_SIZE                                    (2u)
#define CY_CAPSENSE_LINEARSLIDER0_SIGPFC_PARAM_ID                                (0x0602008au)

#define CY_CAPSENSE_LINEARSLIDER0_RESOLUTION_VALUE                               (cy_capsense_tuner.widgetContext[2].resolution)
#define CY_CAPSENSE_LINEARSLIDER0_RESOLUTION_OFFSET                              (140u)
#define CY_CAPSENSE_LINEARSLIDER0_RESOLUTION_SIZE                                (2u)
#define CY_CAPSENSE_LINEARSLIDER0_RESOLUTION_PARAM_ID                            (0x0602008cu)

#define CY_CAPSENSE_LINEARSLIDER0_MAX_RAW_COUNT_VALUE                            (cy_capsense_tuner.widgetContext[2].maxRawCount)
#define CY_CAPSENSE_LINEARSLIDER0_MAX_RAW_COUNT_OFFSET                           (142u)
#define CY_CAPSENSE_LINEARSLIDER0_MAX_RAW_COUNT_SIZE                             (2u)
#define CY_CAPSENSE_LINEARSLIDER0_MAX_RAW_COUNT_PARAM_ID                         (0x0602008eu)

#define CY_CAPSENSE_LINEARSLIDER0_ROW_MAX_RAW_COUNT_VALUE                        (cy_capsense_tuner.widgetContext[2].maxRawCountRow)
#define CY_CAPSENSE_LINEARSLIDER0_ROW_MAX_RAW_COUNT_OFFSET                       (144u)
#define CY_CAPSENSE_LINEARSLIDER0_ROW_MAX_RAW_COUNT_SIZE                         (2u)
#define CY_CAPSENSE_LINEARSLIDER0_ROW_MAX_RAW_COUNT_PARAM_ID                     (0x06020090u)

#define CY_CAPSENSE_LINEARSLIDER0_FINGER_TH_VALUE                                (cy_capsense_tuner.widgetContext[2].fingerTh)
#define CY_CAPSENSE_LINEARSLIDER0_FINGER_TH_OFFSET                               (146u)
#define CY_CAPSENSE_LINEARSLIDER0_FINGER_TH_SIZE                                 (2u)
#define CY_CAPSENSE_LINEARSLIDER0_FINGER_TH_PARAM_ID                             (0x02020092u)

#define CY_CAPSENSE_LINEARSLIDER0_PROX_TOUCH_TH_VALUE                            (cy_capsense_tuner.widgetContext[2].proxTh)
#define CY_CAPSENSE_LINEARSLIDER0_PROX_TOUCH_TH_OFFSET                           (148u)
#define CY_CAPSENSE_LINEARSLIDER0_PROX_TOUCH_TH_SIZE                             (2u)
#define CY_CAPSENSE_LINEARSLIDER0_PROX_TOUCH_TH_PARAM_ID                         (0x02020094u)

#define CY_CAPSENSE_LINEARSLIDER0_LOW_BSLN_RST_VALUE                             (cy_capsense_tuner.widgetContext[2].lowBslnRst)
#define CY_CAPSENSE_LINEARSLIDER0_LOW_BSLN_RST_OFFSET                            (150u)
#define CY_CAPSENSE_LINEARSLIDER0_LOW_BSLN_RST_SIZE                              (2u)
#define CY_CAPSENSE_LINEARSLIDER0_LOW_BSLN_RST_PARAM_ID                          (0x06020096u)

#define CY_CAPSENSE_LINEARSLIDER0_SNS_CLK_VALUE                                  (cy_capsense_tuner.widgetContext[2].snsClk)
#define CY_CAPSENSE_LINEARSLIDER0_SNS_CLK_OFFSET                                 (152u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS_CLK_SIZE                                   (2u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS_CLK_PARAM_ID                               (0x06020098u)

#define CY_CAPSENSE_LINEARSLIDER0_ROW_SNS_CLK_VALUE                              (cy_capsense_tuner.widgetContext[2].rowSnsClk)
#define CY_CAPSENSE_LINEARSLIDER0_ROW_SNS_CLK_OFFSET                             (154u)
#define CY_CAPSENSE_LINEARSLIDER0_ROW_SNS_CLK_SIZE                               (2u)
#define CY_CAPSENSE_LINEARSLIDER0_ROW_SNS_CLK_PARAM_ID                           (0x0602009au)

#define CY_CAPSENSE_LINEARSLIDER0_GESTURE_DETECTED_VALUE                         (cy_capsense_tuner.widgetContext[2].gestureDetected)
#define CY_CAPSENSE_LINEARSLIDER0_GESTURE_DETECTED_OFFSET                        (156u)
#define CY_CAPSENSE_LINEARSLIDER0_GESTURE_DETECTED_SIZE                          (2u)
#define CY_CAPSENSE_LINEARSLIDER0_GESTURE_DETECTED_PARAM_ID                      (0x0202009cu)

#define CY_CAPSENSE_LINEARSLIDER0_GESTURE_DIRECTION_VALUE                        (cy_capsense_tuner.widgetContext[2].gestureDirection)
#define CY_CAPSENSE_LINEARSLIDER0_GESTURE_DIRECTION_OFFSET                       (158u)
#define CY_CAPSENSE_LINEARSLIDER0_GESTURE_DIRECTION_SIZE                         (2u)
#define CY_CAPSENSE_LINEARSLIDER0_GESTURE_DIRECTION_PARAM_ID                     (0x0202009eu)

#define CY_CAPSENSE_LINEARSLIDER0_XDELTA_VALUE                                   (cy_capsense_tuner.widgetContext[2].xDelta)
#define CY_CAPSENSE_LINEARSLIDER0_XDELTA_OFFSET                                  (160u)
#define CY_CAPSENSE_LINEARSLIDER0_XDELTA_SIZE                                    (2u)
#define CY_CAPSENSE_LINEARSLIDER0_XDELTA_PARAM_ID                                (0x020200a0u)

#define CY_CAPSENSE_LINEARSLIDER0_YDELTA_VALUE                                   (cy_capsense_tuner.widgetContext[2].yDelta)
#define CY_CAPSENSE_LINEARSLIDER0_YDELTA_OFFSET                                  (162u)
#define CY_CAPSENSE_LINEARSLIDER0_YDELTA_SIZE                                    (2u)
#define CY_CAPSENSE_LINEARSLIDER0_YDELTA_PARAM_ID                                (0x020200a2u)

#define CY_CAPSENSE_LINEARSLIDER0_NOISE_TH_VALUE                                 (cy_capsense_tuner.widgetContext[2].noiseTh)
#define CY_CAPSENSE_LINEARSLIDER0_NOISE_TH_OFFSET                                (164u)
#define CY_CAPSENSE_LINEARSLIDER0_NOISE_TH_SIZE                                  (2u)
#define CY_CAPSENSE_LINEARSLIDER0_NOISE_TH_PARAM_ID                              (0x020200a4u)

#define CY_CAPSENSE_LINEARSLIDER0_NNOISE_TH_VALUE                                (cy_capsense_tuner.widgetContext[2].nNoiseTh)
#define CY_CAPSENSE_LINEARSLIDER0_NNOISE_TH_OFFSET                               (166u)
#define CY_CAPSENSE_LINEARSLIDER0_NNOISE_TH_SIZE                                 (2u)
#define CY_CAPSENSE_LINEARSLIDER0_NNOISE_TH_PARAM_ID                             (0x020200a6u)

#define CY_CAPSENSE_LINEARSLIDER0_HYSTERESIS_VALUE                               (cy_capsense_tuner.widgetContext[2].hysteresis)
#define CY_CAPSENSE_LINEARSLIDER0_HYSTERESIS_OFFSET                              (168u)
#define CY_CAPSENSE_LINEARSLIDER0_HYSTERESIS_SIZE                                (2u)
#define CY_CAPSENSE_LINEARSLIDER0_HYSTERESIS_PARAM_ID                            (0x020200a8u)

#define CY_CAPSENSE_LINEARSLIDER0_ON_DEBOUNCE_VALUE                              (cy_capsense_tuner.widgetContext[2].onDebounce)
#define CY_CAPSENSE_LINEARSLIDER0_ON_DEBOUNCE_OFFSET                             (170u)
#define CY_CAPSENSE_LINEARSLIDER0_ON_DEBOUNCE_SIZE                               (1u)
#define CY_CAPSENSE_LINEARSLIDER0_ON_DEBOUNCE_PARAM_ID                           (0x050200aau)

#define CY_CAPSENSE_LINEARSLIDER0_SNS_CLK_SOURCE_VALUE                           (cy_capsense_tuner.widgetContext[2].snsClkSource)
#define CY_CAPSENSE_LINEARSLIDER0_SNS_CLK_SOURCE_OFFSET                          (171u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS_CLK_SOURCE_SIZE                            (1u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS_CLK_SOURCE_PARAM_ID                        (0x050200abu)

#define CY_CAPSENSE_LINEARSLIDER0_IDAC_MOD0_VALUE                                (cy_capsense_tuner.widgetContext[2].idacMod[0])
#define CY_CAPSENSE_LINEARSLIDER0_IDAC_MOD0_OFFSET                               (172u)
#define CY_CAPSENSE_LINEARSLIDER0_IDAC_MOD0_SIZE                                 (1u)
#define CY_CAPSENSE_LINEARSLIDER0_IDAC_MOD0_PARAM_ID                             (0x050200acu)

#define CY_CAPSENSE_LINEARSLIDER0_IDAC_MOD1_VALUE                                (cy_capsense_tuner.widgetContext[2].idacMod[1])
#define CY_CAPSENSE_LINEARSLIDER0_IDAC_MOD1_OFFSET                               (173u)
#define CY_CAPSENSE_LINEARSLIDER0_IDAC_MOD1_SIZE                                 (1u)
#define CY_CAPSENSE_LINEARSLIDER0_IDAC_MOD1_PARAM_ID                             (0x050200adu)

#define CY_CAPSENSE_LINEARSLIDER0_IDAC_MOD2_VALUE                                (cy_capsense_tuner.widgetContext[2].idacMod[2])
#define CY_CAPSENSE_LINEARSLIDER0_IDAC_MOD2_OFFSET                               (174u)
#define CY_CAPSENSE_LINEARSLIDER0_IDAC_MOD2_SIZE                                 (1u)
#define CY_CAPSENSE_LINEARSLIDER0_IDAC_MOD2_PARAM_ID                             (0x050200aeu)

#define CY_CAPSENSE_LINEARSLIDER0_IDAC_GAIN_INDEX_VALUE                          (cy_capsense_tuner.widgetContext[2].idacGainIndex)
#define CY_CAPSENSE_LINEARSLIDER0_IDAC_GAIN_INDEX_OFFSET                         (175u)
#define CY_CAPSENSE_LINEARSLIDER0_IDAC_GAIN_INDEX_SIZE                           (1u)
#define CY_CAPSENSE_LINEARSLIDER0_IDAC_GAIN_INDEX_PARAM_ID                       (0x050200afu)

#define CY_CAPSENSE_LINEARSLIDER0_ROW_IDAC_MOD0_VALUE                            (cy_capsense_tuner.widgetContext[2].rowIdacMod[0])
#define CY_CAPSENSE_LINEARSLIDER0_ROW_IDAC_MOD0_OFFSET                           (176u)
#define CY_CAPSENSE_LINEARSLIDER0_ROW_IDAC_MOD0_SIZE                             (1u)
#define CY_CAPSENSE_LINEARSLIDER0_ROW_IDAC_MOD0_PARAM_ID                         (0x050200b0u)

#define CY_CAPSENSE_LINEARSLIDER0_ROW_IDAC_MOD1_VALUE                            (cy_capsense_tuner.widgetContext[2].rowIdacMod[1])
#define CY_CAPSENSE_LINEARSLIDER0_ROW_IDAC_MOD1_OFFSET                           (177u)
#define CY_CAPSENSE_LINEARSLIDER0_ROW_IDAC_MOD1_SIZE                             (1u)
#define CY_CAPSENSE_LINEARSLIDER0_ROW_IDAC_MOD1_PARAM_ID                         (0x050200b1u)

#define CY_CAPSENSE_LINEARSLIDER0_ROW_IDAC_MOD2_VALUE                            (cy_capsense_tuner.widgetContext[2].rowIdacMod[2])
#define CY_CAPSENSE_LINEARSLIDER0_ROW_IDAC_MOD2_OFFSET                           (178u)
#define CY_CAPSENSE_LINEARSLIDER0_ROW_IDAC_MOD2_SIZE                             (1u)
#define CY_CAPSENSE_LINEARSLIDER0_ROW_IDAC_MOD2_PARAM_ID                         (0x050200b2u)

#define CY_CAPSENSE_LINEARSLIDER0_REGULAR_IIR_BL_N_VALUE                         (cy_capsense_tuner.widgetContext[2].bslnCoeff)
#define CY_CAPSENSE_LINEARSLIDER0_REGULAR_IIR_BL_N_OFFSET                        (179u)
#define CY_CAPSENSE_LINEARSLIDER0_REGULAR_IIR_BL_N_SIZE                          (1u)
#define CY_CAPSENSE_LINEARSLIDER0_REGULAR_IIR_BL_N_PARAM_ID                      (0x050200b3u)

#define CY_CAPSENSE_LINEARSLIDER0_STATUS_VALUE                                   (cy_capsense_tuner.widgetContext[2].status)
#define CY_CAPSENSE_LINEARSLIDER0_STATUS_OFFSET                                  (180u)
#define CY_CAPSENSE_LINEARSLIDER0_STATUS_SIZE                                    (1u)
#define CY_CAPSENSE_LINEARSLIDER0_STATUS_PARAM_ID                                (0x010200b4u)

#define CY_CAPSENSE_LINEARSLIDER0_PTRPOSITION_VALUE                              (cy_capsense_tuner.widgetContext[2].wdTouch.ptrPosition)
#define CY_CAPSENSE_LINEARSLIDER0_PTRPOSITION_OFFSET                             (184u)
#define CY_CAPSENSE_LINEARSLIDER0_PTRPOSITION_SIZE                               (4u)
#define CY_CAPSENSE_LINEARSLIDER0_PTRPOSITION_PARAM_ID                           (0x030200b8u)

#define CY_CAPSENSE_LINEARSLIDER0_NUM_POSITIONS_VALUE                            (cy_capsense_tuner.widgetContext[2].wdTouch.numPosition)
#define CY_CAPSENSE_LINEARSLIDER0_NUM_POSITIONS_OFFSET                           (188u)
#define CY_CAPSENSE_LINEARSLIDER0_NUM_POSITIONS_SIZE                             (1u)
#define CY_CAPSENSE_LINEARSLIDER0_NUM_POSITIONS_PARAM_ID                         (0x010200bcu)

#define CY_CAPSENSE_BUTTON0_RX0_RAW0_VALUE                                       (cy_capsense_tuner.sensorContext[0].raw)
#define CY_CAPSENSE_BUTTON0_RX0_RAW0_OFFSET                                      (192u)
#define CY_CAPSENSE_BUTTON0_RX0_RAW0_SIZE                                        (2u)
#define CY_CAPSENSE_BUTTON0_RX0_RAW0_PARAM_ID                                    (0x020000c0u)

#define CY_CAPSENSE_BUTTON0_RX0_BSLN0_VALUE                                      (cy_capsense_tuner.sensorContext[0].bsln)
#define CY_CAPSENSE_BUTTON0_RX0_BSLN0_OFFSET                                     (194u)
#define CY_CAPSENSE_BUTTON0_RX0_BSLN0_SIZE                                       (2u)
#define CY_CAPSENSE_BUTTON0_RX0_BSLN0_PARAM_ID                                   (0x020000c2u)

#define CY_CAPSENSE_BUTTON0_RX0_DIFF0_VALUE                                      (cy_capsense_tuner.sensorContext[0].diff)
#define CY_CAPSENSE_BUTTON0_RX0_DIFF0_OFFSET                                     (196u)
#define CY_CAPSENSE_BUTTON0_RX0_DIFF0_SIZE                                       (2u)
#define CY_CAPSENSE_BUTTON0_RX0_DIFF0_PARAM_ID                                   (0x020000c4u)

#define CY_CAPSENSE_BUTTON0_RX0_STATUS0_VALUE                                    (cy_capsense_tuner.sensorContext[0].status)
#define CY_CAPSENSE_BUTTON0_RX0_STATUS0_OFFSET                                   (198u)
#define CY_CAPSENSE_BUTTON0_RX0_STATUS0_SIZE                                     (1u)
#define CY_CAPSENSE_BUTTON0_RX0_STATUS0_PARAM_ID                                 (0x010000c6u)

#define CY_CAPSENSE_BUTTON0_RX0_NEG_BSLN_RST_CNT0_VALUE                          (cy_capsense_tuner.sensorContext[0].negBslnRstCnt)
#define CY_CAPSENSE_BUTTON0_RX0_NEG_BSLN_RST_CNT0_OFFSET                         (199u)
#define CY_CAPSENSE_BUTTON0_RX0_NEG_BSLN_RST_CNT0_SIZE                           (1u)
#define CY_CAPSENSE_BUTTON0_RX0_NEG_BSLN_RST_CNT0_PARAM_ID                       (0x010000c7u)

#define CY_CAPSENSE_BUTTON0_RX0_IDAC0_VALUE                                      (cy_capsense_tuner.sensorContext[0].idacComp)
#define CY_CAPSENSE_BUTTON0_RX0_IDAC0_OFFSET                                     (200u)
#define CY_CAPSENSE_BUTTON0_RX0_IDAC0_SIZE                                       (1u)
#define CY_CAPSENSE_BUTTON0_RX0_IDAC0_PARAM_ID                                   (0x010000c8u)

#define CY_CAPSENSE_BUTTON0_RX0_BSLN_EXT0_VALUE                                  (cy_capsense_tuner.sensorContext[0].bslnExt)
#define CY_CAPSENSE_BUTTON0_RX0_BSLN_EXT0_OFFSET                                 (201u)
#define CY_CAPSENSE_BUTTON0_RX0_BSLN_EXT0_SIZE                                   (1u)
#define CY_CAPSENSE_BUTTON0_RX0_BSLN_EXT0_PARAM_ID                               (0x010000c9u)

#define CY_CAPSENSE_BUTTON1_RX0_RAW0_VALUE                                       (cy_capsense_tuner.sensorContext[1].raw)
#define CY_CAPSENSE_BUTTON1_RX0_RAW0_OFFSET                                      (202u)
#define CY_CAPSENSE_BUTTON1_RX0_RAW0_SIZE                                        (2u)
#define CY_CAPSENSE_BUTTON1_RX0_RAW0_PARAM_ID                                    (0x020100cau)

#define CY_CAPSENSE_BUTTON1_RX0_BSLN0_VALUE                                      (cy_capsense_tuner.sensorContext[1].bsln)
#define CY_CAPSENSE_BUTTON1_RX0_BSLN0_OFFSET                                     (204u)
#define CY_CAPSENSE_BUTTON1_RX0_BSLN0_SIZE                                       (2u)
#define CY_CAPSENSE_BUTTON1_RX0_BSLN0_PARAM_ID                                   (0x020100ccu)

#define CY_CAPSENSE_BUTTON1_RX0_DIFF0_VALUE                                      (cy_capsense_tuner.sensorContext[1].diff)
#define CY_CAPSENSE_BUTTON1_RX0_DIFF0_OFFSET                                     (206u)
#define CY_CAPSENSE_BUTTON1_RX0_DIFF0_SIZE                                       (2u)
#define CY_CAPSENSE_BUTTON1_RX0_DIFF0_PARAM_ID                                   (0x020100ceu)

#define CY_CAPSENSE_BUTTON1_RX0_STATUS0_VALUE                                    (cy_capsense_tuner.sensorContext[1].status)
#define CY_CAPSENSE_BUTTON1_RX0_STATUS0_OFFSET                                   (208u)
#define CY_CAPSENSE_BUTTON1_RX0_STATUS0_SIZE                                     (1u)
#define CY_CAPSENSE_BUTTON1_RX0_STATUS0_PARAM_ID                                 (0x010100d0u)

#define CY_CAPSENSE_BUTTON1_RX0_NEG_BSLN_RST_CNT0_VALUE                          (cy_capsense_tuner.sensorContext[1].negBslnRstCnt)
#define CY_CAPSENSE_BUTTON1_RX0_NEG_BSLN_RST_CNT0_OFFSET                         (209u)
#define CY_CAPSENSE_BUTTON1_RX0_NEG_BSLN_RST_CNT0_SIZE                           (1u)
#define CY_CAPSENSE_BUTTON1_RX0_NEG_BSLN_RST_CNT0_PARAM_ID                       (0x010100d1u)

#define CY_CAPSENSE_BUTTON1_RX0_IDAC0_VALUE                                      (cy_capsense_tuner.sensorContext[1].idacComp)
#define CY_CAPSENSE_BUTTON1_RX0_IDAC0_OFFSET                                     (210u)
#define CY_CAPSENSE_BUTTON1_RX0_IDAC0_SIZE                                       (1u)
#define CY_CAPSENSE_BUTTON1_RX0_IDAC0_PARAM_ID                                   (0x010100d2u)

#define CY_CAPSENSE_BUTTON1_RX0_BSLN_EXT0_VALUE                                  (cy_capsense_tuner.sensorContext[1].bslnExt)
#define CY_CAPSENSE_BUTTON1_RX0_BSLN_EXT0_OFFSET                                 (211u)
#define CY_CAPSENSE_BUTTON1_RX0_BSLN_EXT0_SIZE                                   (1u)
#define CY_CAPSENSE_BUTTON1_RX0_BSLN_EXT0_PARAM_ID                               (0x010100d3u)

#define CY_CAPSENSE_LINEARSLIDER0_SNS0_RAW0_VALUE                                (cy_capsense_tuner.sensorContext[2].raw)
#define CY_CAPSENSE_LINEARSLIDER0_SNS0_RAW0_OFFSET                               (212u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS0_RAW0_SIZE                                 (2u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS0_RAW0_PARAM_ID                             (0x020200d4u)

#define CY_CAPSENSE_LINEARSLIDER0_SNS0_BSLN0_VALUE                               (cy_capsense_tuner.sensorContext[2].bsln)
#define CY_CAPSENSE_LINEARSLIDER0_SNS0_BSLN0_OFFSET                              (214u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS0_BSLN0_SIZE                                (2u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS0_BSLN0_PARAM_ID                            (0x020200d6u)

#define CY_CAPSENSE_LINEARSLIDER0_SNS0_DIFF0_VALUE                               (cy_capsense_tuner.sensorContext[2].diff)
#define CY_CAPSENSE_LINEARSLIDER0_SNS0_DIFF0_OFFSET                              (216u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS0_DIFF0_SIZE                                (2u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS0_DIFF0_PARAM_ID                            (0x020200d8u)

#define CY_CAPSENSE_LINEARSLIDER0_SNS0_STATUS0_VALUE                             (cy_capsense_tuner.sensorContext[2].status)
#define CY_CAPSENSE_LINEARSLIDER0_SNS0_STATUS0_OFFSET                            (218u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS0_STATUS0_SIZE                              (1u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS0_STATUS0_PARAM_ID                          (0x010200dau)

#define CY_CAPSENSE_LINEARSLIDER0_SNS0_NEG_BSLN_RST_CNT0_VALUE                   (cy_capsense_tuner.sensorContext[2].negBslnRstCnt)
#define CY_CAPSENSE_LINEARSLIDER0_SNS0_NEG_BSLN_RST_CNT0_OFFSET                  (219u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS0_NEG_BSLN_RST_CNT0_SIZE                    (1u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS0_NEG_BSLN_RST_CNT0_PARAM_ID                (0x010200dbu)

#define CY_CAPSENSE_LINEARSLIDER0_SNS0_IDAC0_VALUE                               (cy_capsense_tuner.sensorContext[2].idacComp)
#define CY_CAPSENSE_LINEARSLIDER0_SNS0_IDAC0_OFFSET                              (220u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS0_IDAC0_SIZE                                (1u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS0_IDAC0_PARAM_ID                            (0x010200dcu)

#define CY_CAPSENSE_LINEARSLIDER0_SNS0_BSLN_EXT0_VALUE                           (cy_capsense_tuner.sensorContext[2].bslnExt)
#define CY_CAPSENSE_LINEARSLIDER0_SNS0_BSLN_EXT0_OFFSET                          (221u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS0_BSLN_EXT0_SIZE                            (1u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS0_BSLN_EXT0_PARAM_ID                        (0x010200ddu)

#define CY_CAPSENSE_LINEARSLIDER0_SNS1_RAW0_VALUE                                (cy_capsense_tuner.sensorContext[3].raw)
#define CY_CAPSENSE_LINEARSLIDER0_SNS1_RAW0_OFFSET                               (222u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS1_RAW0_SIZE                                 (2u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS1_RAW0_PARAM_ID                             (0x020200deu)

#define CY_CAPSENSE_LINEARSLIDER0_SNS1_BSLN0_VALUE                               (cy_capsense_tuner.sensorContext[3].bsln)
#define CY_CAPSENSE_LINEARSLIDER0_SNS1_BSLN0_OFFSET                              (224u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS1_BSLN0_SIZE                                (2u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS1_BSLN0_PARAM_ID                            (0x020200e0u)

#define CY_CAPSENSE_LINEARSLIDER0_SNS1_DIFF0_VALUE                               (cy_capsense_tuner.sensorContext[3].diff)
#define CY_CAPSENSE_LINEARSLIDER0_SNS1_DIFF0_OFFSET                              (226u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS1_DIFF0_SIZE                                (2u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS1_DIFF0_PARAM_ID                            (0x020200e2u)

#define CY_CAPSENSE_LINEARSLIDER0_SNS1_STATUS0_VALUE                             (cy_capsense_tuner.sensorContext[3].status)
#define CY_CAPSENSE_LINEARSLIDER0_SNS1_STATUS0_OFFSET                            (228u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS1_STATUS0_SIZE                              (1u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS1_STATUS0_PARAM_ID                          (0x010200e4u)

#define CY_CAPSENSE_LINEARSLIDER0_SNS1_NEG_BSLN_RST_CNT0_VALUE                   (cy_capsense_tuner.sensorContext[3].negBslnRstCnt)
#define CY_CAPSENSE_LINEARSLIDER0_SNS1_NEG_BSLN_RST_CNT0_OFFSET                  (229u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS1_NEG_BSLN_RST_CNT0_SIZE                    (1u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS1_NEG_BSLN_RST_CNT0_PARAM_ID                (0x010200e5u)

#define CY_CAPSENSE_LINEARSLIDER0_SNS1_IDAC0_VALUE                               (cy_capsense_tuner.sensorContext[3].idacComp)
#define CY_CAPSENSE_LINEARSLIDER0_SNS1_IDAC0_OFFSET                              (230u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS1_IDAC0_SIZE                                (1u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS1_IDAC0_PARAM_ID                            (0x010200e6u)

#define CY_CAPSENSE_LINEARSLIDER0_SNS1_BSLN_EXT0_VALUE                           (cy_capsense_tuner.sensorContext[3].bslnExt)
#define CY_CAPSENSE_LINEARSLIDER0_SNS1_BSLN_EXT0_OFFSET                          (231u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS1_BSLN_EXT0_SIZE                            (1u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS1_BSLN_EXT0_PARAM_ID                        (0x010200e7u)

#define CY_CAPSENSE_LINEARSLIDER0_SNS2_RAW0_VALUE                                (cy_capsense_tuner.sensorContext[4].raw)
#define CY_CAPSENSE_LINEARSLIDER0_SNS2_RAW0_OFFSET                               (232u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS2_RAW0_SIZE                                 (2u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS2_RAW0_PARAM_ID                             (0x020200e8u)

#define CY_CAPSENSE_LINEARSLIDER0_SNS2_BSLN0_VALUE                               (cy_capsense_tuner.sensorContext[4].bsln)
#define CY_CAPSENSE_LINEARSLIDER0_SNS2_BSLN0_OFFSET                              (234u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS2_BSLN0_SIZE                                (2u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS2_BSLN0_PARAM_ID                            (0x020200eau)

#define CY_CAPSENSE_LINEARSLIDER0_SNS2_DIFF0_VALUE                               (cy_capsense_tuner.sensorContext[4].diff)
#define CY_CAPSENSE_LINEARSLIDER0_SNS2_DIFF0_OFFSET                              (236u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS2_DIFF0_SIZE                                (2u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS2_DIFF0_PARAM_ID                            (0x020200ecu)

#define CY_CAPSENSE_LINEARSLIDER0_SNS2_STATUS0_VALUE                             (cy_capsense_tuner.sensorContext[4].status)
#define CY_CAPSENSE_LINEARSLIDER0_SNS2_STATUS0_OFFSET                            (238u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS2_STATUS0_SIZE                              (1u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS2_STATUS0_PARAM_ID                          (0x010200eeu)

#define CY_CAPSENSE_LINEARSLIDER0_SNS2_NEG_BSLN_RST_CNT0_VALUE                   (cy_capsense_tuner.sensorContext[4].negBslnRstCnt)
#define CY_CAPSENSE_LINEARSLIDER0_SNS2_NEG_BSLN_RST_CNT0_OFFSET                  (239u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS2_NEG_BSLN_RST_CNT0_SIZE                    (1u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS2_NEG_BSLN_RST_CNT0_PARAM_ID                (0x010200efu)

#define CY_CAPSENSE_LINEARSLIDER0_SNS2_IDAC0_VALUE                               (cy_capsense_tuner.sensorContext[4].idacComp)
#define CY_CAPSENSE_LINEARSLIDER0_SNS2_IDAC0_OFFSET                              (240u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS2_IDAC0_SIZE                                (1u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS2_IDAC0_PARAM_ID                            (0x010200f0u)

#define CY_CAPSENSE_LINEARSLIDER0_SNS2_BSLN_EXT0_VALUE                           (cy_capsense_tuner.sensorContext[4].bslnExt)
#define CY_CAPSENSE_LINEARSLIDER0_SNS2_BSLN_EXT0_OFFSET                          (241u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS2_BSLN_EXT0_SIZE                            (1u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS2_BSLN_EXT0_PARAM_ID                        (0x010200f1u)

#define CY_CAPSENSE_LINEARSLIDER0_SNS3_RAW0_VALUE                                (cy_capsense_tuner.sensorContext[5].raw)
#define CY_CAPSENSE_LINEARSLIDER0_SNS3_RAW0_OFFSET                               (242u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS3_RAW0_SIZE                                 (2u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS3_RAW0_PARAM_ID                             (0x020200f2u)

#define CY_CAPSENSE_LINEARSLIDER0_SNS3_BSLN0_VALUE                               (cy_capsense_tuner.sensorContext[5].bsln)
#define CY_CAPSENSE_LINEARSLIDER0_SNS3_BSLN0_OFFSET                              (244u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS3_BSLN0_SIZE                                (2u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS3_BSLN0_PARAM_ID                            (0x020200f4u)

#define CY_CAPSENSE_LINEARSLIDER0_SNS3_DIFF0_VALUE                               (cy_capsense_tuner.sensorContext[5].diff)
#define CY_CAPSENSE_LINEARSLIDER0_SNS3_DIFF0_OFFSET                              (246u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS3_DIFF0_SIZE                                (2u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS3_DIFF0_PARAM_ID                            (0x020200f6u)

#define CY_CAPSENSE_LINEARSLIDER0_SNS3_STATUS0_VALUE                             (cy_capsense_tuner.sensorContext[5].status)
#define CY_CAPSENSE_LINEARSLIDER0_SNS3_STATUS0_OFFSET                            (248u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS3_STATUS0_SIZE                              (1u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS3_STATUS0_PARAM_ID                          (0x010200f8u)

#define CY_CAPSENSE_LINEARSLIDER0_SNS3_NEG_BSLN_RST_CNT0_VALUE                   (cy_capsense_tuner.sensorContext[5].negBslnRstCnt)
#define CY_CAPSENSE_LINEARSLIDER0_SNS3_NEG_BSLN_RST_CNT0_OFFSET                  (249u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS3_NEG_BSLN_RST_CNT0_SIZE                    (1u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS3_NEG_BSLN_RST_CNT0_PARAM_ID                (0x010200f9u)

#define CY_CAPSENSE_LINEARSLIDER0_SNS3_IDAC0_VALUE                               (cy_capsense_tuner.sensorContext[5].idacComp)
#define CY_CAPSENSE_LINEARSLIDER0_SNS3_IDAC0_OFFSET                              (250u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS3_IDAC0_SIZE                                (1u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS3_IDAC0_PARAM_ID                            (0x010200fau)

#define CY_CAPSENSE_LINEARSLIDER0_SNS3_BSLN_EXT0_VALUE                           (cy_capsense_tuner.sensorContext[5].bslnExt)
#define CY_CAPSENSE_LINEARSLIDER0_SNS3_BSLN_EXT0_OFFSET                          (251u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS3_BSLN_EXT0_SIZE                            (1u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS3_BSLN_EXT0_PARAM_ID                        (0x010200fbu)

#define CY_CAPSENSE_LINEARSLIDER0_SNS4_RAW0_VALUE                                (cy_capsense_tuner.sensorContext[6].raw)
#define CY_CAPSENSE_LINEARSLIDER0_SNS4_RAW0_OFFSET                               (252u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS4_RAW0_SIZE                                 (2u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS4_RAW0_PARAM_ID                             (0x020200fcu)

#define CY_CAPSENSE_LINEARSLIDER0_SNS4_BSLN0_VALUE                               (cy_capsense_tuner.sensorContext[6].bsln)
#define CY_CAPSENSE_LINEARSLIDER0_SNS4_BSLN0_OFFSET                              (254u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS4_BSLN0_SIZE                                (2u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS4_BSLN0_PARAM_ID                            (0x020200feu)

#define CY_CAPSENSE_LINEARSLIDER0_SNS4_DIFF0_VALUE                               (cy_capsense_tuner.sensorContext[6].diff)
#define CY_CAPSENSE_LINEARSLIDER0_SNS4_DIFF0_OFFSET                              (256u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS4_DIFF0_SIZE                                (2u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS4_DIFF0_PARAM_ID                            (0x02020100u)

#define CY_CAPSENSE_LINEARSLIDER0_SNS4_STATUS0_VALUE                             (cy_capsense_tuner.sensorContext[6].status)
#define CY_CAPSENSE_LINEARSLIDER0_SNS4_STATUS0_OFFSET                            (258u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS4_STATUS0_SIZE                              (1u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS4_STATUS0_PARAM_ID                          (0x01020102u)

#define CY_CAPSENSE_LINEARSLIDER0_SNS4_NEG_BSLN_RST_CNT0_VALUE                   (cy_capsense_tuner.sensorContext[6].negBslnRstCnt)
#define CY_CAPSENSE_LINEARSLIDER0_SNS4_NEG_BSLN_RST_CNT0_OFFSET                  (259u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS4_NEG_BSLN_RST_CNT0_SIZE                    (1u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS4_NEG_BSLN_RST_CNT0_PARAM_ID                (0x01020103u)

#define CY_CAPSENSE_LINEARSLIDER0_SNS4_IDAC0_VALUE                               (cy_capsense_tuner.sensorContext[6].idacComp)
#define CY_CAPSENSE_LINEARSLIDER0_SNS4_IDAC0_OFFSET                              (260u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS4_IDAC0_SIZE                                (1u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS4_IDAC0_PARAM_ID                            (0x01020104u)

#define CY_CAPSENSE_LINEARSLIDER0_SNS4_BSLN_EXT0_VALUE                           (cy_capsense_tuner.sensorContext[6].bslnExt)
#define CY_CAPSENSE_LINEARSLIDER0_SNS4_BSLN_EXT0_OFFSET                          (261u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS4_BSLN_EXT0_SIZE                            (1u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS4_BSLN_EXT0_PARAM_ID                        (0x01020105u)

#define CY_CAPSENSE_LINEARSLIDER0_X0_VALUE                                       (cy_capsense_tuner.position[0].x)
#define CY_CAPSENSE_LINEARSLIDER0_X0_OFFSET                                      (262u)
#define CY_CAPSENSE_LINEARSLIDER0_X0_SIZE                                        (2u)
#define CY_CAPSENSE_LINEARSLIDER0_X0_PARAM_ID                                    (0x02020106u)

#define CY_CAPSENSE_LINEARSLIDER0_Y0_VALUE                                       (cy_capsense_tuner.position[0].y)
#define CY_CAPSENSE_LINEARSLIDER0_Y0_OFFSET                                      (264u)
#define CY_CAPSENSE_LINEARSLIDER0_Y0_SIZE                                        (2u)
#define CY_CAPSENSE_LINEARSLIDER0_Y0_PARAM_ID                                    (0x02020108u)

#define CY_CAPSENSE_LINEARSLIDER0_Z0_VALUE                                       (cy_capsense_tuner.position[0].z)
#define CY_CAPSENSE_LINEARSLIDER0_Z0_OFFSET                                      (266u)
#define CY_CAPSENSE_LINEARSLIDER0_Z0_SIZE                                        (2u)
#define CY_CAPSENSE_LINEARSLIDER0_Z0_PARAM_ID                                    (0x0202010au)

#define CY_CAPSENSE_LINEARSLIDER0_ID0_VALUE                                      (cy_capsense_tuner.position[0].id)
#define CY_CAPSENSE_LINEARSLIDER0_ID0_OFFSET                                     (268u)
#define CY_CAPSENSE_LINEARSLIDER0_ID0_SIZE                                       (2u)
#define CY_CAPSENSE_LINEARSLIDER0_ID0_PARAM_ID                                   (0x0202010cu)

#elif (CY_CAPSENSE_MW_VERSION < 500)
#define CY_CAPSENSE_CONFIG_ID_VALUE                                              (cy_capsense_tuner.commonContext.configId)
#define CY_CAPSENSE_CONFIG_ID_OFFSET                                             (0u)
#define CY_CAPSENSE_CONFIG_ID_SIZE                                               (2u)
#define CY_CAPSENSE_CONFIG_ID_PARAM_ID                                           (0x02000000u)

#define CY_CAPSENSE_TUNER_CMD_VALUE                                              (cy_capsense_tuner.commonContext.tunerCmd)
#define CY_CAPSENSE_TUNER_CMD_OFFSET                                             (2u)
#define CY_CAPSENSE_TUNER_CMD_SIZE                                               (2u)
#define CY_CAPSENSE_TUNER_CMD_PARAM_ID                                           (0x02000002u)

#define CY_CAPSENSE_SCAN_COUNTER_VALUE                                           (cy_capsense_tuner.commonContext.scanCounter)
#define CY_CAPSENSE_SCAN_COUNTER_OFFSET                                          (4u)
#define CY_CAPSENSE_SCAN_COUNTER_SIZE                                            (2u)
#define CY_CAPSENSE_SCAN_COUNTER_PARAM_ID                                        (0x02000004u)

#define CY_CAPSENSE_TUNER_ST_VALUE                                               (cy_capsense_tuner.commonContext.tunerSt)
#define CY_CAPSENSE_TUNER_ST_OFFSET                                              (6u)
#define CY_CAPSENSE_TUNER_ST_SIZE                                                (1u)
#define CY_CAPSENSE_TUNER_ST_PARAM_ID                                            (0x01000006u)

#define CY_CAPSENSE_INITDONE_VALUE                                               (cy_capsense_tuner.commonContext.initDone)
#define CY_CAPSENSE_INITDONE_OFFSET                                              (7u)
#define CY_CAPSENSE_INITDONE_SIZE                                                (1u)
#define CY_CAPSENSE_INITDONE_PARAM_ID                                            (0x01000007u)

#define CY_CAPSENSE_STATUS_VALUE                                                 (cy_capsense_tuner.commonContext.status)
#define CY_CAPSENSE_STATUS_OFFSET                                                (8u)
#define CY_CAPSENSE_STATUS_SIZE                                                  (4u)
#define CY_CAPSENSE_STATUS_PARAM_ID                                              (0x03000008u)

#define CY_CAPSENSE_TIMESTAMPINTERVAL_VALUE                                      (cy_capsense_tuner.commonContext.timestampInterval)
#define CY_CAPSENSE_TIMESTAMPINTERVAL_OFFSET                                     (12u)
#define CY_CAPSENSE_TIMESTAMPINTERVAL_SIZE                                       (4u)
#define CY_CAPSENSE_TIMESTAMPINTERVAL_PARAM_ID                                   (0x0300000cu)

#define CY_CAPSENSE_TIMESTAMP_VALUE                                              (cy_capsense_tuner.commonContext.timestamp)
#define CY_CAPSENSE_TIMESTAMP_OFFSET                                             (16u)
#define CY_CAPSENSE_TIMESTAMP_SIZE                                               (4u)
#define CY_CAPSENSE_TIMESTAMP_PARAM_ID                                           (0x03000010u)

#define CY_CAPSENSE_CSD_MOD_CLK_DIVIDER_VALUE                                    (cy_capsense_tuner.commonContext.modCsdClk)
#define CY_CAPSENSE_CSD_MOD_CLK_DIVIDER_OFFSET                                   (20u)
#define CY_CAPSENSE_CSD_MOD_CLK_DIVIDER_SIZE                                     (1u)
#define CY_CAPSENSE_CSD_MOD_CLK_DIVIDER_PARAM_ID                                 (0x01000014u)

#define CY_CAPSENSE_CSX_MOD_CLK_DIVIDER_VALUE                                    (cy_capsense_tuner.commonContext.modCsxClk)
#define CY_CAPSENSE_CSX_MOD_CLK_DIVIDER_OFFSET                                   (21u)
#define CY_CAPSENSE_CSX_MOD_CLK_DIVIDER_SIZE                                     (1u)
#define CY_CAPSENSE_CSX_MOD_CLK_DIVIDER_PARAM_ID                                 (0x01000015u)

#define CY_CAPSENSE_TUNER_CNT_VALUE                                              (cy_capsense_tuner.commonContext.tunerCnt)
#define CY_CAPSENSE_TUNER_CNT_OFFSET                                             (22u)
#define CY_CAPSENSE_TUNER_CNT_SIZE                                               (1u)
#define CY_CAPSENSE_TUNER_CNT_PARAM_ID                                           (0x01000016u)

#define CY_CAPSENSE_BUTTON0_FINGER_CP_VALUE                                      (cy_capsense_tuner.widgetContext[0].fingerCap)
#define CY_CAPSENSE_BUTTON0_FINGER_CP_OFFSET                                     (24u)
#define CY_CAPSENSE_BUTTON0_FINGER_CP_SIZE                                       (2u)
#define CY_CAPSENSE_BUTTON0_FINGER_CP_PARAM_ID                                   (0x06000018u)

#define CY_CAPSENSE_BUTTON0_SIGPFC_VALUE                                         (cy_capsense_tuner.widgetContext[0].sigPFC)
#define CY_CAPSENSE_BUTTON0_SIGPFC_OFFSET                                        (26u)
#define CY_CAPSENSE_BUTTON0_SIGPFC_SIZE                                          (2u)
#define CY_CAPSENSE_BUTTON0_SIGPFC_PARAM_ID                                      (0x0600001au)

#define CY_CAPSENSE_BUTTON0_NUM_CONV_VALUE                                       (cy_capsense_tuner.widgetContext[0].resolution)
#define CY_CAPSENSE_BUTTON0_NUM_CONV_OFFSET                                      (28u)
#define CY_CAPSENSE_BUTTON0_NUM_CONV_SIZE                                        (2u)
#define CY_CAPSENSE_BUTTON0_NUM_CONV_PARAM_ID                                    (0x0600001cu)

#define CY_CAPSENSE_BUTTON0_MAX_RAW_COUNT_VALUE                                  (cy_capsense_tuner.widgetContext[0].maxRawCount)
#define CY_CAPSENSE_BUTTON0_MAX_RAW_COUNT_OFFSET                                 (30u)
#define CY_CAPSENSE_BUTTON0_MAX_RAW_COUNT_SIZE                                   (2u)
#define CY_CAPSENSE_BUTTON0_MAX_RAW_COUNT_PARAM_ID                               (0x0600001eu)

#define CY_CAPSENSE_BUTTON0_ROW_MAX_RAW_COUNT_VALUE                              (cy_capsense_tuner.widgetContext[0].maxRawCountRow)
#define CY_CAPSENSE_BUTTON0_ROW_MAX_RAW_COUNT_OFFSET                             (32u)
#define CY_CAPSENSE_BUTTON0_ROW_MAX_RAW_COUNT_SIZE                               (2u)
#define CY_CAPSENSE_BUTTON0_ROW_MAX_RAW_COUNT_PARAM_ID                           (0x06000020u)

#define CY_CAPSENSE_BUTTON0_FINGER_TH_VALUE                                      (cy_capsense_tuner.widgetContext[0].fingerTh)
#define CY_CAPSENSE_BUTTON0_FINGER_TH_OFFSET                                     (34u)
#define CY_CAPSENSE_BUTTON0_FINGER_TH_SIZE                                       (2u)
#define CY_CAPSENSE_BUTTON0_FINGER_TH_PARAM_ID                                   (0x06000022u)

#define CY_CAPSENSE_BUTTON0_PROX_TOUCH_TH_VALUE                                  (cy_capsense_tuner.widgetContext[0].proxTh)
#define CY_CAPSENSE_BUTTON0_PROX_TOUCH_TH_OFFSET                                 (36u)
#define CY_CAPSENSE_BUTTON0_PROX_TOUCH_TH_SIZE                                   (2u)
#define CY_CAPSENSE_BUTTON0_PROX_TOUCH_TH_PARAM_ID                               (0x06000024u)

#define CY_CAPSENSE_BUTTON0_LOW_BSLN_RST_VALUE                                   (cy_capsense_tuner.widgetContext[0].lowBslnRst)
#define CY_CAPSENSE_BUTTON0_LOW_BSLN_RST_OFFSET                                  (38u)
#define CY_CAPSENSE_BUTTON0_LOW_BSLN_RST_SIZE                                    (2u)
#define CY_CAPSENSE_BUTTON0_LOW_BSLN_RST_PARAM_ID                                (0x06000026u)

#define CY_CAPSENSE_BUTTON0_TX_CLK_VALUE                                         (cy_capsense_tuner.widgetContext[0].snsClk)
#define CY_CAPSENSE_BUTTON0_TX_CLK_OFFSET                                        (40u)
#define CY_CAPSENSE_BUTTON0_TX_CLK_SIZE                                          (2u)
#define CY_CAPSENSE_BUTTON0_TX_CLK_PARAM_ID                                      (0x06000028u)

#define CY_CAPSENSE_BUTTON0_ROW_SNS_CLK_VALUE                                    (cy_capsense_tuner.widgetContext[0].rowSnsClk)
#define CY_CAPSENSE_BUTTON0_ROW_SNS_CLK_OFFSET                                   (42u)
#define CY_CAPSENSE_BUTTON0_ROW_SNS_CLK_SIZE                                     (2u)
#define CY_CAPSENSE_BUTTON0_ROW_SNS_CLK_PARAM_ID                                 (0x0600002au)

#define CY_CAPSENSE_BUTTON0_GESTURE_DETECTED_VALUE                               (cy_capsense_tuner.widgetContext[0].gestureDetected)
#define CY_CAPSENSE_BUTTON0_GESTURE_DETECTED_OFFSET                              (44u)
#define CY_CAPSENSE_BUTTON0_GESTURE_DETECTED_SIZE                                (2u)
#define CY_CAPSENSE_BUTTON0_GESTURE_DETECTED_PARAM_ID                            (0x0200002cu)

#define CY_CAPSENSE_BUTTON0_GESTURE_DIRECTION_VALUE                              (cy_capsense_tuner.widgetContext[0].gestureDirection)
#define CY_CAPSENSE_BUTTON0_GESTURE_DIRECTION_OFFSET                             (46u)
#define CY_CAPSENSE_BUTTON0_GESTURE_DIRECTION_SIZE                               (2u)
#define CY_CAPSENSE_BUTTON0_GESTURE_DIRECTION_PARAM_ID                           (0x0200002eu)

#define CY_CAPSENSE_BUTTON0_XDELTA_VALUE                                         (cy_capsense_tuner.widgetContext[0].xDelta)
#define CY_CAPSENSE_BUTTON0_XDELTA_OFFSET                                        (48u)
#define CY_CAPSENSE_BUTTON0_XDELTA_SIZE                                          (2u)
#define CY_CAPSENSE_BUTTON0_XDELTA_PARAM_ID                                      (0x02000030u)

#define CY_CAPSENSE_BUTTON0_YDELTA_VALUE                                         (cy_capsense_tuner.widgetContext[0].yDelta)
#define CY_CAPSENSE_BUTTON0_YDELTA_OFFSET                                        (50u)
#define CY_CAPSENSE_BUTTON0_YDELTA_SIZE                                          (2u)
#define CY_CAPSENSE_BUTTON0_YDELTA_PARAM_ID                                      (0x02000032u)

#define CY_CAPSENSE_BUTTON0_NOISE_TH_VALUE                                       (cy_capsense_tuner.widgetContext[0].noiseTh)
#define CY_CAPSENSE_BUTTON0_NOISE_TH_OFFSET                                      (52u)
#define CY_CAPSENSE_BUTTON0_NOISE_TH_SIZE                                        (2u)
#define CY_CAPSENSE_BUTTON0_NOISE_TH_PARAM_ID                                    (0x06000034u)

#define CY_CAPSENSE_BUTTON0_NNOISE_TH_VALUE                                      (cy_capsense_tuner.widgetContext[0].nNoiseTh)
#define CY_CAPSENSE_BUTTON0_NNOISE_TH_OFFSET                                     (54u)
#define CY_CAPSENSE_BUTTON0_NNOISE_TH_SIZE                                       (2u)
#define CY_CAPSENSE_BUTTON0_NNOISE_TH_PARAM_ID                                   (0x06000036u)

#define CY_CAPSENSE_BUTTON0_HYSTERESIS_VALUE                                     (cy_capsense_tuner.widgetContext[0].hysteresis)
#define CY_CAPSENSE_BUTTON0_HYSTERESIS_OFFSET                                    (56u)
#define CY_CAPSENSE_BUTTON0_HYSTERESIS_SIZE                                      (2u)
#define CY_CAPSENSE_BUTTON0_HYSTERESIS_PARAM_ID                                  (0x06000038u)

#define CY_CAPSENSE_BUTTON0_ON_DEBOUNCE_VALUE                                    (cy_capsense_tuner.widgetContext[0].onDebounce)
#define CY_CAPSENSE_BUTTON0_ON_DEBOUNCE_OFFSET                                   (58u)
#define CY_CAPSENSE_BUTTON0_ON_DEBOUNCE_SIZE                                     (1u)
#define CY_CAPSENSE_BUTTON0_ON_DEBOUNCE_PARAM_ID                                 (0x0500003au)

#define CY_CAPSENSE_BUTTON0_TX_CLK_SOURCE_VALUE                                  (cy_capsense_tuner.widgetContext[0].snsClkSource)
#define CY_CAPSENSE_BUTTON0_TX_CLK_SOURCE_OFFSET                                 (59u)
#define CY_CAPSENSE_BUTTON0_TX_CLK_SOURCE_SIZE                                   (1u)
#define CY_CAPSENSE_BUTTON0_TX_CLK_SOURCE_PARAM_ID                               (0x0500003bu)

#define CY_CAPSENSE_BUTTON0_IDAC_MOD0_VALUE                                      (cy_capsense_tuner.widgetContext[0].idacMod[0])
#define CY_CAPSENSE_BUTTON0_IDAC_MOD0_OFFSET                                     (60u)
#define CY_CAPSENSE_BUTTON0_IDAC_MOD0_SIZE                                       (1u)
#define CY_CAPSENSE_BUTTON0_IDAC_MOD0_PARAM_ID                                   (0x0500003cu)

#define CY_CAPSENSE_BUTTON0_IDAC_MOD1_VALUE                                      (cy_capsense_tuner.widgetContext[0].idacMod[1])
#define CY_CAPSENSE_BUTTON0_IDAC_MOD1_OFFSET                                     (61u)
#define CY_CAPSENSE_BUTTON0_IDAC_MOD1_SIZE                                       (1u)
#define CY_CAPSENSE_BUTTON0_IDAC_MOD1_PARAM_ID                                   (0x0500003du)

#define CY_CAPSENSE_BUTTON0_IDAC_MOD2_VALUE                                      (cy_capsense_tuner.widgetContext[0].idacMod[2])
#define CY_CAPSENSE_BUTTON0_IDAC_MOD2_OFFSET                                     (62u)
#define CY_CAPSENSE_BUTTON0_IDAC_MOD2_SIZE                                       (1u)
#define CY_CAPSENSE_BUTTON0_IDAC_MOD2_PARAM_ID                                   (0x0500003eu)

#define CY_CAPSENSE_BUTTON0_IDAC_GAIN_INDEX_VALUE                                (cy_capsense_tuner.widgetContext[0].idacGainIndex)
#define CY_CAPSENSE_BUTTON0_IDAC_GAIN_INDEX_OFFSET                               (63u)
#define CY_CAPSENSE_BUTTON0_IDAC_GAIN_INDEX_SIZE                                 (1u)
#define CY_CAPSENSE_BUTTON0_IDAC_GAIN_INDEX_PARAM_ID                             (0x0500003fu)

#define CY_CAPSENSE_BUTTON0_ROW_IDAC_MOD0_VALUE                                  (cy_capsense_tuner.widgetContext[0].rowIdacMod[0])
#define CY_CAPSENSE_BUTTON0_ROW_IDAC_MOD0_OFFSET                                 (64u)
#define CY_CAPSENSE_BUTTON0_ROW_IDAC_MOD0_SIZE                                   (1u)
#define CY_CAPSENSE_BUTTON0_ROW_IDAC_MOD0_PARAM_ID                               (0x05000040u)

#define CY_CAPSENSE_BUTTON0_ROW_IDAC_MOD1_VALUE                                  (cy_capsense_tuner.widgetContext[0].rowIdacMod[1])
#define CY_CAPSENSE_BUTTON0_ROW_IDAC_MOD1_OFFSET                                 (65u)
#define CY_CAPSENSE_BUTTON0_ROW_IDAC_MOD1_SIZE                                   (1u)
#define CY_CAPSENSE_BUTTON0_ROW_IDAC_MOD1_PARAM_ID                               (0x05000041u)

#define CY_CAPSENSE_BUTTON0_ROW_IDAC_MOD2_VALUE                                  (cy_capsense_tuner.widgetContext[0].rowIdacMod[2])
#define CY_CAPSENSE_BUTTON0_ROW_IDAC_MOD2_OFFSET                                 (66u)
#define CY_CAPSENSE_BUTTON0_ROW_IDAC_MOD2_SIZE                                   (1u)
#define CY_CAPSENSE_BUTTON0_ROW_IDAC_MOD2_PARAM_ID                               (0x05000042u)

#define CY_CAPSENSE_BUTTON0_REGULAR_IIR_BL_N_VALUE                               (cy_capsense_tuner.widgetContext[0].bslnCoeff)
#define CY_CAPSENSE_BUTTON0_REGULAR_IIR_BL_N_OFFSET                              (67u)
#define CY_CAPSENSE_BUTTON0_REGULAR_IIR_BL_N_SIZE                                (1u)
#define CY_CAPSENSE_BUTTON0_REGULAR_IIR_BL_N_PARAM_ID                            (0x05000043u)

#define CY_CAPSENSE_BUTTON0_STATUS_VALUE                                         (cy_capsense_tuner.widgetContext[0].status)
#define CY_CAPSENSE_BUTTON0_STATUS_OFFSET                                        (68u)
#define CY_CAPSENSE_BUTTON0_STATUS_SIZE                                          (1u)
#define CY_CAPSENSE_BUTTON0_STATUS_PARAM_ID                                      (0x01000044u)

#define CY_CAPSENSE_BUTTON0_PTRPOSITION_VALUE                                    (cy_capsense_tuner.widgetContext[0].wdTouch.ptrPosition)
#define CY_CAPSENSE_BUTTON0_PTRPOSITION_OFFSET                                   (72u)
#define CY_CAPSENSE_BUTTON0_PTRPOSITION_SIZE                                     (4u)
#define CY_CAPSENSE_BUTTON0_PTRPOSITION_PARAM_ID                                 (0x03000048u)

#define CY_CAPSENSE_BUTTON0_NUM_POSITIONS_VALUE                                  (cy_capsense_tuner.widgetContext[0].wdTouch.numPosition)
#define CY_CAPSENSE_BUTTON0_NUM_POSITIONS_OFFSET                                 (76u)
#define CY_CAPSENSE_BUTTON0_NUM_POSITIONS_SIZE                                   (1u)
#define CY_CAPSENSE_BUTTON0_NUM_POSITIONS_PARAM_ID                               (0x0100004cu)

#define CY_CAPSENSE_BUTTON1_FINGER_CP_VALUE                                      (cy_capsense_tuner.widgetContext[1].fingerCap)
#define CY_CAPSENSE_BUTTON1_FINGER_CP_OFFSET                                     (80u)
#define CY_CAPSENSE_BUTTON1_FINGER_CP_SIZE                                       (2u)
#define CY_CAPSENSE_BUTTON1_FINGER_CP_PARAM_ID                                   (0x06010050u)

#define CY_CAPSENSE_BUTTON1_SIGPFC_VALUE                                         (cy_capsense_tuner.widgetContext[1].sigPFC)
#define CY_CAPSENSE_BUTTON1_SIGPFC_OFFSET                                        (82u)
#define CY_CAPSENSE_BUTTON1_SIGPFC_SIZE                                          (2u)
#define CY_CAPSENSE_BUTTON1_SIGPFC_PARAM_ID                                      (0x06010052u)

#define CY_CAPSENSE_BUTTON1_NUM_CONV_VALUE                                       (cy_capsense_tuner.widgetContext[1].resolution)
#define CY_CAPSENSE_BUTTON1_NUM_CONV_OFFSET                                      (84u)
#define CY_CAPSENSE_BUTTON1_NUM_CONV_SIZE                                        (2u)
#define CY_CAPSENSE_BUTTON1_NUM_CONV_PARAM_ID                                    (0x06010054u)

#define CY_CAPSENSE_BUTTON1_MAX_RAW_COUNT_VALUE                                  (cy_capsense_tuner.widgetContext[1].maxRawCount)
#define CY_CAPSENSE_BUTTON1_MAX_RAW_COUNT_OFFSET                                 (86u)
#define CY_CAPSENSE_BUTTON1_MAX_RAW_COUNT_SIZE                                   (2u)
#define CY_CAPSENSE_BUTTON1_MAX_RAW_COUNT_PARAM_ID                               (0x06010056u)

#define CY_CAPSENSE_BUTTON1_ROW_MAX_RAW_COUNT_VALUE                              (cy_capsense_tuner.widgetContext[1].maxRawCountRow)
#define CY_CAPSENSE_BUTTON1_ROW_MAX_RAW_COUNT_OFFSET                             (88u)
#define CY_CAPSENSE_BUTTON1_ROW_MAX_RAW_COUNT_SIZE                               (2u)
#define CY_CAPSENSE_BUTTON1_ROW_MAX_RAW_COUNT_PARAM_ID                           (0x06010058u)

#define CY_CAPSENSE_BUTTON1_FINGER_TH_VALUE                                      (cy_capsense_tuner.widgetContext[1].fingerTh)
#define CY_CAPSENSE_BUTTON1_FINGER_TH_OFFSET                                     (90u)
#define CY_CAPSENSE_BUTTON1_FINGER_TH_SIZE                                       (2u)
#define CY_CAPSENSE_BUTTON1_FINGER_TH_PARAM_ID                                   (0x0601005au)

#define CY_CAPSENSE_BUTTON1_PROX_TOUCH_TH_VALUE                                  (cy_capsense_tuner.widgetContext[1].proxTh)
#define CY_CAPSENSE_BUTTON1_PROX_TOUCH_TH_OFFSET                                 (92u)
#define CY_CAPSENSE_BUTTON1_PROX_TOUCH_TH_SIZE                                   (2u)
#define CY_CAPSENSE_BUTTON1_PROX_TOUCH_TH_PARAM_ID                               (0x0601005cu)

#define CY_CAPSENSE_BUTTON1_LOW_BSLN_RST_VALUE                                   (cy_capsense_tuner.widgetContext[1].lowBslnRst)
#define CY_CAPSENSE_BUTTON1_LOW_BSLN_RST_OFFSET                                  (94u)
#define CY_CAPSENSE_BUTTON1_LOW_BSLN_RST_SIZE                                    (2u)
#define CY_CAPSENSE_BUTTON1_LOW_BSLN_RST_PARAM_ID                                (0x0601005eu)

#define CY_CAPSENSE_BUTTON1_TX_CLK_VALUE                                         (cy_capsense_tuner.widgetContext[1].snsClk)
#define CY_CAPSENSE_BUTTON1_TX_CLK_OFFSET                                        (96u)
#define CY_CAPSENSE_BUTTON1_TX_CLK_SIZE                                          (2u)
#define CY_CAPSENSE_BUTTON1_TX_CLK_PARAM_ID                                      (0x06010060u)

#define CY_CAPSENSE_BUTTON1_ROW_SNS_CLK_VALUE                                    (cy_capsense_tuner.widgetContext[1].rowSnsClk)
#define CY_CAPSENSE_BUTTON1_ROW_SNS_CLK_OFFSET                                   (98u)
#define CY_CAPSENSE_BUTTON1_ROW_SNS_CLK_SIZE                                     (2u)
#define CY_CAPSENSE_BUTTON1_ROW_SNS_CLK_PARAM_ID                                 (0x06010062u)

#define CY_CAPSENSE_BUTTON1_GESTURE_DETECTED_VALUE                               (cy_capsense_tuner.widgetContext[1].gestureDetected)
#define CY_CAPSENSE_BUTTON1_GESTURE_DETECTED_OFFSET                              (100u)
#define CY_CAPSENSE_BUTTON1_GESTURE_DETECTED_SIZE                                (2u)
#define CY_CAPSENSE_BUTTON1_GESTURE_DETECTED_PARAM_ID                            (0x02010064u)

#define CY_CAPSENSE_BUTTON1_GESTURE_DIRECTION_VALUE                              (cy_capsense_tuner.widgetContext[1].gestureDirection)
#define CY_CAPSENSE_BUTTON1_GESTURE_DIRECTION_OFFSET                             (102u)
#define CY_CAPSENSE_BUTTON1_GESTURE_DIRECTION_SIZE                               (2u)
#define CY_CAPSENSE_BUTTON1_GESTURE_DIRECTION_PARAM_ID                           (0x02010066u)

#define CY_CAPSENSE_BUTTON1_XDELTA_VALUE                                         (cy_capsense_tuner.widgetContext[1].xDelta)
#define CY_CAPSENSE_BUTTON1_XDELTA_OFFSET                                        (104u)
#define CY_CAPSENSE_BUTTON1_XDELTA_SIZE                                          (2u)
#define CY_CAPSENSE_BUTTON1_XDELTA_PARAM_ID                                      (0x02010068u)

#define CY_CAPSENSE_BUTTON1_YDELTA_VALUE                                         (cy_capsense_tuner.widgetContext[1].yDelta)
#define CY_CAPSENSE_BUTTON1_YDELTA_OFFSET                                        (106u)
#define CY_CAPSENSE_BUTTON1_YDELTA_SIZE                                          (2u)
#define CY_CAPSENSE_BUTTON1_YDELTA_PARAM_ID                                      (0x0201006au)

#define CY_CAPSENSE_BUTTON1_NOISE_TH_VALUE                                       (cy_capsense_tuner.widgetContext[1].noiseTh)
#define CY_CAPSENSE_BUTTON1_NOISE_TH_OFFSET                                      (108u)
#define CY_CAPSENSE_BUTTON1_NOISE_TH_SIZE                                        (2u)
#define CY_CAPSENSE_BUTTON1_NOISE_TH_PARAM_ID                                    (0x0601006cu)

#define CY_CAPSENSE_BUTTON1_NNOISE_TH_VALUE                                      (cy_capsense_tuner.widgetContext[1].nNoiseTh)
#define CY_CAPSENSE_BUTTON1_NNOISE_TH_OFFSET                                     (110u)
#define CY_CAPSENSE_BUTTON1_NNOISE_TH_SIZE                                       (2u)
#define CY_CAPSENSE_BUTTON1_NNOISE_TH_PARAM_ID                                   (0x0601006eu)

#define CY_CAPSENSE_BUTTON1_HYSTERESIS_VALUE                                     (cy_capsense_tuner.widgetContext[1].hysteresis)
#define CY_CAPSENSE_BUTTON1_HYSTERESIS_OFFSET                                    (112u)
#define CY_CAPSENSE_BUTTON1_HYSTERESIS_SIZE                                      (2u)
#define CY_CAPSENSE_BUTTON1_HYSTERESIS_PARAM_ID                                  (0x06010070u)

#define CY_CAPSENSE_BUTTON1_ON_DEBOUNCE_VALUE                                    (cy_capsense_tuner.widgetContext[1].onDebounce)
#define CY_CAPSENSE_BUTTON1_ON_DEBOUNCE_OFFSET                                   (114u)
#define CY_CAPSENSE_BUTTON1_ON_DEBOUNCE_SIZE                                     (1u)
#define CY_CAPSENSE_BUTTON1_ON_DEBOUNCE_PARAM_ID                                 (0x05010072u)

#define CY_CAPSENSE_BUTTON1_TX_CLK_SOURCE_VALUE                                  (cy_capsense_tuner.widgetContext[1].snsClkSource)
#define CY_CAPSENSE_BUTTON1_TX_CLK_SOURCE_OFFSET                                 (115u)
#define CY_CAPSENSE_BUTTON1_TX_CLK_SOURCE_SIZE                                   (1u)
#define CY_CAPSENSE_BUTTON1_TX_CLK_SOURCE_PARAM_ID                               (0x05010073u)

#define CY_CAPSENSE_BUTTON1_IDAC_MOD0_VALUE                                      (cy_capsense_tuner.widgetContext[1].idacMod[0])
#define CY_CAPSENSE_BUTTON1_IDAC_MOD0_OFFSET                                     (116u)
#define CY_CAPSENSE_BUTTON1_IDAC_MOD0_SIZE                                       (1u)
#define CY_CAPSENSE_BUTTON1_IDAC_MOD0_PARAM_ID                                   (0x05010074u)

#define CY_CAPSENSE_BUTTON1_IDAC_MOD1_VALUE                                      (cy_capsense_tuner.widgetContext[1].idacMod[1])
#define CY_CAPSENSE_BUTTON1_IDAC_MOD1_OFFSET                                     (117u)
#define CY_CAPSENSE_BUTTON1_IDAC_MOD1_SIZE                                       (1u)
#define CY_CAPSENSE_BUTTON1_IDAC_MOD1_PARAM_ID                                   (0x05010075u)

#define CY_CAPSENSE_BUTTON1_IDAC_MOD2_VALUE                                      (cy_capsense_tuner.widgetContext[1].idacMod[2])
#define CY_CAPSENSE_BUTTON1_IDAC_MOD2_OFFSET                                     (118u)
#define CY_CAPSENSE_BUTTON1_IDAC_MOD2_SIZE                                       (1u)
#define CY_CAPSENSE_BUTTON1_IDAC_MOD2_PARAM_ID                                   (0x05010076u)

#define CY_CAPSENSE_BUTTON1_IDAC_GAIN_INDEX_VALUE                                (cy_capsense_tuner.widgetContext[1].idacGainIndex)
#define CY_CAPSENSE_BUTTON1_IDAC_GAIN_INDEX_OFFSET                               (119u)
#define CY_CAPSENSE_BUTTON1_IDAC_GAIN_INDEX_SIZE                                 (1u)
#define CY_CAPSENSE_BUTTON1_IDAC_GAIN_INDEX_PARAM_ID                             (0x05010077u)

#define CY_CAPSENSE_BUTTON1_ROW_IDAC_MOD0_VALUE                                  (cy_capsense_tuner.widgetContext[1].rowIdacMod[0])
#define CY_CAPSENSE_BUTTON1_ROW_IDAC_MOD0_OFFSET                                 (120u)
#define CY_CAPSENSE_BUTTON1_ROW_IDAC_MOD0_SIZE                                   (1u)
#define CY_CAPSENSE_BUTTON1_ROW_IDAC_MOD0_PARAM_ID                               (0x05010078u)

#define CY_CAPSENSE_BUTTON1_ROW_IDAC_MOD1_VALUE                                  (cy_capsense_tuner.widgetContext[1].rowIdacMod[1])
#define CY_CAPSENSE_BUTTON1_ROW_IDAC_MOD1_OFFSET                                 (121u)
#define CY_CAPSENSE_BUTTON1_ROW_IDAC_MOD1_SIZE                                   (1u)
#define CY_CAPSENSE_BUTTON1_ROW_IDAC_MOD1_PARAM_ID                               (0x05010079u)

#define CY_CAPSENSE_BUTTON1_ROW_IDAC_MOD2_VALUE                                  (cy_capsense_tuner.widgetContext[1].rowIdacMod[2])
#define CY_CAPSENSE_BUTTON1_ROW_IDAC_MOD2_OFFSET                                 (122u)
#define CY_CAPSENSE_BUTTON1_ROW_IDAC_MOD2_SIZE                                   (1u)
#define CY_CAPSENSE_BUTTON1_ROW_IDAC_MOD2_PARAM_ID                               (0x0501007au)

#define CY_CAPSENSE_BUTTON1_REGULAR_IIR_BL_N_VALUE                               (cy_capsense_tuner.widgetContext[1].bslnCoeff)
#define CY_CAPSENSE_BUTTON1_REGULAR_IIR_BL_N_OFFSET                              (123u)
#define CY_CAPSENSE_BUTTON1_REGULAR_IIR_BL_N_SIZE                                (1u)
#define CY_CAPSENSE_BUTTON1_REGULAR_IIR_BL_N_PARAM_ID                            (0x0501007bu)

#define CY_CAPSENSE_BUTTON1_STATUS_VALUE                                         (cy_capsense_tuner.widgetContext[1].status)
#define CY_CAPSENSE_BUTTON1_STATUS_OFFSET                                        (124u)
#define CY_CAPSENSE_BUTTON1_STATUS_SIZE                                          (1u)
#define CY_CAPSENSE_BUTTON1_STATUS_PARAM_ID                                      (0x0101007cu)

#define CY_CAPSENSE_BUTTON1_PTRPOSITION_VALUE                                    (cy_capsense_tuner.widgetContext[1].wdTouch.ptrPosition)
#define CY_CAPSENSE_BUTTON1_PTRPOSITION_OFFSET                                   (128u)
#define CY_CAPSENSE_BUTTON1_PTRPOSITION_SIZE                                     (4u)
#define CY_CAPSENSE_BUTTON1_PTRPOSITION_PARAM_ID                                 (0x03010080u)

#define CY_CAPSENSE_BUTTON1_NUM_POSITIONS_VALUE                                  (cy_capsense_tuner.widgetContext[1].wdTouch.numPosition)
#define CY_CAPSENSE_BUTTON1_NUM_POSITIONS_OFFSET                                 (132u)
#define CY_CAPSENSE_BUTTON1_NUM_POSITIONS_SIZE                                   (1u)
#define CY_CAPSENSE_BUTTON1_NUM_POSITIONS_PARAM_ID                               (0x01010084u)

#define CY_CAPSENSE_LINEARSLIDER0_FINGER_CP_VALUE                                (cy_capsense_tuner.widgetContext[2].fingerCap)
#define CY_CAPSENSE_LINEARSLIDER0_FINGER_CP_OFFSET                               (136u)
#define CY_CAPSENSE_LINEARSLIDER0_FINGER_CP_SIZE                                 (2u)
#define CY_CAPSENSE_LINEARSLIDER0_FINGER_CP_PARAM_ID                             (0x06020088u)

#define CY_CAPSENSE_LINEARSLIDER0_SIGPFC_VALUE                                   (cy_capsense_tuner.widgetContext[2].sigPFC)
#define CY_CAPSENSE_LINEARSLIDER0_SIGPFC_OFFSET                                  (138u)
#define CY_CAPSENSE_LINEARSLIDER0_SIGPFC_SIZE                                    (2u)
#define CY_CAPSENSE_LINEARSLIDER0_SIGPFC_PARAM_ID                                (0x0602008au)

#define CY_CAPSENSE_LINEARSLIDER0_RESOLUTION_VALUE                               (cy_capsense_tuner.widgetContext[2].resolution)
#define CY_CAPSENSE_LINEARSLIDER0_RESOLUTION_OFFSET                              (140u)
#define CY_CAPSENSE_LINEARSLIDER0_RESOLUTION_SIZE                                (2u)
#define CY_CAPSENSE_LINEARSLIDER0_RESOLUTION_PARAM_ID                            (0x0602008cu)

#define CY_CAPSENSE_LINEARSLIDER0_MAX_RAW_COUNT_VALUE                            (cy_capsense_tuner.widgetContext[2].maxRawCount)
#define CY_CAPSENSE_LINEARSLIDER0_MAX_RAW_COUNT_OFFSET                           (142u)
#define CY_CAPSENSE_LINEARSLIDER0_MAX_RAW_COUNT_SIZE                             (2u)
#define CY_CAPSENSE_LINEARSLIDER0_MAX_RAW_COUNT_PARAM_ID                         (0x0602008eu)

#define CY_CAPSENSE_LINEARSLIDER0_ROW_MAX_RAW_COUNT_VALUE                        (cy_capsense_tuner.widgetContext[2].maxRawCountRow)
#define CY_CAPSENSE_LINEARSLIDER0_ROW_MAX_RAW_COUNT_OFFSET                       (144u)
#define CY_CAPSENSE_LINEARSLIDER0_ROW_MAX_RAW_COUNT_SIZE                         (2u)
#define CY_CAPSENSE_LINEARSLIDER0_ROW_MAX_RAW_COUNT_PARAM_ID                     (0x06020090u)

#define CY_CAPSENSE_LINEARSLIDER0_FINGER_TH_VALUE                                (cy_capsense_tuner.widgetContext[2].fingerTh)
#define CY_CAPSENSE_LINEARSLIDER0_FINGER_TH_OFFSET                               (146u)
#define CY_CAPSENSE_LINEARSLIDER0_FINGER_TH_SIZE                                 (2u)
#define CY_CAPSENSE_LINEARSLIDER0_FINGER_TH_PARAM_ID                             (0x02020092u)

#define CY_CAPSENSE_LINEARSLIDER0_PROX_TOUCH_TH_VALUE                            (cy_capsense_tuner.widgetContext[2].proxTh)
#define CY_CAPSENSE_LINEARSLIDER0_PROX_TOUCH_TH_OFFSET                           (148u)
#define CY_CAPSENSE_LINEARSLIDER0_PROX_TOUCH_TH_SIZE                             (2u)
#define CY_CAPSENSE_LINEARSLIDER0_PROX_TOUCH_TH_PARAM_ID                         (0x02020094u)

#define CY_CAPSENSE_LINEARSLIDER0_LOW_BSLN_RST_VALUE                             (cy_capsense_tuner.widgetContext[2].lowBslnRst)
#define CY_CAPSENSE_LINEARSLIDER0_LOW_BSLN_RST_OFFSET                            (150u)
#define CY_CAPSENSE_LINEARSLIDER0_LOW_BSLN_RST_SIZE                              (2u)
#define CY_CAPSENSE_LINEARSLIDER0_LOW_BSLN_RST_PARAM_ID                          (0x06020096u)

#define CY_CAPSENSE_LINEARSLIDER0_SNS_CLK_VALUE                                  (cy_capsense_tuner.widgetContext[2].snsClk)
#define CY_CAPSENSE_LINEARSLIDER0_SNS_CLK_OFFSET                                 (152u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS_CLK_SIZE                                   (2u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS_CLK_PARAM_ID                               (0x06020098u)

#define CY_CAPSENSE_LINEARSLIDER0_ROW_SNS_CLK_VALUE                              (cy_capsense_tuner.widgetContext[2].rowSnsClk)
#define CY_CAPSENSE_LINEARSLIDER0_ROW_SNS_CLK_OFFSET                             (154u)
#define CY_CAPSENSE_LINEARSLIDER0_ROW_SNS_CLK_SIZE                               (2u)
#define CY_CAPSENSE_LINEARSLIDER0_ROW_SNS_CLK_PARAM_ID                           (0x0602009au)

#define CY_CAPSENSE_LINEARSLIDER0_GESTURE_DETECTED_VALUE                         (cy_capsense_tuner.widgetContext[2].gestureDetected)
#define CY_CAPSENSE_LINEARSLIDER0_GESTURE_DETECTED_OFFSET                        (156u)
#define CY_CAPSENSE_LINEARSLIDER0_GESTURE_DETECTED_SIZE                          (2u)
#define CY_CAPSENSE_LINEARSLIDER0_GESTURE_DETECTED_PARAM_ID                      (0x0202009cu)

#define CY_CAPSENSE_LINEARSLIDER0_GESTURE_DIRECTION_VALUE                        (cy_capsense_tuner.widgetContext[2].gestureDirection)
#define CY_CAPSENSE_LINEARSLIDER0_GESTURE_DIRECTION_OFFSET                       (158u)
#define CY_CAPSENSE_LINEARSLIDER0_GESTURE_DIRECTION_SIZE                         (2u)
#define CY_CAPSENSE_LINEARSLIDER0_GESTURE_DIRECTION_PARAM_ID                     (0x0202009eu)

#define CY_CAPSENSE_LINEARSLIDER0_XDELTA_VALUE                                   (cy_capsense_tuner.widgetContext[2].xDelta)
#define CY_CAPSENSE_LINEARSLIDER0_XDELTA_OFFSET                                  (160u)
#define CY_CAPSENSE_LINEARSLIDER0_XDELTA_SIZE                                    (2u)
#define CY_CAPSENSE_LINEARSLIDER0_XDELTA_PARAM_ID                                (0x020200a0u)

#define CY_CAPSENSE_LINEARSLIDER0_YDELTA_VALUE                                   (cy_capsense_tuner.widgetContext[2].yDelta)
#define CY_CAPSENSE_LINEARSLIDER0_YDELTA_OFFSET                                  (162u)
#define CY_CAPSENSE_LINEARSLIDER0_YDELTA_SIZE                                    (2u)
#define CY_CAPSENSE_LINEARSLIDER0_YDELTA_PARAM_ID                                (0x020200a2u)

#define CY_CAPSENSE_LINEARSLIDER0_NOISE_TH_VALUE                                 (cy_capsense_tuner.widgetContext[2].noiseTh)
#define CY_CAPSENSE_LINEARSLIDER0_NOISE_TH_OFFSET                                (164u)
#define CY_CAPSENSE_LINEARSLIDER0_NOISE_TH_SIZE                                  (2u)
#define CY_CAPSENSE_LINEARSLIDER0_NOISE_TH_PARAM_ID                              (0x020200a4u)

#define CY_CAPSENSE_LINEARSLIDER0_NNOISE_TH_VALUE                                (cy_capsense_tuner.widgetContext[2].nNoiseTh)
#define CY_CAPSENSE_LINEARSLIDER0_NNOISE_TH_OFFSET                               (166u)
#define CY_CAPSENSE_LINEARSLIDER0_NNOISE_TH_SIZE                                 (2u)
#define CY_CAPSENSE_LINEARSLIDER0_NNOISE_TH_PARAM_ID                             (0x020200a6u)

#define CY_CAPSENSE_LINEARSLIDER0_HYSTERESIS_VALUE                               (cy_capsense_tuner.widgetContext[2].hysteresis)
#define CY_CAPSENSE_LINEARSLIDER0_HYSTERESIS_OFFSET                              (168u)
#define CY_CAPSENSE_LINEARSLIDER0_HYSTERESIS_SIZE                                (2u)
#define CY_CAPSENSE_LINEARSLIDER0_HYSTERESIS_PARAM_ID                            (0x020200a8u)

#define CY_CAPSENSE_LINEARSLIDER0_ON_DEBOUNCE_VALUE                              (cy_capsense_tuner.widgetContext[2].onDebounce)
#define CY_CAPSENSE_LINEARSLIDER0_ON_DEBOUNCE_OFFSET                             (170u)
#define CY_CAPSENSE_LINEARSLIDER0_ON_DEBOUNCE_SIZE                               (1u)
#define CY_CAPSENSE_LINEARSLIDER0_ON_DEBOUNCE_PARAM_ID                           (0x050200aau)

#define CY_CAPSENSE_LINEARSLIDER0_SNS_CLK_SOURCE_VALUE                           (cy_capsense_tuner.widgetContext[2].snsClkSource)
#define CY_CAPSENSE_LINEARSLIDER0_SNS_CLK_SOURCE_OFFSET                          (171u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS_CLK_SOURCE_SIZE                            (1u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS_CLK_SOURCE_PARAM_ID                        (0x050200abu)

#define CY_CAPSENSE_LINEARSLIDER0_IDAC_MOD0_VALUE                                (cy_capsense_tuner.widgetContext[2].idacMod[0])
#define CY_CAPSENSE_LINEARSLIDER0_IDAC_MOD0_OFFSET                               (172u)
#define CY_CAPSENSE_LINEARSLIDER0_IDAC_MOD0_SIZE                                 (1u)
#define CY_CAPSENSE_LINEARSLIDER0_IDAC_MOD0_PARAM_ID                             (0x050200acu)

#define CY_CAPSENSE_LINEARSLIDER0_IDAC_MOD1_VALUE                                (cy_capsense_tuner.widgetContext[2].idacMod[1])
#define CY_CAPSENSE_LINEARSLIDER0_IDAC_MOD1_OFFSET                               (173u)
#define CY_CAPSENSE_LINEARSLIDER0_IDAC_MOD1_SIZE                                 (1u)
#define CY_CAPSENSE_LINEARSLIDER0_IDAC_MOD1_PARAM_ID                             (0x050200adu)

#define CY_CAPSENSE_LINEARSLIDER0_IDAC_MOD2_VALUE                                (cy_capsense_tuner.widgetContext[2].idacMod[2])
#define CY_CAPSENSE_LINEARSLIDER0_IDAC_MOD2_OFFSET                               (174u)
#define CY_CAPSENSE_LINEARSLIDER0_IDAC_MOD2_SIZE                                 (1u)
#define CY_CAPSENSE_LINEARSLIDER0_IDAC_MOD2_PARAM_ID                             (0x050200aeu)

#define CY_CAPSENSE_LINEARSLIDER0_IDAC_GAIN_INDEX_VALUE                          (cy_capsense_tuner.widgetContext[2].idacGainIndex)
#define CY_CAPSENSE_LINEARSLIDER0_IDAC_GAIN_INDEX_OFFSET                         (175u)
#define CY_CAPSENSE_LINEARSLIDER0_IDAC_GAIN_INDEX_SIZE                           (1u)
#define CY_CAPSENSE_LINEARSLIDER0_IDAC_GAIN_INDEX_PARAM_ID                       (0x050200afu)

#define CY_CAPSENSE_LINEARSLIDER0_ROW_IDAC_MOD0_VALUE                            (cy_capsense_tuner.widgetContext[2].rowIdacMod[0])
#define CY_CAPSENSE_LINEARSLIDER0_ROW_IDAC_MOD0_OFFSET                           (176u)
#define CY_CAPSENSE_LINEARSLIDER0_ROW_IDAC_MOD0_SIZE                             (1u)
#define CY_CAPSENSE_LINEARSLIDER0_ROW_IDAC_MOD0_PARAM_ID                         (0x050200b0u)

#define CY_CAPSENSE_LINEARSLIDER0_ROW_IDAC_MOD1_VALUE                            (cy_capsense_tuner.widgetContext[2].rowIdacMod[1])
#define CY_CAPSENSE_LINEARSLIDER0_ROW_IDAC_MOD1_OFFSET                           (177u)
#define CY_CAPSENSE_LINEARSLIDER0_ROW_IDAC_MOD1_SIZE                             (1u)
#define CY_CAPSENSE_LINEARSLIDER0_ROW_IDAC_MOD1_PARAM_ID                         (0x050200b1u)

#define CY_CAPSENSE_LINEARSLIDER0_ROW_IDAC_MOD2_VALUE                            (cy_capsense_tuner.widgetContext[2].rowIdacMod[2])
#define CY_CAPSENSE_LINEARSLIDER0_ROW_IDAC_MOD2_OFFSET                           (178u)
#define CY_CAPSENSE_LINEARSLIDER0_ROW_IDAC_MOD2_SIZE                             (1u)
#define CY_CAPSENSE_LINEARSLIDER0_ROW_IDAC_MOD2_PARAM_ID                         (0x050200b2u)

#define CY_CAPSENSE_LINEARSLIDER0_REGULAR_IIR_BL_N_VALUE                         (cy_capsense_tuner.widgetContext[2].bslnCoeff)
#define CY_CAPSENSE_LINEARSLIDER0_REGULAR_IIR_BL_N_OFFSET                        (179u)
#define CY_CAPSENSE_LINEARSLIDER0_REGULAR_IIR_BL_N_SIZE                          (1u)
#define CY_CAPSENSE_LINEARSLIDER0_REGULAR_IIR_BL_N_PARAM_ID                      (0x050200b3u)

#define CY_CAPSENSE_LINEARSLIDER0_STATUS_VALUE                                   (cy_capsense_tuner.widgetContext[2].status)
#define CY_CAPSENSE_LINEARSLIDER0_STATUS_OFFSET                                  (180u)
#define CY_CAPSENSE_LINEARSLIDER0_STATUS_SIZE                                    (1u)
#define CY_CAPSENSE_LINEARSLIDER0_STATUS_PARAM_ID                                (0x010200b4u)

#define CY_CAPSENSE_LINEARSLIDER0_PTRPOSITION_VALUE                              (cy_capsense_tuner.widgetContext[2].wdTouch.ptrPosition)
#define CY_CAPSENSE_LINEARSLIDER0_PTRPOSITION_OFFSET                             (184u)
#define CY_CAPSENSE_LINEARSLIDER0_PTRPOSITION_SIZE                               (4u)
#define CY_CAPSENSE_LINEARSLIDER0_PTRPOSITION_PARAM_ID                           (0x030200b8u)

#define CY_CAPSENSE_LINEARSLIDER0_NUM_POSITIONS_VALUE                            (cy_capsense_tuner.widgetContext[2].wdTouch.numPosition)
#define CY_CAPSENSE_LINEARSLIDER0_NUM_POSITIONS_OFFSET                           (188u)
#define CY_CAPSENSE_LINEARSLIDER0_NUM_POSITIONS_SIZE                             (1u)
#define CY_CAPSENSE_LINEARSLIDER0_NUM_POSITIONS_PARAM_ID                         (0x010200bcu)

#define CY_CAPSENSE_BUTTON0_RX0_RAW0_VALUE                                       (cy_capsense_tuner.sensorContext[0].raw)
#define CY_CAPSENSE_BUTTON0_RX0_RAW0_OFFSET                                      (192u)
#define CY_CAPSENSE_BUTTON0_RX0_RAW0_SIZE                                        (2u)
#define CY_CAPSENSE_BUTTON0_RX0_RAW0_PARAM_ID                                    (0x020000c0u)

#define CY_CAPSENSE_BUTTON0_RX0_BSLN0_VALUE                                      (cy_capsense_tuner.sensorContext[0].bsln)
#define CY_CAPSENSE_BUTTON0_RX0_BSLN0_OFFSET                                     (194u)
#define CY_CAPSENSE_BUTTON0_RX0_BSLN0_SIZE                                       (2u)
#define CY_CAPSENSE_BUTTON0_RX0_BSLN0_PARAM_ID                                   (0x020000c2u)

#define CY_CAPSENSE_BUTTON0_RX0_DIFF0_VALUE                                      (cy_capsense_tuner.sensorContext[0].diff)
#define CY_CAPSENSE_BUTTON0_RX0_DIFF0_OFFSET                                     (196u)
#define CY_CAPSENSE_BUTTON0_RX0_DIFF0_SIZE                                       (2u)
#define CY_CAPSENSE_BUTTON0_RX0_DIFF0_PARAM_ID                                   (0x020000c4u)

#define CY_CAPSENSE_BUTTON0_RX0_STATUS0_VALUE                                    (cy_capsense_tuner.sensorContext[0].status)
#define CY_CAPSENSE_BUTTON0_RX0_STATUS0_OFFSET                                   (198u)
#define CY_CAPSENSE_BUTTON0_RX0_STATUS0_SIZE                                     (1u)
#define CY_CAPSENSE_BUTTON0_RX0_STATUS0_PARAM_ID                                 (0x010000c6u)

#define CY_CAPSENSE_BUTTON0_RX0_NEG_BSLN_RST_CNT0_VALUE                          (cy_capsense_tuner.sensorContext[0].negBslnRstCnt)
#define CY_CAPSENSE_BUTTON0_RX0_NEG_BSLN_RST_CNT0_OFFSET                         (199u)
#define CY_CAPSENSE_BUTTON0_RX0_NEG_BSLN_RST_CNT0_SIZE                           (1u)
#define CY_CAPSENSE_BUTTON0_RX0_NEG_BSLN_RST_CNT0_PARAM_ID                       (0x010000c7u)

#define CY_CAPSENSE_BUTTON0_RX0_IDAC0_VALUE                                      (cy_capsense_tuner.sensorContext[0].idacComp)
#define CY_CAPSENSE_BUTTON0_RX0_IDAC0_OFFSET                                     (200u)
#define CY_CAPSENSE_BUTTON0_RX0_IDAC0_SIZE                                       (1u)
#define CY_CAPSENSE_BUTTON0_RX0_IDAC0_PARAM_ID                                   (0x010000c8u)

#define CY_CAPSENSE_BUTTON0_RX0_BSLN_EXT0_VALUE                                  (cy_capsense_tuner.sensorContext[0].bslnExt)
#define CY_CAPSENSE_BUTTON0_RX0_BSLN_EXT0_OFFSET                                 (201u)
#define CY_CAPSENSE_BUTTON0_RX0_BSLN_EXT0_SIZE                                   (1u)
#define CY_CAPSENSE_BUTTON0_RX0_BSLN_EXT0_PARAM_ID                               (0x010000c9u)

#define CY_CAPSENSE_BUTTON1_RX0_RAW0_VALUE                                       (cy_capsense_tuner.sensorContext[1].raw)
#define CY_CAPSENSE_BUTTON1_RX0_RAW0_OFFSET                                      (202u)
#define CY_CAPSENSE_BUTTON1_RX0_RAW0_SIZE                                        (2u)
#define CY_CAPSENSE_BUTTON1_RX0_RAW0_PARAM_ID                                    (0x020100cau)

#define CY_CAPSENSE_BUTTON1_RX0_BSLN0_VALUE                                      (cy_capsense_tuner.sensorContext[1].bsln)
#define CY_CAPSENSE_BUTTON1_RX0_BSLN0_OFFSET                                     (204u)
#define CY_CAPSENSE_BUTTON1_RX0_BSLN0_SIZE                                       (2u)
#define CY_CAPSENSE_BUTTON1_RX0_BSLN0_PARAM_ID                                   (0x020100ccu)

#define CY_CAPSENSE_BUTTON1_RX0_DIFF0_VALUE                                      (cy_capsense_tuner.sensorContext[1].diff)
#define CY_CAPSENSE_BUTTON1_RX0_DIFF0_OFFSET                                     (206u)
#define CY_CAPSENSE_BUTTON1_RX0_DIFF0_SIZE                                       (2u)
#define CY_CAPSENSE_BUTTON1_RX0_DIFF0_PARAM_ID                                   (0x020100ceu)

#define CY_CAPSENSE_BUTTON1_RX0_STATUS0_VALUE                                    (cy_capsense_tuner.sensorContext[1].status)
#define CY_CAPSENSE_BUTTON1_RX0_STATUS0_OFFSET                                   (208u)
#define CY_CAPSENSE_BUTTON1_RX0_STATUS0_SIZE                                     (1u)
#define CY_CAPSENSE_BUTTON1_RX0_STATUS0_PARAM_ID                                 (0x010100d0u)

#define CY_CAPSENSE_BUTTON1_RX0_NEG_BSLN_RST_CNT0_VALUE                          (cy_capsense_tuner.sensorContext[1].negBslnRstCnt)
#define CY_CAPSENSE_BUTTON1_RX0_NEG_BSLN_RST_CNT0_OFFSET                         (209u)
#define CY_CAPSENSE_BUTTON1_RX0_NEG_BSLN_RST_CNT0_SIZE                           (1u)
#define CY_CAPSENSE_BUTTON1_RX0_NEG_BSLN_RST_CNT0_PARAM_ID                       (0x010100d1u)

#define CY_CAPSENSE_BUTTON1_RX0_IDAC0_VALUE                                      (cy_capsense_tuner.sensorContext[1].idacComp)
#define CY_CAPSENSE_BUTTON1_RX0_IDAC0_OFFSET                                     (210u)
#define CY_CAPSENSE_BUTTON1_RX0_IDAC0_SIZE                                       (1u)
#define CY_CAPSENSE_BUTTON1_RX0_IDAC0_PARAM_ID                                   (0x010100d2u)

#define CY_CAPSENSE_BUTTON1_RX0_BSLN_EXT0_VALUE                                  (cy_capsense_tuner.sensorContext[1].bslnExt)
#define CY_CAPSENSE_BUTTON1_RX0_BSLN_EXT0_OFFSET                                 (211u)
#define CY_CAPSENSE_BUTTON1_RX0_BSLN_EXT0_SIZE                                   (1u)
#define CY_CAPSENSE_BUTTON1_RX0_BSLN_EXT0_PARAM_ID                               (0x010100d3u)

#define CY_CAPSENSE_LINEARSLIDER0_SNS0_RAW0_VALUE                                (cy_capsense_tuner.sensorContext[2].raw)
#define CY_CAPSENSE_LINEARSLIDER0_SNS0_RAW0_OFFSET                               (212u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS0_RAW0_SIZE                                 (2u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS0_RAW0_PARAM_ID                             (0x020200d4u)

#define CY_CAPSENSE_LINEARSLIDER0_SNS0_BSLN0_VALUE                               (cy_capsense_tuner.sensorContext[2].bsln)
#define CY_CAPSENSE_LINEARSLIDER0_SNS0_BSLN0_OFFSET                              (214u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS0_BSLN0_SIZE                                (2u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS0_BSLN0_PARAM_ID                            (0x020200d6u)

#define CY_CAPSENSE_LINEARSLIDER0_SNS0_DIFF0_VALUE                               (cy_capsense_tuner.sensorContext[2].diff)
#define CY_CAPSENSE_LINEARSLIDER0_SNS0_DIFF0_OFFSET                              (216u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS0_DIFF0_SIZE                                (2u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS0_DIFF0_PARAM_ID                            (0x020200d8u)

#define CY_CAPSENSE_LINEARSLIDER0_SNS0_STATUS0_VALUE                             (cy_capsense_tuner.sensorContext[2].status)
#define CY_CAPSENSE_LINEARSLIDER0_SNS0_STATUS0_OFFSET                            (218u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS0_STATUS0_SIZE                              (1u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS0_STATUS0_PARAM_ID                          (0x010200dau)

#define CY_CAPSENSE_LINEARSLIDER0_SNS0_NEG_BSLN_RST_CNT0_VALUE                   (cy_capsense_tuner.sensorContext[2].negBslnRstCnt)
#define CY_CAPSENSE_LINEARSLIDER0_SNS0_NEG_BSLN_RST_CNT0_OFFSET                  (219u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS0_NEG_BSLN_RST_CNT0_SIZE                    (1u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS0_NEG_BSLN_RST_CNT0_PARAM_ID                (0x010200dbu)

#define CY_CAPSENSE_LINEARSLIDER0_SNS0_IDAC0_VALUE                               (cy_capsense_tuner.sensorContext[2].idacComp)
#define CY_CAPSENSE_LINEARSLIDER0_SNS0_IDAC0_OFFSET                              (220u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS0_IDAC0_SIZE                                (1u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS0_IDAC0_PARAM_ID                            (0x010200dcu)

#define CY_CAPSENSE_LINEARSLIDER0_SNS0_BSLN_EXT0_VALUE                           (cy_capsense_tuner.sensorContext[2].bslnExt)
#define CY_CAPSENSE_LINEARSLIDER0_SNS0_BSLN_EXT0_OFFSET                          (221u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS0_BSLN_EXT0_SIZE                            (1u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS0_BSLN_EXT0_PARAM_ID                        (0x010200ddu)

#define CY_CAPSENSE_LINEARSLIDER0_SNS1_RAW0_VALUE                                (cy_capsense_tuner.sensorContext[3].raw)
#define CY_CAPSENSE_LINEARSLIDER0_SNS1_RAW0_OFFSET                               (222u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS1_RAW0_SIZE                                 (2u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS1_RAW0_PARAM_ID                             (0x020200deu)

#define CY_CAPSENSE_LINEARSLIDER0_SNS1_BSLN0_VALUE                               (cy_capsense_tuner.sensorContext[3].bsln)
#define CY_CAPSENSE_LINEARSLIDER0_SNS1_BSLN0_OFFSET                              (224u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS1_BSLN0_SIZE                                (2u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS1_BSLN0_PARAM_ID                            (0x020200e0u)

#define CY_CAPSENSE_LINEARSLIDER0_SNS1_DIFF0_VALUE                               (cy_capsense_tuner.sensorContext[3].diff)
#define CY_CAPSENSE_LINEARSLIDER0_SNS1_DIFF0_OFFSET                              (226u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS1_DIFF0_SIZE                                (2u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS1_DIFF0_PARAM_ID                            (0x020200e2u)

#define CY_CAPSENSE_LINEARSLIDER0_SNS1_STATUS0_VALUE                             (cy_capsense_tuner.sensorContext[3].status)
#define CY_CAPSENSE_LINEARSLIDER0_SNS1_STATUS0_OFFSET                            (228u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS1_STATUS0_SIZE                              (1u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS1_STATUS0_PARAM_ID                          (0x010200e4u)

#define CY_CAPSENSE_LINEARSLIDER0_SNS1_NEG_BSLN_RST_CNT0_VALUE                   (cy_capsense_tuner.sensorContext[3].negBslnRstCnt)
#define CY_CAPSENSE_LINEARSLIDER0_SNS1_NEG_BSLN_RST_CNT0_OFFSET                  (229u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS1_NEG_BSLN_RST_CNT0_SIZE                    (1u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS1_NEG_BSLN_RST_CNT0_PARAM_ID                (0x010200e5u)

#define CY_CAPSENSE_LINEARSLIDER0_SNS1_IDAC0_VALUE                               (cy_capsense_tuner.sensorContext[3].idacComp)
#define CY_CAPSENSE_LINEARSLIDER0_SNS1_IDAC0_OFFSET                              (230u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS1_IDAC0_SIZE                                (1u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS1_IDAC0_PARAM_ID                            (0x010200e6u)

#define CY_CAPSENSE_LINEARSLIDER0_SNS1_BSLN_EXT0_VALUE                           (cy_capsense_tuner.sensorContext[3].bslnExt)
#define CY_CAPSENSE_LINEARSLIDER0_SNS1_BSLN_EXT0_OFFSET                          (231u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS1_BSLN_EXT0_SIZE                            (1u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS1_BSLN_EXT0_PARAM_ID                        (0x010200e7u)

#define CY_CAPSENSE_LINEARSLIDER0_SNS2_RAW0_VALUE                                (cy_capsense_tuner.sensorContext[4].raw)
#define CY_CAPSENSE_LINEARSLIDER0_SNS2_RAW0_OFFSET                               (232u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS2_RAW0_SIZE                                 (2u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS2_RAW0_PARAM_ID                             (0x020200e8u)

#define CY_CAPSENSE_LINEARSLIDER0_SNS2_BSLN0_VALUE                               (cy_capsense_tuner.sensorContext[4].bsln)
#define CY_CAPSENSE_LINEARSLIDER0_SNS2_BSLN0_OFFSET                              (234u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS2_BSLN0_SIZE                                (2u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS2_BSLN0_PARAM_ID                            (0x020200eau)

#define CY_CAPSENSE_LINEARSLIDER0_SNS2_DIFF0_VALUE                               (cy_capsense_tuner.sensorContext[4].diff)
#define CY_CAPSENSE_LINEARSLIDER0_SNS2_DIFF0_OFFSET                              (236u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS2_DIFF0_SIZE                                (2u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS2_DIFF0_PARAM_ID                            (0x020200ecu)

#define CY_CAPSENSE_LINEARSLIDER0_SNS2_STATUS0_VALUE                             (cy_capsense_tuner.sensorContext[4].status)
#define CY_CAPSENSE_LINEARSLIDER0_SNS2_STATUS0_OFFSET                            (238u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS2_STATUS0_SIZE                              (1u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS2_STATUS0_PARAM_ID                          (0x010200eeu)

#define CY_CAPSENSE_LINEARSLIDER0_SNS2_NEG_BSLN_RST_CNT0_VALUE                   (cy_capsense_tuner.sensorContext[4].negBslnRstCnt)
#define CY_CAPSENSE_LINEARSLIDER0_SNS2_NEG_BSLN_RST_CNT0_OFFSET                  (239u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS2_NEG_BSLN_RST_CNT0_SIZE                    (1u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS2_NEG_BSLN_RST_CNT0_PARAM_ID                (0x010200efu)

#define CY_CAPSENSE_LINEARSLIDER0_SNS2_IDAC0_VALUE                               (cy_capsense_tuner.sensorContext[4].idacComp)
#define CY_CAPSENSE_LINEARSLIDER0_SNS2_IDAC0_OFFSET                              (240u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS2_IDAC0_SIZE                                (1u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS2_IDAC0_PARAM_ID                            (0x010200f0u)

#define CY_CAPSENSE_LINEARSLIDER0_SNS2_BSLN_EXT0_VALUE                           (cy_capsense_tuner.sensorContext[4].bslnExt)
#define CY_CAPSENSE_LINEARSLIDER0_SNS2_BSLN_EXT0_OFFSET                          (241u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS2_BSLN_EXT0_SIZE                            (1u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS2_BSLN_EXT0_PARAM_ID                        (0x010200f1u)

#define CY_CAPSENSE_LINEARSLIDER0_SNS3_RAW0_VALUE                                (cy_capsense_tuner.sensorContext[5].raw)
#define CY_CAPSENSE_LINEARSLIDER0_SNS3_RAW0_OFFSET                               (242u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS3_RAW0_SIZE                                 (2u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS3_RAW0_PARAM_ID                             (0x020200f2u)

#define CY_CAPSENSE_LINEARSLIDER0_SNS3_BSLN0_VALUE                               (cy_capsense_tuner.sensorContext[5].bsln)
#define CY_CAPSENSE_LINEARSLIDER0_SNS3_BSLN0_OFFSET                              (244u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS3_BSLN0_SIZE                                (2u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS3_BSLN0_PARAM_ID                            (0x020200f4u)

#define CY_CAPSENSE_LINEARSLIDER0_SNS3_DIFF0_VALUE                               (cy_capsense_tuner.sensorContext[5].diff)
#define CY_CAPSENSE_LINEARSLIDER0_SNS3_DIFF0_OFFSET                              (246u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS3_DIFF0_SIZE                                (2u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS3_DIFF0_PARAM_ID                            (0x020200f6u)

#define CY_CAPSENSE_LINEARSLIDER0_SNS3_STATUS0_VALUE                             (cy_capsense_tuner.sensorContext[5].status)
#define CY_CAPSENSE_LINEARSLIDER0_SNS3_STATUS0_OFFSET                            (248u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS3_STATUS0_SIZE                              (1u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS3_STATUS0_PARAM_ID                          (0x010200f8u)

#define CY_CAPSENSE_LINEARSLIDER0_SNS3_NEG_BSLN_RST_CNT0_VALUE                   (cy_capsense_tuner.sensorContext[5].negBslnRstCnt)
#define CY_CAPSENSE_LINEARSLIDER0_SNS3_NEG_BSLN_RST_CNT0_OFFSET                  (249u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS3_NEG_BSLN_RST_CNT0_SIZE                    (1u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS3_NEG_BSLN_RST_CNT0_PARAM_ID                (0x010200f9u)

#define CY_CAPSENSE_LINEARSLIDER0_SNS3_IDAC0_VALUE                               (cy_capsense_tuner.sensorContext[5].idacComp)
#define CY_CAPSENSE_LINEARSLIDER0_SNS3_IDAC0_OFFSET                              (250u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS3_IDAC0_SIZE                                (1u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS3_IDAC0_PARAM_ID                            (0x010200fau)

#define CY_CAPSENSE_LINEARSLIDER0_SNS3_BSLN_EXT0_VALUE                           (cy_capsense_tuner.sensorContext[5].bslnExt)
#define CY_CAPSENSE_LINEARSLIDER0_SNS3_BSLN_EXT0_OFFSET                          (251u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS3_BSLN_EXT0_SIZE                            (1u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS3_BSLN_EXT0_PARAM_ID                        (0x010200fbu)

#define CY_CAPSENSE_LINEARSLIDER0_SNS4_RAW0_VALUE                                (cy_capsense_tuner.sensorContext[6].raw)
#define CY_CAPSENSE_LINEARSLIDER0_SNS4_RAW0_OFFSET                               (252u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS4_RAW0_SIZE                                 (2u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS4_RAW0_PARAM_ID                             (0x020200fcu)

#define CY_CAPSENSE_LINEARSLIDER0_SNS4_BSLN0_VALUE                               (cy_capsense_tuner.sensorContext[6].bsln)
#define CY_CAPSENSE_LINEARSLIDER0_SNS4_BSLN0_OFFSET                              (254u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS4_BSLN0_SIZE                                (2u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS4_BSLN0_PARAM_ID                            (0x020200feu)

#define CY_CAPSENSE_LINEARSLIDER0_SNS4_DIFF0_VALUE                               (cy_capsense_tuner.sensorContext[6].diff)
#define CY_CAPSENSE_LINEARSLIDER0_SNS4_DIFF0_OFFSET                              (256u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS4_DIFF0_SIZE                                (2u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS4_DIFF0_PARAM_ID                            (0x02020100u)

#define CY_CAPSENSE_LINEARSLIDER0_SNS4_STATUS0_VALUE                             (cy_capsense_tuner.sensorContext[6].status)
#define CY_CAPSENSE_LINEARSLIDER0_SNS4_STATUS0_OFFSET                            (258u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS4_STATUS0_SIZE                              (1u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS4_STATUS0_PARAM_ID                          (0x01020102u)

#define CY_CAPSENSE_LINEARSLIDER0_SNS4_NEG_BSLN_RST_CNT0_VALUE                   (cy_capsense_tuner.sensorContext[6].negBslnRstCnt)
#define CY_CAPSENSE_LINEARSLIDER0_SNS4_NEG_BSLN_RST_CNT0_OFFSET                  (259u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS4_NEG_BSLN_RST_CNT0_SIZE                    (1u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS4_NEG_BSLN_RST_CNT0_PARAM_ID                (0x01020103u)

#define CY_CAPSENSE_LINEARSLIDER0_SNS4_IDAC0_VALUE                               (cy_capsense_tuner.sensorContext[6].idacComp)
#define CY_CAPSENSE_LINEARSLIDER0_SNS4_IDAC0_OFFSET                              (260u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS4_IDAC0_SIZE                                (1u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS4_IDAC0_PARAM_ID                            (0x01020104u)

#define CY_CAPSENSE_LINEARSLIDER0_SNS4_BSLN_EXT0_VALUE                           (cy_capsense_tuner.sensorContext[6].bslnExt)
#define CY_CAPSENSE_LINEARSLIDER0_SNS4_BSLN_EXT0_OFFSET                          (261u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS4_BSLN_EXT0_SIZE                            (1u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS4_BSLN_EXT0_PARAM_ID                        (0x01020105u)

#define CY_CAPSENSE_LINEARSLIDER0_X0_VALUE                                       (cy_capsense_tuner.position[0].x)
#define CY_CAPSENSE_LINEARSLIDER0_X0_OFFSET                                      (262u)
#define CY_CAPSENSE_LINEARSLIDER0_X0_SIZE                                        (2u)
#define CY_CAPSENSE_LINEARSLIDER0_X0_PARAM_ID                                    (0x02020106u)

#define CY_CAPSENSE_LINEARSLIDER0_Y0_VALUE                                       (cy_capsense_tuner.position[0].y)
#define CY_CAPSENSE_LINEARSLIDER0_Y0_OFFSET                                      (264u)
#define CY_CAPSENSE_LINEARSLIDER0_Y0_SIZE                                        (2u)
#define CY_CAPSENSE_LINEARSLIDER0_Y0_PARAM_ID                                    (0x02020108u)

#define CY_CAPSENSE_LINEARSLIDER0_Z0_VALUE                                       (cy_capsense_tuner.position[0].z)
#define CY_CAPSENSE_LINEARSLIDER0_Z0_OFFSET                                      (266u)
#define CY_CAPSENSE_LINEARSLIDER0_Z0_SIZE                                        (2u)
#define CY_CAPSENSE_LINEARSLIDER0_Z0_PARAM_ID                                    (0x0202010au)

#define CY_CAPSENSE_LINEARSLIDER0_ID0_VALUE                                      (cy_capsense_tuner.position[0].id)
#define CY_CAPSENSE_LINEARSLIDER0_ID0_OFFSET                                     (268u)
#define CY_CAPSENSE_LINEARSLIDER0_ID0_SIZE                                       (2u)
#define CY_CAPSENSE_LINEARSLIDER0_ID0_PARAM_ID                                   (0x0202010cu)

#elif (CY_CAPSENSE_MW_VERSION < 700)
#define CY_CAPSENSE_CONFIG_ID_VALUE                                              (cy_capsense_tuner.commonContext.configId)
#define CY_CAPSENSE_CONFIG_ID_OFFSET                                             (0u)
#define CY_CAPSENSE_CONFIG_ID_SIZE                                               (2u)
#define CY_CAPSENSE_CONFIG_ID_PARAM_ID                                           (0x02000000u)

#define CY_CAPSENSE_TUNER_CMD_VALUE                                              (cy_capsense_tuner.commonContext.tunerCmd)
#define CY_CAPSENSE_TUNER_CMD_OFFSET                                             (2u)
#define CY_CAPSENSE_TUNER_CMD_SIZE                                               (2u)
#define CY_CAPSENSE_TUNER_CMD_PARAM_ID                                           (0x02000002u)

#define CY_CAPSENSE_SCAN_COUNTER_VALUE                                           (cy_capsense_tuner.commonContext.scanCounter)
#define CY_CAPSENSE_SCAN_COUNTER_OFFSET                                          (4u)
#define CY_CAPSENSE_SCAN_COUNTER_SIZE                                            (2u)
#define CY_CAPSENSE_SCAN_COUNTER_PARAM_ID                                        (0x02000004u)

#define CY_CAPSENSE_TUNER_ST_VALUE                                               (cy_capsense_tuner.commonContext.tunerSt)
#define CY_CAPSENSE_TUNER_ST_OFFSET                                              (6u)
#define CY_CAPSENSE_TUNER_ST_SIZE                                                (1u)
#define CY_CAPSENSE_TUNER_ST_PARAM_ID                                            (0x01000006u)

#define CY_CAPSENSE_INITDONE_VALUE                                               (cy_capsense_tuner.commonContext.initDone)
#define CY_CAPSENSE_INITDONE_OFFSET                                              (7u)
#define CY_CAPSENSE_INITDONE_SIZE                                                (1u)
#define CY_CAPSENSE_INITDONE_PARAM_ID                                            (0x01000007u)

#define CY_CAPSENSE_STATUS_VALUE                                                 (cy_capsense_tuner.commonContext.status)
#define CY_CAPSENSE_STATUS_OFFSET                                                (8u)
#define CY_CAPSENSE_STATUS_SIZE                                                  (4u)
#define CY_CAPSENSE_STATUS_PARAM_ID                                              (0x03000008u)

#define CY_CAPSENSE_TIMESTAMPINTERVAL_VALUE                                      (cy_capsense_tuner.commonContext.timestampInterval)
#define CY_CAPSENSE_TIMESTAMPINTERVAL_OFFSET                                     (12u)
#define CY_CAPSENSE_TIMESTAMPINTERVAL_SIZE                                       (4u)
#define CY_CAPSENSE_TIMESTAMPINTERVAL_PARAM_ID                                   (0x0300000cu)

#define CY_CAPSENSE_TIMESTAMP_VALUE                                              (cy_capsense_tuner.commonContext.timestamp)
#define CY_CAPSENSE_TIMESTAMP_OFFSET                                             (16u)
#define CY_CAPSENSE_TIMESTAMP_SIZE                                               (4u)
#define CY_CAPSENSE_TIMESTAMP_PARAM_ID                                           (0x03000010u)

#define CY_CAPSENSE_CSD_MOD_CLK_DIVIDER_VALUE                                    (cy_capsense_tuner.commonContext.modCsdClk)
#define CY_CAPSENSE_CSD_MOD_CLK_DIVIDER_OFFSET                                   (20u)
#define CY_CAPSENSE_CSD_MOD_CLK_DIVIDER_SIZE                                     (1u)
#define CY_CAPSENSE_CSD_MOD_CLK_DIVIDER_PARAM_ID                                 (0x01000014u)

#define CY_CAPSENSE_CSX_MOD_CLK_DIVIDER_VALUE                                    (cy_capsense_tuner.commonContext.modCsxClk)
#define CY_CAPSENSE_CSX_MOD_CLK_DIVIDER_OFFSET                                   (21u)
#define CY_CAPSENSE_CSX_MOD_CLK_DIVIDER_SIZE                                     (1u)
#define CY_CAPSENSE_CSX_MOD_CLK_DIVIDER_PARAM_ID                                 (0x01000015u)

#define CY_CAPSENSE_TUNER_CNT_VALUE                                              (cy_capsense_tuner.commonContext.tunerCnt)
#define CY_CAPSENSE_TUNER_CNT_OFFSET                                             (22u)
#define CY_CAPSENSE_TUNER_CNT_SIZE                                               (1u)
#define CY_CAPSENSE_TUNER_CNT_PARAM_ID                                           (0x01000016u)

#define CY_CAPSENSE_BUTTON0_FINGER_CP_VALUE                                      (cy_capsense_tuner.widgetContext[0].fingerCap)
#define CY_CAPSENSE_BUTTON0_FINGER_CP_OFFSET                                     (24u)
#define CY_CAPSENSE_BUTTON0_FINGER_CP_SIZE                                       (2u)
#define CY_CAPSENSE_BUTTON0_FINGER_CP_PARAM_ID                                   (0x06000018u)

#define CY_CAPSENSE_BUTTON0_SIGPFC_VALUE                                         (cy_capsense_tuner.widgetContext[0].sigPFC)
#define CY_CAPSENSE_BUTTON0_SIGPFC_OFFSET                                        (26u)
#define CY_CAPSENSE_BUTTON0_SIGPFC_SIZE                                          (2u)
#define CY_CAPSENSE_BUTTON0_SIGPFC_PARAM_ID                                      (0x0600001au)

#define CY_CAPSENSE_BUTTON0_NUM_CONV_VALUE                                       (cy_capsense_tuner.widgetContext[0].resolution)
#define CY_CAPSENSE_BUTTON0_NUM_CONV_OFFSET                                      (28u)
#define CY_CAPSENSE_BUTTON0_NUM_CONV_SIZE                                        (2u)
#define CY_CAPSENSE_BUTTON0_NUM_CONV_PARAM_ID                                    (0x0600001cu)

#define CY_CAPSENSE_BUTTON0_MAX_RAW_COUNT_VALUE                                  (cy_capsense_tuner.widgetContext[0].maxRawCount)
#define CY_CAPSENSE_BUTTON0_MAX_RAW_COUNT_OFFSET                                 (30u)
#define CY_CAPSENSE_BUTTON0_MAX_RAW_COUNT_SIZE                                   (2u)
#define CY_CAPSENSE_BUTTON0_MAX_RAW_COUNT_PARAM_ID                               (0x0600001eu)

#define CY_CAPSENSE_BUTTON0_ROW_MAX_RAW_COUNT_VALUE                              (cy_capsense_tuner.widgetContext[0].maxRawCountRow)
#define CY_CAPSENSE_BUTTON0_ROW_MAX_RAW_COUNT_OFFSET                             (32u)
#define CY_CAPSENSE_BUTTON0_ROW_MAX_RAW_COUNT_SIZE                               (2u)
#define CY_CAPSENSE_BUTTON0_ROW_MAX_RAW_COUNT_PARAM_ID                           (0x06000020u)

#define CY_CAPSENSE_BUTTON0_FINGER_TH_VALUE                                      (cy_capsense_tuner.widgetContext[0].fingerTh)
#define CY_CAPSENSE_BUTTON0_FINGER_TH_OFFSET                                     (34u)
#define CY_CAPSENSE_BUTTON0_FINGER_TH_SIZE                                       (2u)
#define CY_CAPSENSE_BUTTON0_FINGER_TH_PARAM_ID                                   (0x06000022u)

#define CY_CAPSENSE_BUTTON0_PROX_TOUCH_TH_VALUE                                  (cy_capsense_tuner.widgetContext[0].proxTh)
#define CY_CAPSENSE_BUTTON0_PROX_TOUCH_TH_OFFSET                                 (36u)
#define CY_CAPSENSE_BUTTON0_PROX_TOUCH_TH_SIZE                                   (2u)
#define CY_CAPSENSE_BUTTON0_PROX_TOUCH_TH_PARAM_ID                               (0x06000024u)

#define CY_CAPSENSE_BUTTON0_LOW_BSLN_RST_VALUE                                   (cy_capsense_tuner.widgetContext[0].lowBslnRst)
#define CY_CAPSENSE_BUTTON0_LOW_BSLN_RST_OFFSET                                  (38u)
#define CY_CAPSENSE_BUTTON0_LOW_BSLN_RST_SIZE                                    (2u)
#define CY_CAPSENSE_BUTTON0_LOW_BSLN_RST_PARAM_ID                                (0x06000026u)

#define CY_CAPSENSE_BUTTON0_TX_CLK_VALUE                                         (cy_capsense_tuner.widgetContext[0].snsClk)
#define CY_CAPSENSE_BUTTON0_TX_CLK_OFFSET                                        (40u)
#define CY_CAPSENSE_BUTTON0_TX_CLK_SIZE                                          (2u)
#define CY_CAPSENSE_BUTTON0_TX_CLK_PARAM_ID                                      (0x06000028u)

#define CY_CAPSENSE_BUTTON0_ROW_SNS_CLK_VALUE                                    (cy_capsense_tuner.widgetContext[0].rowSnsClk)
#define CY_CAPSENSE_BUTTON0_ROW_SNS_CLK_OFFSET                                   (42u)
#define CY_CAPSENSE_BUTTON0_ROW_SNS_CLK_SIZE                                     (2u)
#define CY_CAPSENSE_BUTTON0_ROW_SNS_CLK_PARAM_ID                                 (0x0600002au)

#define CY_CAPSENSE_BUTTON0_GESTURE_DETECTED_VALUE                               (cy_capsense_tuner.widgetContext[0].gestureDetected)
#define CY_CAPSENSE_BUTTON0_GESTURE_DETECTED_OFFSET                              (44u)
#define CY_CAPSENSE_BUTTON0_GESTURE_DETECTED_SIZE                                (2u)
#define CY_CAPSENSE_BUTTON0_GESTURE_DETECTED_PARAM_ID                            (0x0200002cu)

#define CY_CAPSENSE_BUTTON0_GESTURE_DIRECTION_VALUE                              (cy_capsense_tuner.widgetContext[0].gestureDirection)
#define CY_CAPSENSE_BUTTON0_GESTURE_DIRECTION_OFFSET                             (46u)
#define CY_CAPSENSE_BUTTON0_GESTURE_DIRECTION_SIZE                               (2u)
#define CY_CAPSENSE_BUTTON0_GESTURE_DIRECTION_PARAM_ID                           (0x0200002eu)

#define CY_CAPSENSE_BUTTON0_XDELTA_VALUE                                         (cy_capsense_tuner.widgetContext[0].xDelta)
#define CY_CAPSENSE_BUTTON0_XDELTA_OFFSET                                        (48u)
#define CY_CAPSENSE_BUTTON0_XDELTA_SIZE                                          (2u)
#define CY_CAPSENSE_BUTTON0_XDELTA_PARAM_ID                                      (0x02000030u)

#define CY_CAPSENSE_BUTTON0_YDELTA_VALUE                                         (cy_capsense_tuner.widgetContext[0].yDelta)
#define CY_CAPSENSE_BUTTON0_YDELTA_OFFSET                                        (50u)
#define CY_CAPSENSE_BUTTON0_YDELTA_SIZE                                          (2u)
#define CY_CAPSENSE_BUTTON0_YDELTA_PARAM_ID                                      (0x02000032u)

#define CY_CAPSENSE_BUTTON0_NOISE_TH_VALUE                                       (cy_capsense_tuner.widgetContext[0].noiseTh)
#define CY_CAPSENSE_BUTTON0_NOISE_TH_OFFSET                                      (52u)
#define CY_CAPSENSE_BUTTON0_NOISE_TH_SIZE                                        (2u)
#define CY_CAPSENSE_BUTTON0_NOISE_TH_PARAM_ID                                    (0x06000034u)

#define CY_CAPSENSE_BUTTON0_NNOISE_TH_VALUE                                      (cy_capsense_tuner.widgetContext[0].nNoiseTh)
#define CY_CAPSENSE_BUTTON0_NNOISE_TH_OFFSET                                     (54u)
#define CY_CAPSENSE_BUTTON0_NNOISE_TH_SIZE                                       (2u)
#define CY_CAPSENSE_BUTTON0_NNOISE_TH_PARAM_ID                                   (0x06000036u)

#define CY_CAPSENSE_BUTTON0_HYSTERESIS_VALUE                                     (cy_capsense_tuner.widgetContext[0].hysteresis)
#define CY_CAPSENSE_BUTTON0_HYSTERESIS_OFFSET                                    (56u)
#define CY_CAPSENSE_BUTTON0_HYSTERESIS_SIZE                                      (2u)
#define CY_CAPSENSE_BUTTON0_HYSTERESIS_PARAM_ID                                  (0x06000038u)

#define CY_CAPSENSE_BUTTON0_ON_DEBOUNCE_VALUE                                    (cy_capsense_tuner.widgetContext[0].onDebounce)
#define CY_CAPSENSE_BUTTON0_ON_DEBOUNCE_OFFSET                                   (58u)
#define CY_CAPSENSE_BUTTON0_ON_DEBOUNCE_SIZE                                     (1u)
#define CY_CAPSENSE_BUTTON0_ON_DEBOUNCE_PARAM_ID                                 (0x0500003au)

#define CY_CAPSENSE_BUTTON0_TX_CLK_SOURCE_VALUE                                  (cy_capsense_tuner.widgetContext[0].snsClkSource)
#define CY_CAPSENSE_BUTTON0_TX_CLK_SOURCE_OFFSET                                 (59u)
#define CY_CAPSENSE_BUTTON0_TX_CLK_SOURCE_SIZE                                   (1u)
#define CY_CAPSENSE_BUTTON0_TX_CLK_SOURCE_PARAM_ID                               (0x0500003bu)

#define CY_CAPSENSE_BUTTON0_IDAC_MOD0_VALUE                                      (cy_capsense_tuner.widgetContext[0].idacMod[0])
#define CY_CAPSENSE_BUTTON0_IDAC_MOD0_OFFSET                                     (60u)
#define CY_CAPSENSE_BUTTON0_IDAC_MOD0_SIZE                                       (1u)
#define CY_CAPSENSE_BUTTON0_IDAC_MOD0_PARAM_ID                                   (0x0500003cu)

#define CY_CAPSENSE_BUTTON0_IDAC_MOD1_VALUE                                      (cy_capsense_tuner.widgetContext[0].idacMod[1])
#define CY_CAPSENSE_BUTTON0_IDAC_MOD1_OFFSET                                     (61u)
#define CY_CAPSENSE_BUTTON0_IDAC_MOD1_SIZE                                       (1u)
#define CY_CAPSENSE_BUTTON0_IDAC_MOD1_PARAM_ID                                   (0x0500003du)

#define CY_CAPSENSE_BUTTON0_IDAC_MOD2_VALUE                                      (cy_capsense_tuner.widgetContext[0].idacMod[2])
#define CY_CAPSENSE_BUTTON0_IDAC_MOD2_OFFSET                                     (62u)
#define CY_CAPSENSE_BUTTON0_IDAC_MOD2_SIZE                                       (1u)
#define CY_CAPSENSE_BUTTON0_IDAC_MOD2_PARAM_ID                                   (0x0500003eu)

#define CY_CAPSENSE_BUTTON0_IDAC_GAIN_INDEX_VALUE                                (cy_capsense_tuner.widgetContext[0].idacGainIndex)
#define CY_CAPSENSE_BUTTON0_IDAC_GAIN_INDEX_OFFSET                               (63u)
#define CY_CAPSENSE_BUTTON0_IDAC_GAIN_INDEX_SIZE                                 (1u)
#define CY_CAPSENSE_BUTTON0_IDAC_GAIN_INDEX_PARAM_ID                             (0x0500003fu)

#define CY_CAPSENSE_BUTTON0_ROW_IDAC_MOD0_VALUE                                  (cy_capsense_tuner.widgetContext[0].rowIdacMod[0])
#define CY_CAPSENSE_BUTTON0_ROW_IDAC_MOD0_OFFSET                                 (64u)
#define CY_CAPSENSE_BUTTON0_ROW_IDAC_MOD0_SIZE                                   (1u)
#define CY_CAPSENSE_BUTTON0_ROW_IDAC_MOD0_PARAM_ID                               (0x05000040u)

#define CY_CAPSENSE_BUTTON0_ROW_IDAC_MOD1_VALUE                                  (cy_capsense_tuner.widgetContext[0].rowIdacMod[1])
#define CY_CAPSENSE_BUTTON0_ROW_IDAC_MOD1_OFFSET                                 (65u)
#define CY_CAPSENSE_BUTTON0_ROW_IDAC_MOD1_SIZE                                   (1u)
#define CY_CAPSENSE_BUTTON0_ROW_IDAC_MOD1_PARAM_ID                               (0x05000041u)

#define CY_CAPSENSE_BUTTON0_ROW_IDAC_MOD2_VALUE                                  (cy_capsense_tuner.widgetContext[0].rowIdacMod[2])
#define CY_CAPSENSE_BUTTON0_ROW_IDAC_MOD2_OFFSET                                 (66u)
#define CY_CAPSENSE_BUTTON0_ROW_IDAC_MOD2_SIZE                                   (1u)
#define CY_CAPSENSE_BUTTON0_ROW_IDAC_MOD2_PARAM_ID                               (0x05000042u)

#define CY_CAPSENSE_BUTTON0_REGULAR_IIR_BL_N_VALUE                               (cy_capsense_tuner.widgetContext[0].bslnCoeff)
#define CY_CAPSENSE_BUTTON0_REGULAR_IIR_BL_N_OFFSET                              (67u)
#define CY_CAPSENSE_BUTTON0_REGULAR_IIR_BL_N_SIZE                                (1u)
#define CY_CAPSENSE_BUTTON0_REGULAR_IIR_BL_N_PARAM_ID                            (0x05000043u)

#define CY_CAPSENSE_BUTTON0_STATUS_VALUE                                         (cy_capsense_tuner.widgetContext[0].status)
#define CY_CAPSENSE_BUTTON0_STATUS_OFFSET                                        (68u)
#define CY_CAPSENSE_BUTTON0_STATUS_SIZE                                          (1u)
#define CY_CAPSENSE_BUTTON0_STATUS_PARAM_ID                                      (0x01000044u)

#define CY_CAPSENSE_BUTTON0_PTRPOSITION_VALUE                                    (cy_capsense_tuner.widgetContext[0].wdTouch.ptrPosition)
#define CY_CAPSENSE_BUTTON0_PTRPOSITION_OFFSET                                   (72u)
#define CY_CAPSENSE_BUTTON0_PTRPOSITION_SIZE                                     (4u)
#define CY_CAPSENSE_BUTTON0_PTRPOSITION_PARAM_ID                                 (0x03000048u)

#define CY_CAPSENSE_BUTTON0_NUM_POSITIONS_VALUE                                  (cy_capsense_tuner.widgetContext[0].wdTouch.numPosition)
#define CY_CAPSENSE_BUTTON0_NUM_POSITIONS_OFFSET                                 (76u)
#define CY_CAPSENSE_BUTTON0_NUM_POSITIONS_SIZE                                   (1u)
#define CY_CAPSENSE_BUTTON0_NUM_POSITIONS_PARAM_ID                               (0x0100004cu)

#define CY_CAPSENSE_BUTTON1_FINGER_CP_VALUE                                      (cy_capsense_tuner.widgetContext[1].fingerCap)
#define CY_CAPSENSE_BUTTON1_FINGER_CP_OFFSET                                     (80u)
#define CY_CAPSENSE_BUTTON1_FINGER_CP_SIZE                                       (2u)
#define CY_CAPSENSE_BUTTON1_FINGER_CP_PARAM_ID                                   (0x06010050u)

#define CY_CAPSENSE_BUTTON1_SIGPFC_VALUE                                         (cy_capsense_tuner.widgetContext[1].sigPFC)
#define CY_CAPSENSE_BUTTON1_SIGPFC_OFFSET                                        (82u)
#define CY_CAPSENSE_BUTTON1_SIGPFC_SIZE                                          (2u)
#define CY_CAPSENSE_BUTTON1_SIGPFC_PARAM_ID                                      (0x06010052u)

#define CY_CAPSENSE_BUTTON1_NUM_CONV_VALUE                                       (cy_capsense_tuner.widgetContext[1].resolution)
#define CY_CAPSENSE_BUTTON1_NUM_CONV_OFFSET                                      (84u)
#define CY_CAPSENSE_BUTTON1_NUM_CONV_SIZE                                        (2u)
#define CY_CAPSENSE_BUTTON1_NUM_CONV_PARAM_ID                                    (0x06010054u)

#define CY_CAPSENSE_BUTTON1_MAX_RAW_COUNT_VALUE                                  (cy_capsense_tuner.widgetContext[1].maxRawCount)
#define CY_CAPSENSE_BUTTON1_MAX_RAW_COUNT_OFFSET                                 (86u)
#define CY_CAPSENSE_BUTTON1_MAX_RAW_COUNT_SIZE                                   (2u)
#define CY_CAPSENSE_BUTTON1_MAX_RAW_COUNT_PARAM_ID                               (0x06010056u)

#define CY_CAPSENSE_BUTTON1_ROW_MAX_RAW_COUNT_VALUE                              (cy_capsense_tuner.widgetContext[1].maxRawCountRow)
#define CY_CAPSENSE_BUTTON1_ROW_MAX_RAW_COUNT_OFFSET                             (88u)
#define CY_CAPSENSE_BUTTON1_ROW_MAX_RAW_COUNT_SIZE                               (2u)
#define CY_CAPSENSE_BUTTON1_ROW_MAX_RAW_COUNT_PARAM_ID                           (0x06010058u)

#define CY_CAPSENSE_BUTTON1_FINGER_TH_VALUE                                      (cy_capsense_tuner.widgetContext[1].fingerTh)
#define CY_CAPSENSE_BUTTON1_FINGER_TH_OFFSET                                     (90u)
#define CY_CAPSENSE_BUTTON1_FINGER_TH_SIZE                                       (2u)
#define CY_CAPSENSE_BUTTON1_FINGER_TH_PARAM_ID                                   (0x0601005au)

#define CY_CAPSENSE_BUTTON1_PROX_TOUCH_TH_VALUE                                  (cy_capsense_tuner.widgetContext[1].proxTh)
#define CY_CAPSENSE_BUTTON1_PROX_TOUCH_TH_OFFSET                                 (92u)
#define CY_CAPSENSE_BUTTON1_PROX_TOUCH_TH_SIZE                                   (2u)
#define CY_CAPSENSE_BUTTON1_PROX_TOUCH_TH_PARAM_ID                               (0x0601005cu)

#define CY_CAPSENSE_BUTTON1_LOW_BSLN_RST_VALUE                                   (cy_capsense_tuner.widgetContext[1].lowBslnRst)
#define CY_CAPSENSE_BUTTON1_LOW_BSLN_RST_OFFSET                                  (94u)
#define CY_CAPSENSE_BUTTON1_LOW_BSLN_RST_SIZE                                    (2u)
#define CY_CAPSENSE_BUTTON1_LOW_BSLN_RST_PARAM_ID                                (0x0601005eu)

#define CY_CAPSENSE_BUTTON1_TX_CLK_VALUE                                         (cy_capsense_tuner.widgetContext[1].snsClk)
#define CY_CAPSENSE_BUTTON1_TX_CLK_OFFSET                                        (96u)
#define CY_CAPSENSE_BUTTON1_TX_CLK_SIZE                                          (2u)
#define CY_CAPSENSE_BUTTON1_TX_CLK_PARAM_ID                                      (0x06010060u)

#define CY_CAPSENSE_BUTTON1_ROW_SNS_CLK_VALUE                                    (cy_capsense_tuner.widgetContext[1].rowSnsClk)
#define CY_CAPSENSE_BUTTON1_ROW_SNS_CLK_OFFSET                                   (98u)
#define CY_CAPSENSE_BUTTON1_ROW_SNS_CLK_SIZE                                     (2u)
#define CY_CAPSENSE_BUTTON1_ROW_SNS_CLK_PARAM_ID                                 (0x06010062u)

#define CY_CAPSENSE_BUTTON1_GESTURE_DETECTED_VALUE                               (cy_capsense_tuner.widgetContext[1].gestureDetected)
#define CY_CAPSENSE_BUTTON1_GESTURE_DETECTED_OFFSET                              (100u)
#define CY_CAPSENSE_BUTTON1_GESTURE_DETECTED_SIZE                                (2u)
#define CY_CAPSENSE_BUTTON1_GESTURE_DETECTED_PARAM_ID                            (0x02010064u)

#define CY_CAPSENSE_BUTTON1_GESTURE_DIRECTION_VALUE                              (cy_capsense_tuner.widgetContext[1].gestureDirection)
#define CY_CAPSENSE_BUTTON1_GESTURE_DIRECTION_OFFSET                             (102u)
#define CY_CAPSENSE_BUTTON1_GESTURE_DIRECTION_SIZE                               (2u)
#define CY_CAPSENSE_BUTTON1_GESTURE_DIRECTION_PARAM_ID                           (0x02010066u)

#define CY_CAPSENSE_BUTTON1_XDELTA_VALUE                                         (cy_capsense_tuner.widgetContext[1].xDelta)
#define CY_CAPSENSE_BUTTON1_XDELTA_OFFSET                                        (104u)
#define CY_CAPSENSE_BUTTON1_XDELTA_SIZE                                          (2u)
#define CY_CAPSENSE_BUTTON1_XDELTA_PARAM_ID                                      (0x02010068u)

#define CY_CAPSENSE_BUTTON1_YDELTA_VALUE                                         (cy_capsense_tuner.widgetContext[1].yDelta)
#define CY_CAPSENSE_BUTTON1_YDELTA_OFFSET                                        (106u)
#define CY_CAPSENSE_BUTTON1_YDELTA_SIZE                                          (2u)
#define CY_CAPSENSE_BUTTON1_YDELTA_PARAM_ID                                      (0x0201006au)

#define CY_CAPSENSE_BUTTON1_NOISE_TH_VALUE                                       (cy_capsense_tuner.widgetContext[1].noiseTh)
#define CY_CAPSENSE_BUTTON1_NOISE_TH_OFFSET                                      (108u)
#define CY_CAPSENSE_BUTTON1_NOISE_TH_SIZE                                        (2u)
#define CY_CAPSENSE_BUTTON1_NOISE_TH_PARAM_ID                                    (0x0601006cu)

#define CY_CAPSENSE_BUTTON1_NNOISE_TH_VALUE                                      (cy_capsense_tuner.widgetContext[1].nNoiseTh)
#define CY_CAPSENSE_BUTTON1_NNOISE_TH_OFFSET                                     (110u)
#define CY_CAPSENSE_BUTTON1_NNOISE_TH_SIZE                                       (2u)
#define CY_CAPSENSE_BUTTON1_NNOISE_TH_PARAM_ID                                   (0x0601006eu)

#define CY_CAPSENSE_BUTTON1_HYSTERESIS_VALUE                                     (cy_capsense_tuner.widgetContext[1].hysteresis)
#define CY_CAPSENSE_BUTTON1_HYSTERESIS_OFFSET                                    (112u)
#define CY_CAPSENSE_BUTTON1_HYSTERESIS_SIZE                                      (2u)
#define CY_CAPSENSE_BUTTON1_HYSTERESIS_PARAM_ID                                  (0x06010070u)

#define CY_CAPSENSE_BUTTON1_ON_DEBOUNCE_VALUE                                    (cy_capsense_tuner.widgetContext[1].onDebounce)
#define CY_CAPSENSE_BUTTON1_ON_DEBOUNCE_OFFSET                                   (114u)
#define CY_CAPSENSE_BUTTON1_ON_DEBOUNCE_SIZE                                     (1u)
#define CY_CAPSENSE_BUTTON1_ON_DEBOUNCE_PARAM_ID                                 (0x05010072u)

#define CY_CAPSENSE_BUTTON1_TX_CLK_SOURCE_VALUE                                  (cy_capsense_tuner.widgetContext[1].snsClkSource)
#define CY_CAPSENSE_BUTTON1_TX_CLK_SOURCE_OFFSET                                 (115u)
#define CY_CAPSENSE_BUTTON1_TX_CLK_SOURCE_SIZE                                   (1u)
#define CY_CAPSENSE_BUTTON1_TX_CLK_SOURCE_PARAM_ID                               (0x05010073u)

#define CY_CAPSENSE_BUTTON1_IDAC_MOD0_VALUE                                      (cy_capsense_tuner.widgetContext[1].idacMod[0])
#define CY_CAPSENSE_BUTTON1_IDAC_MOD0_OFFSET                                     (116u)
#define CY_CAPSENSE_BUTTON1_IDAC_MOD0_SIZE                                       (1u)
#define CY_CAPSENSE_BUTTON1_IDAC_MOD0_PARAM_ID                                   (0x05010074u)

#define CY_CAPSENSE_BUTTON1_IDAC_MOD1_VALUE                                      (cy_capsense_tuner.widgetContext[1].idacMod[1])
#define CY_CAPSENSE_BUTTON1_IDAC_MOD1_OFFSET                                     (117u)
#define CY_CAPSENSE_BUTTON1_IDAC_MOD1_SIZE                                       (1u)
#define CY_CAPSENSE_BUTTON1_IDAC_MOD1_PARAM_ID                                   (0x05010075u)

#define CY_CAPSENSE_BUTTON1_IDAC_MOD2_VALUE                                      (cy_capsense_tuner.widgetContext[1].idacMod[2])
#define CY_CAPSENSE_BUTTON1_IDAC_MOD2_OFFSET                                     (118u)
#define CY_CAPSENSE_BUTTON1_IDAC_MOD2_SIZE                                       (1u)
#define CY_CAPSENSE_BUTTON1_IDAC_MOD2_PARAM_ID                                   (0x05010076u)

#define CY_CAPSENSE_BUTTON1_IDAC_GAIN_INDEX_VALUE                                (cy_capsense_tuner.widgetContext[1].idacGainIndex)
#define CY_CAPSENSE_BUTTON1_IDAC_GAIN_INDEX_OFFSET                               (119u)
#define CY_CAPSENSE_BUTTON1_IDAC_GAIN_INDEX_SIZE                                 (1u)
#define CY_CAPSENSE_BUTTON1_IDAC_GAIN_INDEX_PARAM_ID                             (0x05010077u)

#define CY_CAPSENSE_BUTTON1_ROW_IDAC_MOD0_VALUE                                  (cy_capsense_tuner.widgetContext[1].rowIdacMod[0])
#define CY_CAPSENSE_BUTTON1_ROW_IDAC_MOD0_OFFSET                                 (120u)
#define CY_CAPSENSE_BUTTON1_ROW_IDAC_MOD0_SIZE                                   (1u)
#define CY_CAPSENSE_BUTTON1_ROW_IDAC_MOD0_PARAM_ID                               (0x05010078u)

#define CY_CAPSENSE_BUTTON1_ROW_IDAC_MOD1_VALUE                                  (cy_capsense_tuner.widgetContext[1].rowIdacMod[1])
#define CY_CAPSENSE_BUTTON1_ROW_IDAC_MOD1_OFFSET                                 (121u)
#define CY_CAPSENSE_BUTTON1_ROW_IDAC_MOD1_SIZE                                   (1u)
#define CY_CAPSENSE_BUTTON1_ROW_IDAC_MOD1_PARAM_ID                               (0x05010079u)

#define CY_CAPSENSE_BUTTON1_ROW_IDAC_MOD2_VALUE                                  (cy_capsense_tuner.widgetContext[1].rowIdacMod[2])
#define CY_CAPSENSE_BUTTON1_ROW_IDAC_MOD2_OFFSET                                 (122u)
#define CY_CAPSENSE_BUTTON1_ROW_IDAC_MOD2_SIZE                                   (1u)
#define CY_CAPSENSE_BUTTON1_ROW_IDAC_MOD2_PARAM_ID                               (0x0501007au)

#define CY_CAPSENSE_BUTTON1_REGULAR_IIR_BL_N_VALUE                               (cy_capsense_tuner.widgetContext[1].bslnCoeff)
#define CY_CAPSENSE_BUTTON1_REGULAR_IIR_BL_N_OFFSET                              (123u)
#define CY_CAPSENSE_BUTTON1_REGULAR_IIR_BL_N_SIZE                                (1u)
#define CY_CAPSENSE_BUTTON1_REGULAR_IIR_BL_N_PARAM_ID                            (0x0501007bu)

#define CY_CAPSENSE_BUTTON1_STATUS_VALUE                                         (cy_capsense_tuner.widgetContext[1].status)
#define CY_CAPSENSE_BUTTON1_STATUS_OFFSET                                        (124u)
#define CY_CAPSENSE_BUTTON1_STATUS_SIZE                                          (1u)
#define CY_CAPSENSE_BUTTON1_STATUS_PARAM_ID                                      (0x0101007cu)

#define CY_CAPSENSE_BUTTON1_PTRPOSITION_VALUE                                    (cy_capsense_tuner.widgetContext[1].wdTouch.ptrPosition)
#define CY_CAPSENSE_BUTTON1_PTRPOSITION_OFFSET                                   (128u)
#define CY_CAPSENSE_BUTTON1_PTRPOSITION_SIZE                                     (4u)
#define CY_CAPSENSE_BUTTON1_PTRPOSITION_PARAM_ID                                 (0x03010080u)

#define CY_CAPSENSE_BUTTON1_NUM_POSITIONS_VALUE                                  (cy_capsense_tuner.widgetContext[1].wdTouch.numPosition)
#define CY_CAPSENSE_BUTTON1_NUM_POSITIONS_OFFSET                                 (132u)
#define CY_CAPSENSE_BUTTON1_NUM_POSITIONS_SIZE                                   (1u)
#define CY_CAPSENSE_BUTTON1_NUM_POSITIONS_PARAM_ID                               (0x01010084u)

#define CY_CAPSENSE_LINEARSLIDER0_FINGER_CP_VALUE                                (cy_capsense_tuner.widgetContext[2].fingerCap)
#define CY_CAPSENSE_LINEARSLIDER0_FINGER_CP_OFFSET                               (136u)
#define CY_CAPSENSE_LINEARSLIDER0_FINGER_CP_SIZE                                 (2u)
#define CY_CAPSENSE_LINEARSLIDER0_FINGER_CP_PARAM_ID                             (0x06020088u)

#define CY_CAPSENSE_LINEARSLIDER0_SIGPFC_VALUE                                   (cy_capsense_tuner.widgetContext[2].sigPFC)
#define CY_CAPSENSE_LINEARSLIDER0_SIGPFC_OFFSET                                  (138u)
#define CY_CAPSENSE_LINEARSLIDER0_SIGPFC_SIZE                                    (2u)
#define CY_CAPSENSE_LINEARSLIDER0_SIGPFC_PARAM_ID                                (0x0602008au)

#define CY_CAPSENSE_LINEARSLIDER0_RESOLUTION_VALUE                               (cy_capsense_tuner.widgetContext[2].resolution)
#define CY_CAPSENSE_LINEARSLIDER0_RESOLUTION_OFFSET                              (140u)
#define CY_CAPSENSE_LINEARSLIDER0_RESOLUTION_SIZE                                (2u)
#define CY_CAPSENSE_LINEARSLIDER0_RESOLUTION_PARAM_ID                            (0x0602008cu)

#define CY_CAPSENSE_LINEARSLIDER0_MAX_RAW_COUNT_VALUE                            (cy_capsense_tuner.widgetContext[2].maxRawCount)
#define CY_CAPSENSE_LINEARSLIDER0_MAX_RAW_COUNT_OFFSET                           (142u)
#define CY_CAPSENSE_LINEARSLIDER0_MAX_RAW_COUNT_SIZE                             (2u)
#define CY_CAPSENSE_LINEARSLIDER0_MAX_RAW_COUNT_PARAM_ID                         (0x0602008eu)

#define CY_CAPSENSE_LINEARSLIDER0_ROW_MAX_RAW_COUNT_VALUE                        (cy_capsense_tuner.widgetContext[2].maxRawCountRow)
#define CY_CAPSENSE_LINEARSLIDER0_ROW_MAX_RAW_COUNT_OFFSET                       (144u)
#define CY_CAPSENSE_LINEARSLIDER0_ROW_MAX_RAW_COUNT_SIZE                         (2u)
#define CY_CAPSENSE_LINEARSLIDER0_ROW_MAX_RAW_COUNT_PARAM_ID                     (0x06020090u)

#define CY_CAPSENSE_LINEARSLIDER0_FINGER_TH_VALUE                                (cy_capsense_tuner.widgetContext[2].fingerTh)
#define CY_CAPSENSE_LINEARSLIDER0_FINGER_TH_OFFSET                               (146u)
#define CY_CAPSENSE_LINEARSLIDER0_FINGER_TH_SIZE                                 (2u)
#define CY_CAPSENSE_LINEARSLIDER0_FINGER_TH_PARAM_ID                             (0x02020092u)

#define CY_CAPSENSE_LINEARSLIDER0_PROX_TOUCH_TH_VALUE                            (cy_capsense_tuner.widgetContext[2].proxTh)
#define CY_CAPSENSE_LINEARSLIDER0_PROX_TOUCH_TH_OFFSET                           (148u)
#define CY_CAPSENSE_LINEARSLIDER0_PROX_TOUCH_TH_SIZE                             (2u)
#define CY_CAPSENSE_LINEARSLIDER0_PROX_TOUCH_TH_PARAM_ID                         (0x02020094u)

#define CY_CAPSENSE_LINEARSLIDER0_LOW_BSLN_RST_VALUE                             (cy_capsense_tuner.widgetContext[2].lowBslnRst)
#define CY_CAPSENSE_LINEARSLIDER0_LOW_BSLN_RST_OFFSET                            (150u)
#define CY_CAPSENSE_LINEARSLIDER0_LOW_BSLN_RST_SIZE                              (2u)
#define CY_CAPSENSE_LINEARSLIDER0_LOW_BSLN_RST_PARAM_ID                          (0x06020096u)

#define CY_CAPSENSE_LINEARSLIDER0_SNS_CLK_VALUE                                  (cy_capsense_tuner.widgetContext[2].snsClk)
#define CY_CAPSENSE_LINEARSLIDER0_SNS_CLK_OFFSET                                 (152u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS_CLK_SIZE                                   (2u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS_CLK_PARAM_ID                               (0x06020098u)

#define CY_CAPSENSE_LINEARSLIDER0_ROW_SNS_CLK_VALUE                              (cy_capsense_tuner.widgetContext[2].rowSnsClk)
#define CY_CAPSENSE_LINEARSLIDER0_ROW_SNS_CLK_OFFSET                             (154u)
#define CY_CAPSENSE_LINEARSLIDER0_ROW_SNS_CLK_SIZE                               (2u)
#define CY_CAPSENSE_LINEARSLIDER0_ROW_SNS_CLK_PARAM_ID                           (0x0602009au)

#define CY_CAPSENSE_LINEARSLIDER0_GESTURE_DETECTED_VALUE                         (cy_capsense_tuner.widgetContext[2].gestureDetected)
#define CY_CAPSENSE_LINEARSLIDER0_GESTURE_DETECTED_OFFSET                        (156u)
#define CY_CAPSENSE_LINEARSLIDER0_GESTURE_DETECTED_SIZE                          (2u)
#define CY_CAPSENSE_LINEARSLIDER0_GESTURE_DETECTED_PARAM_ID                      (0x0202009cu)

#define CY_CAPSENSE_LINEARSLIDER0_GESTURE_DIRECTION_VALUE                        (cy_capsense_tuner.widgetContext[2].gestureDirection)
#define CY_CAPSENSE_LINEARSLIDER0_GESTURE_DIRECTION_OFFSET                       (158u)
#define CY_CAPSENSE_LINEARSLIDER0_GESTURE_DIRECTION_SIZE                         (2u)
#define CY_CAPSENSE_LINEARSLIDER0_GESTURE_DIRECTION_PARAM_ID                     (0x0202009eu)

#define CY_CAPSENSE_LINEARSLIDER0_XDELTA_VALUE                                   (cy_capsense_tuner.widgetContext[2].xDelta)
#define CY_CAPSENSE_LINEARSLIDER0_XDELTA_OFFSET                                  (160u)
#define CY_CAPSENSE_LINEARSLIDER0_XDELTA_SIZE                                    (2u)
#define CY_CAPSENSE_LINEARSLIDER0_XDELTA_PARAM_ID                                (0x020200a0u)

#define CY_CAPSENSE_LINEARSLIDER0_YDELTA_VALUE                                   (cy_capsense_tuner.widgetContext[2].yDelta)
#define CY_CAPSENSE_LINEARSLIDER0_YDELTA_OFFSET                                  (162u)
#define CY_CAPSENSE_LINEARSLIDER0_YDELTA_SIZE                                    (2u)
#define CY_CAPSENSE_LINEARSLIDER0_YDELTA_PARAM_ID                                (0x020200a2u)

#define CY_CAPSENSE_LINEARSLIDER0_NOISE_TH_VALUE                                 (cy_capsense_tuner.widgetContext[2].noiseTh)
#define CY_CAPSENSE_LINEARSLIDER0_NOISE_TH_OFFSET                                (164u)
#define CY_CAPSENSE_LINEARSLIDER0_NOISE_TH_SIZE                                  (2u)
#define CY_CAPSENSE_LINEARSLIDER0_NOISE_TH_PARAM_ID                              (0x020200a4u)

#define CY_CAPSENSE_LINEARSLIDER0_NNOISE_TH_VALUE                                (cy_capsense_tuner.widgetContext[2].nNoiseTh)
#define CY_CAPSENSE_LINEARSLIDER0_NNOISE_TH_OFFSET                               (166u)
#define CY_CAPSENSE_LINEARSLIDER0_NNOISE_TH_SIZE                                 (2u)
#define CY_CAPSENSE_LINEARSLIDER0_NNOISE_TH_PARAM_ID                             (0x020200a6u)

#define CY_CAPSENSE_LINEARSLIDER0_HYSTERESIS_VALUE                               (cy_capsense_tuner.widgetContext[2].hysteresis)
#define CY_CAPSENSE_LINEARSLIDER0_HYSTERESIS_OFFSET                              (168u)
#define CY_CAPSENSE_LINEARSLIDER0_HYSTERESIS_SIZE                                (2u)
#define CY_CAPSENSE_LINEARSLIDER0_HYSTERESIS_PARAM_ID                            (0x020200a8u)

#define CY_CAPSENSE_LINEARSLIDER0_ON_DEBOUNCE_VALUE                              (cy_capsense_tuner.widgetContext[2].onDebounce)
#define CY_CAPSENSE_LINEARSLIDER0_ON_DEBOUNCE_OFFSET                             (170u)
#define CY_CAPSENSE_LINEARSLIDER0_ON_DEBOUNCE_SIZE                               (1u)
#define CY_CAPSENSE_LINEARSLIDER0_ON_DEBOUNCE_PARAM_ID                           (0x050200aau)

#define CY_CAPSENSE_LINEARSLIDER0_SNS_CLK_SOURCE_VALUE                           (cy_capsense_tuner.widgetContext[2].snsClkSource)
#define CY_CAPSENSE_LINEARSLIDER0_SNS_CLK_SOURCE_OFFSET                          (171u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS_CLK_SOURCE_SIZE                            (1u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS_CLK_SOURCE_PARAM_ID                        (0x050200abu)

#define CY_CAPSENSE_LINEARSLIDER0_IDAC_MOD0_VALUE                                (cy_capsense_tuner.widgetContext[2].idacMod[0])
#define CY_CAPSENSE_LINEARSLIDER0_IDAC_MOD0_OFFSET                               (172u)
#define CY_CAPSENSE_LINEARSLIDER0_IDAC_MOD0_SIZE                                 (1u)
#define CY_CAPSENSE_LINEARSLIDER0_IDAC_MOD0_PARAM_ID                             (0x050200acu)

#define CY_CAPSENSE_LINEARSLIDER0_IDAC_MOD1_VALUE                                (cy_capsense_tuner.widgetContext[2].idacMod[1])
#define CY_CAPSENSE_LINEARSLIDER0_IDAC_MOD1_OFFSET                               (173u)
#define CY_CAPSENSE_LINEARSLIDER0_IDAC_MOD1_SIZE                                 (1u)
#define CY_CAPSENSE_LINEARSLIDER0_IDAC_MOD1_PARAM_ID                             (0x050200adu)

#define CY_CAPSENSE_LINEARSLIDER0_IDAC_MOD2_VALUE                                (cy_capsense_tuner.widgetContext[2].idacMod[2])
#define CY_CAPSENSE_LINEARSLIDER0_IDAC_MOD2_OFFSET                               (174u)
#define CY_CAPSENSE_LINEARSLIDER0_IDAC_MOD2_SIZE                                 (1u)
#define CY_CAPSENSE_LINEARSLIDER0_IDAC_MOD2_PARAM_ID                             (0x050200aeu)

#define CY_CAPSENSE_LINEARSLIDER0_IDAC_GAIN_INDEX_VALUE                          (cy_capsense_tuner.widgetContext[2].idacGainIndex)
#define CY_CAPSENSE_LINEARSLIDER0_IDAC_GAIN_INDEX_OFFSET                         (175u)
#define CY_CAPSENSE_LINEARSLIDER0_IDAC_GAIN_INDEX_SIZE                           (1u)
#define CY_CAPSENSE_LINEARSLIDER0_IDAC_GAIN_INDEX_PARAM_ID                       (0x050200afu)

#define CY_CAPSENSE_LINEARSLIDER0_ROW_IDAC_MOD0_VALUE                            (cy_capsense_tuner.widgetContext[2].rowIdacMod[0])
#define CY_CAPSENSE_LINEARSLIDER0_ROW_IDAC_MOD0_OFFSET                           (176u)
#define CY_CAPSENSE_LINEARSLIDER0_ROW_IDAC_MOD0_SIZE                             (1u)
#define CY_CAPSENSE_LINEARSLIDER0_ROW_IDAC_MOD0_PARAM_ID                         (0x050200b0u)

#define CY_CAPSENSE_LINEARSLIDER0_ROW_IDAC_MOD1_VALUE                            (cy_capsense_tuner.widgetContext[2].rowIdacMod[1])
#define CY_CAPSENSE_LINEARSLIDER0_ROW_IDAC_MOD1_OFFSET                           (177u)
#define CY_CAPSENSE_LINEARSLIDER0_ROW_IDAC_MOD1_SIZE                             (1u)
#define CY_CAPSENSE_LINEARSLIDER0_ROW_IDAC_MOD1_PARAM_ID                         (0x050200b1u)

#define CY_CAPSENSE_LINEARSLIDER0_ROW_IDAC_MOD2_VALUE                            (cy_capsense_tuner.widgetContext[2].rowIdacMod[2])
#define CY_CAPSENSE_LINEARSLIDER0_ROW_IDAC_MOD2_OFFSET                           (178u)
#define CY_CAPSENSE_LINEARSLIDER0_ROW_IDAC_MOD2_SIZE                             (1u)
#define CY_CAPSENSE_LINEARSLIDER0_ROW_IDAC_MOD2_PARAM_ID                         (0x050200b2u)

#define CY_CAPSENSE_LINEARSLIDER0_REGULAR_IIR_BL_N_VALUE                         (cy_capsense_tuner.widgetContext[2].bslnCoeff)
#define CY_CAPSENSE_LINEARSLIDER0_REGULAR_IIR_BL_N_OFFSET                        (179u)
#define CY_CAPSENSE_LINEARSLIDER0_REGULAR_IIR_BL_N_SIZE                          (1u)
#define CY_CAPSENSE_LINEARSLIDER0_REGULAR_IIR_BL_N_PARAM_ID                      (0x050200b3u)

#define CY_CAPSENSE_LINEARSLIDER0_STATUS_VALUE                                   (cy_capsense_tuner.widgetContext[2].status)
#define CY_CAPSENSE_LINEARSLIDER0_STATUS_OFFSET                                  (180u)
#define CY_CAPSENSE_LINEARSLIDER0_STATUS_SIZE                                    (1u)
#define CY_CAPSENSE_LINEARSLIDER0_STATUS_PARAM_ID                                (0x010200b4u)

#define CY_CAPSENSE_LINEARSLIDER0_PTRPOSITION_VALUE                              (cy_capsense_tuner.widgetContext[2].wdTouch.ptrPosition)
#define CY_CAPSENSE_LINEARSLIDER0_PTRPOSITION_OFFSET                             (184u)
#define CY_CAPSENSE_LINEARSLIDER0_PTRPOSITION_SIZE                               (4u)
#define CY_CAPSENSE_LINEARSLIDER0_PTRPOSITION_PARAM_ID                           (0x030200b8u)

#define CY_CAPSENSE_LINEARSLIDER0_NUM_POSITIONS_VALUE                            (cy_capsense_tuner.widgetContext[2].wdTouch.numPosition)
#define CY_CAPSENSE_LINEARSLIDER0_NUM_POSITIONS_OFFSET                           (188u)
#define CY_CAPSENSE_LINEARSLIDER0_NUM_POSITIONS_SIZE                             (1u)
#define CY_CAPSENSE_LINEARSLIDER0_NUM_POSITIONS_PARAM_ID                         (0x010200bcu)

#define CY_CAPSENSE_BUTTON0_RX0_RAW0_VALUE                                       (cy_capsense_tuner.sensorContext[0].raw)
#define CY_CAPSENSE_BUTTON0_RX0_RAW0_OFFSET                                      (192u)
#define CY_CAPSENSE_BUTTON0_RX0_RAW0_SIZE                                        (2u)
#define CY_CAPSENSE_BUTTON0_RX0_RAW0_PARAM_ID                                    (0x020000c0u)

#define CY_CAPSENSE_BUTTON0_RX0_BSLN0_VALUE                                      (cy_capsense_tuner.sensorContext[0].bsln)
#define CY_CAPSENSE_BUTTON0_RX0_BSLN0_OFFSET                                     (194u)
#define CY_CAPSENSE_BUTTON0_RX0_BSLN0_SIZE                                       (2u)
#define CY_CAPSENSE_BUTTON0_RX0_BSLN0_PARAM_ID                                   (0x020000c2u)

#define CY_CAPSENSE_BUTTON0_RX0_DIFF0_VALUE                                      (cy_capsense_tuner.sensorContext[0].diff)
#define CY_CAPSENSE_BUTTON0_RX0_DIFF0_OFFSET                                     (196u)
#define CY_CAPSENSE_BUTTON0_RX0_DIFF0_SIZE                                       (2u)
#define CY_CAPSENSE_BUTTON0_RX0_DIFF0_PARAM_ID                                   (0x020000c4u)

#define CY_CAPSENSE_BUTTON0_RX0_STATUS0_VALUE                                    (cy_capsense_tuner.sensorContext[0].status)
#define CY_CAPSENSE_BUTTON0_RX0_STATUS0_OFFSET                                   (198u)
#define CY_CAPSENSE_BUTTON0_RX0_STATUS0_SIZE                                     (1u)
#define CY_CAPSENSE_BUTTON0_RX0_STATUS0_PARAM_ID                                 (0x010000c6u)

#define CY_CAPSENSE_BUTTON0_RX0_NEG_BSLN_RST_CNT0_VALUE                          (cy_capsense_tuner.sensorContext[0].negBslnRstCnt)
#define CY_CAPSENSE_BUTTON0_RX0_NEG_BSLN_RST_CNT0_OFFSET                         (199u)
#define CY_CAPSENSE_BUTTON0_RX0_NEG_BSLN_RST_CNT0_SIZE                           (1u)
#define CY_CAPSENSE_BUTTON0_RX0_NEG_BSLN_RST_CNT0_PARAM_ID                       (0x010000c7u)

#define CY_CAPSENSE_BUTTON0_RX0_IDAC0_VALUE                                      (cy_capsense_tuner.sensorContext[0].idacComp)
#define CY_CAPSENSE_BUTTON0_RX0_IDAC0_OFFSET                                     (200u)
#define CY_CAPSENSE_BUTTON0_RX0_IDAC0_SIZE                                       (1u)
#define CY_CAPSENSE_BUTTON0_RX0_IDAC0_PARAM_ID                                   (0x010000c8u)

#define CY_CAPSENSE_BUTTON0_RX0_BSLN_EXT0_VALUE                                  (cy_capsense_tuner.sensorContext[0].bslnExt)
#define CY_CAPSENSE_BUTTON0_RX0_BSLN_EXT0_OFFSET                                 (201u)
#define CY_CAPSENSE_BUTTON0_RX0_BSLN_EXT0_SIZE                                   (1u)
#define CY_CAPSENSE_BUTTON0_RX0_BSLN_EXT0_PARAM_ID                               (0x010000c9u)

#define CY_CAPSENSE_BUTTON1_RX0_RAW0_VALUE                                       (cy_capsense_tuner.sensorContext[1].raw)
#define CY_CAPSENSE_BUTTON1_RX0_RAW0_OFFSET                                      (202u)
#define CY_CAPSENSE_BUTTON1_RX0_RAW0_SIZE                                        (2u)
#define CY_CAPSENSE_BUTTON1_RX0_RAW0_PARAM_ID                                    (0x020100cau)

#define CY_CAPSENSE_BUTTON1_RX0_BSLN0_VALUE                                      (cy_capsense_tuner.sensorContext[1].bsln)
#define CY_CAPSENSE_BUTTON1_RX0_BSLN0_OFFSET                                     (204u)
#define CY_CAPSENSE_BUTTON1_RX0_BSLN0_SIZE                                       (2u)
#define CY_CAPSENSE_BUTTON1_RX0_BSLN0_PARAM_ID                                   (0x020100ccu)

#define CY_CAPSENSE_BUTTON1_RX0_DIFF0_VALUE                                      (cy_capsense_tuner.sensorContext[1].diff)
#define CY_CAPSENSE_BUTTON1_RX0_DIFF0_OFFSET                                     (206u)
#define CY_CAPSENSE_BUTTON1_RX0_DIFF0_SIZE                                       (2u)
#define CY_CAPSENSE_BUTTON1_RX0_DIFF0_PARAM_ID                                   (0x020100ceu)

#define CY_CAPSENSE_BUTTON1_RX0_STATUS0_VALUE                                    (cy_capsense_tuner.sensorContext[1].status)
#define CY_CAPSENSE_BUTTON1_RX0_STATUS0_OFFSET                                   (208u)
#define CY_CAPSENSE_BUTTON1_RX0_STATUS0_SIZE                                     (1u)
#define CY_CAPSENSE_BUTTON1_RX0_STATUS0_PARAM_ID                                 (0x010100d0u)

#define CY_CAPSENSE_BUTTON1_RX0_NEG_BSLN_RST_CNT0_VALUE                          (cy_capsense_tuner.sensorContext[1].negBslnRstCnt)
#define CY_CAPSENSE_BUTTON1_RX0_NEG_BSLN_RST_CNT0_OFFSET                         (209u)
#define CY_CAPSENSE_BUTTON1_RX0_NEG_BSLN_RST_CNT0_SIZE                           (1u)
#define CY_CAPSENSE_BUTTON1_RX0_NEG_BSLN_RST_CNT0_PARAM_ID                       (0x010100d1u)

#define CY_CAPSENSE_BUTTON1_RX0_IDAC0_VALUE                                      (cy_capsense_tuner.sensorContext[1].idacComp)
#define CY_CAPSENSE_BUTTON1_RX0_IDAC0_OFFSET                                     (210u)
#define CY_CAPSENSE_BUTTON1_RX0_IDAC0_SIZE                                       (1u)
#define CY_CAPSENSE_BUTTON1_RX0_IDAC0_PARAM_ID                                   (0x010100d2u)

#define CY_CAPSENSE_BUTTON1_RX0_BSLN_EXT0_VALUE                                  (cy_capsense_tuner.sensorContext[1].bslnExt)
#define CY_CAPSENSE_BUTTON1_RX0_BSLN_EXT0_OFFSET                                 (211u)
#define CY_CAPSENSE_BUTTON1_RX0_BSLN_EXT0_SIZE                                   (1u)
#define CY_CAPSENSE_BUTTON1_RX0_BSLN_EXT0_PARAM_ID                               (0x010100d3u)

#define CY_CAPSENSE_LINEARSLIDER0_SNS0_RAW0_VALUE                                (cy_capsense_tuner.sensorContext[2].raw)
#define CY_CAPSENSE_LINEARSLIDER0_SNS0_RAW0_OFFSET                               (212u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS0_RAW0_SIZE                                 (2u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS0_RAW0_PARAM_ID                             (0x020200d4u)

#define CY_CAPSENSE_LINEARSLIDER0_SNS0_BSLN0_VALUE                               (cy_capsense_tuner.sensorContext[2].bsln)
#define CY_CAPSENSE_LINEARSLIDER0_SNS0_BSLN0_OFFSET                              (214u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS0_BSLN0_SIZE                                (2u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS0_BSLN0_PARAM_ID                            (0x020200d6u)

#define CY_CAPSENSE_LINEARSLIDER0_SNS0_DIFF0_VALUE                               (cy_capsense_tuner.sensorContext[2].diff)
#define CY_CAPSENSE_LINEARSLIDER0_SNS0_DIFF0_OFFSET                              (216u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS0_DIFF0_SIZE                                (2u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS0_DIFF0_PARAM_ID                            (0x020200d8u)

#define CY_CAPSENSE_LINEARSLIDER0_SNS0_STATUS0_VALUE                             (cy_capsense_tuner.sensorContext[2].status)
#define CY_CAPSENSE_LINEARSLIDER0_SNS0_STATUS0_OFFSET                            (218u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS0_STATUS0_SIZE                              (1u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS0_STATUS0_PARAM_ID                          (0x010200dau)

#define CY_CAPSENSE_LINEARSLIDER0_SNS0_NEG_BSLN_RST_CNT0_VALUE                   (cy_capsense_tuner.sensorContext[2].negBslnRstCnt)
#define CY_CAPSENSE_LINEARSLIDER0_SNS0_NEG_BSLN_RST_CNT0_OFFSET                  (219u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS0_NEG_BSLN_RST_CNT0_SIZE                    (1u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS0_NEG_BSLN_RST_CNT0_PARAM_ID                (0x010200dbu)

#define CY_CAPSENSE_LINEARSLIDER0_SNS0_IDAC0_VALUE                               (cy_capsense_tuner.sensorContext[2].idacComp)
#define CY_CAPSENSE_LINEARSLIDER0_SNS0_IDAC0_OFFSET                              (220u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS0_IDAC0_SIZE                                (1u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS0_IDAC0_PARAM_ID                            (0x010200dcu)

#define CY_CAPSENSE_LINEARSLIDER0_SNS0_BSLN_EXT0_VALUE                           (cy_capsense_tuner.sensorContext[2].bslnExt)
#define CY_CAPSENSE_LINEARSLIDER0_SNS0_BSLN_EXT0_OFFSET                          (221u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS0_BSLN_EXT0_SIZE                            (1u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS0_BSLN_EXT0_PARAM_ID                        (0x010200ddu)

#define CY_CAPSENSE_LINEARSLIDER0_SNS1_RAW0_VALUE                                (cy_capsense_tuner.sensorContext[3].raw)
#define CY_CAPSENSE_LINEARSLIDER0_SNS1_RAW0_OFFSET                               (222u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS1_RAW0_SIZE                                 (2u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS1_RAW0_PARAM_ID                             (0x020200deu)

#define CY_CAPSENSE_LINEARSLIDER0_SNS1_BSLN0_VALUE                               (cy_capsense_tuner.sensorContext[3].bsln)
#define CY_CAPSENSE_LINEARSLIDER0_SNS1_BSLN0_OFFSET                              (224u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS1_BSLN0_SIZE                                (2u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS1_BSLN0_PARAM_ID                            (0x020200e0u)

#define CY_CAPSENSE_LINEARSLIDER0_SNS1_DIFF0_VALUE                               (cy_capsense_tuner.sensorContext[3].diff)
#define CY_CAPSENSE_LINEARSLIDER0_SNS1_DIFF0_OFFSET                              (226u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS1_DIFF0_SIZE                                (2u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS1_DIFF0_PARAM_ID                            (0x020200e2u)

#define CY_CAPSENSE_LINEARSLIDER0_SNS1_STATUS0_VALUE                             (cy_capsense_tuner.sensorContext[3].status)
#define CY_CAPSENSE_LINEARSLIDER0_SNS1_STATUS0_OFFSET                            (228u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS1_STATUS0_SIZE                              (1u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS1_STATUS0_PARAM_ID                          (0x010200e4u)

#define CY_CAPSENSE_LINEARSLIDER0_SNS1_NEG_BSLN_RST_CNT0_VALUE                   (cy_capsense_tuner.sensorContext[3].negBslnRstCnt)
#define CY_CAPSENSE_LINEARSLIDER0_SNS1_NEG_BSLN_RST_CNT0_OFFSET                  (229u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS1_NEG_BSLN_RST_CNT0_SIZE                    (1u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS1_NEG_BSLN_RST_CNT0_PARAM_ID                (0x010200e5u)

#define CY_CAPSENSE_LINEARSLIDER0_SNS1_IDAC0_VALUE                               (cy_capsense_tuner.sensorContext[3].idacComp)
#define CY_CAPSENSE_LINEARSLIDER0_SNS1_IDAC0_OFFSET                              (230u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS1_IDAC0_SIZE                                (1u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS1_IDAC0_PARAM_ID                            (0x010200e6u)

#define CY_CAPSENSE_LINEARSLIDER0_SNS1_BSLN_EXT0_VALUE                           (cy_capsense_tuner.sensorContext[3].bslnExt)
#define CY_CAPSENSE_LINEARSLIDER0_SNS1_BSLN_EXT0_OFFSET                          (231u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS1_BSLN_EXT0_SIZE                            (1u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS1_BSLN_EXT0_PARAM_ID                        (0x010200e7u)

#define CY_CAPSENSE_LINEARSLIDER0_SNS2_RAW0_VALUE                                (cy_capsense_tuner.sensorContext[4].raw)
#define CY_CAPSENSE_LINEARSLIDER0_SNS2_RAW0_OFFSET                               (232u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS2_RAW0_SIZE                                 (2u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS2_RAW0_PARAM_ID                             (0x020200e8u)

#define CY_CAPSENSE_LINEARSLIDER0_SNS2_BSLN0_VALUE                               (cy_capsense_tuner.sensorContext[4].bsln)
#define CY_CAPSENSE_LINEARSLIDER0_SNS2_BSLN0_OFFSET                              (234u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS2_BSLN0_SIZE                                (2u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS2_BSLN0_PARAM_ID                            (0x020200eau)

#define CY_CAPSENSE_LINEARSLIDER0_SNS2_DIFF0_VALUE                               (cy_capsense_tuner.sensorContext[4].diff)
#define CY_CAPSENSE_LINEARSLIDER0_SNS2_DIFF0_OFFSET                              (236u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS2_DIFF0_SIZE                                (2u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS2_DIFF0_PARAM_ID                            (0x020200ecu)

#define CY_CAPSENSE_LINEARSLIDER0_SNS2_STATUS0_VALUE                             (cy_capsense_tuner.sensorContext[4].status)
#define CY_CAPSENSE_LINEARSLIDER0_SNS2_STATUS0_OFFSET                            (238u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS2_STATUS0_SIZE                              (1u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS2_STATUS0_PARAM_ID                          (0x010200eeu)

#define CY_CAPSENSE_LINEARSLIDER0_SNS2_NEG_BSLN_RST_CNT0_VALUE                   (cy_capsense_tuner.sensorContext[4].negBslnRstCnt)
#define CY_CAPSENSE_LINEARSLIDER0_SNS2_NEG_BSLN_RST_CNT0_OFFSET                  (239u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS2_NEG_BSLN_RST_CNT0_SIZE                    (1u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS2_NEG_BSLN_RST_CNT0_PARAM_ID                (0x010200efu)

#define CY_CAPSENSE_LINEARSLIDER0_SNS2_IDAC0_VALUE                               (cy_capsense_tuner.sensorContext[4].idacComp)
#define CY_CAPSENSE_LINEARSLIDER0_SNS2_IDAC0_OFFSET                              (240u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS2_IDAC0_SIZE                                (1u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS2_IDAC0_PARAM_ID                            (0x010200f0u)

#define CY_CAPSENSE_LINEARSLIDER0_SNS2_BSLN_EXT0_VALUE                           (cy_capsense_tuner.sensorContext[4].bslnExt)
#define CY_CAPSENSE_LINEARSLIDER0_SNS2_BSLN_EXT0_OFFSET                          (241u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS2_BSLN_EXT0_SIZE                            (1u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS2_BSLN_EXT0_PARAM_ID                        (0x010200f1u)

#define CY_CAPSENSE_LINEARSLIDER0_SNS3_RAW0_VALUE                                (cy_capsense_tuner.sensorContext[5].raw)
#define CY_CAPSENSE_LINEARSLIDER0_SNS3_RAW0_OFFSET                               (242u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS3_RAW0_SIZE                                 (2u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS3_RAW0_PARAM_ID                             (0x020200f2u)

#define CY_CAPSENSE_LINEARSLIDER0_SNS3_BSLN0_VALUE                               (cy_capsense_tuner.sensorContext[5].bsln)
#define CY_CAPSENSE_LINEARSLIDER0_SNS3_BSLN0_OFFSET                              (244u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS3_BSLN0_SIZE                                (2u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS3_BSLN0_PARAM_ID                            (0x020200f4u)

#define CY_CAPSENSE_LINEARSLIDER0_SNS3_DIFF0_VALUE                               (cy_capsense_tuner.sensorContext[5].diff)
#define CY_CAPSENSE_LINEARSLIDER0_SNS3_DIFF0_OFFSET                              (246u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS3_DIFF0_SIZE                                (2u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS3_DIFF0_PARAM_ID                            (0x020200f6u)

#define CY_CAPSENSE_LINEARSLIDER0_SNS3_STATUS0_VALUE                             (cy_capsense_tuner.sensorContext[5].status)
#define CY_CAPSENSE_LINEARSLIDER0_SNS3_STATUS0_OFFSET                            (248u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS3_STATUS0_SIZE                              (1u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS3_STATUS0_PARAM_ID                          (0x010200f8u)

#define CY_CAPSENSE_LINEARSLIDER0_SNS3_NEG_BSLN_RST_CNT0_VALUE                   (cy_capsense_tuner.sensorContext[5].negBslnRstCnt)
#define CY_CAPSENSE_LINEARSLIDER0_SNS3_NEG_BSLN_RST_CNT0_OFFSET                  (249u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS3_NEG_BSLN_RST_CNT0_SIZE                    (1u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS3_NEG_BSLN_RST_CNT0_PARAM_ID                (0x010200f9u)

#define CY_CAPSENSE_LINEARSLIDER0_SNS3_IDAC0_VALUE                               (cy_capsense_tuner.sensorContext[5].idacComp)
#define CY_CAPSENSE_LINEARSLIDER0_SNS3_IDAC0_OFFSET                              (250u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS3_IDAC0_SIZE                                (1u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS3_IDAC0_PARAM_ID                            (0x010200fau)

#define CY_CAPSENSE_LINEARSLIDER0_SNS3_BSLN_EXT0_VALUE                           (cy_capsense_tuner.sensorContext[5].bslnExt)
#define CY_CAPSENSE_LINEARSLIDER0_SNS3_BSLN_EXT0_OFFSET                          (251u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS3_BSLN_EXT0_SIZE                            (1u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS3_BSLN_EXT0_PARAM_ID                        (0x010200fbu)

#define CY_CAPSENSE_LINEARSLIDER0_SNS4_RAW0_VALUE                                (cy_capsense_tuner.sensorContext[6].raw)
#define CY_CAPSENSE_LINEARSLIDER0_SNS4_RAW0_OFFSET                               (252u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS4_RAW0_SIZE                                 (2u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS4_RAW0_PARAM_ID                             (0x020200fcu)

#define CY_CAPSENSE_LINEARSLIDER0_SNS4_BSLN0_VALUE                               (cy_capsense_tuner.sensorContext[6].bsln)
#define CY_CAPSENSE_LINEARSLIDER0_SNS4_BSLN0_OFFSET                              (254u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS4_BSLN0_SIZE                                (2u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS4_BSLN0_PARAM_ID                            (0x020200feu)

#define CY_CAPSENSE_LINEARSLIDER0_SNS4_DIFF0_VALUE                               (cy_capsense_tuner.sensorContext[6].diff)
#define CY_CAPSENSE_LINEARSLIDER0_SNS4_DIFF0_OFFSET                              (256u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS4_DIFF0_SIZE                                (2u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS4_DIFF0_PARAM_ID                            (0x02020100u)

#define CY_CAPSENSE_LINEARSLIDER0_SNS4_STATUS0_VALUE                             (cy_capsense_tuner.sensorContext[6].status)
#define CY_CAPSENSE_LINEARSLIDER0_SNS4_STATUS0_OFFSET                            (258u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS4_STATUS0_SIZE                              (1u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS4_STATUS0_PARAM_ID                          (0x01020102u)

#define CY_CAPSENSE_LINEARSLIDER0_SNS4_NEG_BSLN_RST_CNT0_VALUE                   (cy_capsense_tuner.sensorContext[6].negBslnRstCnt)
#define CY_CAPSENSE_LINEARSLIDER0_SNS4_NEG_BSLN_RST_CNT0_OFFSET                  (259u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS4_NEG_BSLN_RST_CNT0_SIZE                    (1u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS4_NEG_BSLN_RST_CNT0_PARAM_ID                (0x01020103u)

#define CY_CAPSENSE_LINEARSLIDER0_SNS4_IDAC0_VALUE                               (cy_capsense_tuner.sensorContext[6].idacComp)
#define CY_CAPSENSE_LINEARSLIDER0_SNS4_IDAC0_OFFSET                              (260u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS4_IDAC0_SIZE                                (1u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS4_IDAC0_PARAM_ID                            (0x01020104u)

#define CY_CAPSENSE_LINEARSLIDER0_SNS4_BSLN_EXT0_VALUE                           (cy_capsense_tuner.sensorContext[6].bslnExt)
#define CY_CAPSENSE_LINEARSLIDER0_SNS4_BSLN_EXT0_OFFSET                          (261u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS4_BSLN_EXT0_SIZE                            (1u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS4_BSLN_EXT0_PARAM_ID                        (0x01020105u)

#define CY_CAPSENSE_LINEARSLIDER0_X0_VALUE                                       (cy_capsense_tuner.position[0].x)
#define CY_CAPSENSE_LINEARSLIDER0_X0_OFFSET                                      (262u)
#define CY_CAPSENSE_LINEARSLIDER0_X0_SIZE                                        (2u)
#define CY_CAPSENSE_LINEARSLIDER0_X0_PARAM_ID                                    (0x02020106u)

#define CY_CAPSENSE_LINEARSLIDER0_Y0_VALUE                                       (cy_capsense_tuner.position[0].y)
#define CY_CAPSENSE_LINEARSLIDER0_Y0_OFFSET                                      (264u)
#define CY_CAPSENSE_LINEARSLIDER0_Y0_SIZE                                        (2u)
#define CY_CAPSENSE_LINEARSLIDER0_Y0_PARAM_ID                                    (0x02020108u)

#define CY_CAPSENSE_LINEARSLIDER0_Z0_VALUE                                       (cy_capsense_tuner.position[0].z)
#define CY_CAPSENSE_LINEARSLIDER0_Z0_OFFSET                                      (266u)
#define CY_CAPSENSE_LINEARSLIDER0_Z0_SIZE                                        (2u)
#define CY_CAPSENSE_LINEARSLIDER0_Z0_PARAM_ID                                    (0x0202010au)

#define CY_CAPSENSE_LINEARSLIDER0_ID0_VALUE                                      (cy_capsense_tuner.position[0].id)
#define CY_CAPSENSE_LINEARSLIDER0_ID0_OFFSET                                     (268u)
#define CY_CAPSENSE_LINEARSLIDER0_ID0_SIZE                                       (2u)
#define CY_CAPSENSE_LINEARSLIDER0_ID0_PARAM_ID                                   (0x0202010cu)

#else /* CY_CAPSENSE_MW_VERSION >= 700 */
#define CY_CAPSENSE_CONFIG_ID_VALUE                                              (cy_capsense_tuner.commonContext.configId)
#define CY_CAPSENSE_CONFIG_ID_OFFSET                                             (0u)
#define CY_CAPSENSE_CONFIG_ID_SIZE                                               (2u)
#define CY_CAPSENSE_CONFIG_ID_PARAM_ID                                           (0x02000000u)

#define CY_CAPSENSE_TUNER_CMD_VALUE                                              (cy_capsense_tuner.commonContext.tunerCmd)
#define CY_CAPSENSE_TUNER_CMD_OFFSET                                             (2u)
#define CY_CAPSENSE_TUNER_CMD_SIZE                                               (2u)
#define CY_CAPSENSE_TUNER_CMD_PARAM_ID                                           (0x02000002u)

#define CY_CAPSENSE_MWVERSIONMAJOR_VALUE                                         (cy_capsense_tuner.commonContext.mwVersionMajor)
#define CY_CAPSENSE_MWVERSIONMAJOR_OFFSET                                        (4u)
#define CY_CAPSENSE_MWVERSIONMAJOR_SIZE                                          (1u)
#define CY_CAPSENSE_MWVERSIONMAJOR_PARAM_ID                                      (0x01000004u)

#define CY_CAPSENSE_MWVERSIONMINOR_VALUE                                         (cy_capsense_tuner.commonContext.mwVersionMinor)
#define CY_CAPSENSE_MWVERSIONMINOR_OFFSET                                        (5u)
#define CY_CAPSENSE_MWVERSIONMINOR_SIZE                                          (1u)
#define CY_CAPSENSE_MWVERSIONMINOR_PARAM_ID                                      (0x01000005u)

#define CY_CAPSENSE_SCAN_COUNTER_VALUE                                           (cy_capsense_tuner.commonContext.scanCounter)
#define CY_CAPSENSE_SCAN_COUNTER_OFFSET                                          (6u)
#define CY_CAPSENSE_SCAN_COUNTER_SIZE                                            (2u)
#define CY_CAPSENSE_SCAN_COUNTER_PARAM_ID                                        (0x02000006u)

#define CY_CAPSENSE_TUNER_ST_VALUE                                               (cy_capsense_tuner.commonContext.tunerSt)
#define CY_CAPSENSE_TUNER_ST_OFFSET                                              (8u)
#define CY_CAPSENSE_TUNER_ST_SIZE                                                (1u)
#define CY_CAPSENSE_TUNER_ST_PARAM_ID                                            (0x01000008u)

#define CY_CAPSENSE_INITDONE_VALUE                                               (cy_capsense_tuner.commonContext.initDone)
#define CY_CAPSENSE_INITDONE_OFFSET                                              (9u)
#define CY_CAPSENSE_INITDONE_SIZE                                                (1u)
#define CY_CAPSENSE_INITDONE_PARAM_ID                                            (0x01000009u)

#define CY_CAPSENSE_MISC_VALUE                                                   (cy_capsense_tuner.commonContext.misc)
#define CY_CAPSENSE_MISC_OFFSET                                                  (10u)
#define CY_CAPSENSE_MISC_SIZE                                                    (1u)
#define CY_CAPSENSE_MISC_PARAM_ID                                                (0x0100000au)

#define CY_CAPSENSE_STATUS_VALUE                                                 (cy_capsense_tuner.commonContext.status)
#define CY_CAPSENSE_STATUS_OFFSET                                                (12u)
#define CY_CAPSENSE_STATUS_SIZE                                                  (4u)
#define CY_CAPSENSE_STATUS_PARAM_ID                                              (0x0300000cu)

#define CY_CAPSENSE_TIMESTAMPINTERVAL_VALUE                                      (cy_capsense_tuner.commonContext.timestampInterval)
#define CY_CAPSENSE_TIMESTAMPINTERVAL_OFFSET                                     (16u)
#define CY_CAPSENSE_TIMESTAMPINTERVAL_SIZE                                       (4u)
#define CY_CAPSENSE_TIMESTAMPINTERVAL_PARAM_ID                                   (0x03000010u)

#define CY_CAPSENSE_TIMESTAMP_VALUE                                              (cy_capsense_tuner.commonContext.timestamp)
#define CY_CAPSENSE_TIMESTAMP_OFFSET                                             (20u)
#define CY_CAPSENSE_TIMESTAMP_SIZE                                               (4u)
#define CY_CAPSENSE_TIMESTAMP_PARAM_ID                                           (0x03000014u)

#define CY_CAPSENSE_CSD_MOD_CLK_DIVIDER_VALUE                                    (cy_capsense_tuner.commonContext.modCsdClk)
#define CY_CAPSENSE_CSD_MOD_CLK_DIVIDER_OFFSET                                   (24u)
#define CY_CAPSENSE_CSD_MOD_CLK_DIVIDER_SIZE                                     (1u)
#define CY_CAPSENSE_CSD_MOD_CLK_DIVIDER_PARAM_ID                                 (0x01000018u)

#define CY_CAPSENSE_CSX_MOD_CLK_DIVIDER_VALUE                                    (cy_capsense_tuner.commonContext.modCsxClk)
#define CY_CAPSENSE_CSX_MOD_CLK_DIVIDER_OFFSET                                   (25u)
#define CY_CAPSENSE_CSX_MOD_CLK_DIVIDER_SIZE                                     (1u)
#define CY_CAPSENSE_CSX_MOD_CLK_DIVIDER_PARAM_ID                                 (0x01000019u)

#define CY_CAPSENSE_TUNER_CNT_VALUE                                              (cy_capsense_tuner.commonContext.tunerCnt)
#define CY_CAPSENSE_TUNER_CNT_OFFSET                                             (26u)
#define CY_CAPSENSE_TUNER_CNT_SIZE                                               (1u)
#define CY_CAPSENSE_TUNER_CNT_PARAM_ID                                           (0x0100001au)

#define CY_CAPSENSE_BUTTON0_FINGER_CP_VALUE                                      (cy_capsense_tuner.widgetContext[0].fingerCap)
#define CY_CAPSENSE_BUTTON0_FINGER_CP_OFFSET                                     (28u)
#define CY_CAPSENSE_BUTTON0_FINGER_CP_SIZE                                       (2u)
#define CY_CAPSENSE_BUTTON0_FINGER_CP_PARAM_ID                                   (0x0600001cu)

#define CY_CAPSENSE_BUTTON0_SIGPFC_VALUE                                         (cy_capsense_tuner.widgetContext[0].sigPFC)
#define CY_CAPSENSE_BUTTON0_SIGPFC_OFFSET                                        (30u)
#define CY_CAPSENSE_BUTTON0_SIGPFC_SIZE                                          (2u)
#define CY_CAPSENSE_BUTTON0_SIGPFC_PARAM_ID                                      (0x0600001eu)

#define CY_CAPSENSE_BUTTON0_NUM_CONV_VALUE                                       (cy_capsense_tuner.widgetContext[0].resolution)
#define CY_CAPSENSE_BUTTON0_NUM_CONV_OFFSET                                      (32u)
#define CY_CAPSENSE_BUTTON0_NUM_CONV_SIZE                                        (2u)
#define CY_CAPSENSE_BUTTON0_NUM_CONV_PARAM_ID                                    (0x06000020u)

#define CY_CAPSENSE_BUTTON0_MAX_RAW_COUNT_VALUE                                  (cy_capsense_tuner.widgetContext[0].maxRawCount)
#define CY_CAPSENSE_BUTTON0_MAX_RAW_COUNT_OFFSET                                 (34u)
#define CY_CAPSENSE_BUTTON0_MAX_RAW_COUNT_SIZE                                   (2u)
#define CY_CAPSENSE_BUTTON0_MAX_RAW_COUNT_PARAM_ID                               (0x06000022u)

#define CY_CAPSENSE_BUTTON0_ROW_MAX_RAW_COUNT_VALUE                              (cy_capsense_tuner.widgetContext[0].maxRawCountRow)
#define CY_CAPSENSE_BUTTON0_ROW_MAX_RAW_COUNT_OFFSET                             (36u)
#define CY_CAPSENSE_BUTTON0_ROW_MAX_RAW_COUNT_SIZE                               (2u)
#define CY_CAPSENSE_BUTTON0_ROW_MAX_RAW_COUNT_PARAM_ID                           (0x06000024u)

#define CY_CAPSENSE_BUTTON0_FINGER_TH_VALUE                                      (cy_capsense_tuner.widgetContext[0].fingerTh)
#define CY_CAPSENSE_BUTTON0_FINGER_TH_OFFSET                                     (38u)
#define CY_CAPSENSE_BUTTON0_FINGER_TH_SIZE                                       (2u)
#define CY_CAPSENSE_BUTTON0_FINGER_TH_PARAM_ID                                   (0x06000026u)

#define CY_CAPSENSE_BUTTON0_PROX_TOUCH_TH_VALUE                                  (cy_capsense_tuner.widgetContext[0].proxTh)
#define CY_CAPSENSE_BUTTON0_PROX_TOUCH_TH_OFFSET                                 (40u)
#define CY_CAPSENSE_BUTTON0_PROX_TOUCH_TH_SIZE                                   (2u)
#define CY_CAPSENSE_BUTTON0_PROX_TOUCH_TH_PARAM_ID                               (0x06000028u)

#define CY_CAPSENSE_BUTTON0_LOW_BSLN_RST_VALUE                                   (cy_capsense_tuner.widgetContext[0].lowBslnRst)
#define CY_CAPSENSE_BUTTON0_LOW_BSLN_RST_OFFSET                                  (42u)
#define CY_CAPSENSE_BUTTON0_LOW_BSLN_RST_SIZE                                    (2u)
#define CY_CAPSENSE_BUTTON0_LOW_BSLN_RST_PARAM_ID                                (0x0600002au)

#define CY_CAPSENSE_BUTTON0_TX_CLK_VALUE                                         (cy_capsense_tuner.widgetContext[0].snsClk)
#define CY_CAPSENSE_BUTTON0_TX_CLK_OFFSET                                        (44u)
#define CY_CAPSENSE_BUTTON0_TX_CLK_SIZE                                          (2u)
#define CY_CAPSENSE_BUTTON0_TX_CLK_PARAM_ID                                      (0x0600002cu)

#define CY_CAPSENSE_BUTTON0_ROW_SNS_CLK_VALUE                                    (cy_capsense_tuner.widgetContext[0].rowSnsClk)
#define CY_CAPSENSE_BUTTON0_ROW_SNS_CLK_OFFSET                                   (46u)
#define CY_CAPSENSE_BUTTON0_ROW_SNS_CLK_SIZE                                     (2u)
#define CY_CAPSENSE_BUTTON0_ROW_SNS_CLK_PARAM_ID                                 (0x0600002eu)

#define CY_CAPSENSE_BUTTON0_GESTURE_DETECTED_VALUE                               (cy_capsense_tuner.widgetContext[0].gestureDetected)
#define CY_CAPSENSE_BUTTON0_GESTURE_DETECTED_OFFSET                              (48u)
#define CY_CAPSENSE_BUTTON0_GESTURE_DETECTED_SIZE                                (2u)
#define CY_CAPSENSE_BUTTON0_GESTURE_DETECTED_PARAM_ID                            (0x02000030u)

#define CY_CAPSENSE_BUTTON0_GESTURE_DIRECTION_VALUE                              (cy_capsense_tuner.widgetContext[0].gestureDirection)
#define CY_CAPSENSE_BUTTON0_GESTURE_DIRECTION_OFFSET                             (50u)
#define CY_CAPSENSE_BUTTON0_GESTURE_DIRECTION_SIZE                               (2u)
#define CY_CAPSENSE_BUTTON0_GESTURE_DIRECTION_PARAM_ID                           (0x02000032u)

#define CY_CAPSENSE_BUTTON0_XDELTA_VALUE                                         (cy_capsense_tuner.widgetContext[0].xDelta)
#define CY_CAPSENSE_BUTTON0_XDELTA_OFFSET                                        (52u)
#define CY_CAPSENSE_BUTTON0_XDELTA_SIZE                                          (2u)
#define CY_CAPSENSE_BUTTON0_XDELTA_PARAM_ID                                      (0x02000034u)

#define CY_CAPSENSE_BUTTON0_YDELTA_VALUE                                         (cy_capsense_tuner.widgetContext[0].yDelta)
#define CY_CAPSENSE_BUTTON0_YDELTA_OFFSET                                        (54u)
#define CY_CAPSENSE_BUTTON0_YDELTA_SIZE                                          (2u)
#define CY_CAPSENSE_BUTTON0_YDELTA_PARAM_ID                                      (0x02000036u)

#define CY_CAPSENSE_BUTTON0_NOISE_TH_VALUE                                       (cy_capsense_tuner.widgetContext[0].noiseTh)
#define CY_CAPSENSE_BUTTON0_NOISE_TH_OFFSET                                      (56u)
#define CY_CAPSENSE_BUTTON0_NOISE_TH_SIZE                                        (2u)
#define CY_CAPSENSE_BUTTON0_NOISE_TH_PARAM_ID                                    (0x06000038u)

#define CY_CAPSENSE_BUTTON0_NNOISE_TH_VALUE                                      (cy_capsense_tuner.widgetContext[0].nNoiseTh)
#define CY_CAPSENSE_BUTTON0_NNOISE_TH_OFFSET                                     (58u)
#define CY_CAPSENSE_BUTTON0_NNOISE_TH_SIZE                                       (2u)
#define CY_CAPSENSE_BUTTON0_NNOISE_TH_PARAM_ID                                   (0x0600003au)

#define CY_CAPSENSE_BUTTON0_HYSTERESIS_VALUE                                     (cy_capsense_tuner.widgetContext[0].hysteresis)
#define CY_CAPSENSE_BUTTON0_HYSTERESIS_OFFSET                                    (60u)
#define CY_CAPSENSE_BUTTON0_HYSTERESIS_SIZE                                      (2u)
#define CY_CAPSENSE_BUTTON0_HYSTERESIS_PARAM_ID                                  (0x0600003cu)

#define CY_CAPSENSE_BUTTON0_ON_DEBOUNCE_VALUE                                    (cy_capsense_tuner.widgetContext[0].onDebounce)
#define CY_CAPSENSE_BUTTON0_ON_DEBOUNCE_OFFSET                                   (62u)
#define CY_CAPSENSE_BUTTON0_ON_DEBOUNCE_SIZE                                     (1u)
#define CY_CAPSENSE_BUTTON0_ON_DEBOUNCE_PARAM_ID                                 (0x0500003eu)

#define CY_CAPSENSE_BUTTON0_TX_CLK_SOURCE_VALUE                                  (cy_capsense_tuner.widgetContext[0].snsClkSource)
#define CY_CAPSENSE_BUTTON0_TX_CLK_SOURCE_OFFSET                                 (63u)
#define CY_CAPSENSE_BUTTON0_TX_CLK_SOURCE_SIZE                                   (1u)
#define CY_CAPSENSE_BUTTON0_TX_CLK_SOURCE_PARAM_ID                               (0x0500003fu)

#define CY_CAPSENSE_BUTTON0_IDAC_MOD0_VALUE                                      (cy_capsense_tuner.widgetContext[0].idacMod[0])
#define CY_CAPSENSE_BUTTON0_IDAC_MOD0_OFFSET                                     (64u)
#define CY_CAPSENSE_BUTTON0_IDAC_MOD0_SIZE                                       (1u)
#define CY_CAPSENSE_BUTTON0_IDAC_MOD0_PARAM_ID                                   (0x05000040u)

#define CY_CAPSENSE_BUTTON0_IDAC_MOD1_VALUE                                      (cy_capsense_tuner.widgetContext[0].idacMod[1])
#define CY_CAPSENSE_BUTTON0_IDAC_MOD1_OFFSET                                     (65u)
#define CY_CAPSENSE_BUTTON0_IDAC_MOD1_SIZE                                       (1u)
#define CY_CAPSENSE_BUTTON0_IDAC_MOD1_PARAM_ID                                   (0x05000041u)

#define CY_CAPSENSE_BUTTON0_IDAC_MOD2_VALUE                                      (cy_capsense_tuner.widgetContext[0].idacMod[2])
#define CY_CAPSENSE_BUTTON0_IDAC_MOD2_OFFSET                                     (66u)
#define CY_CAPSENSE_BUTTON0_IDAC_MOD2_SIZE                                       (1u)
#define CY_CAPSENSE_BUTTON0_IDAC_MOD2_PARAM_ID                                   (0x05000042u)

#define CY_CAPSENSE_BUTTON0_IDAC_GAIN_INDEX_VALUE                                (cy_capsense_tuner.widgetContext[0].idacGainIndex)
#define CY_CAPSENSE_BUTTON0_IDAC_GAIN_INDEX_OFFSET                               (67u)
#define CY_CAPSENSE_BUTTON0_IDAC_GAIN_INDEX_SIZE                                 (1u)
#define CY_CAPSENSE_BUTTON0_IDAC_GAIN_INDEX_PARAM_ID                             (0x05000043u)

#define CY_CAPSENSE_BUTTON0_ROW_IDAC_MOD0_VALUE                                  (cy_capsense_tuner.widgetContext[0].rowIdacMod[0])
#define CY_CAPSENSE_BUTTON0_ROW_IDAC_MOD0_OFFSET                                 (68u)
#define CY_CAPSENSE_BUTTON0_ROW_IDAC_MOD0_SIZE                                   (1u)
#define CY_CAPSENSE_BUTTON0_ROW_IDAC_MOD0_PARAM_ID                               (0x05000044u)

#define CY_CAPSENSE_BUTTON0_ROW_IDAC_MOD1_VALUE                                  (cy_capsense_tuner.widgetContext[0].rowIdacMod[1])
#define CY_CAPSENSE_BUTTON0_ROW_IDAC_MOD1_OFFSET                                 (69u)
#define CY_CAPSENSE_BUTTON0_ROW_IDAC_MOD1_SIZE                                   (1u)
#define CY_CAPSENSE_BUTTON0_ROW_IDAC_MOD1_PARAM_ID                               (0x05000045u)

#define CY_CAPSENSE_BUTTON0_ROW_IDAC_MOD2_VALUE                                  (cy_capsense_tuner.widgetContext[0].rowIdacMod[2])
#define CY_CAPSENSE_BUTTON0_ROW_IDAC_MOD2_OFFSET                                 (70u)
#define CY_CAPSENSE_BUTTON0_ROW_IDAC_MOD2_SIZE                                   (1u)
#define CY_CAPSENSE_BUTTON0_ROW_IDAC_MOD2_PARAM_ID                               (0x05000046u)

#define CY_CAPSENSE_BUTTON0_REGULAR_IIR_BL_N_VALUE                               (cy_capsense_tuner.widgetContext[0].bslnCoeff)
#define CY_CAPSENSE_BUTTON0_REGULAR_IIR_BL_N_OFFSET                              (71u)
#define CY_CAPSENSE_BUTTON0_REGULAR_IIR_BL_N_SIZE                                (1u)
#define CY_CAPSENSE_BUTTON0_REGULAR_IIR_BL_N_PARAM_ID                            (0x05000047u)

#define CY_CAPSENSE_BUTTON0_STATUS_VALUE                                         (cy_capsense_tuner.widgetContext[0].status)
#define CY_CAPSENSE_BUTTON0_STATUS_OFFSET                                        (72u)
#define CY_CAPSENSE_BUTTON0_STATUS_SIZE                                          (1u)
#define CY_CAPSENSE_BUTTON0_STATUS_PARAM_ID                                      (0x01000048u)

#define CY_CAPSENSE_BUTTON0_PTRPOSITION_VALUE                                    (cy_capsense_tuner.widgetContext[0].wdTouch.ptrPosition)
#define CY_CAPSENSE_BUTTON0_PTRPOSITION_OFFSET                                   (76u)
#define CY_CAPSENSE_BUTTON0_PTRPOSITION_SIZE                                     (4u)
#define CY_CAPSENSE_BUTTON0_PTRPOSITION_PARAM_ID                                 (0x0300004cu)

#define CY_CAPSENSE_BUTTON0_NUM_POSITIONS_VALUE                                  (cy_capsense_tuner.widgetContext[0].wdTouch.numPosition)
#define CY_CAPSENSE_BUTTON0_NUM_POSITIONS_OFFSET                                 (80u)
#define CY_CAPSENSE_BUTTON0_NUM_POSITIONS_SIZE                                   (1u)
#define CY_CAPSENSE_BUTTON0_NUM_POSITIONS_PARAM_ID                               (0x01000050u)

#define CY_CAPSENSE_BUTTON1_FINGER_CP_VALUE                                      (cy_capsense_tuner.widgetContext[1].fingerCap)
#define CY_CAPSENSE_BUTTON1_FINGER_CP_OFFSET                                     (84u)
#define CY_CAPSENSE_BUTTON1_FINGER_CP_SIZE                                       (2u)
#define CY_CAPSENSE_BUTTON1_FINGER_CP_PARAM_ID                                   (0x06010054u)

#define CY_CAPSENSE_BUTTON1_SIGPFC_VALUE                                         (cy_capsense_tuner.widgetContext[1].sigPFC)
#define CY_CAPSENSE_BUTTON1_SIGPFC_OFFSET                                        (86u)
#define CY_CAPSENSE_BUTTON1_SIGPFC_SIZE                                          (2u)
#define CY_CAPSENSE_BUTTON1_SIGPFC_PARAM_ID                                      (0x06010056u)

#define CY_CAPSENSE_BUTTON1_NUM_CONV_VALUE                                       (cy_capsense_tuner.widgetContext[1].resolution)
#define CY_CAPSENSE_BUTTON1_NUM_CONV_OFFSET                                      (88u)
#define CY_CAPSENSE_BUTTON1_NUM_CONV_SIZE                                        (2u)
#define CY_CAPSENSE_BUTTON1_NUM_CONV_PARAM_ID                                    (0x06010058u)

#define CY_CAPSENSE_BUTTON1_MAX_RAW_COUNT_VALUE                                  (cy_capsense_tuner.widgetContext[1].maxRawCount)
#define CY_CAPSENSE_BUTTON1_MAX_RAW_COUNT_OFFSET                                 (90u)
#define CY_CAPSENSE_BUTTON1_MAX_RAW_COUNT_SIZE                                   (2u)
#define CY_CAPSENSE_BUTTON1_MAX_RAW_COUNT_PARAM_ID                               (0x0601005au)

#define CY_CAPSENSE_BUTTON1_ROW_MAX_RAW_COUNT_VALUE                              (cy_capsense_tuner.widgetContext[1].maxRawCountRow)
#define CY_CAPSENSE_BUTTON1_ROW_MAX_RAW_COUNT_OFFSET                             (92u)
#define CY_CAPSENSE_BUTTON1_ROW_MAX_RAW_COUNT_SIZE                               (2u)
#define CY_CAPSENSE_BUTTON1_ROW_MAX_RAW_COUNT_PARAM_ID                           (0x0601005cu)

#define CY_CAPSENSE_BUTTON1_FINGER_TH_VALUE                                      (cy_capsense_tuner.widgetContext[1].fingerTh)
#define CY_CAPSENSE_BUTTON1_FINGER_TH_OFFSET                                     (94u)
#define CY_CAPSENSE_BUTTON1_FINGER_TH_SIZE                                       (2u)
#define CY_CAPSENSE_BUTTON1_FINGER_TH_PARAM_ID                                   (0x0601005eu)

#define CY_CAPSENSE_BUTTON1_PROX_TOUCH_TH_VALUE                                  (cy_capsense_tuner.widgetContext[1].proxTh)
#define CY_CAPSENSE_BUTTON1_PROX_TOUCH_TH_OFFSET                                 (96u)
#define CY_CAPSENSE_BUTTON1_PROX_TOUCH_TH_SIZE                                   (2u)
#define CY_CAPSENSE_BUTTON1_PROX_TOUCH_TH_PARAM_ID                               (0x06010060u)

#define CY_CAPSENSE_BUTTON1_LOW_BSLN_RST_VALUE                                   (cy_capsense_tuner.widgetContext[1].lowBslnRst)
#define CY_CAPSENSE_BUTTON1_LOW_BSLN_RST_OFFSET                                  (98u)
#define CY_CAPSENSE_BUTTON1_LOW_BSLN_RST_SIZE                                    (2u)
#define CY_CAPSENSE_BUTTON1_LOW_BSLN_RST_PARAM_ID                                (0x06010062u)

#define CY_CAPSENSE_BUTTON1_TX_CLK_VALUE                                         (cy_capsense_tuner.widgetContext[1].snsClk)
#define CY_CAPSENSE_BUTTON1_TX_CLK_OFFSET                                        (100u)
#define CY_CAPSENSE_BUTTON1_TX_CLK_SIZE                                          (2u)
#define CY_CAPSENSE_BUTTON1_TX_CLK_PARAM_ID                                      (0x06010064u)

#define CY_CAPSENSE_BUTTON1_ROW_SNS_CLK_VALUE                                    (cy_capsense_tuner.widgetContext[1].rowSnsClk)
#define CY_CAPSENSE_BUTTON1_ROW_SNS_CLK_OFFSET                                   (102u)
#define CY_CAPSENSE_BUTTON1_ROW_SNS_CLK_SIZE                                     (2u)
#define CY_CAPSENSE_BUTTON1_ROW_SNS_CLK_PARAM_ID                                 (0x06010066u)

#define CY_CAPSENSE_BUTTON1_GESTURE_DETECTED_VALUE                               (cy_capsense_tuner.widgetContext[1].gestureDetected)
#define CY_CAPSENSE_BUTTON1_GESTURE_DETECTED_OFFSET                              (104u)
#define CY_CAPSENSE_BUTTON1_GESTURE_DETECTED_SIZE                                (2u)
#define CY_CAPSENSE_BUTTON1_GESTURE_DETECTED_PARAM_ID                            (0x02010068u)

#define CY_CAPSENSE_BUTTON1_GESTURE_DIRECTION_VALUE                              (cy_capsense_tuner.widgetContext[1].gestureDirection)
#define CY_CAPSENSE_BUTTON1_GESTURE_DIRECTION_OFFSET                             (106u)
#define CY_CAPSENSE_BUTTON1_GESTURE_DIRECTION_SIZE                               (2u)
#define CY_CAPSENSE_BUTTON1_GESTURE_DIRECTION_PARAM_ID                           (0x0201006au)

#define CY_CAPSENSE_BUTTON1_XDELTA_VALUE                                         (cy_capsense_tuner.widgetContext[1].xDelta)
#define CY_CAPSENSE_BUTTON1_XDELTA_OFFSET                                        (108u)
#define CY_CAPSENSE_BUTTON1_XDELTA_SIZE                                          (2u)
#define CY_CAPSENSE_BUTTON1_XDELTA_PARAM_ID                                      (0x0201006cu)

#define CY_CAPSENSE_BUTTON1_YDELTA_VALUE                                         (cy_capsense_tuner.widgetContext[1].yDelta)
#define CY_CAPSENSE_BUTTON1_YDELTA_OFFSET                                        (110u)
#define CY_CAPSENSE_BUTTON1_YDELTA_SIZE                                          (2u)
#define CY_CAPSENSE_BUTTON1_YDELTA_PARAM_ID                                      (0x0201006eu)

#define CY_CAPSENSE_BUTTON1_NOISE_TH_VALUE                                       (cy_capsense_tuner.widgetContext[1].noiseTh)
#define CY_CAPSENSE_BUTTON1_NOISE_TH_OFFSET                                      (112u)
#define CY_CAPSENSE_BUTTON1_NOISE_TH_SIZE                                        (2u)
#define CY_CAPSENSE_BUTTON1_NOISE_TH_PARAM_ID                                    (0x06010070u)

#define CY_CAPSENSE_BUTTON1_NNOISE_TH_VALUE                                      (cy_capsense_tuner.widgetContext[1].nNoiseTh)
#define CY_CAPSENSE_BUTTON1_NNOISE_TH_OFFSET                                     (114u)
#define CY_CAPSENSE_BUTTON1_NNOISE_TH_SIZE                                       (2u)
#define CY_CAPSENSE_BUTTON1_NNOISE_TH_PARAM_ID                                   (0x06010072u)

#define CY_CAPSENSE_BUTTON1_HYSTERESIS_VALUE                                     (cy_capsense_tuner.widgetContext[1].hysteresis)
#define CY_CAPSENSE_BUTTON1_HYSTERESIS_OFFSET                                    (116u)
#define CY_CAPSENSE_BUTTON1_HYSTERESIS_SIZE                                      (2u)
#define CY_CAPSENSE_BUTTON1_HYSTERESIS_PARAM_ID                                  (0x06010074u)

#define CY_CAPSENSE_BUTTON1_ON_DEBOUNCE_VALUE                                    (cy_capsense_tuner.widgetContext[1].onDebounce)
#define CY_CAPSENSE_BUTTON1_ON_DEBOUNCE_OFFSET                                   (118u)
#define CY_CAPSENSE_BUTTON1_ON_DEBOUNCE_SIZE                                     (1u)
#define CY_CAPSENSE_BUTTON1_ON_DEBOUNCE_PARAM_ID                                 (0x05010076u)

#define CY_CAPSENSE_BUTTON1_TX_CLK_SOURCE_VALUE                                  (cy_capsense_tuner.widgetContext[1].snsClkSource)
#define CY_CAPSENSE_BUTTON1_TX_CLK_SOURCE_OFFSET                                 (119u)
#define CY_CAPSENSE_BUTTON1_TX_CLK_SOURCE_SIZE                                   (1u)
#define CY_CAPSENSE_BUTTON1_TX_CLK_SOURCE_PARAM_ID                               (0x05010077u)

#define CY_CAPSENSE_BUTTON1_IDAC_MOD0_VALUE                                      (cy_capsense_tuner.widgetContext[1].idacMod[0])
#define CY_CAPSENSE_BUTTON1_IDAC_MOD0_OFFSET                                     (120u)
#define CY_CAPSENSE_BUTTON1_IDAC_MOD0_SIZE                                       (1u)
#define CY_CAPSENSE_BUTTON1_IDAC_MOD0_PARAM_ID                                   (0x05010078u)

#define CY_CAPSENSE_BUTTON1_IDAC_MOD1_VALUE                                      (cy_capsense_tuner.widgetContext[1].idacMod[1])
#define CY_CAPSENSE_BUTTON1_IDAC_MOD1_OFFSET                                     (121u)
#define CY_CAPSENSE_BUTTON1_IDAC_MOD1_SIZE                                       (1u)
#define CY_CAPSENSE_BUTTON1_IDAC_MOD1_PARAM_ID                                   (0x05010079u)

#define CY_CAPSENSE_BUTTON1_IDAC_MOD2_VALUE                                      (cy_capsense_tuner.widgetContext[1].idacMod[2])
#define CY_CAPSENSE_BUTTON1_IDAC_MOD2_OFFSET                                     (122u)
#define CY_CAPSENSE_BUTTON1_IDAC_MOD2_SIZE                                       (1u)
#define CY_CAPSENSE_BUTTON1_IDAC_MOD2_PARAM_ID                                   (0x0501007au)

#define CY_CAPSENSE_BUTTON1_IDAC_GAIN_INDEX_VALUE                                (cy_capsense_tuner.widgetContext[1].idacGainIndex)
#define CY_CAPSENSE_BUTTON1_IDAC_GAIN_INDEX_OFFSET                               (123u)
#define CY_CAPSENSE_BUTTON1_IDAC_GAIN_INDEX_SIZE                                 (1u)
#define CY_CAPSENSE_BUTTON1_IDAC_GAIN_INDEX_PARAM_ID                             (0x0501007bu)

#define CY_CAPSENSE_BUTTON1_ROW_IDAC_MOD0_VALUE                                  (cy_capsense_tuner.widgetContext[1].rowIdacMod[0])
#define CY_CAPSENSE_BUTTON1_ROW_IDAC_MOD0_OFFSET                                 (124u)
#define CY_CAPSENSE_BUTTON1_ROW_IDAC_MOD0_SIZE                                   (1u)
#define CY_CAPSENSE_BUTTON1_ROW_IDAC_MOD0_PARAM_ID                               (0x0501007cu)

#define CY_CAPSENSE_BUTTON1_ROW_IDAC_MOD1_VALUE                                  (cy_capsense_tuner.widgetContext[1].rowIdacMod[1])
#define CY_CAPSENSE_BUTTON1_ROW_IDAC_MOD1_OFFSET                                 (125u)
#define CY_CAPSENSE_BUTTON1_ROW_IDAC_MOD1_SIZE                                   (1u)
#define CY_CAPSENSE_BUTTON1_ROW_IDAC_MOD1_PARAM_ID                               (0x0501007du)

#define CY_CAPSENSE_BUTTON1_ROW_IDAC_MOD2_VALUE                                  (cy_capsense_tuner.widgetContext[1].rowIdacMod[2])
#define CY_CAPSENSE_BUTTON1_ROW_IDAC_MOD2_OFFSET                                 (126u)
#define CY_CAPSENSE_BUTTON1_ROW_IDAC_MOD2_SIZE                                   (1u)
#define CY_CAPSENSE_BUTTON1_ROW_IDAC_MOD2_PARAM_ID                               (0x0501007eu)

#define CY_CAPSENSE_BUTTON1_REGULAR_IIR_BL_N_VALUE                               (cy_capsense_tuner.widgetContext[1].bslnCoeff)
#define CY_CAPSENSE_BUTTON1_REGULAR_IIR_BL_N_OFFSET                              (127u)
#define CY_CAPSENSE_BUTTON1_REGULAR_IIR_BL_N_SIZE                                (1u)
#define CY_CAPSENSE_BUTTON1_REGULAR_IIR_BL_N_PARAM_ID                            (0x0501007fu)

#define CY_CAPSENSE_BUTTON1_STATUS_VALUE                                         (cy_capsense_tuner.widgetContext[1].status)
#define CY_CAPSENSE_BUTTON1_STATUS_OFFSET                                        (128u)
#define CY_CAPSENSE_BUTTON1_STATUS_SIZE                                          (1u)
#define CY_CAPSENSE_BUTTON1_STATUS_PARAM_ID                                      (0x01010080u)

#define CY_CAPSENSE_BUTTON1_PTRPOSITION_VALUE                                    (cy_capsense_tuner.widgetContext[1].wdTouch.ptrPosition)
#define CY_CAPSENSE_BUTTON1_PTRPOSITION_OFFSET                                   (132u)
#define CY_CAPSENSE_BUTTON1_PTRPOSITION_SIZE                                     (4u)
#define CY_CAPSENSE_BUTTON1_PTRPOSITION_PARAM_ID                                 (0x03010084u)

#define CY_CAPSENSE_BUTTON1_NUM_POSITIONS_VALUE                                  (cy_capsense_tuner.widgetContext[1].wdTouch.numPosition)
#define CY_CAPSENSE_BUTTON1_NUM_POSITIONS_OFFSET                                 (136u)
#define CY_CAPSENSE_BUTTON1_NUM_POSITIONS_SIZE                                   (1u)
#define CY_CAPSENSE_BUTTON1_NUM_POSITIONS_PARAM_ID                               (0x01010088u)

#define CY_CAPSENSE_LINEARSLIDER0_FINGER_CP_VALUE                                (cy_capsense_tuner.widgetContext[2].fingerCap)
#define CY_CAPSENSE_LINEARSLIDER0_FINGER_CP_OFFSET                               (140u)
#define CY_CAPSENSE_LINEARSLIDER0_FINGER_CP_SIZE                                 (2u)
#define CY_CAPSENSE_LINEARSLIDER0_FINGER_CP_PARAM_ID                             (0x0602008cu)

#define CY_CAPSENSE_LINEARSLIDER0_SIGPFC_VALUE                                   (cy_capsense_tuner.widgetContext[2].sigPFC)
#define CY_CAPSENSE_LINEARSLIDER0_SIGPFC_OFFSET                                  (142u)
#define CY_CAPSENSE_LINEARSLIDER0_SIGPFC_SIZE                                    (2u)
#define CY_CAPSENSE_LINEARSLIDER0_SIGPFC_PARAM_ID                                (0x0602008eu)

#define CY_CAPSENSE_LINEARSLIDER0_RESOLUTION_VALUE                               (cy_capsense_tuner.widgetContext[2].resolution)
#define CY_CAPSENSE_LINEARSLIDER0_RESOLUTION_OFFSET                              (144u)
#define CY_CAPSENSE_LINEARSLIDER0_RESOLUTION_SIZE                                (2u)
#define CY_CAPSENSE_LINEARSLIDER0_RESOLUTION_PARAM_ID                            (0x06020090u)

#define CY_CAPSENSE_LINEARSLIDER0_MAX_RAW_COUNT_VALUE                            (cy_capsense_tuner.widgetContext[2].maxRawCount)
#define CY_CAPSENSE_LINEARSLIDER0_MAX_RAW_COUNT_OFFSET                           (146u)
#define CY_CAPSENSE_LINEARSLIDER0_MAX_RAW_COUNT_SIZE                             (2u)
#define CY_CAPSENSE_LINEARSLIDER0_MAX_RAW_COUNT_PARAM_ID                         (0x06020092u)

#define CY_CAPSENSE_LINEARSLIDER0_ROW_MAX_RAW_COUNT_VALUE                        (cy_capsense_tuner.widgetContext[2].maxRawCountRow)
#define CY_CAPSENSE_LINEARSLIDER0_ROW_MAX_RAW_COUNT_OFFSET                       (148u)
#define CY_CAPSENSE_LINEARSLIDER0_ROW_MAX_RAW_COUNT_SIZE                         (2u)
#define CY_CAPSENSE_LINEARSLIDER0_ROW_MAX_RAW_COUNT_PARAM_ID                     (0x06020094u)

#define CY_CAPSENSE_LINEARSLIDER0_FINGER_TH_VALUE                                (cy_capsense_tuner.widgetContext[2].fingerTh)
#define CY_CAPSENSE_LINEARSLIDER0_FINGER_TH_OFFSET                               (150u)
#define CY_CAPSENSE_LINEARSLIDER0_FINGER_TH_SIZE                                 (2u)
#define CY_CAPSENSE_LINEARSLIDER0_FINGER_TH_PARAM_ID                             (0x02020096u)

#define CY_CAPSENSE_LINEARSLIDER0_PROX_TOUCH_TH_VALUE                            (cy_capsense_tuner.widgetContext[2].proxTh)
#define CY_CAPSENSE_LINEARSLIDER0_PROX_TOUCH_TH_OFFSET                           (152u)
#define CY_CAPSENSE_LINEARSLIDER0_PROX_TOUCH_TH_SIZE                             (2u)
#define CY_CAPSENSE_LINEARSLIDER0_PROX_TOUCH_TH_PARAM_ID                         (0x02020098u)

#define CY_CAPSENSE_LINEARSLIDER0_LOW_BSLN_RST_VALUE                             (cy_capsense_tuner.widgetContext[2].lowBslnRst)
#define CY_CAPSENSE_LINEARSLIDER0_LOW_BSLN_RST_OFFSET                            (154u)
#define CY_CAPSENSE_LINEARSLIDER0_LOW_BSLN_RST_SIZE                              (2u)
#define CY_CAPSENSE_LINEARSLIDER0_LOW_BSLN_RST_PARAM_ID                          (0x0602009au)

#define CY_CAPSENSE_LINEARSLIDER0_SNS_CLK_VALUE                                  (cy_capsense_tuner.widgetContext[2].snsClk)
#define CY_CAPSENSE_LINEARSLIDER0_SNS_CLK_OFFSET                                 (156u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS_CLK_SIZE                                   (2u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS_CLK_PARAM_ID                               (0x0602009cu)

#define CY_CAPSENSE_LINEARSLIDER0_ROW_SNS_CLK_VALUE                              (cy_capsense_tuner.widgetContext[2].rowSnsClk)
#define CY_CAPSENSE_LINEARSLIDER0_ROW_SNS_CLK_OFFSET                             (158u)
#define CY_CAPSENSE_LINEARSLIDER0_ROW_SNS_CLK_SIZE                               (2u)
#define CY_CAPSENSE_LINEARSLIDER0_ROW_SNS_CLK_PARAM_ID                           (0x0602009eu)

#define CY_CAPSENSE_LINEARSLIDER0_GESTURE_DETECTED_VALUE                         (cy_capsense_tuner.widgetContext[2].gestureDetected)
#define CY_CAPSENSE_LINEARSLIDER0_GESTURE_DETECTED_OFFSET                        (160u)
#define CY_CAPSENSE_LINEARSLIDER0_GESTURE_DETECTED_SIZE                          (2u)
#define CY_CAPSENSE_LINEARSLIDER0_GESTURE_DETECTED_PARAM_ID                      (0x020200a0u)

#define CY_CAPSENSE_LINEARSLIDER0_GESTURE_DIRECTION_VALUE                        (cy_capsense_tuner.widgetContext[2].gestureDirection)
#define CY_CAPSENSE_LINEARSLIDER0_GESTURE_DIRECTION_OFFSET                       (162u)
#define CY_CAPSENSE_LINEARSLIDER0_GESTURE_DIRECTION_SIZE                         (2u)
#define CY_CAPSENSE_LINEARSLIDER0_GESTURE_DIRECTION_PARAM_ID                     (0x020200a2u)

#define CY_CAPSENSE_LINEARSLIDER0_XDELTA_VALUE                                   (cy_capsense_tuner.widgetContext[2].xDelta)
#define CY_CAPSENSE_LINEARSLIDER0_XDELTA_OFFSET                                  (164u)
#define CY_CAPSENSE_LINEARSLIDER0_XDELTA_SIZE                                    (2u)
#define CY_CAPSENSE_LINEARSLIDER0_XDELTA_PARAM_ID                                (0x020200a4u)

#define CY_CAPSENSE_LINEARSLIDER0_YDELTA_VALUE                                   (cy_capsense_tuner.widgetContext[2].yDelta)
#define CY_CAPSENSE_LINEARSLIDER0_YDELTA_OFFSET                                  (166u)
#define CY_CAPSENSE_LINEARSLIDER0_YDELTA_SIZE                                    (2u)
#define CY_CAPSENSE_LINEARSLIDER0_YDELTA_PARAM_ID                                (0x020200a6u)

#define CY_CAPSENSE_LINEARSLIDER0_NOISE_TH_VALUE                                 (cy_capsense_tuner.widgetContext[2].noiseTh)
#define CY_CAPSENSE_LINEARSLIDER0_NOISE_TH_OFFSET                                (168u)
#define CY_CAPSENSE_LINEARSLIDER0_NOISE_TH_SIZE                                  (2u)
#define CY_CAPSENSE_LINEARSLIDER0_NOISE_TH_PARAM_ID                              (0x020200a8u)

#define CY_CAPSENSE_LINEARSLIDER0_NNOISE_TH_VALUE                                (cy_capsense_tuner.widgetContext[2].nNoiseTh)
#define CY_CAPSENSE_LINEARSLIDER0_NNOISE_TH_OFFSET                               (170u)
#define CY_CAPSENSE_LINEARSLIDER0_NNOISE_TH_SIZE                                 (2u)
#define CY_CAPSENSE_LINEARSLIDER0_NNOISE_TH_PARAM_ID                             (0x020200aau)

#define CY_CAPSENSE_LINEARSLIDER0_HYSTERESIS_VALUE                               (cy_capsense_tuner.widgetContext[2].hysteresis)
#define CY_CAPSENSE_LINEARSLIDER0_HYSTERESIS_OFFSET                              (172u)
#define CY_CAPSENSE_LINEARSLIDER0_HYSTERESIS_SIZE                                (2u)
#define CY_CAPSENSE_LINEARSLIDER0_HYSTERESIS_PARAM_ID                            (0x020200acu)

#define CY_CAPSENSE_LINEARSLIDER0_ON_DEBOUNCE_VALUE                              (cy_capsense_tuner.widgetContext[2].onDebounce)
#define CY_CAPSENSE_LINEARSLIDER0_ON_DEBOUNCE_OFFSET                             (174u)
#define CY_CAPSENSE_LINEARSLIDER0_ON_DEBOUNCE_SIZE                               (1u)
#define CY_CAPSENSE_LINEARSLIDER0_ON_DEBOUNCE_PARAM_ID                           (0x050200aeu)

#define CY_CAPSENSE_LINEARSLIDER0_SNS_CLK_SOURCE_VALUE                           (cy_capsense_tuner.widgetContext[2].snsClkSource)
#define CY_CAPSENSE_LINEARSLIDER0_SNS_CLK_SOURCE_OFFSET                          (175u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS_CLK_SOURCE_SIZE                            (1u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS_CLK_SOURCE_PARAM_ID                        (0x050200afu)

#define CY_CAPSENSE_LINEARSLIDER0_IDAC_MOD0_VALUE                                (cy_capsense_tuner.widgetContext[2].idacMod[0])
#define CY_CAPSENSE_LINEARSLIDER0_IDAC_MOD0_OFFSET                               (176u)
#define CY_CAPSENSE_LINEARSLIDER0_IDAC_MOD0_SIZE                                 (1u)
#define CY_CAPSENSE_LINEARSLIDER0_IDAC_MOD0_PARAM_ID                             (0x050200b0u)

#define CY_CAPSENSE_LINEARSLIDER0_IDAC_MOD1_VALUE                                (cy_capsense_tuner.widgetContext[2].idacMod[1])
#define CY_CAPSENSE_LINEARSLIDER0_IDAC_MOD1_OFFSET                               (177u)
#define CY_CAPSENSE_LINEARSLIDER0_IDAC_MOD1_SIZE                                 (1u)
#define CY_CAPSENSE_LINEARSLIDER0_IDAC_MOD1_PARAM_ID                             (0x050200b1u)

#define CY_CAPSENSE_LINEARSLIDER0_IDAC_MOD2_VALUE                                (cy_capsense_tuner.widgetContext[2].idacMod[2])
#define CY_CAPSENSE_LINEARSLIDER0_IDAC_MOD2_OFFSET                               (178u)
#define CY_CAPSENSE_LINEARSLIDER0_IDAC_MOD2_SIZE                                 (1u)
#define CY_CAPSENSE_LINEARSLIDER0_IDAC_MOD2_PARAM_ID                             (0x050200b2u)

#define CY_CAPSENSE_LINEARSLIDER0_IDAC_GAIN_INDEX_VALUE                          (cy_capsense_tuner.widgetContext[2].idacGainIndex)
#define CY_CAPSENSE_LINEARSLIDER0_IDAC_GAIN_INDEX_OFFSET                         (179u)
#define CY_CAPSENSE_LINEARSLIDER0_IDAC_GAIN_INDEX_SIZE                           (1u)
#define CY_CAPSENSE_LINEARSLIDER0_IDAC_GAIN_INDEX_PARAM_ID                       (0x050200b3u)

#define CY_CAPSENSE_LINEARSLIDER0_ROW_IDAC_MOD0_VALUE                            (cy_capsense_tuner.widgetContext[2].rowIdacMod[0])
#define CY_CAPSENSE_LINEARSLIDER0_ROW_IDAC_MOD0_OFFSET                           (180u)
#define CY_CAPSENSE_LINEARSLIDER0_ROW_IDAC_MOD0_SIZE                             (1u)
#define CY_CAPSENSE_LINEARSLIDER0_ROW_IDAC_MOD0_PARAM_ID                         (0x050200b4u)

#define CY_CAPSENSE_LINEARSLIDER0_ROW_IDAC_MOD1_VALUE                            (cy_capsense_tuner.widgetContext[2].rowIdacMod[1])
#define CY_CAPSENSE_LINEARSLIDER0_ROW_IDAC_MOD1_OFFSET                           (181u)
#define CY_CAPSENSE_LINEARSLIDER0_ROW_IDAC_MOD1_SIZE                             (1u)
#define CY_CAPSENSE_LINEARSLIDER0_ROW_IDAC_MOD1_PARAM_ID                         (0x050200b5u)

#define CY_CAPSENSE_LINEARSLIDER0_ROW_IDAC_MOD2_VALUE                            (cy_capsense_tuner.widgetContext[2].rowIdacMod[2])
#define CY_CAPSENSE_LINEARSLIDER0_ROW_IDAC_MOD2_OFFSET                           (182u)
#define CY_CAPSENSE_LINEARSLIDER0_ROW_IDAC_MOD2_SIZE                             (1u)
#define CY_CAPSENSE_LINEARSLIDER0_ROW_IDAC_MOD2_PARAM_ID                         (0x050200b6u)

#define CY_CAPSENSE_LINEARSLIDER0_REGULAR_IIR_BL_N_VALUE                         (cy_capsense_tuner.widgetContext[2].bslnCoeff)
#define CY_CAPSENSE_LINEARSLIDER0_REGULAR_IIR_BL_N_OFFSET                        (183u)
#define CY_CAPSENSE_LINEARSLIDER0_REGULAR_IIR_BL_N_SIZE                          (1u)
#define CY_CAPSENSE_LINEARSLIDER0_REGULAR_IIR_BL_N_PARAM_ID                      (0x050200b7u)

#define CY_CAPSENSE_LINEARSLIDER0_STATUS_VALUE                                   (cy_capsense_tuner.widgetContext[2].status)
#define CY_CAPSENSE_LINEARSLIDER0_STATUS_OFFSET                                  (184u)
#define CY_CAPSENSE_LINEARSLIDER0_STATUS_SIZE                                    (1u)
#define CY_CAPSENSE_LINEARSLIDER0_STATUS_PARAM_ID                                (0x010200b8u)

#define CY_CAPSENSE_LINEARSLIDER0_PTRPOSITION_VALUE                              (cy_capsense_tuner.widgetContext[2].wdTouch.ptrPosition)
#define CY_CAPSENSE_LINEARSLIDER0_PTRPOSITION_OFFSET                             (188u)
#define CY_CAPSENSE_LINEARSLIDER0_PTRPOSITION_SIZE                               (4u)
#define CY_CAPSENSE_LINEARSLIDER0_PTRPOSITION_PARAM_ID                           (0x030200bcu)

#define CY_CAPSENSE_LINEARSLIDER0_NUM_POSITIONS_VALUE                            (cy_capsense_tuner.widgetContext[2].wdTouch.numPosition)
#define CY_CAPSENSE_LINEARSLIDER0_NUM_POSITIONS_OFFSET                           (192u)
#define CY_CAPSENSE_LINEARSLIDER0_NUM_POSITIONS_SIZE                             (1u)
#define CY_CAPSENSE_LINEARSLIDER0_NUM_POSITIONS_PARAM_ID                         (0x010200c0u)

#define CY_CAPSENSE_BUTTON0_RX0_RAW0_VALUE                                       (cy_capsense_tuner.sensorContext[0].raw)
#define CY_CAPSENSE_BUTTON0_RX0_RAW0_OFFSET                                      (196u)
#define CY_CAPSENSE_BUTTON0_RX0_RAW0_SIZE                                        (2u)
#define CY_CAPSENSE_BUTTON0_RX0_RAW0_PARAM_ID                                    (0x020000c4u)

#define CY_CAPSENSE_BUTTON0_RX0_BSLN0_VALUE                                      (cy_capsense_tuner.sensorContext[0].bsln)
#define CY_CAPSENSE_BUTTON0_RX0_BSLN0_OFFSET                                     (198u)
#define CY_CAPSENSE_BUTTON0_RX0_BSLN0_SIZE                                       (2u)
#define CY_CAPSENSE_BUTTON0_RX0_BSLN0_PARAM_ID                                   (0x020000c6u)

#define CY_CAPSENSE_BUTTON0_RX0_DIFF0_VALUE                                      (cy_capsense_tuner.sensorContext[0].diff)
#define CY_CAPSENSE_BUTTON0_RX0_DIFF0_OFFSET                                     (200u)
#define CY_CAPSENSE_BUTTON0_RX0_DIFF0_SIZE                                       (2u)
#define CY_CAPSENSE_BUTTON0_RX0_DIFF0_PARAM_ID                                   (0x020000c8u)

#define CY_CAPSENSE_BUTTON0_RX0_STATUS0_VALUE                                    (cy_capsense_tuner.sensorContext[0].status)
#define CY_CAPSENSE_BUTTON0_RX0_STATUS0_OFFSET                                   (202u)
#define CY_CAPSENSE_BUTTON0_RX0_STATUS0_SIZE                                     (1u)
#define CY_CAPSENSE_BUTTON0_RX0_STATUS0_PARAM_ID                                 (0x010000cau)

#define CY_CAPSENSE_BUTTON0_RX0_NEG_BSLN_RST_CNT0_VALUE                          (cy_capsense_tuner.sensorContext[0].negBslnRstCnt)
#define CY_CAPSENSE_BUTTON0_RX0_NEG_BSLN_RST_CNT0_OFFSET                         (203u)
#define CY_CAPSENSE_BUTTON0_RX0_NEG_BSLN_RST_CNT0_SIZE                           (1u)
#define CY_CAPSENSE_BUTTON0_RX0_NEG_BSLN_RST_CNT0_PARAM_ID                       (0x010000cbu)

#define CY_CAPSENSE_BUTTON0_RX0_IDAC0_VALUE                                      (cy_capsense_tuner.sensorContext[0].idacComp)
#define CY_CAPSENSE_BUTTON0_RX0_IDAC0_OFFSET                                     (204u)
#define CY_CAPSENSE_BUTTON0_RX0_IDAC0_SIZE                                       (1u)
#define CY_CAPSENSE_BUTTON0_RX0_IDAC0_PARAM_ID                                   (0x010000ccu)

#define CY_CAPSENSE_BUTTON0_RX0_BSLN_EXT0_VALUE                                  (cy_capsense_tuner.sensorContext[0].bslnExt)
#define CY_CAPSENSE_BUTTON0_RX0_BSLN_EXT0_OFFSET                                 (205u)
#define CY_CAPSENSE_BUTTON0_RX0_BSLN_EXT0_SIZE                                   (1u)
#define CY_CAPSENSE_BUTTON0_RX0_BSLN_EXT0_PARAM_ID                               (0x010000cdu)

#define CY_CAPSENSE_BUTTON1_RX0_RAW0_VALUE                                       (cy_capsense_tuner.sensorContext[1].raw)
#define CY_CAPSENSE_BUTTON1_RX0_RAW0_OFFSET                                      (206u)
#define CY_CAPSENSE_BUTTON1_RX0_RAW0_SIZE                                        (2u)
#define CY_CAPSENSE_BUTTON1_RX0_RAW0_PARAM_ID                                    (0x020100ceu)

#define CY_CAPSENSE_BUTTON1_RX0_BSLN0_VALUE                                      (cy_capsense_tuner.sensorContext[1].bsln)
#define CY_CAPSENSE_BUTTON1_RX0_BSLN0_OFFSET                                     (208u)
#define CY_CAPSENSE_BUTTON1_RX0_BSLN0_SIZE                                       (2u)
#define CY_CAPSENSE_BUTTON1_RX0_BSLN0_PARAM_ID                                   (0x020100d0u)

#define CY_CAPSENSE_BUTTON1_RX0_DIFF0_VALUE                                      (cy_capsense_tuner.sensorContext[1].diff)
#define CY_CAPSENSE_BUTTON1_RX0_DIFF0_OFFSET                                     (210u)
#define CY_CAPSENSE_BUTTON1_RX0_DIFF0_SIZE                                       (2u)
#define CY_CAPSENSE_BUTTON1_RX0_DIFF0_PARAM_ID                                   (0x020100d2u)

#define CY_CAPSENSE_BUTTON1_RX0_STATUS0_VALUE                                    (cy_capsense_tuner.sensorContext[1].status)
#define CY_CAPSENSE_BUTTON1_RX0_STATUS0_OFFSET                                   (212u)
#define CY_CAPSENSE_BUTTON1_RX0_STATUS0_SIZE                                     (1u)
#define CY_CAPSENSE_BUTTON1_RX0_STATUS0_PARAM_ID                                 (0x010100d4u)

#define CY_CAPSENSE_BUTTON1_RX0_NEG_BSLN_RST_CNT0_VALUE                          (cy_capsense_tuner.sensorContext[1].negBslnRstCnt)
#define CY_CAPSENSE_BUTTON1_RX0_NEG_BSLN_RST_CNT0_OFFSET                         (213u)
#define CY_CAPSENSE_BUTTON1_RX0_NEG_BSLN_RST_CNT0_SIZE                           (1u)
#define CY_CAPSENSE_BUTTON1_RX0_NEG_BSLN_RST_CNT0_PARAM_ID                       (0x010100d5u)

#define CY_CAPSENSE_BUTTON1_RX0_IDAC0_VALUE                                      (cy_capsense_tuner.sensorContext[1].idacComp)
#define CY_CAPSENSE_BUTTON1_RX0_IDAC0_OFFSET                                     (214u)
#define CY_CAPSENSE_BUTTON1_RX0_IDAC0_SIZE                                       (1u)
#define CY_CAPSENSE_BUTTON1_RX0_IDAC0_PARAM_ID                                   (0x010100d6u)

#define CY_CAPSENSE_BUTTON1_RX0_BSLN_EXT0_VALUE                                  (cy_capsense_tuner.sensorContext[1].bslnExt)
#define CY_CAPSENSE_BUTTON1_RX0_BSLN_EXT0_OFFSET                                 (215u)
#define CY_CAPSENSE_BUTTON1_RX0_BSLN_EXT0_SIZE                                   (1u)
#define CY_CAPSENSE_BUTTON1_RX0_BSLN_EXT0_PARAM_ID                               (0x010100d7u)

#define CY_CAPSENSE_LINEARSLIDER0_SNS0_RAW0_VALUE                                (cy_capsense_tuner.sensorContext[2].raw)
#define CY_CAPSENSE_LINEARSLIDER0_SNS0_RAW0_OFFSET                               (216u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS0_RAW0_SIZE                                 (2u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS0_RAW0_PARAM_ID                             (0x020200d8u)

#define CY_CAPSENSE_LINEARSLIDER0_SNS0_BSLN0_VALUE                               (cy_capsense_tuner.sensorContext[2].bsln)
#define CY_CAPSENSE_LINEARSLIDER0_SNS0_BSLN0_OFFSET                              (218u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS0_BSLN0_SIZE                                (2u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS0_BSLN0_PARAM_ID                            (0x020200dau)

#define CY_CAPSENSE_LINEARSLIDER0_SNS0_DIFF0_VALUE                               (cy_capsense_tuner.sensorContext[2].diff)
#define CY_CAPSENSE_LINEARSLIDER0_SNS0_DIFF0_OFFSET                              (220u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS0_DIFF0_SIZE                                (2u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS0_DIFF0_PARAM_ID                            (0x020200dcu)

#define CY_CAPSENSE_LINEARSLIDER0_SNS0_STATUS0_VALUE                             (cy_capsense_tuner.sensorContext[2].status)
#define CY_CAPSENSE_LINEARSLIDER0_SNS0_STATUS0_OFFSET                            (222u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS0_STATUS0_SIZE                              (1u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS0_STATUS0_PARAM_ID                          (0x010200deu)

#define CY_CAPSENSE_LINEARSLIDER0_SNS0_NEG_BSLN_RST_CNT0_VALUE                   (cy_capsense_tuner.sensorContext[2].negBslnRstCnt)
#define CY_CAPSENSE_LINEARSLIDER0_SNS0_NEG_BSLN_RST_CNT0_OFFSET                  (223u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS0_NEG_BSLN_RST_CNT0_SIZE                    (1u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS0_NEG_BSLN_RST_CNT0_PARAM_ID                (0x010200dfu)

#define CY_CAPSENSE_LINEARSLIDER0_SNS0_IDAC0_VALUE                               (cy_capsense_tuner.sensorContext[2].idacComp)
#define CY_CAPSENSE_LINEARSLIDER0_SNS0_IDAC0_OFFSET                              (224u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS0_IDAC0_SIZE                                (1u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS0_IDAC0_PARAM_ID                            (0x010200e0u)

#define CY_CAPSENSE_LINEARSLIDER0_SNS0_BSLN_EXT0_VALUE                           (cy_capsense_tuner.sensorContext[2].bslnExt)
#define CY_CAPSENSE_LINEARSLIDER0_SNS0_BSLN_EXT0_OFFSET                          (225u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS0_BSLN_EXT0_SIZE                            (1u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS0_BSLN_EXT0_PARAM_ID                        (0x010200e1u)

#define CY_CAPSENSE_LINEARSLIDER0_SNS1_RAW0_VALUE                                (cy_capsense_tuner.sensorContext[3].raw)
#define CY_CAPSENSE_LINEARSLIDER0_SNS1_RAW0_OFFSET                               (226u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS1_RAW0_SIZE                                 (2u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS1_RAW0_PARAM_ID                             (0x020200e2u)

#define CY_CAPSENSE_LINEARSLIDER0_SNS1_BSLN0_VALUE                               (cy_capsense_tuner.sensorContext[3].bsln)
#define CY_CAPSENSE_LINEARSLIDER0_SNS1_BSLN0_OFFSET                              (228u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS1_BSLN0_SIZE                                (2u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS1_BSLN0_PARAM_ID                            (0x020200e4u)

#define CY_CAPSENSE_LINEARSLIDER0_SNS1_DIFF0_VALUE                               (cy_capsense_tuner.sensorContext[3].diff)
#define CY_CAPSENSE_LINEARSLIDER0_SNS1_DIFF0_OFFSET                              (230u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS1_DIFF0_SIZE                                (2u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS1_DIFF0_PARAM_ID                            (0x020200e6u)

#define CY_CAPSENSE_LINEARSLIDER0_SNS1_STATUS0_VALUE                             (cy_capsense_tuner.sensorContext[3].status)
#define CY_CAPSENSE_LINEARSLIDER0_SNS1_STATUS0_OFFSET                            (232u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS1_STATUS0_SIZE                              (1u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS1_STATUS0_PARAM_ID                          (0x010200e8u)

#define CY_CAPSENSE_LINEARSLIDER0_SNS1_NEG_BSLN_RST_CNT0_VALUE                   (cy_capsense_tuner.sensorContext[3].negBslnRstCnt)
#define CY_CAPSENSE_LINEARSLIDER0_SNS1_NEG_BSLN_RST_CNT0_OFFSET                  (233u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS1_NEG_BSLN_RST_CNT0_SIZE                    (1u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS1_NEG_BSLN_RST_CNT0_PARAM_ID                (0x010200e9u)

#define CY_CAPSENSE_LINEARSLIDER0_SNS1_IDAC0_VALUE                               (cy_capsense_tuner.sensorContext[3].idacComp)
#define CY_CAPSENSE_LINEARSLIDER0_SNS1_IDAC0_OFFSET                              (234u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS1_IDAC0_SIZE                                (1u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS1_IDAC0_PARAM_ID                            (0x010200eau)

#define CY_CAPSENSE_LINEARSLIDER0_SNS1_BSLN_EXT0_VALUE                           (cy_capsense_tuner.sensorContext[3].bslnExt)
#define CY_CAPSENSE_LINEARSLIDER0_SNS1_BSLN_EXT0_OFFSET                          (235u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS1_BSLN_EXT0_SIZE                            (1u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS1_BSLN_EXT0_PARAM_ID                        (0x010200ebu)

#define CY_CAPSENSE_LINEARSLIDER0_SNS2_RAW0_VALUE                                (cy_capsense_tuner.sensorContext[4].raw)
#define CY_CAPSENSE_LINEARSLIDER0_SNS2_RAW0_OFFSET                               (236u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS2_RAW0_SIZE                                 (2u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS2_RAW0_PARAM_ID                             (0x020200ecu)

#define CY_CAPSENSE_LINEARSLIDER0_SNS2_BSLN0_VALUE                               (cy_capsense_tuner.sensorContext[4].bsln)
#define CY_CAPSENSE_LINEARSLIDER0_SNS2_BSLN0_OFFSET                              (238u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS2_BSLN0_SIZE                                (2u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS2_BSLN0_PARAM_ID                            (0x020200eeu)

#define CY_CAPSENSE_LINEARSLIDER0_SNS2_DIFF0_VALUE                               (cy_capsense_tuner.sensorContext[4].diff)
#define CY_CAPSENSE_LINEARSLIDER0_SNS2_DIFF0_OFFSET                              (240u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS2_DIFF0_SIZE                                (2u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS2_DIFF0_PARAM_ID                            (0x020200f0u)

#define CY_CAPSENSE_LINEARSLIDER0_SNS2_STATUS0_VALUE                             (cy_capsense_tuner.sensorContext[4].status)
#define CY_CAPSENSE_LINEARSLIDER0_SNS2_STATUS0_OFFSET                            (242u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS2_STATUS0_SIZE                              (1u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS2_STATUS0_PARAM_ID                          (0x010200f2u)

#define CY_CAPSENSE_LINEARSLIDER0_SNS2_NEG_BSLN_RST_CNT0_VALUE                   (cy_capsense_tuner.sensorContext[4].negBslnRstCnt)
#define CY_CAPSENSE_LINEARSLIDER0_SNS2_NEG_BSLN_RST_CNT0_OFFSET                  (243u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS2_NEG_BSLN_RST_CNT0_SIZE                    (1u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS2_NEG_BSLN_RST_CNT0_PARAM_ID                (0x010200f3u)

#define CY_CAPSENSE_LINEARSLIDER0_SNS2_IDAC0_VALUE                               (cy_capsense_tuner.sensorContext[4].idacComp)
#define CY_CAPSENSE_LINEARSLIDER0_SNS2_IDAC0_OFFSET                              (244u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS2_IDAC0_SIZE                                (1u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS2_IDAC0_PARAM_ID                            (0x010200f4u)

#define CY_CAPSENSE_LINEARSLIDER0_SNS2_BSLN_EXT0_VALUE                           (cy_capsense_tuner.sensorContext[4].bslnExt)
#define CY_CAPSENSE_LINEARSLIDER0_SNS2_BSLN_EXT0_OFFSET                          (245u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS2_BSLN_EXT0_SIZE                            (1u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS2_BSLN_EXT0_PARAM_ID                        (0x010200f5u)

#define CY_CAPSENSE_LINEARSLIDER0_SNS3_RAW0_VALUE                                (cy_capsense_tuner.sensorContext[5].raw)
#define CY_CAPSENSE_LINEARSLIDER0_SNS3_RAW0_OFFSET                               (246u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS3_RAW0_SIZE                                 (2u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS3_RAW0_PARAM_ID                             (0x020200f6u)

#define CY_CAPSENSE_LINEARSLIDER0_SNS3_BSLN0_VALUE                               (cy_capsense_tuner.sensorContext[5].bsln)
#define CY_CAPSENSE_LINEARSLIDER0_SNS3_BSLN0_OFFSET                              (248u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS3_BSLN0_SIZE                                (2u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS3_BSLN0_PARAM_ID                            (0x020200f8u)

#define CY_CAPSENSE_LINEARSLIDER0_SNS3_DIFF0_VALUE                               (cy_capsense_tuner.sensorContext[5].diff)
#define CY_CAPSENSE_LINEARSLIDER0_SNS3_DIFF0_OFFSET                              (250u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS3_DIFF0_SIZE                                (2u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS3_DIFF0_PARAM_ID                            (0x020200fau)

#define CY_CAPSENSE_LINEARSLIDER0_SNS3_STATUS0_VALUE                             (cy_capsense_tuner.sensorContext[5].status)
#define CY_CAPSENSE_LINEARSLIDER0_SNS3_STATUS0_OFFSET                            (252u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS3_STATUS0_SIZE                              (1u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS3_STATUS0_PARAM_ID                          (0x010200fcu)

#define CY_CAPSENSE_LINEARSLIDER0_SNS3_NEG_BSLN_RST_CNT0_VALUE                   (cy_capsense_tuner.sensorContext[5].negBslnRstCnt)
#define CY_CAPSENSE_LINEARSLIDER0_SNS3_NEG_BSLN_RST_CNT0_OFFSET                  (253u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS3_NEG_BSLN_RST_CNT0_SIZE                    (1u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS3_NEG_BSLN_RST_CNT0_PARAM_ID                (0x010200fdu)

#define CY_CAPSENSE_LINEARSLIDER0_SNS3_IDAC0_VALUE                               (cy_capsense_tuner.sensorContext[5].idacComp)
#define CY_CAPSENSE_LINEARSLIDER0_SNS3_IDAC0_OFFSET                              (254u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS3_IDAC0_SIZE                                (1u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS3_IDAC0_PARAM_ID                            (0x010200feu)

#define CY_CAPSENSE_LINEARSLIDER0_SNS3_BSLN_EXT0_VALUE                           (cy_capsense_tuner.sensorContext[5].bslnExt)
#define CY_CAPSENSE_LINEARSLIDER0_SNS3_BSLN_EXT0_OFFSET                          (255u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS3_BSLN_EXT0_SIZE                            (1u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS3_BSLN_EXT0_PARAM_ID                        (0x010200ffu)

#define CY_CAPSENSE_LINEARSLIDER0_SNS4_RAW0_VALUE                                (cy_capsense_tuner.sensorContext[6].raw)
#define CY_CAPSENSE_LINEARSLIDER0_SNS4_RAW0_OFFSET                               (256u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS4_RAW0_SIZE                                 (2u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS4_RAW0_PARAM_ID                             (0x02020100u)

#define CY_CAPSENSE_LINEARSLIDER0_SNS4_BSLN0_VALUE                               (cy_capsense_tuner.sensorContext[6].bsln)
#define CY_CAPSENSE_LINEARSLIDER0_SNS4_BSLN0_OFFSET                              (258u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS4_BSLN0_SIZE                                (2u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS4_BSLN0_PARAM_ID                            (0x02020102u)

#define CY_CAPSENSE_LINEARSLIDER0_SNS4_DIFF0_VALUE                               (cy_capsense_tuner.sensorContext[6].diff)
#define CY_CAPSENSE_LINEARSLIDER0_SNS4_DIFF0_OFFSET                              (260u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS4_DIFF0_SIZE                                (2u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS4_DIFF0_PARAM_ID                            (0x02020104u)

#define CY_CAPSENSE_LINEARSLIDER0_SNS4_STATUS0_VALUE                             (cy_capsense_tuner.sensorContext[6].status)
#define CY_CAPSENSE_LINEARSLIDER0_SNS4_STATUS0_OFFSET                            (262u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS4_STATUS0_SIZE                              (1u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS4_STATUS0_PARAM_ID                          (0x01020106u)

#define CY_CAPSENSE_LINEARSLIDER0_SNS4_NEG_BSLN_RST_CNT0_VALUE                   (cy_capsense_tuner.sensorContext[6].negBslnRstCnt)
#define CY_CAPSENSE_LINEARSLIDER0_SNS4_NEG_BSLN_RST_CNT0_OFFSET                  (263u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS4_NEG_BSLN_RST_CNT0_SIZE                    (1u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS4_NEG_BSLN_RST_CNT0_PARAM_ID                (0x01020107u)

#define CY_CAPSENSE_LINEARSLIDER0_SNS4_IDAC0_VALUE                               (cy_capsense_tuner.sensorContext[6].idacComp)
#define CY_CAPSENSE_LINEARSLIDER0_SNS4_IDAC0_OFFSET                              (264u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS4_IDAC0_SIZE                                (1u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS4_IDAC0_PARAM_ID                            (0x01020108u)

#define CY_CAPSENSE_LINEARSLIDER0_SNS4_BSLN_EXT0_VALUE                           (cy_capsense_tuner.sensorContext[6].bslnExt)
#define CY_CAPSENSE_LINEARSLIDER0_SNS4_BSLN_EXT0_OFFSET                          (265u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS4_BSLN_EXT0_SIZE                            (1u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS4_BSLN_EXT0_PARAM_ID                        (0x01020109u)

#define CY_CAPSENSE_LINEARSLIDER0_X0_VALUE                                       (cy_capsense_tuner.position[0].x)
#define CY_CAPSENSE_LINEARSLIDER0_X0_OFFSET                                      (266u)
#define CY_CAPSENSE_LINEARSLIDER0_X0_SIZE                                        (2u)
#define CY_CAPSENSE_LINEARSLIDER0_X0_PARAM_ID                                    (0x0202010au)

#define CY_CAPSENSE_LINEARSLIDER0_Y0_VALUE                                       (cy_capsense_tuner.position[0].y)
#define CY_CAPSENSE_LINEARSLIDER0_Y0_OFFSET                                      (268u)
#define CY_CAPSENSE_LINEARSLIDER0_Y0_SIZE                                        (2u)
#define CY_CAPSENSE_LINEARSLIDER0_Y0_PARAM_ID                                    (0x0202010cu)

#define CY_CAPSENSE_LINEARSLIDER0_Z0_VALUE                                       (cy_capsense_tuner.position[0].z)
#define CY_CAPSENSE_LINEARSLIDER0_Z0_OFFSET                                      (270u)
#define CY_CAPSENSE_LINEARSLIDER0_Z0_SIZE                                        (2u)
#define CY_CAPSENSE_LINEARSLIDER0_Z0_PARAM_ID                                    (0x0202010eu)

#define CY_CAPSENSE_LINEARSLIDER0_ID0_VALUE                                      (cy_capsense_tuner.position[0].id)
#define CY_CAPSENSE_LINEARSLIDER0_ID0_OFFSET                                     (272u)
#define CY_CAPSENSE_LINEARSLIDER0_ID0_SIZE                                       (2u)
#define CY_CAPSENSE_LINEARSLIDER0_ID0_PARAM_ID                                   (0x02020110u)

#endif
/* cy_capsense_context */
#define CY_CAPSENSE_COMMON_CONFIG_PTR_VALUE                                      (cy_capsense_context.ptrCommonConfig)
#define CY_CAPSENSE_COMMON_CONFIG_PTR_SIZE                                       (sizeof(cy_capsense_context.ptrCommonConfig))

#define CY_CAPSENSE_COMMON_CONTEXT_PTR_VALUE                                     (cy_capsense_context.ptrCommonContext)
#define CY_CAPSENSE_COMMON_CONTEXT_PTR_SIZE                                      (sizeof(cy_capsense_context.ptrCommonContext))

#define CY_CAPSENSE_INTERNAL_CONTEXT_PTR_VALUE                                   (cy_capsense_context.ptrInternalContext)
#define CY_CAPSENSE_INTERNAL_CONTEXT_PTR_SIZE                                    (sizeof(cy_capsense_context.ptrInternalContext))

#define CY_CAPSENSE_WD_CONFIG_PTR_VALUE                                          (cy_capsense_context.ptrWdConfig)
#define CY_CAPSENSE_WD_CONFIG_PTR_SIZE                                           (sizeof(cy_capsense_context.ptrWdConfig))

#define CY_CAPSENSE_WD_CONTEXT_PTR_VALUE                                         (cy_capsense_context.ptrWdContext)
#define CY_CAPSENSE_WD_CONTEXT_PTR_SIZE                                          (sizeof(cy_capsense_context.ptrWdContext))

#define CY_CAPSENSE_PIN_CONFIG_PTR_VALUE                                         (cy_capsense_context.ptrPinConfig)
#define CY_CAPSENSE_PIN_CONFIG_PTR_SIZE                                          (sizeof(cy_capsense_context.ptrPinConfig))

#define CY_CAPSENSE_SHIELD_PIN_CONFIG_PTR_VALUE                                  (cy_capsense_context.ptrShieldPinConfig)
#define CY_CAPSENSE_SHIELD_PIN_CONFIG_PTR_SIZE                                   (sizeof(cy_capsense_context.ptrShieldPinConfig))

#define CY_CAPSENSE_ACTIVE_SCAN_SNS_PTR_VALUE                                    (cy_capsense_context.ptrActiveScanSns)
#define CY_CAPSENSE_ACTIVE_SCAN_SNS_PTR_SIZE                                     (sizeof(cy_capsense_context.ptrActiveScanSns))

#if (CY_CAPSENSE_MW_VERSION < 300)
#define CY_CAPSENSE_FPTR_CONFIG_PTR_VALUE                                        (cy_capsense_context.ptrFptrConfig)
#define CY_CAPSENSE_FPTR_CONFIG_PTR_SIZE                                         (sizeof(cy_capsense_context.ptrFptrConfig))
#endif

#define CY_CAPSENSE_BIST_CONTEXT_PTR_VALUE                                       (cy_capsense_context.ptrBistContext)
#define CY_CAPSENSE_BIST_CONTEXT_PTR_SIZE                                        (sizeof(cy_capsense_context.ptrBistContext))

/* cy_capsense_commonConfig */
#define CY_CAPSENSE_CPU_CLK_HZ_VALUE                                             (cy_capsense_context.ptrCommonConfig->cpuClkHz)
#define CY_CAPSENSE_CPU_CLK_HZ_SIZE                                              (sizeof(cy_capsense_context.ptrCommonConfig->cpuClkHz))

#define CY_CAPSENSE_PERI_CLK_HZ_VALUE                                            (cy_capsense_context.ptrCommonConfig->periClkHz)
#define CY_CAPSENSE_PERI_CLK_HZ_SIZE                                             (sizeof(cy_capsense_context.ptrCommonConfig->periClkHz))

#define CY_CAPSENSE_VDDA_VALUE                                                   (cy_capsense_context.ptrCommonConfig->vdda)
#define CY_CAPSENSE_VDDA_SIZE                                                    (sizeof(cy_capsense_context.ptrCommonConfig->vdda))

#define CY_CAPSENSE_NUM_PIN_VALUE                                                (cy_capsense_context.ptrCommonConfig->numPin)
#define CY_CAPSENSE_NUM_PIN_SIZE                                                 (sizeof(cy_capsense_context.ptrCommonConfig->numPin))

#define CY_CAPSENSE_NUM_SNS_VALUE                                                (cy_capsense_context.ptrCommonConfig->numSns)
#define CY_CAPSENSE_NUM_SNS_SIZE                                                 (sizeof(cy_capsense_context.ptrCommonConfig->numSns))

#define CY_CAPSENSE_NUM_WD_VALUE                                                 (cy_capsense_context.ptrCommonConfig->numWd)
#define CY_CAPSENSE_NUM_WD_SIZE                                                  (sizeof(cy_capsense_context.ptrCommonConfig->numWd))

#if (CY_CAPSENSE_MW_VERSION < 400)
#define CY_CAPSENSE_CSD_EN_VALUE                                                 (cy_capsense_context.ptrCommonConfig->csdEn)
#define CY_CAPSENSE_CSD_EN_SIZE                                                  (sizeof(cy_capsense_context.ptrCommonConfig->csdEn))

#define CY_CAPSENSE_CSX_EN_VALUE                                                 (cy_capsense_context.ptrCommonConfig->csxEn)
#define CY_CAPSENSE_CSX_EN_SIZE                                                  (sizeof(cy_capsense_context.ptrCommonConfig->csxEn))

#if (CY_CAPSENSE_MW_VERSION < 300)
#define CY_CAPSENSE_MFS_EN_VALUE                                                 (cy_capsense_context.ptrCommonConfig->mfsEn)
#define CY_CAPSENSE_MFS_EN_SIZE                                                  (sizeof(cy_capsense_context.ptrCommonConfig->mfsEn))
#endif

#define CY_CAPSENSE_BIST_EN_VALUE                                                (cy_capsense_context.ptrCommonConfig->bistEn)
#define CY_CAPSENSE_BIST_EN_SIZE                                                 (sizeof(cy_capsense_context.ptrCommonConfig->bistEn))

#define CY_CAPSENSE_POSITION_FILTER_EN_VALUE                                     (cy_capsense_context.ptrCommonConfig->positionFilterEn)
#define CY_CAPSENSE_POSITION_FILTER_EN_SIZE                                      (sizeof(cy_capsense_context.ptrCommonConfig->positionFilterEn))
#endif

#define CY_CAPSENSE_PERI_DIVIDER_TYPE_VALUE                                      (cy_capsense_context.ptrCommonConfig->periDividerType)
#define CY_CAPSENSE_PERI_DIVIDER_TYPE_SIZE                                       (sizeof(cy_capsense_context.ptrCommonConfig->periDividerType))

#define CY_CAPSENSE_PERI_DIVIDER_INDEX_VALUE                                     (cy_capsense_context.ptrCommonConfig->periDividerIndex)
#define CY_CAPSENSE_PERI_DIVIDER_INDEX_SIZE                                      (sizeof(cy_capsense_context.ptrCommonConfig->periDividerIndex))

#define CY_CAPSENSE_ANALOG_WAKEUP_DELAY_VALUE                                    (cy_capsense_context.ptrCommonConfig->analogWakeupDelay)
#define CY_CAPSENSE_ANALOG_WAKEUP_DELAY_SIZE                                     (sizeof(cy_capsense_context.ptrCommonConfig->analogWakeupDelay))

#define CY_CAPSENSE_SS_IREF_SOURCE_VALUE                                         (cy_capsense_context.ptrCommonConfig->ssIrefSource)
#define CY_CAPSENSE_SS_IREF_SOURCE_SIZE                                          (sizeof(cy_capsense_context.ptrCommonConfig->ssIrefSource))

#define CY_CAPSENSE_SS_VREF_SOURCE_VALUE                                         (cy_capsense_context.ptrCommonConfig->ssVrefSource)
#define CY_CAPSENSE_SS_VREF_SOURCE_SIZE                                          (sizeof(cy_capsense_context.ptrCommonConfig->ssVrefSource))

#define CY_CAPSENSE_PROX_TOUCH_COEFF_VALUE                                       (cy_capsense_context.ptrCommonConfig->proxTouchCoeff)
#define CY_CAPSENSE_PROX_TOUCH_COEFF_SIZE                                        (sizeof(cy_capsense_context.ptrCommonConfig->proxTouchCoeff))

#define CY_CAPSENSE_SW_SENSOR_AUTO_RESET_EN_VALUE                                (cy_capsense_context.ptrCommonConfig->swSensorAutoResetEn)
#define CY_CAPSENSE_SW_SENSOR_AUTO_RESET_EN_SIZE                                 (sizeof(cy_capsense_context.ptrCommonConfig->swSensorAutoResetEn))

#define CY_CAPSENSE_PORT_CMOD_PAD_NUM_VALUE                                      (cy_capsense_context.ptrCommonConfig->portCmodPadNum)
#define CY_CAPSENSE_PORT_CMOD_PAD_NUM_SIZE                                       (sizeof(cy_capsense_context.ptrCommonConfig->portCmodPadNum))

#define CY_CAPSENSE_PIN_CMOD_PAD_VALUE                                           (cy_capsense_context.ptrCommonConfig->pinCmodPad)
#define CY_CAPSENSE_PIN_CMOD_PAD_SIZE                                            (sizeof(cy_capsense_context.ptrCommonConfig->pinCmodPad))

#define CY_CAPSENSE_PORT_CSH_PAD_NUM_VALUE                                       (cy_capsense_context.ptrCommonConfig->portCshPadNum)
#define CY_CAPSENSE_PORT_CSH_PAD_NUM_SIZE                                        (sizeof(cy_capsense_context.ptrCommonConfig->portCshPadNum))

#define CY_CAPSENSE_PIN_CSH_PAD_VALUE                                            (cy_capsense_context.ptrCommonConfig->pinCshPad)
#define CY_CAPSENSE_PIN_CSH_PAD_SIZE                                             (sizeof(cy_capsense_context.ptrCommonConfig->pinCshPad))

#define CY_CAPSENSE_PORT_SHIELD_PAD_NUM_VALUE                                    (cy_capsense_context.ptrCommonConfig->portShieldPadNum)
#define CY_CAPSENSE_PORT_SHIELD_PAD_NUM_SIZE                                     (sizeof(cy_capsense_context.ptrCommonConfig->portShieldPadNum))

#define CY_CAPSENSE_PIN_SHIELD_PAD_VALUE                                         (cy_capsense_context.ptrCommonConfig->pinShieldPad)
#define CY_CAPSENSE_PIN_SHIELD_PAD_SIZE                                          (sizeof(cy_capsense_context.ptrCommonConfig->pinShieldPad))

#define CY_CAPSENSE_PORT_VREF_EXT_PAD_NUM_VALUE                                  (cy_capsense_context.ptrCommonConfig->portVrefExtPadNum)
#define CY_CAPSENSE_PORT_VREF_EXT_PAD_NUM_SIZE                                   (sizeof(cy_capsense_context.ptrCommonConfig->portVrefExtPadNum))

#define CY_CAPSENSE_PIN_VREF_EXT_PAD_VALUE                                       (cy_capsense_context.ptrCommonConfig->pinVrefExtPad)
#define CY_CAPSENSE_PIN_VREF_EXT_PAD_SIZE                                        (sizeof(cy_capsense_context.ptrCommonConfig->pinVrefExtPad))

#define CY_CAPSENSE_PORT_CMOD_NUM_VALUE                                          (cy_capsense_context.ptrCommonConfig->portCmodNum)
#define CY_CAPSENSE_PORT_CMOD_NUM_SIZE                                           (sizeof(cy_capsense_context.ptrCommonConfig->portCmodNum))

#define CY_CAPSENSE_IDAC_GAIN_TABLE_PTR_VALUE                                    (&cy_capsense_context.ptrCommonConfig->idacGainTable[0u])
#define CY_CAPSENSE_IDAC_GAIN_TABLE_PTR_SIZE                                     (sizeof(&cy_capsense_context.ptrCommonConfig->idacGainTable[0u]))

#define CY_CAPSENSE_PTR_CSD_BASE_VALUE                                           (cy_capsense_context.ptrCommonConfig->ptrCsdBase)
#define CY_CAPSENSE_PTR_CSD_BASE_SIZE                                            (sizeof(cy_capsense_context.ptrCommonConfig->ptrCsdBase))

#define CY_CAPSENSE_PTR_CSD_CONTEXT_VALUE                                        (cy_capsense_context.ptrCommonConfig->ptrCsdContext)
#define CY_CAPSENSE_PTR_CSD_CONTEXT_SIZE                                         (sizeof(cy_capsense_context.ptrCommonConfig->ptrCsdContext))

#define CY_CAPSENSE_PORT_CMOD_VALUE                                              (cy_capsense_context.ptrCommonConfig->portCmod)
#define CY_CAPSENSE_PORT_CMOD_SIZE                                               (sizeof(cy_capsense_context.ptrCommonConfig->portCmod))

#define CY_CAPSENSE_PORT_CSH_VALUE                                               (cy_capsense_context.ptrCommonConfig->portCsh)
#define CY_CAPSENSE_PORT_CSH_SIZE                                                (sizeof(cy_capsense_context.ptrCommonConfig->portCsh))

#define CY_CAPSENSE_PORT_CINT_A_VALUE                                            (cy_capsense_context.ptrCommonConfig->portCintA)
#define CY_CAPSENSE_PORT_CINT_A_SIZE                                             (sizeof(cy_capsense_context.ptrCommonConfig->portCintA))

#define CY_CAPSENSE_PORT_CINT_B_VALUE                                            (cy_capsense_context.ptrCommonConfig->portCintB)
#define CY_CAPSENSE_PORT_CINT_B_SIZE                                             (sizeof(cy_capsense_context.ptrCommonConfig->portCintB))

#define CY_CAPSENSE_PIN_CMOD_VALUE                                               (cy_capsense_context.ptrCommonConfig->pinCmod)
#define CY_CAPSENSE_PIN_CMOD_SIZE                                                (sizeof(cy_capsense_context.ptrCommonConfig->pinCmod))

#define CY_CAPSENSE_PORT_CSH_NUM_VALUE                                           (cy_capsense_context.ptrCommonConfig->portCshNum)
#define CY_CAPSENSE_PORT_CSH_NUM_SIZE                                            (sizeof(cy_capsense_context.ptrCommonConfig->portCshNum))

#define CY_CAPSENSE_PIN_CSH_VALUE                                                (cy_capsense_context.ptrCommonConfig->pinCsh)
#define CY_CAPSENSE_PIN_CSH_SIZE                                                 (sizeof(cy_capsense_context.ptrCommonConfig->pinCsh))

#define CY_CAPSENSE_PIN_CINT_A_VALUE                                             (cy_capsense_context.ptrCommonConfig->pinCintA)
#define CY_CAPSENSE_PIN_CINT_A_SIZE                                              (sizeof(cy_capsense_context.ptrCommonConfig->pinCintA))

#define CY_CAPSENSE_PIN_CINT_B_VALUE                                             (cy_capsense_context.ptrCommonConfig->pinCintB)
#define CY_CAPSENSE_PIN_CINT_B_SIZE                                              (sizeof(cy_capsense_context.ptrCommonConfig->pinCintB))

#if (CY_CAPSENSE_MW_VERSION < 400)
#define CY_CAPSENSE_CSD_SHIELD_EN_VALUE                                          (cy_capsense_context.ptrCommonConfig->csdShieldEn)
#define CY_CAPSENSE_CSD_SHIELD_EN_SIZE                                           (sizeof(cy_capsense_context.ptrCommonConfig->csdShieldEn))
#endif

#define CY_CAPSENSE_CSD_INACTIVE_SNS_CONNECTION_VALUE                            (cy_capsense_context.ptrCommonConfig->csdInactiveSnsConnection)
#define CY_CAPSENSE_CSD_INACTIVE_SNS_CONNECTION_SIZE                             (sizeof(cy_capsense_context.ptrCommonConfig->csdInactiveSnsConnection))

#if (CY_CAPSENSE_MW_VERSION >= 300)
#define CY_CAPSENSE_CSX_INACTIVE_SNS_CONNECTION_VALUE                            (cy_capsense_context.ptrCommonConfig->csxInactiveSnsConnection)
#define CY_CAPSENSE_CSX_INACTIVE_SNS_CONNECTION_SIZE                             (sizeof(cy_capsense_context.ptrCommonConfig->csxInactiveSnsConnection))
#endif

#define CY_CAPSENSE_CSD_SHIELD_DELAY_VALUE                                       (cy_capsense_context.ptrCommonConfig->csdShieldDelay)
#define CY_CAPSENSE_CSD_SHIELD_DELAY_SIZE                                        (sizeof(cy_capsense_context.ptrCommonConfig->csdShieldDelay))

#define CY_CAPSENSE_CSD_VREF_VALUE                                               (cy_capsense_context.ptrCommonConfig->csdVref)
#define CY_CAPSENSE_CSD_VREF_SIZE                                                (sizeof(cy_capsense_context.ptrCommonConfig->csdVref))

#if (CY_CAPSENSE_MW_VERSION < 610)
#define CY_CAPSENSE_CSD_R_CONST_VALUE                                            (cy_capsense_context.ptrCommonConfig->csdRConst)
#endif
#define CY_CAPSENSE_CSD_R_CONST_SIZE                                             (sizeof(cy_capsense_context.ptrCommonConfig->csdRConst))

#if (CY_CAPSENSE_MW_VERSION < 400)
#define CY_CAPSENSE_CSD_C_TANK_SHIELD_EN_VALUE                                   (cy_capsense_context.ptrCommonConfig->csdCTankShieldEn)
#define CY_CAPSENSE_CSD_C_TANK_SHIELD_EN_SIZE                                    (sizeof(cy_capsense_context.ptrCommonConfig->csdCTankShieldEn))
#endif

#define CY_CAPSENSE_CSD_SHIELD_NUM_PIN_VALUE                                     (cy_capsense_context.ptrCommonConfig->csdShieldNumPin)
#define CY_CAPSENSE_CSD_SHIELD_NUM_PIN_SIZE                                      (sizeof(cy_capsense_context.ptrCommonConfig->csdShieldNumPin))

#define CY_CAPSENSE_CSD_SHIELD_SW_RES_VALUE                                      (cy_capsense_context.ptrCommonConfig->csdShieldSwRes)
#define CY_CAPSENSE_CSD_SHIELD_SW_RES_SIZE                                       (sizeof(cy_capsense_context.ptrCommonConfig->csdShieldSwRes))

#define CY_CAPSENSE_CSD_INIT_SW_RES_VALUE                                        (cy_capsense_context.ptrCommonConfig->csdInitSwRes)
#define CY_CAPSENSE_CSD_INIT_SW_RES_SIZE                                         (sizeof(cy_capsense_context.ptrCommonConfig->csdInitSwRes))

#define CY_CAPSENSE_CSD_CHARGE_TRANSFER_VALUE                                    (cy_capsense_context.ptrCommonConfig->csdChargeTransfer)
#define CY_CAPSENSE_CSD_CHARGE_TRANSFER_SIZE                                     (sizeof(cy_capsense_context.ptrCommonConfig->csdChargeTransfer))

#define CY_CAPSENSE_CSD_RAW_TARGET_VALUE                                         (cy_capsense_context.ptrCommonConfig->csdRawTarget)
#define CY_CAPSENSE_CSD_RAW_TARGET_SIZE                                          (sizeof(cy_capsense_context.ptrCommonConfig->csdRawTarget))

#if (CY_CAPSENSE_MW_VERSION < 400)
#define CY_CAPSENSE_CSD_AUTOTUNE_EN_VALUE                                        (cy_capsense_context.ptrCommonConfig->csdAutotuneEn)
#define CY_CAPSENSE_CSD_AUTOTUNE_EN_SIZE                                         (sizeof(cy_capsense_context.ptrCommonConfig->csdAutotuneEn))

#define CY_CAPSENSE_CSD_IDAC_AUTOCAL_EN_VALUE                                    (cy_capsense_context.ptrCommonConfig->csdIdacAutocalEn)
#define CY_CAPSENSE_CSD_IDAC_AUTOCAL_EN_SIZE                                     (sizeof(cy_capsense_context.ptrCommonConfig->csdIdacAutocalEn))

#define CY_CAPSENSE_CSD_IDAC_AUTO_GAIN_EN_VALUE                                  (cy_capsense_context.ptrCommonConfig->csdIdacAutoGainEn)
#define CY_CAPSENSE_CSD_IDAC_AUTO_GAIN_EN_SIZE                                   (sizeof(cy_capsense_context.ptrCommonConfig->csdIdacAutoGainEn))
#endif

#define CY_CAPSENSE_CSD_CALIBRATION_ERROR_VALUE                                  (cy_capsense_context.ptrCommonConfig->csdCalibrationError)
#define CY_CAPSENSE_CSD_CALIBRATION_ERROR_SIZE                                   (sizeof(cy_capsense_context.ptrCommonConfig->csdCalibrationError))

#define CY_CAPSENSE_CSD_IDAC_GAIN_INIT_INDEX_VALUE                               (cy_capsense_context.ptrCommonConfig->csdIdacGainInitIndex)
#define CY_CAPSENSE_CSD_IDAC_GAIN_INIT_INDEX_SIZE                                (sizeof(cy_capsense_context.ptrCommonConfig->csdIdacGainInitIndex))

#define CY_CAPSENSE_CSD_IDAC_MIN_VALUE                                           (cy_capsense_context.ptrCommonConfig->csdIdacMin)
#define CY_CAPSENSE_CSD_IDAC_MIN_SIZE                                            (sizeof(cy_capsense_context.ptrCommonConfig->csdIdacMin))

#define CY_CAPSENSE_CSD_IDAC_COMP_EN_VALUE                                       (cy_capsense_context.ptrCommonConfig->csdIdacCompEn)
#define CY_CAPSENSE_CSD_IDAC_COMP_EN_SIZE                                        (sizeof(cy_capsense_context.ptrCommonConfig->csdIdacCompEn))

#define CY_CAPSENSE_CSD_FINE_INIT_TIME_VALUE                                     (cy_capsense_context.ptrCommonConfig->csdFineInitTime)
#define CY_CAPSENSE_CSD_FINE_INIT_TIME_SIZE                                      (sizeof(cy_capsense_context.ptrCommonConfig->csdFineInitTime))

#if (CY_CAPSENSE_MW_VERSION < 400)
#define CY_CAPSENSE_CSD_IDAC_ROW_COL_ALIGN_EN_VALUE                              (cy_capsense_context.ptrCommonConfig->csdIdacRowColAlignEn)
#define CY_CAPSENSE_CSD_IDAC_ROW_COL_ALIGN_EN_SIZE                               (sizeof(cy_capsense_context.ptrCommonConfig->csdIdacRowColAlignEn))
#endif

#define CY_CAPSENSE_CSD_MFS_DIVIDER_OFFSET_F1_VALUE                              (cy_capsense_context.ptrCommonConfig->csdMfsDividerOffsetF1)
#define CY_CAPSENSE_CSD_MFS_DIVIDER_OFFSET_F1_SIZE                               (sizeof(cy_capsense_context.ptrCommonConfig->csdMfsDividerOffsetF1))

#define CY_CAPSENSE_CSD_MFS_DIVIDER_OFFSET_F2_VALUE                              (cy_capsense_context.ptrCommonConfig->csdMfsDividerOffsetF2)
#define CY_CAPSENSE_CSD_MFS_DIVIDER_OFFSET_F2_SIZE                               (sizeof(cy_capsense_context.ptrCommonConfig->csdMfsDividerOffsetF2))

#define CY_CAPSENSE_CSX_RAW_TARGET_VALUE                                         (cy_capsense_context.ptrCommonConfig->csxRawTarget)
#define CY_CAPSENSE_CSX_RAW_TARGET_SIZE                                          (sizeof(cy_capsense_context.ptrCommonConfig->csxRawTarget))

#if (CY_CAPSENSE_MW_VERSION < 400)
#define CY_CAPSENSE_CSX_IDAC_GAIN_INIT_INDEX_VALUE                               (cy_capsense_context.ptrCommonConfig->csxIdacGainInitIndex)
#define CY_CAPSENSE_CSX_IDAC_GAIN_INIT_INDEX_SIZE                                (sizeof(cy_capsense_context.ptrCommonConfig->csxIdacGainInitIndex))

#define CY_CAPSENSE_CSX_REF_GAIN_VALUE                                           (cy_capsense_context.ptrCommonConfig->csxRefGain)
#define CY_CAPSENSE_CSX_REF_GAIN_SIZE                                            (sizeof(cy_capsense_context.ptrCommonConfig->csxRefGain))

#define CY_CAPSENSE_CSX_IDAC_AUTOCAL_EN_VALUE                                    (cy_capsense_context.ptrCommonConfig->csxIdacAutocalEn)
#define CY_CAPSENSE_CSX_IDAC_AUTOCAL_EN_SIZE                                     (sizeof(cy_capsense_context.ptrCommonConfig->csxIdacAutocalEn))
#endif

#define CY_CAPSENSE_CSX_CALIBRATION_ERROR_VALUE                                  (cy_capsense_context.ptrCommonConfig->csxCalibrationError)
#define CY_CAPSENSE_CSX_CALIBRATION_ERROR_SIZE                                   (sizeof(cy_capsense_context.ptrCommonConfig->csxCalibrationError))

#define CY_CAPSENSE_CSX_FINE_INIT_TIME_VALUE                                     (cy_capsense_context.ptrCommonConfig->csxFineInitTime)
#define CY_CAPSENSE_CSX_FINE_INIT_TIME_SIZE                                      (sizeof(cy_capsense_context.ptrCommonConfig->csxFineInitTime))

#define CY_CAPSENSE_CSX_INIT_SW_RES_VALUE                                        (cy_capsense_context.ptrCommonConfig->csxInitSwRes)
#define CY_CAPSENSE_CSX_INIT_SW_RES_SIZE                                         (sizeof(cy_capsense_context.ptrCommonConfig->csxInitSwRes))

#define CY_CAPSENSE_CSX_SCAN_SW_RES_VALUE                                        (cy_capsense_context.ptrCommonConfig->csxScanSwRes)
#define CY_CAPSENSE_CSX_SCAN_SW_RES_SIZE                                         (sizeof(cy_capsense_context.ptrCommonConfig->csxScanSwRes))

#define CY_CAPSENSE_CSX_INIT_SHIELD_SW_RES_VALUE                                 (cy_capsense_context.ptrCommonConfig->csxInitShieldSwRes)
#define CY_CAPSENSE_CSX_INIT_SHIELD_SW_RES_SIZE                                  (sizeof(cy_capsense_context.ptrCommonConfig->csxInitShieldSwRes))

#define CY_CAPSENSE_CSX_SCAN_SHIELD_SW_RES_VALUE                                 (cy_capsense_context.ptrCommonConfig->csxScanShieldSwRes)
#define CY_CAPSENSE_CSX_SCAN_SHIELD_SW_RES_SIZE                                  (sizeof(cy_capsense_context.ptrCommonConfig->csxScanShieldSwRes))

#define CY_CAPSENSE_CSX_MFS_DIVIDER_OFFSET_F1_VALUE                              (cy_capsense_context.ptrCommonConfig->csxMfsDividerOffsetF1)
#define CY_CAPSENSE_CSX_MFS_DIVIDER_OFFSET_F1_SIZE                               (sizeof(cy_capsense_context.ptrCommonConfig->csxMfsDividerOffsetF1))

#define CY_CAPSENSE_CSX_MFS_DIVIDER_OFFSET_F2_VALUE                              (cy_capsense_context.ptrCommonConfig->csxMfsDividerOffsetF2)
#define CY_CAPSENSE_CSX_MFS_DIVIDER_OFFSET_F2_SIZE                               (sizeof(cy_capsense_context.ptrCommonConfig->csxMfsDividerOffsetF2))

/* cy_capsense_widgetConfig */
#define CY_CAPSENSE_BUTTON0_PTR_WD_CONTEXT_VALUE                                 (cy_capsense_context.ptrWdConfig[0u].ptrWdContext)
#define CY_CAPSENSE_BUTTON0_PTR_WD_CONTEXT_SIZE                                  (sizeof(cy_capsense_context.ptrWdConfig[0u].ptrWdContext))
#define CY_CAPSENSE_BUTTON0_PTR_SNS_CONTEXT_VALUE                                (cy_capsense_context.ptrWdConfig[0u].ptrSnsContext)
#define CY_CAPSENSE_BUTTON0_PTR_SNS_CONTEXT_SIZE                                 (sizeof(cy_capsense_context.ptrWdConfig[0u].ptrSnsContext))
#define CY_CAPSENSE_BUTTON0_PTR_ELTD_CONTEXT_VALUE                               (cy_capsense_context.ptrWdConfig[0u].ptrEltdConfig)
#define CY_CAPSENSE_BUTTON0_PTR_ELTD_CONTEXT_SIZE                                (sizeof(cy_capsense_context.ptrWdConfig[0u].ptrEltdConfig))
#define CY_CAPSENSE_BUTTON0_PTR_ELTD_CAPACITANCE_VALUE                           (cy_capsense_context.ptrWdConfig[0u].ptrEltdCapacitance)
#define CY_CAPSENSE_BUTTON0_PTR_ELTD_CAPACITANCE_SIZE                            (sizeof(cy_capsense_context.ptrWdConfig[0u].ptrEltdCapacitance))
#define CY_CAPSENSE_BUTTON0_PTR_BSLN_INV_VALUE                                   (cy_capsense_context.ptrWdConfig[0u].ptrBslnInv)
#define CY_CAPSENSE_BUTTON0_PTR_BSLN_INV_SIZE                                    (sizeof(cy_capsense_context.ptrWdConfig[0u].ptrBslnInv))
#define CY_CAPSENSE_BUTTON0_PTR_NOISE_ENVELOPE_VALUE                             (cy_capsense_context.ptrWdConfig[0u].ptrNoiseEnvelope)
#define CY_CAPSENSE_BUTTON0_PTR_NOISE_ENVELOPE_SIZE                              (sizeof(cy_capsense_context.ptrWdConfig[0u].ptrNoiseEnvelope))
#define CY_CAPSENSE_BUTTON0_PTR_RAW_FILTER_HISTORY_VALUE                         (cy_capsense_context.ptrWdConfig[0u].ptrRawFilterHistory)
#define CY_CAPSENSE_BUTTON0_PTR_RAW_FILTER_HISTORY_SIZE                          (sizeof(cy_capsense_context.ptrWdConfig[0u].ptrRawFilterHistory))
#define CY_CAPSENSE_BUTTON0_PTR_RAW_FILTER_HISTORY_LOW_VALUE                     (cy_capsense_context.ptrWdConfig[0u].ptrRawFilterHistoryLow)
#define CY_CAPSENSE_BUTTON0_PTR_RAW_FILTER_HISTORY_LOW_SIZE                      (sizeof(cy_capsense_context.ptrWdConfig[0u].ptrRawFilterHistoryLow))
#define CY_CAPSENSE_BUTTON0_IIR_COEFF_VALUE                                      (cy_capsense_context.ptrWdConfig[0u].iirCoeff)
#define CY_CAPSENSE_BUTTON0_IIR_COEFF_SIZE                                       (sizeof(cy_capsense_context.ptrWdConfig[0u].iirCoeff))
#define CY_CAPSENSE_BUTTON0_PTR_DEBOUNCE_ARR_VALUE                               (cy_capsense_context.ptrWdConfig[0u].ptrDebounceArr)
#define CY_CAPSENSE_BUTTON0_PTR_DEBOUNCE_ARR_SIZE                                (sizeof(cy_capsense_context.ptrWdConfig[0u].ptrDebounceArr))
#define CY_CAPSENSE_BUTTON0_PTR_DIPLEX_TABLE_VALUE                               (cy_capsense_context.ptrWdConfig[0u].ptrDiplexTable)
#define CY_CAPSENSE_BUTTON0_PTR_DIPLEX_TABLE_SIZE                                (sizeof(cy_capsense_context.ptrWdConfig[0u].ptrDiplexTable))
#define CY_CAPSENSE_BUTTON0_CENTROID_CONFIG_VALUE                                (cy_capsense_context.ptrWdConfig[0u].centroidConfig)
#define CY_CAPSENSE_BUTTON0_CENTROID_CONFIG_SIZE                                 (sizeof(cy_capsense_context.ptrWdConfig[0u].centroidConfig))
#define CY_CAPSENSE_BUTTON0_X_RESOLUTION_VALUE                                   (cy_capsense_context.ptrWdConfig[0u].xResolution)
#define CY_CAPSENSE_BUTTON0_X_RESOLUTION_SIZE                                    (sizeof(cy_capsense_context.ptrWdConfig[0u].xResolution))
#define CY_CAPSENSE_BUTTON0_Y_RESOLUTION_VALUE                                   (cy_capsense_context.ptrWdConfig[0u].yResolution)
#define CY_CAPSENSE_BUTTON0_Y_RESOLUTION_SIZE                                    (sizeof(cy_capsense_context.ptrWdConfig[0u].yResolution))
#define CY_CAPSENSE_BUTTON0_NUM_SNS_VALUE                                        (cy_capsense_context.ptrWdConfig[0u].numSns)
#define CY_CAPSENSE_BUTTON0_NUM_SNS_SIZE                                         (sizeof(cy_capsense_context.ptrWdConfig[0u].numSns))
#define CY_CAPSENSE_BUTTON0_NUM_COLS_VALUE                                       (cy_capsense_context.ptrWdConfig[0u].numCols)
#define CY_CAPSENSE_BUTTON0_NUM_COLS_SIZE                                        (sizeof(cy_capsense_context.ptrWdConfig[0u].numCols))
#define CY_CAPSENSE_BUTTON0_NUM_ROWS_VALUE                                       (cy_capsense_context.ptrWdConfig[0u].numRows)
#define CY_CAPSENSE_BUTTON0_NUM_ROWS_SIZE                                        (sizeof(cy_capsense_context.ptrWdConfig[0u].numRows))
#define CY_CAPSENSE_BUTTON0_PTR_POS_FILTER_HISTORY_VALUE                         (cy_capsense_context.ptrWdConfig[0u].ptrPosFilterHistory)
#define CY_CAPSENSE_BUTTON0_PTR_POS_FILTER_HISTORY_SIZE                          (sizeof(cy_capsense_context.ptrWdConfig[0u].ptrPosFilterHistory))
#define CY_CAPSENSE_BUTTON0_PTR_CSX_TOUCH_HISTORY_VALUE                          (cy_capsense_context.ptrWdConfig[0u].ptrCsxTouchHistory)
#define CY_CAPSENSE_BUTTON0_PTR_CSX_TOUCH_HISTORY_SIZE                           (sizeof(cy_capsense_context.ptrWdConfig[0u].ptrCsxTouchHistory))
#define CY_CAPSENSE_BUTTON0_PTR_CSX_TOUCH_BUFFER_VALUE                           (cy_capsense_context.ptrWdConfig[0u].ptrCsxTouchBuffer)
#define CY_CAPSENSE_BUTTON0_PTR_CSX_TOUCH_BUFFER_SIZE                            (sizeof(cy_capsense_context.ptrWdConfig[0u].ptrCsxTouchBuffer))
#define CY_CAPSENSE_BUTTON0_PTR_CSD_TOUCH_BUFFER_VALUE                           (cy_capsense_context.ptrWdConfig[0u].ptrCsdTouchBuffer)
#define CY_CAPSENSE_BUTTON0_PTR_CSD_TOUCH_BUFFER_SIZE                            (sizeof(cy_capsense_context.ptrWdConfig[0u].ptrCsdTouchBuffer))
#define CY_CAPSENSE_BUTTON0_PTR_GESTURE_CONFIG_VALUE                             (cy_capsense_context.ptrWdConfig[0u].ptrGestureConfig)
#define CY_CAPSENSE_BUTTON0_PTR_GESTURE_CONFIG_SIZE                              (sizeof(cy_capsense_context.ptrWdConfig[0u].ptrGestureConfig))
#define CY_CAPSENSE_BUTTON0_PTR_GESTURE_CONTEXT_VALUE                            (cy_capsense_context.ptrWdConfig[0u].ptrGestureContext)
#define CY_CAPSENSE_BUTTON0_PTR_GESTURE_CONTEXT_SIZE                             (sizeof(cy_capsense_context.ptrWdConfig[0u].ptrGestureContext))
#define CY_CAPSENSE_BUTTON0_BALLISTIC_CONFIG_VALUE                               (cy_capsense_context.ptrWdConfig[0u].ballisticConfig)
#define CY_CAPSENSE_BUTTON0_BALLISTIC_CONFIG_SIZE                                (sizeof(cy_capsense_context.ptrWdConfig[0u].ballisticConfig))
#define CY_CAPSENSE_BUTTON0_PTR_BALLISTIC_CONTEXT_VALUE                          (cy_capsense_context.ptrWdConfig[0u].ptrBallisticContext)
#define CY_CAPSENSE_BUTTON0_PTR_BALLISTIC_CONTEXT_SIZE                           (sizeof(cy_capsense_context.ptrWdConfig[0u].ptrBallisticContext))
#define CY_CAPSENSE_BUTTON0_AIIR_CONFIG_VALUE                                    (cy_capsense_context.ptrWdConfig[0u].aiirConfig)
#define CY_CAPSENSE_BUTTON0_AIIR_CONFIG_SIZE                                     (sizeof(cy_capsense_context.ptrWdConfig[0u].aiirConfig))
#define CY_CAPSENSE_BUTTON0_ADV_CONFIG_VALUE                                     (cy_capsense_context.ptrWdConfig[0u].advConfig)
#define CY_CAPSENSE_BUTTON0_ADV_CONFIG_SIZE                                      (sizeof(cy_capsense_context.ptrWdConfig[0u].advConfig))
#define CY_CAPSENSE_BUTTON0_POS_FILTER_CONFIG_VALUE                              (cy_capsense_context.ptrWdConfig[0u].posFilterConfig)
#define CY_CAPSENSE_BUTTON0_POS_FILTER_CONFIG_SIZE                               (sizeof(cy_capsense_context.ptrWdConfig[0u].posFilterConfig))
#define CY_CAPSENSE_BUTTON0_RAW_FILTER_CONFIG_VALUE                              (cy_capsense_context.ptrWdConfig[0u].rawFilterConfig)
#define CY_CAPSENSE_BUTTON0_RAW_FILTER_CONFIG_SIZE                               (sizeof(cy_capsense_context.ptrWdConfig[0u].rawFilterConfig))
#if (CY_CAPSENSE_MW_VERSION >= 600)
#define CY_CAPSENSE_BUTTON0_CMF_TH_VALUE                                         (cy_capsense_context.ptrWdConfig[0u].cmfThreshold)
#define CY_CAPSENSE_BUTTON0_CMF_TH_SIZE                                          (sizeof(cy_capsense_context.ptrWdConfig[0u].cmfThreshold))
#endif
#define CY_CAPSENSE_BUTTON0_SENSE_METHOD_VALUE                                   (cy_capsense_context.ptrWdConfig[0u].senseMethod)
#define CY_CAPSENSE_BUTTON0_SENSE_METHOD_SIZE                                    (sizeof(cy_capsense_context.ptrWdConfig[0u].senseMethod))
#define CY_CAPSENSE_BUTTON0_WD_TYPE_VALUE                                        (cy_capsense_context.ptrWdConfig[0u].wdType)
#define CY_CAPSENSE_BUTTON0_WD_TYPE_SIZE                                         (sizeof(cy_capsense_context.ptrWdConfig[0u].wdType))

#define CY_CAPSENSE_BUTTON1_PTR_WD_CONTEXT_VALUE                                 (cy_capsense_context.ptrWdConfig[1u].ptrWdContext)
#define CY_CAPSENSE_BUTTON1_PTR_WD_CONTEXT_SIZE                                  (sizeof(cy_capsense_context.ptrWdConfig[1u].ptrWdContext))
#define CY_CAPSENSE_BUTTON1_PTR_SNS_CONTEXT_VALUE                                (cy_capsense_context.ptrWdConfig[1u].ptrSnsContext)
#define CY_CAPSENSE_BUTTON1_PTR_SNS_CONTEXT_SIZE                                 (sizeof(cy_capsense_context.ptrWdConfig[1u].ptrSnsContext))
#define CY_CAPSENSE_BUTTON1_PTR_ELTD_CONTEXT_VALUE                               (cy_capsense_context.ptrWdConfig[1u].ptrEltdConfig)
#define CY_CAPSENSE_BUTTON1_PTR_ELTD_CONTEXT_SIZE                                (sizeof(cy_capsense_context.ptrWdConfig[1u].ptrEltdConfig))
#define CY_CAPSENSE_BUTTON1_PTR_ELTD_CAPACITANCE_VALUE                           (cy_capsense_context.ptrWdConfig[1u].ptrEltdCapacitance)
#define CY_CAPSENSE_BUTTON1_PTR_ELTD_CAPACITANCE_SIZE                            (sizeof(cy_capsense_context.ptrWdConfig[1u].ptrEltdCapacitance))
#define CY_CAPSENSE_BUTTON1_PTR_BSLN_INV_VALUE                                   (cy_capsense_context.ptrWdConfig[1u].ptrBslnInv)
#define CY_CAPSENSE_BUTTON1_PTR_BSLN_INV_SIZE                                    (sizeof(cy_capsense_context.ptrWdConfig[1u].ptrBslnInv))
#define CY_CAPSENSE_BUTTON1_PTR_NOISE_ENVELOPE_VALUE                             (cy_capsense_context.ptrWdConfig[1u].ptrNoiseEnvelope)
#define CY_CAPSENSE_BUTTON1_PTR_NOISE_ENVELOPE_SIZE                              (sizeof(cy_capsense_context.ptrWdConfig[1u].ptrNoiseEnvelope))
#define CY_CAPSENSE_BUTTON1_PTR_RAW_FILTER_HISTORY_VALUE                         (cy_capsense_context.ptrWdConfig[1u].ptrRawFilterHistory)
#define CY_CAPSENSE_BUTTON1_PTR_RAW_FILTER_HISTORY_SIZE                          (sizeof(cy_capsense_context.ptrWdConfig[1u].ptrRawFilterHistory))
#define CY_CAPSENSE_BUTTON1_PTR_RAW_FILTER_HISTORY_LOW_VALUE                     (cy_capsense_context.ptrWdConfig[1u].ptrRawFilterHistoryLow)
#define CY_CAPSENSE_BUTTON1_PTR_RAW_FILTER_HISTORY_LOW_SIZE                      (sizeof(cy_capsense_context.ptrWdConfig[1u].ptrRawFilterHistoryLow))
#define CY_CAPSENSE_BUTTON1_IIR_COEFF_VALUE                                      (cy_capsense_context.ptrWdConfig[1u].iirCoeff)
#define CY_CAPSENSE_BUTTON1_IIR_COEFF_SIZE                                       (sizeof(cy_capsense_context.ptrWdConfig[1u].iirCoeff))
#define CY_CAPSENSE_BUTTON1_PTR_DEBOUNCE_ARR_VALUE                               (cy_capsense_context.ptrWdConfig[1u].ptrDebounceArr)
#define CY_CAPSENSE_BUTTON1_PTR_DEBOUNCE_ARR_SIZE                                (sizeof(cy_capsense_context.ptrWdConfig[1u].ptrDebounceArr))
#define CY_CAPSENSE_BUTTON1_PTR_DIPLEX_TABLE_VALUE                               (cy_capsense_context.ptrWdConfig[1u].ptrDiplexTable)
#define CY_CAPSENSE_BUTTON1_PTR_DIPLEX_TABLE_SIZE                                (sizeof(cy_capsense_context.ptrWdConfig[1u].ptrDiplexTable))
#define CY_CAPSENSE_BUTTON1_CENTROID_CONFIG_VALUE                                (cy_capsense_context.ptrWdConfig[1u].centroidConfig)
#define CY_CAPSENSE_BUTTON1_CENTROID_CONFIG_SIZE                                 (sizeof(cy_capsense_context.ptrWdConfig[1u].centroidConfig))
#define CY_CAPSENSE_BUTTON1_X_RESOLUTION_VALUE                                   (cy_capsense_context.ptrWdConfig[1u].xResolution)
#define CY_CAPSENSE_BUTTON1_X_RESOLUTION_SIZE                                    (sizeof(cy_capsense_context.ptrWdConfig[1u].xResolution))
#define CY_CAPSENSE_BUTTON1_Y_RESOLUTION_VALUE                                   (cy_capsense_context.ptrWdConfig[1u].yResolution)
#define CY_CAPSENSE_BUTTON1_Y_RESOLUTION_SIZE                                    (sizeof(cy_capsense_context.ptrWdConfig[1u].yResolution))
#define CY_CAPSENSE_BUTTON1_NUM_SNS_VALUE                                        (cy_capsense_context.ptrWdConfig[1u].numSns)
#define CY_CAPSENSE_BUTTON1_NUM_SNS_SIZE                                         (sizeof(cy_capsense_context.ptrWdConfig[1u].numSns))
#define CY_CAPSENSE_BUTTON1_NUM_COLS_VALUE                                       (cy_capsense_context.ptrWdConfig[1u].numCols)
#define CY_CAPSENSE_BUTTON1_NUM_COLS_SIZE                                        (sizeof(cy_capsense_context.ptrWdConfig[1u].numCols))
#define CY_CAPSENSE_BUTTON1_NUM_ROWS_VALUE                                       (cy_capsense_context.ptrWdConfig[1u].numRows)
#define CY_CAPSENSE_BUTTON1_NUM_ROWS_SIZE                                        (sizeof(cy_capsense_context.ptrWdConfig[1u].numRows))
#define CY_CAPSENSE_BUTTON1_PTR_POS_FILTER_HISTORY_VALUE                         (cy_capsense_context.ptrWdConfig[1u].ptrPosFilterHistory)
#define CY_CAPSENSE_BUTTON1_PTR_POS_FILTER_HISTORY_SIZE                          (sizeof(cy_capsense_context.ptrWdConfig[1u].ptrPosFilterHistory))
#define CY_CAPSENSE_BUTTON1_PTR_CSX_TOUCH_HISTORY_VALUE                          (cy_capsense_context.ptrWdConfig[1u].ptrCsxTouchHistory)
#define CY_CAPSENSE_BUTTON1_PTR_CSX_TOUCH_HISTORY_SIZE                           (sizeof(cy_capsense_context.ptrWdConfig[1u].ptrCsxTouchHistory))
#define CY_CAPSENSE_BUTTON1_PTR_CSX_TOUCH_BUFFER_VALUE                           (cy_capsense_context.ptrWdConfig[1u].ptrCsxTouchBuffer)
#define CY_CAPSENSE_BUTTON1_PTR_CSX_TOUCH_BUFFER_SIZE                            (sizeof(cy_capsense_context.ptrWdConfig[1u].ptrCsxTouchBuffer))
#define CY_CAPSENSE_BUTTON1_PTR_CSD_TOUCH_BUFFER_VALUE                           (cy_capsense_context.ptrWdConfig[1u].ptrCsdTouchBuffer)
#define CY_CAPSENSE_BUTTON1_PTR_CSD_TOUCH_BUFFER_SIZE                            (sizeof(cy_capsense_context.ptrWdConfig[1u].ptrCsdTouchBuffer))
#define CY_CAPSENSE_BUTTON1_PTR_GESTURE_CONFIG_VALUE                             (cy_capsense_context.ptrWdConfig[1u].ptrGestureConfig)
#define CY_CAPSENSE_BUTTON1_PTR_GESTURE_CONFIG_SIZE                              (sizeof(cy_capsense_context.ptrWdConfig[1u].ptrGestureConfig))
#define CY_CAPSENSE_BUTTON1_PTR_GESTURE_CONTEXT_VALUE                            (cy_capsense_context.ptrWdConfig[1u].ptrGestureContext)
#define CY_CAPSENSE_BUTTON1_PTR_GESTURE_CONTEXT_SIZE                             (sizeof(cy_capsense_context.ptrWdConfig[1u].ptrGestureContext))
#define CY_CAPSENSE_BUTTON1_BALLISTIC_CONFIG_VALUE                               (cy_capsense_context.ptrWdConfig[1u].ballisticConfig)
#define CY_CAPSENSE_BUTTON1_BALLISTIC_CONFIG_SIZE                                (sizeof(cy_capsense_context.ptrWdConfig[1u].ballisticConfig))
#define CY_CAPSENSE_BUTTON1_PTR_BALLISTIC_CONTEXT_VALUE                          (cy_capsense_context.ptrWdConfig[1u].ptrBallisticContext)
#define CY_CAPSENSE_BUTTON1_PTR_BALLISTIC_CONTEXT_SIZE                           (sizeof(cy_capsense_context.ptrWdConfig[1u].ptrBallisticContext))
#define CY_CAPSENSE_BUTTON1_AIIR_CONFIG_VALUE                                    (cy_capsense_context.ptrWdConfig[1u].aiirConfig)
#define CY_CAPSENSE_BUTTON1_AIIR_CONFIG_SIZE                                     (sizeof(cy_capsense_context.ptrWdConfig[1u].aiirConfig))
#define CY_CAPSENSE_BUTTON1_ADV_CONFIG_VALUE                                     (cy_capsense_context.ptrWdConfig[1u].advConfig)
#define CY_CAPSENSE_BUTTON1_ADV_CONFIG_SIZE                                      (sizeof(cy_capsense_context.ptrWdConfig[1u].advConfig))
#define CY_CAPSENSE_BUTTON1_POS_FILTER_CONFIG_VALUE                              (cy_capsense_context.ptrWdConfig[1u].posFilterConfig)
#define CY_CAPSENSE_BUTTON1_POS_FILTER_CONFIG_SIZE                               (sizeof(cy_capsense_context.ptrWdConfig[1u].posFilterConfig))
#define CY_CAPSENSE_BUTTON1_RAW_FILTER_CONFIG_VALUE                              (cy_capsense_context.ptrWdConfig[1u].rawFilterConfig)
#define CY_CAPSENSE_BUTTON1_RAW_FILTER_CONFIG_SIZE                               (sizeof(cy_capsense_context.ptrWdConfig[1u].rawFilterConfig))
#if (CY_CAPSENSE_MW_VERSION >= 600)
#define CY_CAPSENSE_BUTTON1_CMF_TH_VALUE                                         (cy_capsense_context.ptrWdConfig[1u].cmfThreshold)
#define CY_CAPSENSE_BUTTON1_CMF_TH_SIZE                                          (sizeof(cy_capsense_context.ptrWdConfig[1u].cmfThreshold))
#endif
#define CY_CAPSENSE_BUTTON1_SENSE_METHOD_VALUE                                   (cy_capsense_context.ptrWdConfig[1u].senseMethod)
#define CY_CAPSENSE_BUTTON1_SENSE_METHOD_SIZE                                    (sizeof(cy_capsense_context.ptrWdConfig[1u].senseMethod))
#define CY_CAPSENSE_BUTTON1_WD_TYPE_VALUE                                        (cy_capsense_context.ptrWdConfig[1u].wdType)
#define CY_CAPSENSE_BUTTON1_WD_TYPE_SIZE                                         (sizeof(cy_capsense_context.ptrWdConfig[1u].wdType))

#define CY_CAPSENSE_LINEARSLIDER0_PTR_WD_CONTEXT_VALUE                           (cy_capsense_context.ptrWdConfig[2u].ptrWdContext)
#define CY_CAPSENSE_LINEARSLIDER0_PTR_WD_CONTEXT_SIZE                            (sizeof(cy_capsense_context.ptrWdConfig[2u].ptrWdContext))
#define CY_CAPSENSE_LINEARSLIDER0_PTR_SNS_CONTEXT_VALUE                          (cy_capsense_context.ptrWdConfig[2u].ptrSnsContext)
#define CY_CAPSENSE_LINEARSLIDER0_PTR_SNS_CONTEXT_SIZE                           (sizeof(cy_capsense_context.ptrWdConfig[2u].ptrSnsContext))
#define CY_CAPSENSE_LINEARSLIDER0_PTR_ELTD_CONTEXT_VALUE                         (cy_capsense_context.ptrWdConfig[2u].ptrEltdConfig)
#define CY_CAPSENSE_LINEARSLIDER0_PTR_ELTD_CONTEXT_SIZE                          (sizeof(cy_capsense_context.ptrWdConfig[2u].ptrEltdConfig))
#define CY_CAPSENSE_LINEARSLIDER0_PTR_ELTD_CAPACITANCE_VALUE                     (cy_capsense_context.ptrWdConfig[2u].ptrEltdCapacitance)
#define CY_CAPSENSE_LINEARSLIDER0_PTR_ELTD_CAPACITANCE_SIZE                      (sizeof(cy_capsense_context.ptrWdConfig[2u].ptrEltdCapacitance))
#define CY_CAPSENSE_LINEARSLIDER0_PTR_BSLN_INV_VALUE                             (cy_capsense_context.ptrWdConfig[2u].ptrBslnInv)
#define CY_CAPSENSE_LINEARSLIDER0_PTR_BSLN_INV_SIZE                              (sizeof(cy_capsense_context.ptrWdConfig[2u].ptrBslnInv))
#define CY_CAPSENSE_LINEARSLIDER0_PTR_NOISE_ENVELOPE_VALUE                       (cy_capsense_context.ptrWdConfig[2u].ptrNoiseEnvelope)
#define CY_CAPSENSE_LINEARSLIDER0_PTR_NOISE_ENVELOPE_SIZE                        (sizeof(cy_capsense_context.ptrWdConfig[2u].ptrNoiseEnvelope))
#define CY_CAPSENSE_LINEARSLIDER0_PTR_RAW_FILTER_HISTORY_VALUE                   (cy_capsense_context.ptrWdConfig[2u].ptrRawFilterHistory)
#define CY_CAPSENSE_LINEARSLIDER0_PTR_RAW_FILTER_HISTORY_SIZE                    (sizeof(cy_capsense_context.ptrWdConfig[2u].ptrRawFilterHistory))
#define CY_CAPSENSE_LINEARSLIDER0_PTR_RAW_FILTER_HISTORY_LOW_VALUE               (cy_capsense_context.ptrWdConfig[2u].ptrRawFilterHistoryLow)
#define CY_CAPSENSE_LINEARSLIDER0_PTR_RAW_FILTER_HISTORY_LOW_SIZE                (sizeof(cy_capsense_context.ptrWdConfig[2u].ptrRawFilterHistoryLow))
#define CY_CAPSENSE_LINEARSLIDER0_IIR_COEFF_VALUE                                (cy_capsense_context.ptrWdConfig[2u].iirCoeff)
#define CY_CAPSENSE_LINEARSLIDER0_IIR_COEFF_SIZE                                 (sizeof(cy_capsense_context.ptrWdConfig[2u].iirCoeff))
#define CY_CAPSENSE_LINEARSLIDER0_PTR_DEBOUNCE_ARR_VALUE                         (cy_capsense_context.ptrWdConfig[2u].ptrDebounceArr)
#define CY_CAPSENSE_LINEARSLIDER0_PTR_DEBOUNCE_ARR_SIZE                          (sizeof(cy_capsense_context.ptrWdConfig[2u].ptrDebounceArr))
#define CY_CAPSENSE_LINEARSLIDER0_PTR_DIPLEX_TABLE_VALUE                         (cy_capsense_context.ptrWdConfig[2u].ptrDiplexTable)
#define CY_CAPSENSE_LINEARSLIDER0_PTR_DIPLEX_TABLE_SIZE                          (sizeof(cy_capsense_context.ptrWdConfig[2u].ptrDiplexTable))
#define CY_CAPSENSE_LINEARSLIDER0_CENTROID_CONFIG_VALUE                          (cy_capsense_context.ptrWdConfig[2u].centroidConfig)
#define CY_CAPSENSE_LINEARSLIDER0_CENTROID_CONFIG_SIZE                           (sizeof(cy_capsense_context.ptrWdConfig[2u].centroidConfig))
#define CY_CAPSENSE_LINEARSLIDER0_X_RESOLUTION_VALUE                             (cy_capsense_context.ptrWdConfig[2u].xResolution)
#define CY_CAPSENSE_LINEARSLIDER0_X_RESOLUTION_SIZE                              (sizeof(cy_capsense_context.ptrWdConfig[2u].xResolution))
#define CY_CAPSENSE_LINEARSLIDER0_Y_RESOLUTION_VALUE                             (cy_capsense_context.ptrWdConfig[2u].yResolution)
#define CY_CAPSENSE_LINEARSLIDER0_Y_RESOLUTION_SIZE                              (sizeof(cy_capsense_context.ptrWdConfig[2u].yResolution))
#define CY_CAPSENSE_LINEARSLIDER0_NUM_SNS_VALUE                                  (cy_capsense_context.ptrWdConfig[2u].numSns)
#define CY_CAPSENSE_LINEARSLIDER0_NUM_SNS_SIZE                                   (sizeof(cy_capsense_context.ptrWdConfig[2u].numSns))
#define CY_CAPSENSE_LINEARSLIDER0_NUM_COLS_VALUE                                 (cy_capsense_context.ptrWdConfig[2u].numCols)
#define CY_CAPSENSE_LINEARSLIDER0_NUM_COLS_SIZE                                  (sizeof(cy_capsense_context.ptrWdConfig[2u].numCols))
#define CY_CAPSENSE_LINEARSLIDER0_NUM_ROWS_VALUE                                 (cy_capsense_context.ptrWdConfig[2u].numRows)
#define CY_CAPSENSE_LINEARSLIDER0_NUM_ROWS_SIZE                                  (sizeof(cy_capsense_context.ptrWdConfig[2u].numRows))
#define CY_CAPSENSE_LINEARSLIDER0_PTR_POS_FILTER_HISTORY_VALUE                   (cy_capsense_context.ptrWdConfig[2u].ptrPosFilterHistory)
#define CY_CAPSENSE_LINEARSLIDER0_PTR_POS_FILTER_HISTORY_SIZE                    (sizeof(cy_capsense_context.ptrWdConfig[2u].ptrPosFilterHistory))
#define CY_CAPSENSE_LINEARSLIDER0_PTR_CSX_TOUCH_HISTORY_VALUE                    (cy_capsense_context.ptrWdConfig[2u].ptrCsxTouchHistory)
#define CY_CAPSENSE_LINEARSLIDER0_PTR_CSX_TOUCH_HISTORY_SIZE                     (sizeof(cy_capsense_context.ptrWdConfig[2u].ptrCsxTouchHistory))
#define CY_CAPSENSE_LINEARSLIDER0_PTR_CSX_TOUCH_BUFFER_VALUE                     (cy_capsense_context.ptrWdConfig[2u].ptrCsxTouchBuffer)
#define CY_CAPSENSE_LINEARSLIDER0_PTR_CSX_TOUCH_BUFFER_SIZE                      (sizeof(cy_capsense_context.ptrWdConfig[2u].ptrCsxTouchBuffer))
#define CY_CAPSENSE_LINEARSLIDER0_PTR_CSD_TOUCH_BUFFER_VALUE                     (cy_capsense_context.ptrWdConfig[2u].ptrCsdTouchBuffer)
#define CY_CAPSENSE_LINEARSLIDER0_PTR_CSD_TOUCH_BUFFER_SIZE                      (sizeof(cy_capsense_context.ptrWdConfig[2u].ptrCsdTouchBuffer))
#define CY_CAPSENSE_LINEARSLIDER0_PTR_GESTURE_CONFIG_VALUE                       (cy_capsense_context.ptrWdConfig[2u].ptrGestureConfig)
#define CY_CAPSENSE_LINEARSLIDER0_PTR_GESTURE_CONFIG_SIZE                        (sizeof(cy_capsense_context.ptrWdConfig[2u].ptrGestureConfig))
#define CY_CAPSENSE_LINEARSLIDER0_PTR_GESTURE_CONTEXT_VALUE                      (cy_capsense_context.ptrWdConfig[2u].ptrGestureContext)
#define CY_CAPSENSE_LINEARSLIDER0_PTR_GESTURE_CONTEXT_SIZE                       (sizeof(cy_capsense_context.ptrWdConfig[2u].ptrGestureContext))
#define CY_CAPSENSE_LINEARSLIDER0_BALLISTIC_CONFIG_VALUE                         (cy_capsense_context.ptrWdConfig[2u].ballisticConfig)
#define CY_CAPSENSE_LINEARSLIDER0_BALLISTIC_CONFIG_SIZE                          (sizeof(cy_capsense_context.ptrWdConfig[2u].ballisticConfig))
#define CY_CAPSENSE_LINEARSLIDER0_PTR_BALLISTIC_CONTEXT_VALUE                    (cy_capsense_context.ptrWdConfig[2u].ptrBallisticContext)
#define CY_CAPSENSE_LINEARSLIDER0_PTR_BALLISTIC_CONTEXT_SIZE                     (sizeof(cy_capsense_context.ptrWdConfig[2u].ptrBallisticContext))
#define CY_CAPSENSE_LINEARSLIDER0_AIIR_CONFIG_VALUE                              (cy_capsense_context.ptrWdConfig[2u].aiirConfig)
#define CY_CAPSENSE_LINEARSLIDER0_AIIR_CONFIG_SIZE                               (sizeof(cy_capsense_context.ptrWdConfig[2u].aiirConfig))
#define CY_CAPSENSE_LINEARSLIDER0_ADV_CONFIG_VALUE                               (cy_capsense_context.ptrWdConfig[2u].advConfig)
#define CY_CAPSENSE_LINEARSLIDER0_ADV_CONFIG_SIZE                                (sizeof(cy_capsense_context.ptrWdConfig[2u].advConfig))
#define CY_CAPSENSE_LINEARSLIDER0_POS_FILTER_CONFIG_VALUE                        (cy_capsense_context.ptrWdConfig[2u].posFilterConfig)
#define CY_CAPSENSE_LINEARSLIDER0_POS_FILTER_CONFIG_SIZE                         (sizeof(cy_capsense_context.ptrWdConfig[2u].posFilterConfig))
#define CY_CAPSENSE_LINEARSLIDER0_RAW_FILTER_CONFIG_VALUE                        (cy_capsense_context.ptrWdConfig[2u].rawFilterConfig)
#define CY_CAPSENSE_LINEARSLIDER0_RAW_FILTER_CONFIG_SIZE                         (sizeof(cy_capsense_context.ptrWdConfig[2u].rawFilterConfig))
#if (CY_CAPSENSE_MW_VERSION >= 600)
#define CY_CAPSENSE_LINEARSLIDER0_CMF_TH_VALUE                                   (cy_capsense_context.ptrWdConfig[2u].cmfThreshold)
#define CY_CAPSENSE_LINEARSLIDER0_CMF_TH_SIZE                                    (sizeof(cy_capsense_context.ptrWdConfig[2u].cmfThreshold))
#endif
#define CY_CAPSENSE_LINEARSLIDER0_SENSE_METHOD_VALUE                             (cy_capsense_context.ptrWdConfig[2u].senseMethod)
#define CY_CAPSENSE_LINEARSLIDER0_SENSE_METHOD_SIZE                              (sizeof(cy_capsense_context.ptrWdConfig[2u].senseMethod))
#define CY_CAPSENSE_LINEARSLIDER0_WD_TYPE_VALUE                                  (cy_capsense_context.ptrWdConfig[2u].wdType)
#define CY_CAPSENSE_LINEARSLIDER0_WD_TYPE_SIZE                                   (sizeof(cy_capsense_context.ptrWdConfig[2u].wdType))

/* cy_capsense_pinConfig */
#define CY_CAPSENSE_BUTTON0_RX0_PIN0_PC_PTR_VALUE                                (cy_capsense_context.ptrPinConfig[0].pcPtr)
#define CY_CAPSENSE_BUTTON0_RX0_PIN0_PC_PTR_SIZE                                 (sizeof(cy_capsense_context.ptrPinConfig[0].pcPtr))
#define CY_CAPSENSE_BUTTON0_RX0_PIN0_NUMBER_VALUE                                (cy_capsense_context.ptrPinConfig[0].pinNumber)
#define CY_CAPSENSE_BUTTON0_RX0_PIN0_NUMBER_SIZE                                 (sizeof(cy_capsense_context.ptrPinConfig[0].pinNumber))

#define CY_CAPSENSE_BUTTON0_TX_PIN0_PC_PTR_VALUE                                 (cy_capsense_context.ptrPinConfig[1].pcPtr)
#define CY_CAPSENSE_BUTTON0_TX_PIN0_PC_PTR_SIZE                                  (sizeof(cy_capsense_context.ptrPinConfig[1].pcPtr))
#define CY_CAPSENSE_BUTTON0_TX_PIN0_NUMBER_VALUE                                 (cy_capsense_context.ptrPinConfig[1].pinNumber)
#define CY_CAPSENSE_BUTTON0_TX_PIN0_NUMBER_SIZE                                  (sizeof(cy_capsense_context.ptrPinConfig[1].pinNumber))

#define CY_CAPSENSE_BUTTON1_RX0_PIN0_PC_PTR_VALUE                                (cy_capsense_context.ptrPinConfig[2].pcPtr)
#define CY_CAPSENSE_BUTTON1_RX0_PIN0_PC_PTR_SIZE                                 (sizeof(cy_capsense_context.ptrPinConfig[2].pcPtr))
#define CY_CAPSENSE_BUTTON1_RX0_PIN0_NUMBER_VALUE                                (cy_capsense_context.ptrPinConfig[2].pinNumber)
#define CY_CAPSENSE_BUTTON1_RX0_PIN0_NUMBER_SIZE                                 (sizeof(cy_capsense_context.ptrPinConfig[2].pinNumber))

#define CY_CAPSENSE_BUTTON1_TX_PIN0_PC_PTR_VALUE                                 (cy_capsense_context.ptrPinConfig[3].pcPtr)
#define CY_CAPSENSE_BUTTON1_TX_PIN0_PC_PTR_SIZE                                  (sizeof(cy_capsense_context.ptrPinConfig[3].pcPtr))
#define CY_CAPSENSE_BUTTON1_TX_PIN0_NUMBER_VALUE                                 (cy_capsense_context.ptrPinConfig[3].pinNumber)
#define CY_CAPSENSE_BUTTON1_TX_PIN0_NUMBER_SIZE                                  (sizeof(cy_capsense_context.ptrPinConfig[3].pinNumber))

#define CY_CAPSENSE_LINEARSLIDER0_SNS0_PIN0_PC_PTR_VALUE                         (cy_capsense_context.ptrPinConfig[4].pcPtr)
#define CY_CAPSENSE_LINEARSLIDER0_SNS0_PIN0_PC_PTR_SIZE                          (sizeof(cy_capsense_context.ptrPinConfig[4].pcPtr))
#define CY_CAPSENSE_LINEARSLIDER0_SNS0_PIN0_NUMBER_VALUE                         (cy_capsense_context.ptrPinConfig[4].pinNumber)
#define CY_CAPSENSE_LINEARSLIDER0_SNS0_PIN0_NUMBER_SIZE                          (sizeof(cy_capsense_context.ptrPinConfig[4].pinNumber))

#define CY_CAPSENSE_LINEARSLIDER0_SNS1_PIN0_PC_PTR_VALUE                         (cy_capsense_context.ptrPinConfig[5].pcPtr)
#define CY_CAPSENSE_LINEARSLIDER0_SNS1_PIN0_PC_PTR_SIZE                          (sizeof(cy_capsense_context.ptrPinConfig[5].pcPtr))
#define CY_CAPSENSE_LINEARSLIDER0_SNS1_PIN0_NUMBER_VALUE                         (cy_capsense_context.ptrPinConfig[5].pinNumber)
#define CY_CAPSENSE_LINEARSLIDER0_SNS1_PIN0_NUMBER_SIZE                          (sizeof(cy_capsense_context.ptrPinConfig[5].pinNumber))

#define CY_CAPSENSE_LINEARSLIDER0_SNS2_PIN0_PC_PTR_VALUE                         (cy_capsense_context.ptrPinConfig[6].pcPtr)
#define CY_CAPSENSE_LINEARSLIDER0_SNS2_PIN0_PC_PTR_SIZE                          (sizeof(cy_capsense_context.ptrPinConfig[6].pcPtr))
#define CY_CAPSENSE_LINEARSLIDER0_SNS2_PIN0_NUMBER_VALUE                         (cy_capsense_context.ptrPinConfig[6].pinNumber)
#define CY_CAPSENSE_LINEARSLIDER0_SNS2_PIN0_NUMBER_SIZE                          (sizeof(cy_capsense_context.ptrPinConfig[6].pinNumber))

#define CY_CAPSENSE_LINEARSLIDER0_SNS3_PIN0_PC_PTR_VALUE                         (cy_capsense_context.ptrPinConfig[7].pcPtr)
#define CY_CAPSENSE_LINEARSLIDER0_SNS3_PIN0_PC_PTR_SIZE                          (sizeof(cy_capsense_context.ptrPinConfig[7].pcPtr))
#define CY_CAPSENSE_LINEARSLIDER0_SNS3_PIN0_NUMBER_VALUE                         (cy_capsense_context.ptrPinConfig[7].pinNumber)
#define CY_CAPSENSE_LINEARSLIDER0_SNS3_PIN0_NUMBER_SIZE                          (sizeof(cy_capsense_context.ptrPinConfig[7].pinNumber))

#define CY_CAPSENSE_LINEARSLIDER0_SNS4_PIN0_PC_PTR_VALUE                         (cy_capsense_context.ptrPinConfig[8].pcPtr)
#define CY_CAPSENSE_LINEARSLIDER0_SNS4_PIN0_PC_PTR_SIZE                          (sizeof(cy_capsense_context.ptrPinConfig[8].pcPtr))
#define CY_CAPSENSE_LINEARSLIDER0_SNS4_PIN0_NUMBER_VALUE                         (cy_capsense_context.ptrPinConfig[8].pinNumber)
#define CY_CAPSENSE_LINEARSLIDER0_SNS4_PIN0_NUMBER_SIZE                          (sizeof(cy_capsense_context.ptrPinConfig[8].pinNumber))

/* cy_capsense_electrodeConfig */
#define CY_CAPSENSE_BUTTON0_RX0_CFG_PTR_VALUE                                    (cy_capsense_context.ptrWdConfig[0].ptrEltdConfig[0].ptrPin)
#define CY_CAPSENSE_BUTTON0_RX0_CFG_PTR_SIZE                                     (sizeof(cy_capsense_context.ptrWdConfig[0].ptrEltdConfig[0].ptrPin))
#define CY_CAPSENSE_BUTTON0_RX0_ELTD_TYPE_VALUE                                  (cy_capsense_context.ptrWdConfig[0].ptrEltdConfig[0].type)
#define CY_CAPSENSE_BUTTON0_RX0_ELTD_TYPE_SIZE                                   (sizeof(cy_capsense_context.ptrWdConfig[0].ptrEltdConfig[0].type))
#define CY_CAPSENSE_BUTTON0_RX0_NUM_PINS_VALUE                                   (cy_capsense_context.ptrWdConfig[0].ptrEltdConfig[0].numPins)
#define CY_CAPSENSE_BUTTON0_RX0_NUM_PINS_SIZE                                    (sizeof(cy_capsense_context.ptrWdConfig[0].ptrEltdConfig[0].numPins))

#define CY_CAPSENSE_BUTTON0_TX_CFG_PTR_VALUE                                     (cy_capsense_context.ptrWdConfig[0].ptrEltdConfig[1].ptrPin)
#define CY_CAPSENSE_BUTTON0_TX_CFG_PTR_SIZE                                      (sizeof(cy_capsense_context.ptrWdConfig[0].ptrEltdConfig[1].ptrPin))
#define CY_CAPSENSE_BUTTON0_TX_ELTD_TYPE_VALUE                                   (cy_capsense_context.ptrWdConfig[0].ptrEltdConfig[1].type)
#define CY_CAPSENSE_BUTTON0_TX_ELTD_TYPE_SIZE                                    (sizeof(cy_capsense_context.ptrWdConfig[0].ptrEltdConfig[1].type))
#define CY_CAPSENSE_BUTTON0_TX_NUM_PINS_VALUE                                    (cy_capsense_context.ptrWdConfig[0].ptrEltdConfig[1].numPins)
#define CY_CAPSENSE_BUTTON0_TX_NUM_PINS_SIZE                                     (sizeof(cy_capsense_context.ptrWdConfig[0].ptrEltdConfig[1].numPins))

#define CY_CAPSENSE_BUTTON1_RX0_CFG_PTR_VALUE                                    (cy_capsense_context.ptrWdConfig[1].ptrEltdConfig[0].ptrPin)
#define CY_CAPSENSE_BUTTON1_RX0_CFG_PTR_SIZE                                     (sizeof(cy_capsense_context.ptrWdConfig[1].ptrEltdConfig[0].ptrPin))
#define CY_CAPSENSE_BUTTON1_RX0_ELTD_TYPE_VALUE                                  (cy_capsense_context.ptrWdConfig[1].ptrEltdConfig[0].type)
#define CY_CAPSENSE_BUTTON1_RX0_ELTD_TYPE_SIZE                                   (sizeof(cy_capsense_context.ptrWdConfig[1].ptrEltdConfig[0].type))
#define CY_CAPSENSE_BUTTON1_RX0_NUM_PINS_VALUE                                   (cy_capsense_context.ptrWdConfig[1].ptrEltdConfig[0].numPins)
#define CY_CAPSENSE_BUTTON1_RX0_NUM_PINS_SIZE                                    (sizeof(cy_capsense_context.ptrWdConfig[1].ptrEltdConfig[0].numPins))

#define CY_CAPSENSE_BUTTON1_TX_CFG_PTR_VALUE                                     (cy_capsense_context.ptrWdConfig[1].ptrEltdConfig[1].ptrPin)
#define CY_CAPSENSE_BUTTON1_TX_CFG_PTR_SIZE                                      (sizeof(cy_capsense_context.ptrWdConfig[1].ptrEltdConfig[1].ptrPin))
#define CY_CAPSENSE_BUTTON1_TX_ELTD_TYPE_VALUE                                   (cy_capsense_context.ptrWdConfig[1].ptrEltdConfig[1].type)
#define CY_CAPSENSE_BUTTON1_TX_ELTD_TYPE_SIZE                                    (sizeof(cy_capsense_context.ptrWdConfig[1].ptrEltdConfig[1].type))
#define CY_CAPSENSE_BUTTON1_TX_NUM_PINS_VALUE                                    (cy_capsense_context.ptrWdConfig[1].ptrEltdConfig[1].numPins)
#define CY_CAPSENSE_BUTTON1_TX_NUM_PINS_SIZE                                     (sizeof(cy_capsense_context.ptrWdConfig[1].ptrEltdConfig[1].numPins))

#define CY_CAPSENSE_LINEARSLIDER0_SNS0_CFG_PTR_VALUE                             (cy_capsense_context.ptrWdConfig[2].ptrEltdConfig[0].ptrPin)
#define CY_CAPSENSE_LINEARSLIDER0_SNS0_CFG_PTR_SIZE                              (sizeof(cy_capsense_context.ptrWdConfig[2].ptrEltdConfig[0].ptrPin))
#define CY_CAPSENSE_LINEARSLIDER0_SNS0_ELTD_TYPE_VALUE                           (cy_capsense_context.ptrWdConfig[2].ptrEltdConfig[0].type)
#define CY_CAPSENSE_LINEARSLIDER0_SNS0_ELTD_TYPE_SIZE                            (sizeof(cy_capsense_context.ptrWdConfig[2].ptrEltdConfig[0].type))
#define CY_CAPSENSE_LINEARSLIDER0_SNS0_NUM_PINS_VALUE                            (cy_capsense_context.ptrWdConfig[2].ptrEltdConfig[0].numPins)
#define CY_CAPSENSE_LINEARSLIDER0_SNS0_NUM_PINS_SIZE                             (sizeof(cy_capsense_context.ptrWdConfig[2].ptrEltdConfig[0].numPins))

#define CY_CAPSENSE_LINEARSLIDER0_SNS1_CFG_PTR_VALUE                             (cy_capsense_context.ptrWdConfig[2].ptrEltdConfig[1].ptrPin)
#define CY_CAPSENSE_LINEARSLIDER0_SNS1_CFG_PTR_SIZE                              (sizeof(cy_capsense_context.ptrWdConfig[2].ptrEltdConfig[1].ptrPin))
#define CY_CAPSENSE_LINEARSLIDER0_SNS1_ELTD_TYPE_VALUE                           (cy_capsense_context.ptrWdConfig[2].ptrEltdConfig[1].type)
#define CY_CAPSENSE_LINEARSLIDER0_SNS1_ELTD_TYPE_SIZE                            (sizeof(cy_capsense_context.ptrWdConfig[2].ptrEltdConfig[1].type))
#define CY_CAPSENSE_LINEARSLIDER0_SNS1_NUM_PINS_VALUE                            (cy_capsense_context.ptrWdConfig[2].ptrEltdConfig[1].numPins)
#define CY_CAPSENSE_LINEARSLIDER0_SNS1_NUM_PINS_SIZE                             (sizeof(cy_capsense_context.ptrWdConfig[2].ptrEltdConfig[1].numPins))

#define CY_CAPSENSE_LINEARSLIDER0_SNS2_CFG_PTR_VALUE                             (cy_capsense_context.ptrWdConfig[2].ptrEltdConfig[2].ptrPin)
#define CY_CAPSENSE_LINEARSLIDER0_SNS2_CFG_PTR_SIZE                              (sizeof(cy_capsense_context.ptrWdConfig[2].ptrEltdConfig[2].ptrPin))
#define CY_CAPSENSE_LINEARSLIDER0_SNS2_ELTD_TYPE_VALUE                           (cy_capsense_context.ptrWdConfig[2].ptrEltdConfig[2].type)
#define CY_CAPSENSE_LINEARSLIDER0_SNS2_ELTD_TYPE_SIZE                            (sizeof(cy_capsense_context.ptrWdConfig[2].ptrEltdConfig[2].type))
#define CY_CAPSENSE_LINEARSLIDER0_SNS2_NUM_PINS_VALUE                            (cy_capsense_context.ptrWdConfig[2].ptrEltdConfig[2].numPins)
#define CY_CAPSENSE_LINEARSLIDER0_SNS2_NUM_PINS_SIZE                             (sizeof(cy_capsense_context.ptrWdConfig[2].ptrEltdConfig[2].numPins))

#define CY_CAPSENSE_LINEARSLIDER0_SNS3_CFG_PTR_VALUE                             (cy_capsense_context.ptrWdConfig[2].ptrEltdConfig[3].ptrPin)
#define CY_CAPSENSE_LINEARSLIDER0_SNS3_CFG_PTR_SIZE                              (sizeof(cy_capsense_context.ptrWdConfig[2].ptrEltdConfig[3].ptrPin))
#define CY_CAPSENSE_LINEARSLIDER0_SNS3_ELTD_TYPE_VALUE                           (cy_capsense_context.ptrWdConfig[2].ptrEltdConfig[3].type)
#define CY_CAPSENSE_LINEARSLIDER0_SNS3_ELTD_TYPE_SIZE                            (sizeof(cy_capsense_context.ptrWdConfig[2].ptrEltdConfig[3].type))
#define CY_CAPSENSE_LINEARSLIDER0_SNS3_NUM_PINS_VALUE                            (cy_capsense_context.ptrWdConfig[2].ptrEltdConfig[3].numPins)
#define CY_CAPSENSE_LINEARSLIDER0_SNS3_NUM_PINS_SIZE                             (sizeof(cy_capsense_context.ptrWdConfig[2].ptrEltdConfig[3].numPins))

#define CY_CAPSENSE_LINEARSLIDER0_SNS4_CFG_PTR_VALUE                             (cy_capsense_context.ptrWdConfig[2].ptrEltdConfig[4].ptrPin)
#define CY_CAPSENSE_LINEARSLIDER0_SNS4_CFG_PTR_SIZE                              (sizeof(cy_capsense_context.ptrWdConfig[2].ptrEltdConfig[4].ptrPin))
#define CY_CAPSENSE_LINEARSLIDER0_SNS4_ELTD_TYPE_VALUE                           (cy_capsense_context.ptrWdConfig[2].ptrEltdConfig[4].type)
#define CY_CAPSENSE_LINEARSLIDER0_SNS4_ELTD_TYPE_SIZE                            (sizeof(cy_capsense_context.ptrWdConfig[2].ptrEltdConfig[4].type))
#define CY_CAPSENSE_LINEARSLIDER0_SNS4_NUM_PINS_VALUE                            (cy_capsense_context.ptrWdConfig[2].ptrEltdConfig[4].numPins)
#define CY_CAPSENSE_LINEARSLIDER0_SNS4_NUM_PINS_SIZE                             (sizeof(cy_capsense_context.ptrWdConfig[2].ptrEltdConfig[4].numPins))


#if ((CY_CAPSENSE_PERI_CLK / 2) > 50000000)
    #warning The maximum CSD modulator clock frequency is 50 MHz: increase CSD modulator clock divider to meet the valid operation conditions
#endif

#if ((CY_CAPSENSE_PERI_CLK / 2) > 50000000)
    #warning The maximum CSX modulator clock frequency is 50 MHz: increase CSX modulator clock divider to meet the valid operation conditions
#endif

#if ((CY_CAPSENSE_PERI_CLK / 2 / 32) > 3000000)
    #warning The maximum Tx clock frequency is 3 MHz: increase Tx clock divider for widget Button0 to meet the valid operation conditions
#endif

#if ((CY_CAPSENSE_PERI_CLK / 2 / 32) > 3000000)
    #warning The maximum Tx clock frequency is 3 MHz: increase Tx clock divider for widget Button1 to meet the valid operation conditions
#endif


#if defined(__cplusplus)
}
#endif

#endif /* CY_CAPSENSE_CORE == __CORTEX_M */

#endif /* !defined(CY_DISABLE_CAPSENSE) */

#endif /* (defined(COMPONENT_MW_MIDDLEWARE_LLS_PROTOTYPE) || defined(COMPONENT_MW_CAPSENSE) || !defined(COMPONENT_MW_CORE_MAKE)) */

#endif /* CYCFG_CAPSENSE_H */

/* [] END OF FILE */
