################################################################################
# \file bsp.mk
#
# \brief
# Define the CY8CKIT-062S2-43012 target.
#
################################################################################
# \copyright
# Copyright 2018-2022 Cypress Semiconductor Corporation (an Infineon company) or
# an affiliate of Cypress Semiconductor Corporation
#
# SPDX-License-Identifier: Apache-2.0
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
################################################################################

ifeq ($(WHICHFILE),true)
$(info Processing $(lastword $(MAKEFILE_LIST)))
endif

# Any additional components to apply when using this board.
# Use a default CM0+ image (CM0P_SLEEP). This can be swapped for a different
# pre-built image or removed if custom built project.
BSP_COMPONENTS:=CM0P_SLEEP WIFI_INTERFACE_SDIO

# Any additional defines to apply when using this board.
BSP_DEFINES:=CY_USING_HAL

################################################################################
# ALL ITEMS BELOW THIS POINT ARE AUTO GENERATED BY THE BSP ASSISTANT TOOL.
# DO NOT MODIFY DIRECTLY. CHANGES SHOULD BE MADE THROUGH THE BSP ASSISTANT.
################################################################################

# Board device selection. MPN_LIST tracks what was selected in the BSP Assistant
# All other variables are derived by BSP Assistant based on the MPN_LIST.
MPN_LIST:=CY8C624ABZI-S2D44 LBEE59B1LV
DEVICE:=CY8C624ABZI-S2D44
ADDITIONAL_DEVICES:=CYW43012C0WKWBG
DEVICE_COMPONENTS:=43012 CAT1 CAT1A HCI-UART MURATA-1LV PSOC6_02
DEVICE_CY8C624ABZI-S2D44_CORES:=CORE_NAME_CM0P_0 CORE_NAME_CM4_0
DEVICE_CY8C624ABZI-S2D44_DIE:=PSoC6A2M
DEVICE_CY8C624ABZI-S2D44_FEATURES:=CM4_0_FPU_PRESENT
DEVICE_CY8C624ABZI-S2D44_FLASH_KB:=2048
DEVICE_CY8C624ABZI-S2D44_SRAM_KB:=1024
DEVICE_CYW43012C0WKWBG_CORES:=CORE_NAME_CM4_0
DEVICE_CYW43012C0WKWBG_DIE:=43012C0
DEVICE_CYW43012C0WKWBG_FLASH_KB:=0
DEVICE_CYW43012C0WKWBG_SRAM_KB:=1280
DEVICE_LIST:=CY8C624ABZI-S2D44 CYW43012C0WKWBG
DEVICE_TOOL_IDS:=bsp-assistant bt-configurator capsense-configurator capsense-tuner device-configurator dfuh-tool library-manager lin-configurator ml-configurator motor-suite-gui project-creator qspi-configurator seglcd-configurator smartio-configurator usbdev-configurator
RECIPE_DIR:=$(SEARCH_recipe-make-cat1a)
